/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.common.Version;
import icy.file.FileUtil;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.util.FontUtil;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.sequence.Sequence;
import icy.sequence.SequenceUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzStoppable;
import plugins.adufour.ezplug.EzVarBoolean;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.ezplug.EzVarText;
import plugins.kernel.roi.roi3d.plugin.ROI3DPointPlugin;
import plugins.perrine.ec_clem.ec_clem.DaggerEc_clemComponent;
import plugins.perrine.ec_clem.ec_clem.misc.AdvancedmodulesButton;
import plugins.perrine.ec_clem.ec_clem.transformation.configuration.TransformationConfigurationFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.NoiseModel;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationType;
import plugins.perrine.ec_clem.ec_clem.ui.GuiCLEMButtons;
import plugins.perrine.ec_clem.ec_clem.ui.GuiCLEMButtons2;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class Ec_clem
extends EzPlug
implements EzStoppable {
    private MessageOverlay messageSource = new MessageOverlay("Source");
    private MessageOverlay messageTarget = new MessageOverlay("Target");
    private TransformationConfigurationFactory transformationConfigurationFactory;
    private GuiCLEMButtons guiCLEMButtons;
    private GuiCLEMButtons2 rigidspecificbutton;
    private Workspace workspace;
    private EzVarText choiceinputsection = new EzVarText("Transformation model:", TransformationType.toArray(), 0, Boolean.valueOf(false));
    private EzVarText noiseModel = new EzVarText("Noise model:", NoiseModel.toArray(), 0, Boolean.valueOf(false));
    private EzVarBoolean showgrid = new EzVarBoolean(" Show grid deformation", false);
    private EzVarSequence target = new EzVarSequence("Target sequence");
    private EzVarSequence source = new EzVarSequence("Source sequence");
    private EzGroup inputGroup = new EzGroup("Images to process", new EzComponent[]{this.source, this.target, this.choiceinputsection, this.noiseModel, this.showgrid});

    public Ec_clem() {
        DaggerEc_clemComponent.builder().build().inject(this);
    }

    private String getVersionString() {
        Version version = PluginLoader.getPlugin((String)Ec_clem.class.getName()).getVersion();
        return "version " + version.toString();
    }

    protected void initialize() {
        new ToolTipFrame("<html><br> Press Play when ready. <br> <li> Add point (2D or 3D ROI) on any image and drag it to its correct position in the other image.</li> <br> <li> Use zoom and Lock views to help you!</li> </html>", "startmessage");
        this.addEzComponent((EzComponent)new EzLabel(this.getVersionString()));
        this.addComponent(new AdvancedmodulesButton());
        this.addEzComponent((EzComponent)this.inputGroup);
        this.guiCLEMButtons.setEnabled(false);
        this.addComponent(this.guiCLEMButtons);
        this.rigidspecificbutton.disableButtons();
        this.addComponent(this.rigidspecificbutton);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() {
        Sequence targetSequence;
        Sequence sourceSequence = (Sequence)this.source.getValue();
        if (sourceSequence == (targetSequence = (Sequence)this.target.getValue())) {
            MessageDialog.showDialog((String)"You have selected the same sequence for target sequence and source sequence. \n Check the IMAGES to PROCESS selection");
            return;
        }
        if (sourceSequence == null) {
            MessageDialog.showDialog((String)"No sequence selected for Source. \n Check the IMAGES to PROCESS selection");
            return;
        }
        if (targetSequence == null) {
            MessageDialog.showDialog((String)"No sequence selected for Target. \n Check the IMAGES to PROCESS selection");
            return;
        }
        this.source.setEnabled(false);
        this.target.setEnabled(false);
        this.choiceinputsection.setEnabled(false);
        this.noiseModel.setEnabled(false);
        this.showgrid.setEnabled(false);
        this.workspace = new Workspace();
        this.workspace.setSourceSequence(sourceSequence);
        this.workspace.setTargetSequence(targetSequence);
        Sequence copy = SequenceUtil.getCopy((Sequence)sourceSequence);
        this.workspace.setSourceBackup(copy);
        Path parent = Paths.get(FileUtil.getApplicationDirectory(), new String[0]);
        String warningmessagestorage = "All saved files will be under " + FileUtil.getApplicationDirectory();
        if (sourceSequence.getFilename() == null) {
            if (targetSequence.getFilename() == null) {
                MessageDialog.showDialog((String)("Note that Source and Target are not saved on disk, \n  " + warningmessagestorage), (int)2);
            } else {
                parent = Paths.get(targetSequence.getFilename(), new String[0]).getParent();
                MessageDialog.showDialog((String)("Note that Source is not saved on disk, \n  " + warningmessagestorage), (int)2);
            }
        } else {
            parent = Paths.get(sourceSequence.getFilename(), new String[0]).getParent();
        }
        if (parent == null) {
            parent = Paths.get(FileUtil.getApplicationDirectory(), new String[0]);
        }
        String date = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy_MM_dd_HH_mm_ss"));
        File transformationSchemaOutputFile = new File(String.format("%s/%s_to_%s_%s.transformation_schema.xml", parent.toString(), sourceSequence.getName(), targetSequence.getName(), date));
        System.out.println(String.format("Transformation schema saved at : %s", transformationSchemaOutputFile.toString()));
        this.workspace.setTransformationSchemaOutputFile(transformationSchemaOutputFile);
        File csvTransformationFile = new File(String.format("%s/%s_to_%s_%s.transformation.csv", parent.toString(), sourceSequence.getName(), targetSequence.getName(), date));
        System.out.println(String.format("CSV format transformation saved at : %s", csvTransformationFile.toString()));
        this.workspace.setCsvTransformationOutputFile(csvTransformationFile);
        File XmlTransformationFile = new File(String.format("%s/%s_to_%s_%s.transformation.xml", parent.toString(), sourceSequence.getName(), targetSequence.getName(), date));
        System.out.println(String.format("XML format transformation saved at : %s", XmlTransformationFile.toString()));
        this.workspace.setXmlTransformationOutputFile(XmlTransformationFile);
        this.workspace.setTransformationConfiguration(this.transformationConfigurationFactory.getFrom(TransformationType.valueOf((String)this.choiceinputsection.getValue()), NoiseModel.valueOf((String)this.noiseModel.getValue()), (Boolean)this.showgrid.getValue()));
        this.guiCLEMButtons.setworkspace(this.workspace);
        this.rigidspecificbutton.setWorkspace(this.workspace);
        sourceSequence.addOverlay((Overlay)this.messageSource);
        targetSequence.addOverlay((Overlay)this.messageTarget);
        new ToolTipFrame("<html><br> Set at least 3 fiducial points and click on <b>Update transformation</b> button. <br> Set at least 7 fiducial points to unlock error estimation capabilities. </html>", "runmessage");
        this.guiCLEMButtons.setEnabled(true);
        this.rigidspecificbutton.enableButtons();
        Icy.getMainInterface().setSelectedTool(ROI3DPointPlugin.class.getName());
        Ec_clem ec_clem = this;
        synchronized (ec_clem) {
            try {
                ((Object)((Object)this)).wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        sourceSequence.removeOverlay((Overlay)this.messageSource);
        targetSequence.removeOverlay((Overlay)this.messageTarget);
    }

    public void clean() {
        this.clearWorkspace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        this.guiCLEMButtons.setEnabled(false);
        this.rigidspecificbutton.disableButtons();
        ((Sequence)this.source.getValue()).setFilename(((Sequence)this.source.getValue()).getFilename() + "_transformed.tif");
        this.source.setEnabled(true);
        this.target.setEnabled(true);
        this.choiceinputsection.setEnabled(true);
        this.noiseModel.setEnabled(true);
        this.showgrid.setEnabled(true);
        this.clearWorkspace();
        Ec_clem ec_clem = this;
        synchronized (ec_clem) {
            ((Object)((Object)this)).notify();
        }
    }

    private void clearWorkspace() {
        if (this.workspace != null) {
            this.workspace.setSourceSequence(null);
            this.workspace.setTargetSequence(null);
            this.workspace.setSourceBackup(null);
            this.workspace.setTransformationConfiguration(null);
            this.workspace.setTransformationSchema(null);
            this.workspace.setCsvTransformationOutputFile(null);
            this.workspace.setXmlTransformationOutputFile(null);
            this.workspace.setTransformationSchemaOutputFile(null);
            this.workspace = null;
        }
    }

    @Inject
    public void setTransformationConfigurationFactory(TransformationConfigurationFactory transformationConfigurationFactory) {
        this.transformationConfigurationFactory = transformationConfigurationFactory;
    }

    @Inject
    public void setGuiCLEMButtons(GuiCLEMButtons guiCLEMButtons) {
        this.guiCLEMButtons = guiCLEMButtons;
    }

    @Inject
    public void setRigidspecificbutton(GuiCLEMButtons2 rigidspecificbutton) {
        this.rigidspecificbutton = rigidspecificbutton;
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)Ec_clem.class.getName()));
    }

    private class MessageOverlay
    extends Overlay {
        String message;

        public MessageOverlay(String text) {
            super("Message");
            this.message = text;
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (canvas instanceof IcyCanvas2D && g != null) {
                g.setColor(Color.RED);
                g.setStroke(new BasicStroke(5.0f));
                Font f = g.getFont();
                f = FontUtil.setName((Font)f, (String)"Arial");
                f = FontUtil.setSize((Font)f, (int)((int)canvas.canvasToImageLogDeltaX(20)));
                g.setFont(f);
                g.drawString(this.message, 10, (int)canvas.canvasToImageLogDeltaX(50));
            }
        }
    }
}

