/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.fitzpatrick;

import icy.image.IcyBufferedImage;
import icy.painter.Overlay;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.DaggerTargetRegistrationErrorMapSupplierComponent;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TREComputer;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackableChildTask;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceFactory;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSize;
import plugins.stef.tools.overlay.ColorBarOverlay;

public class TargetRegistrationErrorMapSupplier
extends ProgressTrackableChildTask
implements Supplier<Sequence> {
    private SequenceFactory sequenceFactory;
    private SequenceSize sequenceSize;
    private TREComputer treComputer;
    private CompletionService<IcyBufferedImage> completionService = new ExecutorCompletionService<IcyBufferedImage>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));

    public TargetRegistrationErrorMapSupplier(SequenceSize sequenceSize, TREComputer treComputer) {
        super(sequenceSize.get(DimensionId.Z).getSize());
        DaggerTargetRegistrationErrorMapSupplierComponent.builder().build().inject(this);
        this.sequenceSize = sequenceSize;
        this.treComputer = treComputer;
    }

    @Override
    public Sequence get() {
        HashMap<Future<IcyBufferedImage>, Integer> resultMap = new HashMap<Future<IcyBufferedImage>, Integer>();
        Sequence newSequence = this.sequenceFactory.getFrom(this.sequenceSize);
        newSequence.beginUpdate();
        for (int z = 0; z < this.sequenceSize.get(DimensionId.Z).getSize(); ++z) {
            Point point = new Point(this.sequenceSize.getN());
            point.getMatrix().set(2, 0, (double)z * this.sequenceSize.get(DimensionId.Z).getPixelSizeInMicrometer());
            resultMap.put(this.completionService.submit(() -> {
                float[] dataArray = new float[this.sequenceSize.get(DimensionId.X).getSize() * this.sequenceSize.get(DimensionId.Y).getSize()];
                for (int x = 0; x < this.sequenceSize.get(DimensionId.X).getSize(); ++x) {
                    for (int y = 0; y < this.sequenceSize.get(DimensionId.Y).getSize(); ++y) {
                        point.getMatrix().set(0, 0, (double)x * this.sequenceSize.get(DimensionId.X).getPixelSizeInMicrometer());
                        point.getMatrix().set(1, 0, (double)y * this.sequenceSize.get(DimensionId.Y).getPixelSizeInMicrometer());
                        dataArray[y * this.sequenceSize.get((DimensionId)DimensionId.X).getSize() + x] = (float)this.treComputer.getExpectedSquareTRE(point);
                    }
                }
                return new IcyBufferedImage(this.sequenceSize.get(DimensionId.X).getSize(), this.sequenceSize.get(DimensionId.Y).getSize(), (Object)dataArray);
            }), z);
        }
        while (!resultMap.isEmpty()) {
            try {
                Future<IcyBufferedImage> take = this.completionService.take();
                int offset = (Integer)resultMap.remove(take);
                newSequence.setImage(0, offset, (BufferedImage)take.get());
                super.incrementCompleted();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        newSequence.setAutoUpdateChannelBounds(false);
        newSequence.setName("Error map (\u03bcm)");
        ColorBarOverlay mycolorbar = new ColorBarOverlay(null);
        mycolorbar.setDisplayMinMax(true);
        newSequence.addOverlay((Overlay)mycolorbar);
        newSequence.endUpdate();
        return newSequence;
    }

    @Inject
    public void setSequenceFactory(SequenceFactory sequenceFactory) {
        this.sequenceFactory = sequenceFactory;
    }
}

