/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fiducialset.dataset;

import Jama.Matrix;
import java.util.Random;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;

public class DatasetGenerator {
    private Random random = new Random();

    @Inject
    public DatasetGenerator() {
    }

    public Dataset addNoise(Dataset dataset, double fle) {
        Matrix copy = dataset.getMatrix().copy();
        for (int i = 0; i < copy.getRowDimension(); ++i) {
            for (int j = 0; j < copy.getColumnDimension(); ++j) {
                copy.set(i, j, copy.get(i, j) + this.random.nextGaussian() * fle);
            }
        }
        return new Dataset(copy, dataset.getPointType());
    }

    public Dataset generate(Point center, int radius, int n) {
        Dataset result = new Dataset(center.getDimension(), PointType.FIDUCIAL);
        for (int i = 0; i < n; ++i) {
            Point point = new Point(result.getDimension());
            for (int d = 0; d < point.getDimension(); ++d) {
                point.getMatrix().set(d, 0, center.getMatrix().get(d, 0) + this.random.nextGaussian() * (double)radius);
            }
            result.addPoint(point);
        }
        return result;
    }
}

