/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fixtures.transformation;

import Jama.Matrix;
import javax.inject.Inject;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import plugins.perrine.ec_clem.ec_clem.transformation.AffineTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.Similarity;

public class TestTransformationFactory {
    private SynchronizedRandomGenerator random = new SynchronizedRandomGenerator(new JDKRandomGenerator());

    @Inject
    public TestTransformationFactory() {
    }

    public Similarity getRandomSimpleRotationTransformation(int dimension) {
        return this.getSimpleRotationTransformation(dimension);
    }

    private double getRandomAngle() {
        return this.random.nextDouble() * 2.0 * Math.PI;
    }

    public Similarity getSimpleRotationTransformation(int dimension) {
        switch (dimension) {
            case 2: {
                return this.getSimpleRotationTransformation2D(this.getRandomAngle());
            }
            case 3: {
                return this.getSimpleRotationTransformation3D(this.getRandomAngle(), this.getRandomAngle(), this.getRandomAngle());
            }
        }
        return null;
    }

    public Similarity getRandomSimpleSimilarityTransformation2D() {
        return this.getSimpleSimilarityTransformation2D(this.getRandomAngle(), new double[]{this.random.nextDouble(), this.random.nextDouble()}, this.random.nextDouble());
    }

    public AffineTransformation getRandomSimpleAffineTransformation2D() {
        Matrix A = new Matrix(2, 2);
        A.set(0, 0, this.random.nextDouble());
        A.set(0, 1, this.random.nextDouble());
        A.set(1, 0, this.random.nextDouble());
        A.set(1, 1, this.random.nextDouble());
        Matrix T = new Matrix(2, 1);
        T.set(0, 0, this.random.nextDouble());
        T.set(1, 0, this.random.nextDouble());
        return new AffineTransformation(A, T);
    }

    public Similarity getSimpleSimilarityTransformation2D(double angle, double[] t, double scale) {
        Matrix R = new Matrix((double[][])new double[][]{{Math.cos(angle), -1.0 * Math.sin(angle)}, {Math.sin(angle), Math.cos(angle)}});
        Matrix S = Matrix.identity((int)2, (int)2).times(scale);
        Matrix T = new Matrix((double[][])new double[][]{{t[0]}, {t[1]}});
        return new Similarity(R, T, S);
    }

    public Similarity getSimpleRotationTransformation2D(double angle) {
        Matrix R = new Matrix((double[][])new double[][]{{Math.cos(angle), -1.0 * Math.sin(angle)}, {Math.sin(angle), Math.cos(angle)}});
        Matrix S = Matrix.identity((int)2, (int)2);
        Matrix T = new Matrix((double[][])new double[][]{{0.0}, {0.0}});
        return new Similarity(R, T, S);
    }

    public Similarity getSimpleRotationTransformation3D(double ox, double oy, double oz) {
        Matrix R = new Matrix((double[][])new double[][]{{Math.cos(oz) * Math.cos(oy), Math.cos(oz) * Math.sin(oy) * Math.sin(ox) - Math.sin(oz) * Math.cos(ox), Math.cos(oz) * Math.sin(oy) * Math.cos(ox) + Math.sin(oz) * Math.sin(ox)}, {Math.sin(oz) * Math.cos(oy), Math.sin(oz) * Math.sin(oy) * Math.sin(ox) + Math.cos(oz) * Math.cos(ox), Math.sin(oz) * Math.sin(oy) * Math.cos(ox) - Math.cos(oz) * Math.sin(ox)}, {-Math.sin(oy), Math.cos(oy) * Math.sin(ox), Math.cos(oy) * Math.cos(ox)}});
        Matrix S = Matrix.identity((int)3, (int)3);
        Matrix T = new Matrix((double[][])new double[][]{{0.0}, {0.0}, {0.0}});
        return new Similarity(R, T, S);
    }
}

