/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.misc;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.file.Saver;
import icy.gui.dialog.MessageDialog;
import icy.preferences.ApplicationPreferences;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.XMLUtil;
import java.io.File;
import javax.inject.Inject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.ezplug.EzVarSequence;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarSequence;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceUpdater;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.XmlTransformation;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader.XmlFileReader;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader.XmlTransformationReader;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class ApplyTransformation
extends EzPlug
implements Block {
    private EzVarSequence source = new EzVarSequence("Select Source Image (will be transformed from storage file)");
    private EzVarFile xmlFile = new EzVarFile("Xml file containing list of transformation", ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
    private VarSequence out = new VarSequence("output sequence", null);
    private SequenceUpdater sequenceUpdater;
    private XmlFileReader xmlFileReader = new XmlFileReader();
    private XmlTransformationReader xmlTransformationReader = new XmlTransformationReader();

    @Inject
    public ApplyTransformation() {
    }

    protected void initialize() {
        EzLabel textinfo = new EzLabel("Please select the image on which you want to apply a transformation, and the storage file containing the transformations (likely your file name _transfo.storage)");
        String varName = "Xml file containing list of transformation";
        this.xmlFile = this.source.getValue() != null ? new EzVarFile(varName, ((Sequence)this.source.getValue()).getFilename()) : new EzVarFile(varName, ApplicationPreferences.getPreferences().node("frame/imageLoader").get("path", "."));
        this.addEzComponent((EzComponent)textinfo);
        this.addEzComponent((EzComponent)this.source);
        this.addEzComponent((EzComponent)this.xmlFile);
    }

    protected void execute() {
        Sequence sourceseq = (Sequence)this.source.getValue();
        if (sourceseq == null) {
            MessageDialog.showDialog((String)"Please make sure that your image is opened");
            return;
        }
        Runnable transformer = () -> {
            IcyCanvas sourcecanvas;
            Document document = this.xmlFileReader.loadFile((File)this.xmlFile.getValue());
            Element transformationElement = XMLUtil.getElement((Node)document.getDocumentElement(), (String)XmlTransformation.transformationElementName);
            TransformationSchema transformationSchema = this.xmlTransformationReader.read(transformationElement);
            this.sequenceUpdater = new SequenceUpdater(sourceseq, transformationSchema);
            this.sequenceUpdater.run();
            if (!this.isHeadLess() && (sourcecanvas = ((Sequence)this.source.getValue()).getFirstViewer().getCanvas()) instanceof IcyCanvas2D) {
                ((IcyCanvas2D)sourcecanvas).fitCanvasToImage();
            }
            sourceseq.setFilename(sourceseq.getFilename() + " (transformed)");
            sourceseq.setName(sourceseq.getName() + " (transformed)");
            File file = new File(sourceseq.getFilename());
            boolean multipleFiles = false;
            boolean showProgress = true;
            System.out.println("Transformed Image will be saved as " + sourceseq.getFilename());
            Saver.save((Sequence)sourceseq, (File)file, (boolean)multipleFiles, (boolean)showProgress);
            if (!this.isHeadLess()) {
                MessageDialog.showDialog((String)"TransformationSchema have been applied. Image has been renamed and saved, use this one for going on with your alignments");
            }
        };
        if (!this.isHeadLess()) {
            ThreadUtil.bgRun((Runnable)transformer);
        } else {
            ThreadUtil.invokeNow((Runnable)transformer);
        }
    }

    public void clean() {
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Input Image", (Var)this.source.getVariable());
        inputMap.add("Imput XML File", this.xmlFile.getVariable());
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Transformed Sequence", (Var)this.out);
    }
}

