/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence_listener;

import icy.sequence.Sequence;
import icy.sequence.SequenceListener;
import java.util.List;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.FiducialRoiListener;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.NonFiducialRoiListener;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.SequenceListenerUtil;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class RoiListenerManager {
    private Sequence sourceSequence;
    private Sequence targetSequence;
    private Workspace workspace;
    private SequenceListenerUtil sequenceListenerUtil;
    private FiducialRoiListener sourceSequenceFiducialRoiListener;
    private FiducialRoiListener targetSequenceFiducialRoiListener;
    private NonFiducialRoiListener targetSequenceNonFiducialRoiListener;

    @Inject
    public RoiListenerManager(SequenceListenerUtil sequenceListenerUtil) {
        this.sequenceListenerUtil = sequenceListenerUtil;
    }

    public void set(PointType pointType) {
        switch (pointType) {
            case FIDUCIAL: {
                this.clear();
                this.sourceSequence.addListener((SequenceListener)this.sourceSequenceFiducialRoiListener);
                this.targetSequence.addListener((SequenceListener)this.targetSequenceFiducialRoiListener);
                break;
            }
            case NOT_FIDUCIAL: {
                this.clear();
                this.sourceSequence.addListener((SequenceListener)this.targetSequenceNonFiducialRoiListener);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Point type %s not implemented", new Object[]{pointType}));
            }
        }
    }

    public void clear() {
        this.sequenceListenerUtil.removeListeners(this.sourceSequence, FiducialRoiListener.class);
        this.sequenceListenerUtil.removeListeners(this.targetSequence, FiducialRoiListener.class);
        this.sequenceListenerUtil.removeListeners(this.sourceSequence, NonFiducialRoiListener.class);
        this.sequenceListenerUtil.removeListeners(this.targetSequence, NonFiducialRoiListener.class);
    }

    public List<SequenceListener> removeAll(Sequence sequence) {
        List<SequenceListener> removed = this.sequenceListenerUtil.removeListeners(sequence, FiducialRoiListener.class);
        removed.addAll(this.sequenceListenerUtil.removeListeners(sequence, NonFiducialRoiListener.class));
        return removed;
    }

    public void setSequences(Sequence sourceSequence, Sequence targetSequence) {
        this.sourceSequence = sourceSequence;
        this.targetSequence = targetSequence;
        this.sourceSequenceFiducialRoiListener.setSequence(targetSequence);
        this.targetSequenceFiducialRoiListener.setSequence(sourceSequence);
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        this.sourceSequenceFiducialRoiListener.setWorkspace(workspace);
        this.targetSequenceFiducialRoiListener.setWorkspace(workspace);
    }

    @Inject
    public void setSourceSequenceFiducialRoiListener(FiducialRoiListener sourceSequenceFiducialRoiListener) {
        this.sourceSequenceFiducialRoiListener = sourceSequenceFiducialRoiListener;
    }

    @Inject
    public void setTargetSequenceFiducialRoiListener(FiducialRoiListener targetSequenceFiducialRoiListener) {
        this.targetSequenceFiducialRoiListener = targetSequenceFiducialRoiListener;
    }

    @Inject
    public void setTargetSequenceNonFiducialRoiListener(NonFiducialRoiListener targetSequenceNonFiducialRoiListener) {
        this.targetSequenceNonFiducialRoiListener = targetSequenceNonFiducialRoiListener;
    }
}

