/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.workspace;

import icy.gui.viewer.Viewer;
import icy.image.lut.LUT;
import icy.sequence.Sequence;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.DatasetFactory;
import plugins.perrine.ec_clem.ec_clem.progress.ChildProgressReport;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressManager;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressReport;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackable;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiUpdater;
import plugins.perrine.ec_clem.ec_clem.workspace.DaggerResetOriginalImageComponent;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class ResetOriginalImage
implements Runnable,
ProgressTrackable {
    private DatasetFactory datasetFactory;
    private RoiUpdater roiUpdater;
    private Workspace workspace;
    private ChildProgressReport progressReport;

    public ResetOriginalImage(Workspace workspace) {
        DaggerResetOriginalImageComponent.builder().build().inject(this);
        this.workspace = workspace;
        this.progressReport = new ChildProgressReport(1);
    }

    @Override
    public void visit(ProgressManager progressManager) {
        progressManager.add(this);
    }

    @Override
    public ProgressReport getProgress() {
        return this.progressReport;
    }

    @Override
    public void run() {
        if (this.workspace.getTransformationSchema() != null) {
            Dataset reversed = this.datasetFactory.getFrom(this.datasetFactory.getFrom(this.workspace.getSourceSequence(), PointType.FIDUCIAL), this.workspace.getTransformationSchema().inverse());
            Dataset reversedNonFiducials = this.datasetFactory.getFrom(this.datasetFactory.getFrom(this.workspace.getSourceSequence(), PointType.NOT_FIDUCIAL), this.workspace.getTransformationSchema().inverse());
            this.restoreBackup(this.workspace.getSourceSequence(), this.workspace.getSourceBackup());
            this.roiUpdater.clear(this.workspace.getSourceSequence(), PointType.PREDICTED_ERROR);
            this.roiUpdater.clear(this.workspace.getSourceSequence(), PointType.MEASURED_ERROR);
            this.roiUpdater.updateRoi(reversed, this.workspace.getSourceSequence());
            this.roiUpdater.updateRoi(reversedNonFiducials, this.workspace.getSourceSequence());
            this.workspace.setTransformationSchema(null);
            this.workspace.getSourceSequence().setName(this.workspace.getOriginalNameofSource());
        }
        this.progressReport.incrementCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreBackup(Sequence sequence, Sequence backup) {
        ArrayList<LUT> lutList = new ArrayList<LUT>();
        ArrayList viewers = sequence.getViewers();
        for (Viewer viewer : viewers) {
            viewer.refreshCanvasCombo();
            lutList.add(viewer.getLut());
        }
        sequence.beginUpdate();
        sequence.removeAllImages();
        sequence.beginUpdate();
        try {
            for (int t = 0; t < backup.getSizeT(); ++t) {
                for (int z = 0; z < backup.getSizeZ(); ++z) {
                    sequence.setImage(t, z, (BufferedImage)backup.getImage(t, z));
                }
            }
            sequence.setPixelSizeX(backup.getPixelSizeX());
            sequence.setPixelSizeY(backup.getPixelSizeY());
            sequence.setPixelSizeZ(backup.getPixelSizeZ());
        }
        finally {
            sequence.endUpdate();
        }
        for (int i = 0; i < viewers.size(); ++i) {
            ((Viewer)viewers.get(i)).setLut((LUT)lutList.get(i));
            sequence.setAutoUpdateChannelBounds(true);
        }
        sequence.endUpdate();
    }

    @Inject
    public void setDatasetFactory(DatasetFactory datasetFactory) {
        this.datasetFactory = datasetFactory;
    }

    @Inject
    public void setRoiUpdater(RoiUpdater roiUpdater) {
        this.roiUpdater = roiUpdater;
    }
}

