/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.correlativeview;

import icy.gui.component.button.ColorChooserButton;
import icy.gui.component.button.IcyButton;
import icy.gui.util.ComponentUtil;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.util.EventUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import plugins.perrine.correlativeview.TestVisu;

public class TestVisuSettingPanel
extends JPanel {
    private static final long serialVersionUID = -6747952036222386920L;
    final TestVisu testvisu;
    JComboBox zoomComboBox;
    JComboBox rotationComboBox;
    private IcyButton zoomFitImageButton;
    private IcyButton centerImageButton;
    private IcyButton zoomPlus;
    private IcyButton zoomMinus;
    private IcyButton rotateUnclock;
    private IcyButton rotateClock;
    private IcyButton LoadCorrelated;
    private IcyButton LoadTransfo;
    ColorChooserButton bgColorButton;

    public TestVisuSettingPanel(TestVisu cnv) {
        this.testvisu = cnv;
        this.initialize();
        this.zoomComboBox.setSelectedItem(Integer.toString((int)(this.testvisu.getScaleX() * 100.0)));
        this.bgColorButton.setColor(new Color(this.testvisu.preferences.getInt("bgColor", 0xFFFFFF)));
        this.bgColorButton.setSelected(this.testvisu.preferences.getBoolean("bgColorEnabled", false));
        this.zoomComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TestVisuSettingPanel.this.testvisu.modifyingZoom) {
                    try {
                        double scale = Double.parseDouble((String)TestVisuSettingPanel.this.zoomComboBox.getSelectedItem()) / 100.0;
                        TestVisuSettingPanel.this.testvisu.centerMouseOnView();
                        TestVisuSettingPanel.this.testvisu.setScale(scale, scale, true, true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.rotationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TestVisuSettingPanel.this.testvisu.modifyingRotation) {
                    try {
                        double angle = Double.parseDouble((String)TestVisuSettingPanel.this.rotationComboBox.getSelectedItem());
                        TestVisuSettingPanel.this.testvisu.setRotation(TestVisuSettingPanel.this.testvisu.getRotation(), false);
                        TestVisuSettingPanel.this.testvisu.setRotation(angle * Math.PI / 180.0, true);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        this.zoomPlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double scale = TestVisuSettingPanel.this.testvisu.smoothTransform.getDestValue(2) * 1.25;
                TestVisuSettingPanel.this.testvisu.centerMouseOnView();
                TestVisuSettingPanel.this.testvisu.setScale(scale, scale, true, true);
            }
        });
        this.zoomMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double scale = TestVisuSettingPanel.this.testvisu.smoothTransform.getDestValue(2) * 0.8;
                TestVisuSettingPanel.this.testvisu.centerMouseOnView();
                TestVisuSettingPanel.this.testvisu.setScale(scale, scale, true, true);
            }
        });
        this.rotateUnclock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestVisuSettingPanel.this.testvisu.setRotation(TestVisuSettingPanel.this.testvisu.smoothTransform.getDestValue(4) + 0.39269908169872414, true);
            }
        });
        this.rotateClock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestVisuSettingPanel.this.testvisu.setRotation(TestVisuSettingPanel.this.testvisu.smoothTransform.getDestValue(4) - 0.39269908169872414, true);
            }
        });
        this.zoomFitImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestVisuSettingPanel.this.testvisu.fitCanvasToImage();
            }
        });
        this.centerImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestVisuSettingPanel.this.testvisu.centerImage();
            }
        });
        this.bgColorButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EventUtil.isRightMouseButton((MouseEvent)e)) {
                    TestVisuSettingPanel.this.bgColorButton.setSelected(!TestVisuSettingPanel.this.bgColorButton.isSelected());
                    TestVisuSettingPanel.this.testvisu.backgroundColorEnabledChanged();
                }
            }
        });
        this.bgColorButton.addColorChangeListener(new ColorChooserButton.ColorChangeListener(){

            public void colorChanged(ColorChooserButton source) {
                TestVisuSettingPanel.this.testvisu.backgroundColorChanged();
            }
        });
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        this.add((Component)panel, "South");
        GridBagLayout gbl_panel = new GridBagLayout();
        gbl_panel.columnWidths = new int[]{60, 0, 20, 0, 0, 8, 0, 0};
        gbl_panel.rowHeights = new int[]{0, 0, 0};
        gbl_panel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        JLabel label_1 = new JLabel("Zoom");
        label_1.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_label_1 = new GridBagConstraints();
        gbc_label_1.anchor = 13;
        gbc_label_1.insets = new Insets(0, 0, 5, 5);
        gbc_label_1.gridx = 0;
        gbc_label_1.gridy = 0;
        panel.add((Component)label_1, gbc_label_1);
        this.zoomComboBox = new JComboBox<String>(new String[]{"10", "50", "100", "200", "400", "1000"});
        this.zoomComboBox.setEditable(true);
        this.zoomComboBox.setToolTipText("Select zoom factor");
        this.zoomComboBox.setSelectedIndex(2);
        ComponentUtil.setFixedWidth((Component)this.zoomComboBox, (int)64);
        GridBagConstraints gbc_zoomComboBox = new GridBagConstraints();
        gbc_zoomComboBox.fill = 2;
        gbc_zoomComboBox.insets = new Insets(0, 0, 5, 1);
        gbc_zoomComboBox.gridx = 1;
        gbc_zoomComboBox.gridy = 0;
        panel.add((Component)this.zoomComboBox, gbc_zoomComboBox);
        JLabel label_2 = new JLabel("%");
        label_2.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_label_2 = new GridBagConstraints();
        gbc_label_2.anchor = 17;
        gbc_label_2.insets = new Insets(0, 0, 5, 5);
        gbc_label_2.gridx = 2;
        gbc_label_2.gridy = 0;
        panel.add((Component)label_2, gbc_label_2);
        this.zoomMinus = new IcyButton(new IcyIcon(ResourceUtil.ICON_MINUS, 20));
        this.zoomMinus.setFlat(true);
        this.zoomMinus.setToolTipText("Reduce zoom factor");
        GridBagConstraints gbc_zoomMinus_1 = new GridBagConstraints();
        gbc_zoomMinus_1.insets = new Insets(0, 0, 5, 1);
        gbc_zoomMinus_1.gridx = 3;
        gbc_zoomMinus_1.gridy = 0;
        panel.add((Component)this.zoomMinus, gbc_zoomMinus_1);
        this.zoomPlus = new IcyButton(new IcyIcon(ResourceUtil.ICON_PLUS, 20));
        this.zoomPlus.setFlat(true);
        this.zoomPlus.setToolTipText("Increase zoom factor");
        GridBagConstraints gbc_zoomPlus_1 = new GridBagConstraints();
        gbc_zoomPlus_1.insets = new Insets(0, 0, 5, 5);
        gbc_zoomPlus_1.gridx = 4;
        gbc_zoomPlus_1.gridy = 0;
        panel.add((Component)this.zoomPlus, gbc_zoomPlus_1);
        JLabel label_3 = new JLabel("Rotation");
        label_3.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_label_3 = new GridBagConstraints();
        gbc_label_3.anchor = 13;
        gbc_label_3.insets = new Insets(0, 0, 0, 5);
        gbc_label_3.gridx = 0;
        gbc_label_3.gridy = 1;
        panel.add((Component)label_3, gbc_label_3);
        this.rotationComboBox = new JComboBox<String>(new String[]{"0", "45", "90", "135", "180", "225", "270", "315"});
        ComponentUtil.setFixedWidth((Component)this.rotationComboBox, (int)64);
        this.rotationComboBox.setEditable(true);
        this.rotationComboBox.setToolTipText("Select rotation angle");
        this.rotationComboBox.setSelectedIndex(0);
        GridBagConstraints gbc_rotationComboBox = new GridBagConstraints();
        gbc_rotationComboBox.fill = 2;
        gbc_rotationComboBox.insets = new Insets(0, 0, 0, 1);
        gbc_rotationComboBox.gridx = 1;
        gbc_rotationComboBox.gridy = 1;
        panel.add((Component)this.rotationComboBox, gbc_rotationComboBox);
        JLabel label_4 = new JLabel("\ufffd");
        label_4.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_label_4 = new GridBagConstraints();
        gbc_label_4.anchor = 17;
        gbc_label_4.insets = new Insets(0, 0, 0, 5);
        gbc_label_4.gridx = 2;
        gbc_label_4.gridy = 1;
        panel.add((Component)label_4, gbc_label_4);
        this.rotateUnclock = new IcyButton(new IcyIcon(ResourceUtil.ICON_ROTATE_UNCLOCK, 20));
        this.rotateUnclock.setFlat(true);
        this.rotateUnclock.setToolTipText("Rotate counter clockwise");
        GridBagConstraints gbc_rotateUnclock_1 = new GridBagConstraints();
        gbc_rotateUnclock_1.insets = new Insets(0, 0, 0, 1);
        gbc_rotateUnclock_1.gridx = 3;
        gbc_rotateUnclock_1.gridy = 1;
        panel.add((Component)this.rotateUnclock, gbc_rotateUnclock_1);
        this.rotateClock = new IcyButton(new IcyIcon(ResourceUtil.ICON_ROTATE_CLOCK, 20));
        this.rotateClock.setFlat(true);
        this.rotateClock.setToolTipText("Rotate clockwise");
        GridBagConstraints gbc_rotateClock_1 = new GridBagConstraints();
        gbc_rotateClock_1.insets = new Insets(0, 0, 0, 5);
        gbc_rotateClock_1.gridx = 4;
        gbc_rotateClock_1.gridy = 1;
        panel.add((Component)this.rotateClock, gbc_rotateClock_1);
        this.zoomFitImageButton = new IcyButton(new IcyIcon(TestVisu.ICON_FIT_IMAGE));
        this.zoomFitImageButton.setFlat(true);
        this.zoomFitImageButton.setToolTipText("Fit window to image size");
        GridBagConstraints gbc_zoomFitImage = new GridBagConstraints();
        gbc_zoomFitImage.insets = new Insets(0, 0, 0, 5);
        gbc_zoomFitImage.gridx = 6;
        gbc_zoomFitImage.gridy = 1;
        panel.add((Component)this.zoomFitImageButton, gbc_zoomFitImage);
        this.centerImageButton = new IcyButton(new IcyIcon(TestVisu.ICON_CENTER_IMAGE));
        this.centerImageButton.setFlat(true);
        this.centerImageButton.setToolTipText("Center image in window");
        GridBagConstraints gbc_centerImageButton = new GridBagConstraints();
        gbc_centerImageButton.gridx = 7;
        gbc_centerImageButton.gridy = 1;
        panel.add((Component)this.centerImageButton, gbc_centerImageButton);
        this.bgColorButton = new ColorChooserButton();
        this.bgColorButton.setToolTipText("Left click to change background color, right click to enable/disable background color");
        GridBagConstraints gbc_bgColorButton = new GridBagConstraints();
        gbc_bgColorButton.gridwidth = 2;
        gbc_bgColorButton.fill = 2;
        gbc_bgColorButton.insets = new Insets(0, 0, 5, 0);
        gbc_bgColorButton.gridx = 6;
        gbc_bgColorButton.gridy = 0;
        panel.add((Component)this.bgColorButton, gbc_bgColorButton);
        this.LoadCorrelated = new IcyButton(new IcyIcon(TestVisu.ICON_LOAD));
        this.LoadCorrelated.setFlat(true);
        this.LoadCorrelated.setToolTipText("Load Correlated Image");
        GridBagConstraints gbc_loadcorrelatedButton = new GridBagConstraints();
        gbc_loadcorrelatedButton.gridx = 5;
        gbc_loadcorrelatedButton.gridy = 1;
        panel.add((Component)this.LoadCorrelated, gbc_loadcorrelatedButton);
    }

    public void updateZoomState(String zoom) {
        this.zoomComboBox.setSelectedItem(zoom);
    }

    public void updateRotationState(String rotInfo) {
        this.rotationComboBox.setSelectedItem(rotInfo);
    }

    public boolean isBackgroundColorEnabled() {
        return this.bgColorButton.isSelected();
    }

    public void setBackgroundColorEnabled(boolean value) {
        this.bgColorButton.setSelected(value);
    }

    public Color getBackgroundColor() {
        return this.bgColorButton.getColor();
    }

    public void setBackgroundColor(Color color) {
        this.bgColorButton.setColor(color);
    }
}

