/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.correlativeview;

import icy.canvas.IcyCanvas;
import icy.common.exception.UnsupportedFormatException;
import icy.file.Loader;
import icy.gui.dialog.LoaderDialog;
import icy.gui.dialog.MessageDialog;
import icy.gui.frame.progress.ToolTipFrame;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginCanvas;
import icy.util.XMLUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.perrine.correlativeview.TestVisu;

public class CorrelativeView
extends Plugin
implements PluginCanvas {
    public String getCanvasClassName() {
        return "CorrelativeView";
    }

    public IcyCanvas createCanvas(Viewer viewer) {
        new ToolTipFrame("<html><br> After having used <b>ec-clem</b>:<br> This open image is the \"target\" image: <br> you will now display the source image on the source image, AT FULL RESOLUTION.<br> <li> First select your \"source\" image in the dialog</li> <br> <li> Then select the transformation .xml NOT THE \"SCHEMA \" generated when using ec-clem (source to target)</li> <br> <li> In the layer panel, you can change the opacity of the target image layer, <br> which will balance the opacity of the source as well</li> <br> Note that you can use <b>ecClemTransformationSchemaInverter</b><br> to generate this transform if you do it in the reverse way</html>", "startmessagecorview");
        LoaderDialog dialog = new LoaderDialog(false);
        dialog.setDialogTitle("Select the correlated image");
        dialog.updateUI();
        File path = dialog.getSelectedFile();
        LoaderDialog dialogtransfo = new LoaderDialog(false);
        dialogtransfo.setDialogTitle("Select the transfo from correlated image to opened image");
        dialog.updateUI();
        File pathtransfo = dialogtransfo.getSelectedFile();
        IcyBufferedImage image = null;
        BufferedImage correlatedimagebuf = null;
        try {
            image = Loader.loadImage((String)path.getPath());
            correlatedimagebuf = IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)image, (int)2);
        }
        catch (UnsupportedFormatException e) {
            e.printStackTrace();
            MessageDialog.showDialog((String)"image format not supported");
        }
        catch (IOException e) {
            e.printStackTrace();
            MessageDialog.showDialog((String)"no image selected");
        }
        Document document = XMLUtil.loadDocument((File)pathtransfo);
        Element transfo = (Element)XMLUtil.getElements((Node)document.getDocumentElement(), (String)"MatrixTransformation").get(0);
        Element transfoinfo = (Element)XMLUtil.getElements((Node)document.getDocumentElement(), (String)"transformation").get(0);
        ArrayList sequenceSizeElements = XMLUtil.getElements((Node)transfoinfo, (String)"sequenceSize");
        if (sequenceSizeElements.size() != 2) {
            throw new RuntimeException("Element should contain exactly 2 sequenceSize");
        }
        double sourceSequenceSize = this.readSequenceSize((Element)sequenceSizeElements.get(0));
        double targetSequenceSize = this.readSequenceSize((Element)sequenceSizeElements.get(1));
        if (((Element)sequenceSizeElements.get(0)).getAttribute("type").equals("target")) {
            double tmp = sourceSequenceSize;
            sourceSequenceSize = targetSequenceSize;
            targetSequenceSize = tmp;
        }
        double[][] m = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                m[i][j] = XMLUtil.getAttributeDoubleValue((Element)transfo, (String)("m" + String.valueOf(i) + String.valueOf(j)), (double)0.0);
            }
        }
        return new TestVisu(viewer, correlatedimagebuf, m, sourceSequenceSize, targetSequenceSize);
    }

    private double readSequenceSize(Element element) {
        double pixelsizeum = 1.0;
        ArrayList elements = XMLUtil.getElements((Node)element);
        for (Element dimension : elements) {
            String dim = dimension.getAttribute("name");
            if (dim.compareTo("X") != 0) continue;
            pixelsizeum = Double.parseDouble(dimension.getAttribute("pixelSize"));
        }
        return pixelsizeum;
    }
}

