/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.correlativeview;

import Jama.Matrix;
import icy.canvas.CanvasLayerEvent;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.canvas.IcyCanvasEvent;
import icy.canvas.Layer;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.menu.ROITask;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.ImageUtil;
import icy.image.lut.LUT;
import icy.main.Icy;
import icy.math.Interpolator;
import icy.math.MathUtil;
import icy.math.MultiSmoothMover;
import icy.math.SmoothMover;
import icy.painter.ImageOverlay;
import icy.painter.Overlay;
import icy.preferences.CanvasPreferences;
import icy.preferences.XMLPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.system.thread.SingleProcessor;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle2DUtil;
import icy.type.rectangle.Rectangle5D;
import icy.util.EventUtil;
import icy.util.GraphicsUtil;
import icy.util.ShapeUtil;
import icy.util.StringUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import plugins.kernel.roi.tool.plugin.ROILineCutterPlugin;
import plugins.perrine.correlativeview.TestVisuSettingPanel;

public class TestVisu
extends IcyCanvas2D
implements ROITask.ROITaskListener {
    private static final long serialVersionUID = 891040681251398181L;
    static final int ICON_SIZE = 20;
    static final int ICON_TARGET_SIZE = 20;
    static final Image ICON_CENTER_IMAGE = ResourceUtil.ICON_CENTER_IMAGE;
    static final Image ICON_FIT_IMAGE = ResourceUtil.ICON_FIT_IMAGE;
    static final Image ICON_FIT_CANVAS = ResourceUtil.ICON_FIT_CANVAS;
    static final Image ICON_LOAD = ResourceUtil.ICON_OPEN;
    static final Image ICON_TARGET = ImageUtil.scale((Image)ResourceUtil.ICON_TARGET, (int)20, (int)20);
    static final Image ICON_TARGET_BLACK = ImageUtil.getColorImageFromAlphaImage((Image)ICON_TARGET, (Color)Color.black);
    static final Image ICON_TARGET_LIGHT = ImageUtil.getColorImageFromAlphaImage((Image)ICON_TARGET, (Color)Color.lightGray);
    static final double[] zoomRoundedFactors = new double[]{0.01, 0.02, 0.0333, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.333, 0.5, 0.66, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 2.5, 3.0, 4.0, 5.0, 6.6, 7.5, 10.0, 15.0, 20.0, 30.0, 50.0, 66.0, 75.0, 100.0};
    static final String PREF_TestVisu_ID = "TestVisu";
    static final String ID_FIT_CANVAS = "fitCanvas";
    static final String ID_BG_COLOR_ENABLED = "bgColorEnabled";
    static final String ID_BG_COLOR = "bgColor";
    static final int TRANS_X = 0;
    static final int TRANS_Y = 1;
    static final int SCALE_X = 2;
    static final int SCALE_Y = 3;
    static final int ROT = 4;
    final CanvasView canvasView;
    final CanvasMap canvasMap;
    IcyToggleButton zoomFitCanvasButton;
    Color bgColor;
    final XMLPreferences preferences;
    final TestVisuSmoothMover smoothTransform;
    String textInfos;
    Dimension previousImageSize;
    boolean modifyingZoom;
    boolean modifyingRotation;
    BufferedImage correlatedimage;
    double scales;
    double scalet;
    Matrix matrix;

    public TestVisu(Viewer viewer, BufferedImage correlatedimagebuf, double[][] m, double ss, double st) {
        super(viewer);
        this.correlatedimage = correlatedimagebuf;
        this.scalet = st;
        this.scales = ss;
        this.matrix = new Matrix(m);
        this.posC = -1;
        this.canvasView = new CanvasView();
        this.canvasMap = new CanvasMap();
        this.preferences = CanvasPreferences.getPreferences().node(PREF_TestVisu_ID);
        this.smoothTransform = new TestVisuSmoothMover(5, SmoothMover.SmoothMoveType.LOG);
        this.smoothTransform.setValues(new double[]{0.0, 0.0, 1.0, 1.0, 0.0});
        this.textInfos = null;
        this.modifyingZoom = false;
        this.modifyingRotation = false;
        this.previousImageSize = new Dimension(this.getImageSizeX(), this.getImageSizeY());
        this.getImageLayer().setOpacity(0.8f);
        this.smoothTransform.addListener((MultiSmoothMover.MultiSmoothMoverListener)new MultiSmoothMover.MultiSmoothMoverAdapter(){

            public void valueChanged(MultiSmoothMover source, int index, double newValue, int pourcent) {
                switch (index) {
                    case 0: {
                        TestVisu.this.offsetChanged(DimensionId.X);
                        break;
                    }
                    case 1: {
                        TestVisu.this.offsetChanged(DimensionId.Y);
                        break;
                    }
                    case 2: {
                        TestVisu.this.scaleChanged(DimensionId.X);
                        break;
                    }
                    case 3: {
                        TestVisu.this.scaleChanged(DimensionId.Y);
                        break;
                    }
                    case 4: {
                        TestVisu.this.rotationChanged(DimensionId.Z);
                    }
                }
            }

            public void moveEnded(MultiSmoothMover source, int index, double value) {
                switch (index) {
                    case 2: {
                        TestVisu.this.canvasView.curScaleX = -1.0;
                        break;
                    }
                    case 3: {
                        TestVisu.this.canvasView.curScaleY = -1.0;
                    }
                }
            }
        });
        this.smoothTransform.setMoveTime(400);
        this.smoothTransform.setUpdateDelay(20);
        this.buildSettingGUI();
        this.add(this.canvasView, "Center");
        this.mouseInfPanel.setInfoXVisible(true);
        this.mouseInfPanel.setInfoYVisible(true);
        this.mouseInfPanel.setInfoZVisible(false);
        this.mouseInfPanel.setInfoTVisible(false);
        this.mouseInfPanel.setInfoCVisible(false);
        this.mouseInfPanel.setInfoDataVisible(true);
        this.mouseInfPanel.setInfoColorVisible(true);
        this.updateZNav();
        this.updateTNav();
        ROITask trt = Icy.getMainInterface().getROIRibbonTask();
        if (trt != null) {
            trt.addListener((ROITask.ROITaskListener)this);
        }
    }

    public void shutDown() {
        super.shutDown();
        this.canvasView.shutDown();
        this.smoothTransform.shutDown();
        ROITask trt = Icy.getMainInterface().getROIRibbonTask();
        if (trt != null) {
            trt.removeListener((ROITask.ROITaskListener)this);
        }
    }

    protected Overlay createImageOverlay() {
        return new TestVisuImageOverlay();
    }

    public TestVisuSettingPanel getCanvasSettingPanel() {
        return (TestVisuSettingPanel)this.panel;
    }

    private void buildSettingGUI() {
        this.panel = new TestVisuSettingPanel(this);
        this.panel.add((Component)this.canvasMap, "Center");
        this.zoomFitCanvasButton = new IcyToggleButton(new IcyIcon(ICON_FIT_CANVAS));
        this.zoomFitCanvasButton.setSelected(this.preferences.getBoolean(ID_FIT_CANVAS, false));
        this.zoomFitCanvasButton.setFocusable(false);
        this.zoomFitCanvasButton.setToolTipText("Keep image fitting to window size");
        this.zoomFitCanvasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = TestVisu.this.zoomFitCanvasButton.isSelected();
                TestVisu.this.preferences.putBoolean(TestVisu.ID_FIT_CANVAS, selected);
                if (selected) {
                    TestVisu.this.fitImageToCanvas(true);
                }
            }
        });
    }

    public Component getViewComponent() {
        return this.canvasView;
    }

    public CanvasView getCanvasView() {
        return this.canvasView;
    }

    public CanvasMap getCanvasMap() {
        return this.canvasMap;
    }

    public void customizeToolbar(JToolBar toolBar) {
        toolBar.addSeparator();
        toolBar.add((Component)this.zoomFitCanvasButton);
    }

    public void fitImageToCanvas() {
        this.fitImageToCanvas(false);
    }

    public void fitImageToCanvas(boolean smooth) {
        Point2D.Double s = this.getFitImageToCanvasScale();
        if (s != null) {
            double scale = Math.min(s.x, s.y);
            this.centerMouseOnImage();
            this.setScale(scale, scale, true, smooth);
        }
    }

    public void fitCanvasToImage() {
        this.centerImage();
        super.fitCanvasToImage();
    }

    public void centerOnImage(double x, double y) {
        Point pt = this.imageToCanvas(x, y);
        int canvasCenterX = this.getCanvasSizeX() / 2;
        int canvasCenterY = this.getCanvasSizeY() / 2;
        Point2D.Double newTrans = this.canvasToImageDelta(canvasCenterX - pt.x, canvasCenterY - pt.y, 1.0, 1.0, this.getRotationZ());
        this.setOffset((int)(this.smoothTransform.getDestValue(0) + (double)Math.round(newTrans.x)), (int)(this.smoothTransform.getDestValue(1) + (double)Math.round(newTrans.y)), false);
    }

    protected void centerMouseOnImage() {
        this.setMouseImagePos(this.getImageSizeX() / 2, this.getImageSizeY() / 2);
    }

    protected void centerMouseOnView() {
        this.setMousePos(this.getCanvasSizeX() >> 1, this.getCanvasSizeY() >> 1);
    }

    public void centerOn(Rectangle region) {
        int offY;
        int offX;
        double newScale;
        double scaleY;
        Rectangle2D imageRectMax = Rectangle2DUtil.getScaledRectangle((Rectangle2D)new Rectangle(this.getImageSizeX(), this.getImageSizeY()), (double)1.5, (boolean)true);
        Rectangle2D adjusted = Rectangle2DUtil.getScaledRectangle((Rectangle2D)region, (double)2.0, (boolean)true);
        double wu = Math.max(0.0, 100.0 - adjusted.getWidth());
        double hu = Math.max(0.0, 100.0 - adjusted.getHeight());
        if (wu > 0.0 || hu > 0.0) {
            ShapeUtil.enlarge((RectangularShape)adjusted, (double)wu, (double)hu, (boolean)true);
        }
        double wo = Math.max(0.0, adjusted.getWidth() - imageRectMax.getWidth());
        double ho = Math.max(0.0, adjusted.getHeight() - imageRectMax.getHeight());
        if (wo > 0.0 || ho > 0.0) {
            ShapeUtil.enlarge((RectangularShape)adjusted, (double)(-wo), (double)(-ho), (boolean)true);
        }
        Rectangle viewRect = new Rectangle(this.getViewComponent().getSize());
        double scaleX = (double)viewRect.width / adjusted.getWidth();
        if (scaleX < (scaleY = (double)viewRect.height / adjusted.getHeight())) {
            newScale = scaleX;
            offX = (int)(adjusted.getX() * newScale);
            offY = (int)(adjusted.getY() * newScale - ((double)viewRect.height - adjusted.getHeight() * newScale) / 2.0);
        } else {
            newScale = scaleY;
            offX = (int)(adjusted.getX() * newScale - ((double)viewRect.width - adjusted.getWidth() * newScale) / 2.0);
            offY = (int)(adjusted.getY() * newScale);
        }
        this.setTransform(-offX, -offY, newScale, newScale, this.smoothTransform.getDestValue(4), true);
    }

    protected void setTransform(int tx, int ty, double sx, double sy, double rot, boolean smooth) {
        double[] values = new double[]{tx, ty, sx, sy, rot};
        if (smooth) {
            this.smoothTransform.moveTo(values);
        } else {
            this.smoothTransform.setValues(values);
        }
    }

    public void setOffset(int x, int y, boolean smooth) {
        int adjX = Math.min(this.getMaxOffsetX(), Math.max(this.getMinOffsetX(), x));
        int adjY = Math.min(this.getMaxOffsetY(), Math.max(this.getMinOffsetY(), y));
        this.setTransform(adjX, adjY, this.smoothTransform.getDestValue(2), this.smoothTransform.getDestValue(3), this.smoothTransform.getDestValue(4), smooth);
    }

    public void setScale(double factor, boolean center, boolean smooth) {
        if (center) {
            this.centerMouseOnImage();
        }
        this.setScale(factor, factor, true, smooth);
    }

    public void setScale(double x, double y, boolean mouseCentered, boolean smooth) {
        Point2D.Double newTrans;
        Sequence seq = this.getSequence();
        if (seq == null) {
            return;
        }
        double rot = this.smoothTransform.getDestValue(4);
        double newScaleX = Math.max(0.01, Math.min(100.0, x));
        double newScaleY = Math.max(0.01, Math.min(100.0, y));
        Point newMouseCanvasPos = this.imageToCanvas(this.mouseImagePos.x, this.mouseImagePos.y, 0, 0, newScaleX, newScaleY, rot);
        int newImgSizeX = (int)Math.ceil((double)this.getImageSizeX() * newScaleX);
        int newImgSizeY = (int)Math.ceil((double)this.getImageSizeY() * newScaleY);
        int canvasCenterX = this.getCanvasSizeX() / 2;
        int canvasCenterY = this.getCanvasSizeY() / 2;
        if (mouseCentered) {
            newTrans = this.canvasToImageDelta(canvasCenterX - newMouseCanvasPos.x, canvasCenterY - newMouseCanvasPos.y, 1.0, 1.0, rot);
        } else {
            Point mousePos = this.getMousePos();
            newTrans = this.canvasToImageDelta(mousePos.x - newMouseCanvasPos.x, mousePos.y - newMouseCanvasPos.y, 1.0, 1.0, rot);
        }
        int newTransX = Math.min(canvasCenterX, Math.max(canvasCenterX - newImgSizeX, (int)Math.round(newTrans.x)));
        int newTransY = Math.min(canvasCenterY, Math.max(canvasCenterY - newImgSizeY, (int)Math.round(newTrans.y)));
        this.setTransform(newTransX, newTransY, newScaleX, newScaleY, rot, smooth);
    }

    public void setScale(double x, double y, boolean smooth) {
        this.setTransform((int)this.smoothTransform.getDestValue(0), (int)this.smoothTransform.getDestValue(1), x, y, this.smoothTransform.getDestValue(4), smooth);
    }

    @Deprecated
    public void setZoom(float zoom) {
        this.centerMouseOnImage();
        this.setScale(zoom, zoom, true, false);
    }

    public int getDestImageCanvasSizeX() {
        return (int)Math.ceil((double)this.getImageSizeX() * this.smoothTransform.getDestValue(2));
    }

    public int getDestImageCanvasSizeY() {
        return (int)Math.ceil((double)this.getImageSizeY() * this.smoothTransform.getDestValue(3));
    }

    void backgroundColorEnabledChanged() {
        this.preferences.putBoolean(ID_BG_COLOR_ENABLED, this.isBackgroundColorEnabled());
        this.canvasView.refresh();
    }

    void backgroundColorChanged() {
        this.preferences.putInt(ID_BG_COLOR, this.getBackgroundColor().getRGB());
        this.canvasView.refresh();
    }

    public boolean isBackgroundColorEnabled() {
        return this.getCanvasSettingPanel().isBackgroundColorEnabled();
    }

    public void setBackgroundColorEnabled(boolean value) {
        this.getCanvasSettingPanel().setBackgroundColorEnabled(value);
    }

    public Color getBackgroundColor() {
        return this.getCanvasSettingPanel().getBackgroundColor();
    }

    public void setBackgroundColor(Color color) {
        this.getCanvasSettingPanel().setBackgroundColor(color);
    }

    public boolean getFitToCanvas() {
        if (this.zoomFitCanvasButton != null) {
            return this.zoomFitCanvasButton.isSelected();
        }
        return false;
    }

    public void setFitToCanvas(boolean value) {
        if (this.zoomFitCanvasButton != null) {
            this.zoomFitCanvasButton.setSelected(value);
        }
    }

    public boolean isSynchronizationSupported() {
        return true;
    }

    protected int getMinOffsetX() {
        return this.getCanvasSizeX() / 2 - this.getDestImageCanvasSizeX();
    }

    protected int getMaxOffsetX() {
        return this.getCanvasSizeX() / 2;
    }

    protected int getMinOffsetY() {
        return this.getCanvasSizeY() / 2 - this.getDestImageCanvasSizeY();
    }

    protected int getMaxOffsetY() {
        return this.getCanvasSizeY() / 2;
    }

    public int getOffsetX() {
        if (this.smoothTransform == null) {
            return 0;
        }
        return (int)this.smoothTransform.getValue(0);
    }

    public int getOffsetY() {
        if (this.smoothTransform == null) {
            return 0;
        }
        return (int)this.smoothTransform.getValue(1);
    }

    public double getScaleX() {
        if (this.smoothTransform == null) {
            return 0.0;
        }
        return this.smoothTransform.getValue(2);
    }

    public double getScaleY() {
        if (this.smoothTransform == null) {
            return 0.0;
        }
        return this.smoothTransform.getValue(3);
    }

    public double getRotationZ() {
        if (this.smoothTransform == null) {
            return 0.0;
        }
        return this.smoothTransform.getValue(4);
    }

    @Deprecated
    public double getZoomFactor() {
        return this.getScaleX();
    }

    public double getRotation() {
        return MathUtil.formatRadianAngle((double)this.getRotationZ());
    }

    protected void setPositionCInternal(int c) {
    }

    protected void setOffsetXInternal(int value) {
        this.smoothTransform.setValue(0, Math.min(this.getMaxOffsetX(), Math.max(this.getMinOffsetX(), value)));
    }

    protected void setOffsetYInternal(int value) {
        this.smoothTransform.setValue(1, Math.min(this.getMaxOffsetY(), Math.max(this.getMinOffsetY(), value)));
    }

    protected void setScaleXInternal(double value) {
        this.smoothTransform.setValue(2, value);
        this.canvasView.curScaleX = value;
    }

    protected void setScaleYInternal(double value) {
        this.smoothTransform.setValue(3, value);
        this.canvasView.curScaleY = value;
    }

    protected void setRotationZInternal(double value) {
        this.smoothTransform.setValue(4, value);
    }

    public void setRotation(double value, boolean smooth) {
        this.setTransform((int)this.smoothTransform.getDestValue(0), (int)this.smoothTransform.getDestValue(1), this.smoothTransform.getDestValue(2), this.smoothTransform.getDestValue(3), value, smooth);
    }

    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (!e.isConsumed()) {
            switch (e.getKeyCode()) {
                case 82: {
                    this.setRotation(0.0, false);
                    this.fitImageToCanvas(true);
                    if (EventUtil.isShiftDown((InputEvent)e, (boolean)true)) {
                        Sequence sequence = this.getSequence();
                        if (this.viewer != null && sequence != null) {
                            this.viewer.setLut(sequence.createCompatibleLUT());
                        }
                    }
                    e.consume();
                    break;
                }
                case 37: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.setPositionT(Math.max(this.getPositionT() - 5, 0));
                    } else {
                        this.setPositionT(Math.max(this.getPositionT() - 1, 0));
                    }
                    e.consume();
                    break;
                }
                case 39: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.setPositionT(this.getPositionT() + 5);
                    } else {
                        this.setPositionT(this.getPositionT() + 1);
                    }
                    e.consume();
                    break;
                }
                case 38: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.setPositionZ(this.getPositionZ() + 5);
                    } else {
                        this.setPositionZ(this.getPositionZ() + 1);
                    }
                    e.consume();
                    break;
                }
                case 40: {
                    if (EventUtil.isMenuControlDown((InputEvent)e, (boolean)true)) {
                        this.setPositionZ(Math.max(this.getPositionZ() - 5, 0));
                    } else {
                        this.setPositionZ(Math.max(this.getPositionZ() - 1, 0));
                    }
                    e.consume();
                    break;
                }
                case 98: {
                    if (this.canvasView.moving) break;
                    Point startPos = new Point(this.getOffsetX(), this.getOffsetY());
                    Point delta = new Point(0, -this.getCanvasSizeY() / 4);
                    this.canvasView.translate(startPos, delta, EventUtil.isControlDown((InputEvent)e));
                    e.consume();
                    break;
                }
                case 100: {
                    if (this.canvasView.moving) break;
                    Point startPos = new Point(this.getOffsetX(), this.getOffsetY());
                    Point delta = new Point(this.getCanvasSizeX() / 4, 0);
                    this.canvasView.translate(startPos, delta, EventUtil.isControlDown((InputEvent)e));
                    e.consume();
                    break;
                }
                case 102: {
                    if (this.canvasView.moving) break;
                    Point startPos = new Point(this.getOffsetX(), this.getOffsetY());
                    Point delta = new Point(-this.getCanvasSizeX() / 4, 0);
                    this.canvasView.translate(startPos, delta, EventUtil.isControlDown((InputEvent)e));
                    e.consume();
                    break;
                }
                case 104: {
                    if (this.canvasView.moving) break;
                    Point startPos = new Point(this.getOffsetX(), this.getOffsetY());
                    Point delta = new Point(0, this.getCanvasSizeY() / 4);
                    this.canvasView.translate(startPos, delta, EventUtil.isControlDown((InputEvent)e));
                    e.consume();
                }
            }
        }
        this.canvasView.keyPressed(e);
        this.canvasMap.keyPressed(e);
    }

    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
        this.canvasView.keyReleased(e);
        this.canvasMap.keyReleased(e);
    }

    public void refresh() {
        this.canvasView.imageChanged();
        this.canvasView.layersChanged();
        this.canvasView.refresh();
    }

    public BufferedImage getARGBImage(int t, int z, int c, BufferedImage out) {
        IcyBufferedImage img = this.getImage(t, z, c);
        if (img != null) {
            BufferedImage result = out != null && ImageUtil.sameSize((BufferedImage)img, (BufferedImage)out) ? out : new BufferedImage(img.getSizeX(), img.getSizeY(), 2);
            return IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)img, (BufferedImage)result, (LUT)this.getLut());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getRenderedImage(int t, int z, int c, boolean cv) {
        Sequence seq = this.getSequence();
        if (seq == null) {
            return null;
        }
        int prevT = this.getPositionT();
        int prevZ = this.getPositionZ();
        boolean dl = this.isLayersVisible();
        if (dl) {
            this.setPositionT(t);
            this.setPositionZ(z);
        }
        try {
            Layer imgLayer;
            Dimension size = cv ? this.getCanvasSize() : seq.getDimension2D();
            BufferedImage result = new BufferedImage(size.width, size.height, 2);
            Graphics2D g = result.createGraphics();
            g.setClip(0, 0, size.width, size.height);
            if (cv) {
                if (CanvasPreferences.getFiltering() && this.getScaleX() < 4.0 && this.getScaleY() < 4.0) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.transform(this.getTransform());
            } else {
                if (CanvasPreferences.getFiltering()) {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                } else {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                }
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (t == prevT && z == prevZ && c == -1) {
                imgLayer = this.getImageLayer();
            } else {
                BufferedImage img = this.getARGBImage(t, z, c, null);
                ImageOverlay imgOverlay = new ImageOverlay("Image", (Image)img);
                imgLayer = new Layer((Overlay)imgOverlay);
                imgLayer.setVisible(this.getImageLayer().isVisible());
                imgLayer.setPriority(this.getImageLayer().getPriority());
            }
            this.canvasView.drawImageAndLayers(g, imgLayer);
            g.dispose();
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            if (dl) {
                this.setPositionT(prevT);
                this.setPositionZ(prevZ);
            }
        }
    }

    protected void synchronizeCanvas(List<IcyCanvas> canvasList, IcyCanvasEvent event, boolean processAll) {
        block26: {
            IcyCanvasEvent.IcyCanvasEventType type = event.getType();
            DimensionId dim = event.getDim();
            if (this.isSynchOnSlice() && (processAll || type == IcyCanvasEvent.IcyCanvasEventType.POSITION_CHANGED)) {
                if (processAll || dim == DimensionId.NULL) {
                    int z = this.getPositionZ();
                    int t = this.getPositionT();
                    for (IcyCanvas cnv : canvasList) {
                        if (z != -1) {
                            cnv.setPositionZ(z);
                        }
                        if (t == -1) continue;
                        cnv.setPositionT(t);
                    }
                } else {
                    for (IcyCanvas cnv : canvasList) {
                        int pos = this.getPosition(dim);
                        if (pos == -1) continue;
                        cnv.setPosition(dim, pos);
                    }
                }
            }
            if (this.isSynchOnView()) {
                if (processAll || type == IcyCanvasEvent.IcyCanvasEventType.SCALE_CHANGED) {
                    if (processAll || dim == DimensionId.NULL) {
                        double sX = this.getScaleX();
                        double sY = this.getScaleY();
                        for (IcyCanvas cnv : canvasList) {
                            ((TestVisu)cnv).setScale(sX, sY, false);
                        }
                    } else {
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setScale(dim, this.getScale(dim));
                        }
                    }
                }
                if (processAll || type == IcyCanvasEvent.IcyCanvasEventType.ROTATION_CHANGED) {
                    if (processAll || dim == DimensionId.NULL) {
                        double rot = this.getRotationZ();
                        for (IcyCanvas cnv : canvasList) {
                            ((TestVisu)cnv).setRotation(rot, false);
                        }
                    } else {
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setRotation(dim, this.getRotation(dim));
                        }
                    }
                }
                if (processAll || type == IcyCanvasEvent.IcyCanvasEventType.OFFSET_CHANGED) {
                    if (processAll || dim == DimensionId.NULL) {
                        int offX = this.getOffsetX();
                        int offY = this.getOffsetY();
                        for (IcyCanvas cnv : canvasList) {
                            ((TestVisu)cnv).setOffset(offX, offY, false);
                        }
                    } else {
                        for (IcyCanvas cnv : canvasList) {
                            cnv.setOffset(dim, this.getOffset(dim));
                        }
                    }
                }
            }
            if (!this.isSynchOnCursor() || !processAll && type != IcyCanvasEvent.IcyCanvasEventType.MOUSE_IMAGE_POSITION_CHANGED) break block26;
            if (processAll || dim == DimensionId.NULL) {
                double mouseImagePosX = this.getMouseImagePosX();
                double mouseImagePosY = this.getMouseImagePosY();
                for (IcyCanvas cnv : canvasList) {
                    ((TestVisu)cnv).setMouseImagePos(mouseImagePosX, mouseImagePosY);
                }
            } else {
                for (IcyCanvas cnv : canvasList) {
                    cnv.setMouseImagePos(dim, this.getMouseImagePos(dim));
                }
            }
        }
    }

    public void changed(IcyCanvasEvent event) {
        super.changed(event);
        if (this.canvasView == null) {
            return;
        }
        IcyCanvasEvent.IcyCanvasEventType type = event.getType();
        switch (type) {
            case POSITION_CHANGED: {
                this.canvasView.imageChanged();
            }
            case OFFSET_CHANGED: 
            case SCALE_CHANGED: 
            case ROTATION_CHANGED: {
                this.setMouseImagePos(this.canvasToImage(this.getMousePos()));
                if (type == IcyCanvasEvent.IcyCanvasEventType.SCALE_CHANGED) {
                    final String zoomInfo = Integer.toString((int)(this.getScaleX() * 100.0));
                    ThreadUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TestVisu.this.modifyingZoom = true;
                            try {
                                TestVisu.this.getCanvasSettingPanel().updateZoomState(zoomInfo);
                            }
                            finally {
                                TestVisu.this.modifyingZoom = false;
                            }
                        }
                    });
                    this.canvasView.setZoomMessage("Zoom : " + zoomInfo + " %", 500);
                } else if (type == IcyCanvasEvent.IcyCanvasEventType.ROTATION_CHANGED) {
                    final String rotInfo = Integer.toString((int)Math.round(this.getRotation() * 180.0 / Math.PI));
                    ThreadUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TestVisu.this.modifyingRotation = true;
                            try {
                                TestVisu.this.getCanvasSettingPanel().updateRotationState(rotInfo);
                            }
                            finally {
                                TestVisu.this.modifyingRotation = false;
                            }
                        }
                    });
                    this.canvasView.setRotationMessage("Rotation : " + rotInfo + " \ufffd", 500);
                }
                this.canvasView.refresh();
                break;
            }
            case MOUSE_IMAGE_POSITION_CHANGED: {
                if (!(this.canvasView.handlingMouseMoveEvent || this.canvasView.isDragging() || this.isSynchSlave())) {
                    Point mousePos = this.getMousePos();
                    Point mouseAbsolutePos = this.getMousePos();
                    SwingUtilities.convertPointToScreen(mouseAbsolutePos, this.canvasView);
                    MouseEvent mouseEvent = new MouseEvent((Component)((Object)this), 503, System.currentTimeMillis(), 0, mousePos.x, mousePos.y, mouseAbsolutePos.x, mouseAbsolutePos.y, 0, false, 0);
                    this.mouseMove(mouseEvent, this.getMouseImagePos5D());
                }
                this.canvasView.updateCursor();
                if (this.canvasView.hasMouseFocus) break;
                this.canvasView.refresh();
            }
        }
    }

    protected void lutChanged(int component) {
        super.lutChanged(component);
        if (this.canvasView != null) {
            this.canvasView.imageChanged();
            this.canvasView.refresh();
        }
    }

    protected void layerChanged(CanvasLayerEvent event) {
        super.layerChanged(event);
        if (event.getType() == CanvasLayerEvent.LayersEventType.CHANGED && Layer.isPaintProperty((String)event.getProperty()) && this.canvasView != null) {
            this.canvasView.layersChanged();
            this.canvasView.refresh();
        }
    }

    protected void sequenceOverlayChanged(Overlay overlay, SequenceEvent.SequenceEventType type) {
        super.sequenceOverlayChanged(overlay, type);
        if (this.canvasView != null) {
            this.canvasView.layersChanged();
            this.canvasView.refresh();
        }
    }

    protected void sequenceDataChanged(IcyBufferedImage image, SequenceEvent.SequenceEventType type) {
        super.sequenceDataChanged(image, type);
        if (this.canvasView != null) {
            this.canvasView.imageChanged();
            this.canvasView.refresh();
        }
    }

    protected void sequenceTypeChanged() {
        super.sequenceTypeChanged();
        if ((this.previousImageSize.width != this.getImageSizeX() || this.previousImageSize.height != this.getImageSizeY()) && this.getFitToCanvas()) {
            this.fitImageToCanvas(true);
        }
    }

    public void toolChanged(String command) {
        Sequence seq = this.getSequence();
        ROITask toolTask = Icy.getMainInterface().getROIRibbonTask();
        if (toolTask != null && toolTask.isROITool()) {
            this.setLayersVisible(true);
        }
        if (seq != null) {
            seq.setSelectedROI(null);
        }
    }

    static class TestVisuSmoothMover
    extends MultiSmoothMover {
        public TestVisuSmoothMover(int size, SmoothMover.SmoothMoveType type) {
            super(size, type);
        }

        public TestVisuSmoothMover(int size) {
            super(size);
        }

        public void moveTo(int index, double value) {
            double v = index == 4 ? MathUtil.formatRadianAngle((double)value) : value;
            if (this.destValues[index] != v) {
                this.destValues[index] = v;
                this.start(index, System.currentTimeMillis());
            }
        }

        public void moveTo(double[] values) {
            int maxInd = Math.min(values.length, this.destValues.length);
            boolean changed = false;
            for (int index = 0; index < maxInd; ++index) {
                double value = index == 4 ? MathUtil.formatRadianAngle((double)values[index]) : values[index];
                if (this.destValues[index] == value) continue;
                changed = true;
                break;
            }
            if (changed) {
                long time = System.currentTimeMillis();
                for (int index = 0; index < maxInd; ++index) {
                    double value = index == 4 ? MathUtil.formatRadianAngle((double)values[index]) : values[index];
                    this.destValues[index] = value;
                    this.start(index, time);
                }
            }
        }

        public void setValue(int index, double value) {
            double v = index == 4 ? MathUtil.formatRadianAngle((double)value) : value;
            this.stop(index);
            this.destValues[index] = v;
            this.setCurrentValue(index, v, 100);
        }

        public void setValues(double[] values) {
            int maxInd = Math.min(values.length, this.destValues.length);
            for (int index = 0; index < maxInd; ++index) {
                double value = index == 4 ? MathUtil.formatRadianAngle((double)values[index]) : values[index];
                this.stop(index);
                this.destValues[index] = value;
                this.setCurrentValue(index, value, 100);
            }
        }

        protected void setCurrentValue(int index, double value, int pourcent) {
            double v = index == 4 ? MathUtil.formatRadianAngle((double)value) : value;
            if (this.currentValues[index] != v) {
                this.currentValues[index] = v;
                this.changed(index, v, pourcent);
            }
        }

        protected void start(int index, long time) {
            double d;
            double current = this.currentValues[index];
            double dest = index == 4 ? (Math.abs((d = this.destValues[index]) - current) > Math.PI ? (d > Math.PI ? d - Math.PI * 2 : d + Math.PI * 2) : d) : this.destValues[index];
            int size = Math.max(this.moveTime / this.getUpdateDelay(), 1);
            switch (this.type) {
                case NONE: {
                    this.stepValues[index] = new double[2];
                    this.stepValues[index][0] = current;
                    this.stepValues[index][1] = dest;
                    break;
                }
                case LINEAR: {
                    this.stepValues[index] = Interpolator.doLinearInterpolation((double)current, (double)dest, (int)size);
                    break;
                }
                case LOG: {
                    this.stepValues[index] = Interpolator.doLogInterpolation((double)current, (double)dest, (int)size);
                    break;
                }
                case EXP: {
                    this.stepValues[index] = Interpolator.doExpInterpolation((double)current, (double)dest, (int)size);
                }
            }
            if (!this.isMoving(index)) {
                this.moveStarted(index, time);
                this.moving[index] = true;
            } else {
                this.moveModified(index, time);
            }
        }
    }

    public class CanvasView
    extends JPanel
    implements ActionListener,
    MouseWheelListener,
    MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 4041355608444378172L;
        final ImageCache imageCache = new ImageCache();
        final Font font;
        private final Timer refreshTimer;
        private final Timer zoomInfoTimer;
        private final Timer rotationInfoTimer;
        private final SmoothMover zoomInfoAlphaMover;
        private final SmoothMover rotationInfoAlphaMover;
        private String zoomMessage;
        private String rotationMessage;
        Dimension lastSize = this.getSize();
        boolean actived = false;
        boolean handlingMouseMoveEvent = false;
        private Point startDragPosition = null;
        private Point startOffset = null;
        double curScaleX = -1.0;
        double curScaleY = -1.0;
        private double startRotationZ;
        boolean moving = false;
        boolean rotating = false;
        boolean hasMouseFocus = false;
        boolean areaSelection = false;
        private double ss;
        private double st;

        public CanvasView() {
            this.font = new Font("Arial", 1, 16);
            this.zoomInfoAlphaMover = new SmoothMover(0.0);
            this.zoomInfoAlphaMover.setMoveTime(500);
            this.zoomInfoAlphaMover.setUpdateDelay(20);
            this.zoomInfoAlphaMover.addListener((SmoothMover.SmoothMoverListener)new SmoothMover.SmoothMoverAdapter(){

                public void valueChanged(SmoothMover source, double newValue, int pourcent) {
                    CanvasView.this.repaint();
                }
            });
            this.rotationInfoAlphaMover = new SmoothMover(0.0);
            this.rotationInfoAlphaMover.setMoveTime(500);
            this.rotationInfoAlphaMover.setUpdateDelay(20);
            this.rotationInfoAlphaMover.addListener((SmoothMover.SmoothMoverListener)new SmoothMover.SmoothMoverAdapter(){

                public void valueChanged(SmoothMover source, double newValue, int pourcent) {
                    CanvasView.this.repaint();
                }
            });
            this.refreshTimer = new Timer(100, this);
            this.refreshTimer.setRepeats(false);
            this.zoomInfoTimer = new Timer(1000, this);
            this.zoomInfoTimer.setRepeats(false);
            this.rotationInfoTimer = new Timer(1000, this);
            this.rotationInfoTimer.setRepeats(false);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension newSize = CanvasView.this.getSize();
                    int extX = 0;
                    int extY = 0;
                    if (!CanvasView.this.actived) {
                        TestVisu.this.fitImageToCanvas(false);
                        TestVisu.this.centerImage();
                        CanvasView.this.actived = true;
                    } else if (TestVisu.this.zoomFitCanvasButton.isSelected()) {
                        TestVisu.this.fitImageToCanvas(true);
                    } else {
                        int dx = newSize.width - CanvasView.this.lastSize.width;
                        int dy = newSize.height - CanvasView.this.lastSize.height;
                        int dx2 = dx / 2;
                        int dy2 = dy / 2;
                        extX = 2 * dx2 - dx;
                        extY = 2 * dy2 - dy;
                        TestVisu.this.setOffset((int)TestVisu.this.smoothTransform.getDestValue(0) + dx2, (int)TestVisu.this.smoothTransform.getDestValue(1) + dy2, true);
                    }
                    CanvasView.this.lastSize.width = newSize.width + extX;
                    CanvasView.this.lastSize.height = newSize.height + extY;
                }
            });
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        void shutDown() {
            this.refreshTimer.stop();
            this.zoomInfoTimer.stop();
            this.rotationInfoTimer.stop();
            this.refreshTimer.removeActionListener(this);
            this.zoomInfoTimer.removeActionListener(this);
            this.rotationInfoTimer.removeActionListener(this);
            this.zoomInfoAlphaMover.shutDown();
            this.rotationInfoAlphaMover.shutDown();
        }

        public ImageCache getImageCache() {
            return this.imageCache;
        }

        protected void updateDrag(boolean control, boolean shift) {
            if (!this.moving) {
                return;
            }
            Point mousePos = TestVisu.this.getMousePos();
            Point delta = new Point(mousePos.x - this.startDragPosition.x, mousePos.y - this.startDragPosition.y);
            if (shift) {
                if (Math.abs(delta.x) > Math.abs(delta.y)) {
                    delta.y = 0;
                } else {
                    delta.x = 0;
                }
            }
            this.translate(this.startOffset, delta, control);
        }

        protected void translate(Point startPos, Point delta, boolean control) {
            Point2D.Double deltaD = control ? TestVisu.this.canvasToImageDelta(delta.x * 3, delta.y * 3, 1.0, 1.0, TestVisu.this.getRotationZ()) : TestVisu.this.canvasToImageDelta(delta.x, delta.y, 1.0, 1.0, TestVisu.this.getRotationZ());
            TestVisu.this.setOffset((int)Math.round((double)startPos.x + deltaD.x), (int)Math.round((double)startPos.y + deltaD.y), true);
        }

        protected void updateRot(boolean control, boolean shift) {
            if (!this.rotating) {
                return;
            }
            Point mousePos = TestVisu.this.getMousePos();
            int canvasCenterX = TestVisu.this.getCanvasSizeX() / 2;
            int canvasCenterY = TestVisu.this.getCanvasSizeY() / 2;
            int lastMouseDeltaPosX = this.startDragPosition.x - canvasCenterX;
            int lastMouseDeltaPosY = this.startDragPosition.y - canvasCenterY;
            int newMouseDeltaPosX = mousePos.x - canvasCenterX;
            int newMouseDeltaPosY = mousePos.y - canvasCenterY;
            double newAngle = Math.atan2(newMouseDeltaPosY, newMouseDeltaPosX);
            double lastAngle = Math.atan2(lastMouseDeltaPosY, lastMouseDeltaPosX);
            double angle = newAngle - lastAngle;
            if (control) {
                angle *= 3.0;
            }
            double destAngle = shift ? Math.rint((this.startRotationZ + angle) * 1.2732395447351628) * 0.7853981633974483 : this.startRotationZ + angle;
            TestVisu.this.setRotation(destAngle, true);
        }

        boolean onMouseClicked(boolean consumed, int clickCount, boolean left, boolean right, boolean control) {
            if (!consumed) {
                // empty if block
            }
            return false;
        }

        boolean onMousePressed(boolean consumed, boolean left, boolean right, boolean control) {
            if (!consumed) {
                ROITask toolTask = Icy.getMainInterface().getROIRibbonTask();
                Sequence seq = TestVisu.this.getSequence();
                if (left) {
                    if (toolTask != null && toolTask.isROITool()) {
                        String roiClassName = toolTask.getSelected();
                        if (!control) {
                            Icy.getMainInterface().setSelectedTool(null);
                        }
                        if (seq != null) {
                            ROI roi = ROI.create((String)roiClassName, (Point5D)TestVisu.this.getMouseImagePos5D());
                            if (roi != null) {
                                roi.setCreating(true);
                                seq.addROI(roi, !roiClassName.equals(ROILineCutterPlugin.class.getName()));
                                seq.setSelectedROI(roi);
                            }
                            return true;
                        }
                    }
                    if (control) {
                        this.areaSelection = true;
                    }
                }
                this.startDragPosition = TestVisu.this.getMousePos();
                this.startOffset = new Point(TestVisu.this.getOffsetX(), TestVisu.this.getOffsetY());
                this.startRotationZ = TestVisu.this.getRotationZ();
                this.refresh();
                this.updateCursor();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean onMouseReleased(boolean consumed, boolean left, boolean right, boolean control) {
            ArrayList rois;
            Sequence seq;
            if (this.areaSelection && (seq = TestVisu.this.getSequence()) != null && (rois = seq.getROIs()).size() > 0) {
                Rectangle2D.Double area = TestVisu.this.canvasToImage(this.getAreaSelection());
                Rectangle5D.Double area5d = new Rectangle5D.Double(((RectangularShape)area).getX(), ((RectangularShape)area).getY(), (double)TestVisu.this.getPositionZ(), (double)TestVisu.this.getPositionT(), Double.NEGATIVE_INFINITY, ((RectangularShape)area).getWidth(), ((RectangularShape)area).getHeight(), 1.0, 1.0, Double.POSITIVE_INFINITY);
                seq.beginUpdate();
                try {
                    for (ROI roi : rois) {
                        roi.setSelected(roi.intersects((Rectangle5D)area5d));
                    }
                }
                finally {
                    seq.endUpdate();
                }
            }
            this.startDragPosition = null;
            this.moving = false;
            this.rotating = false;
            this.areaSelection = false;
            this.refresh();
            this.updateCursor();
            return true;
        }

        void onMousePositionChanged(Point pos) {
            this.handlingMouseMoveEvent = true;
            try {
                TestVisu.this.setMousePos(pos);
            }
            finally {
                this.handlingMouseMoveEvent = false;
            }
        }

        boolean onMouseDragged(boolean consumed, Point pos, boolean left, boolean right, boolean control, boolean shift) {
            if (!consumed) {
                if (this.isDragging()) {
                    if (left) {
                        this.moving = true;
                        if (this.rotating) {
                            this.rotating = false;
                            TestVisu.this.canvasView.repaint();
                        }
                        this.updateDrag(control, shift);
                    } else if (right) {
                        this.moving = false;
                        if (!this.rotating) {
                            this.rotating = true;
                            TestVisu.this.canvasView.repaint();
                        }
                        this.updateRot(control, shift);
                    }
                    return true;
                }
                if (this.areaSelection) {
                    this.repaint();
                }
                return false;
            }
            return false;
        }

        boolean onMouseWheelMoved(boolean consumed, int wheelRotation, boolean left, boolean right, boolean control, boolean shift) {
            if (!consumed && !this.isDragging()) {
                if (!TestVisu.this.viewer.hasFocus()) {
                    TestVisu.this.viewer.requestFocus();
                }
                double wr = (double)wheelRotation * CanvasPreferences.getMouseWheelSensitivity();
                if (CanvasPreferences.getInvertMouseWheelAxis()) {
                    wr = -wr;
                }
                double sx = 1.0 + wr / 100.0;
                double sy = 1.0 + wr / 100.0;
                if (control) {
                    sx *= sx;
                    sy *= sy;
                }
                if (this.curScaleX == -1.0) {
                    this.curScaleX = TestVisu.this.smoothTransform.getDestValue(2);
                }
                if (this.curScaleY == -1.0) {
                    this.curScaleY = TestVisu.this.smoothTransform.getDestValue(3);
                }
                this.curScaleX = Math.max(0.01, Math.min(100.0, this.curScaleX * sx));
                this.curScaleY = Math.max(0.01, Math.min(100.0, this.curScaleY * sy));
                double newScaleX = this.curScaleX;
                double newScaleY = this.curScaleY;
                if (shift) {
                    newScaleX = MathUtil.closest((double)newScaleX, (double[])zoomRoundedFactors);
                    newScaleY = MathUtil.closest((double)newScaleY, (double[])zoomRoundedFactors);
                }
                TestVisu.this.setScale(newScaleX, newScaleY, false, true);
                return true;
            }
            return false;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TestVisu.this.mouseClick(e);
            if (this.onMouseClicked(e.isConsumed(), e.getClickCount(), EventUtil.isLeftMouseButton((MouseEvent)e), EventUtil.isRightMouseButton((MouseEvent)e), EventUtil.isControlDown((InputEvent)e))) {
                e.consume();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TestVisu.this.mousePressed(e);
            if (this.onMousePressed(e.isConsumed(), EventUtil.isLeftMouseButton((MouseEvent)e), EventUtil.isRightMouseButton((MouseEvent)e), EventUtil.isControlDown((InputEvent)e))) {
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TestVisu.this.mouseReleased(e);
            if (this.onMouseReleased(e.isConsumed(), EventUtil.isLeftMouseButton((MouseEvent)e), EventUtil.isRightMouseButton((MouseEvent)e), EventUtil.isControlDown((InputEvent)e))) {
                e.consume();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.hasMouseFocus = true;
            TestVisu.this.mouseEntered(e);
            this.refresh();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.hasMouseFocus = false;
            TestVisu.this.mouseExited(e);
            this.refresh();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.onMousePositionChanged(e.getPoint());
            TestVisu.this.mouseMove(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.onMousePositionChanged(e.getPoint());
            TestVisu.this.mouseDrag(e);
            if (this.onMouseDragged(e.isConsumed(), e.getPoint(), EventUtil.isLeftMouseButton((MouseEvent)e), EventUtil.isRightMouseButton((MouseEvent)e), EventUtil.isControlDown((InputEvent)e), EventUtil.isShiftDown((InputEvent)e))) {
                e.consume();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            TestVisu.this.mouseWheelMoved(e);
            if (this.onMouseWheelMoved(e.isConsumed(), e.getWheelRotation(), EventUtil.isLeftMouseButton((MouseEvent)e), EventUtil.isRightMouseButton((MouseEvent)e), EventUtil.isControlDown((InputEvent)e), EventUtil.isShiftDown((InputEvent)e))) {
                e.consume();
            }
        }

        public void keyPressed(KeyEvent e) {
            boolean control = EventUtil.isControlDown((InputEvent)e);
            boolean shift = EventUtil.isShiftDown((InputEvent)e);
            this.updateDrag(control, shift);
            this.updateRot(control, shift);
        }

        public void keyReleased(KeyEvent e) {
            boolean control = EventUtil.isControlDown((InputEvent)e);
            boolean shift = EventUtil.isShiftDown((InputEvent)e);
            this.updateDrag(control, shift);
            this.updateRot(control, shift);
        }

        void drawLayer(Graphics2D g, Sequence seq, Layer layer) {
            if (layer.isVisible()) {
                float opacity = layer.getOpacity();
                if (opacity != 1.0f) {
                    g.setComposite(AlphaComposite.getInstance(3, opacity));
                } else {
                    g.setComposite(AlphaComposite.SrcOver);
                }
                layer.getOverlay().paint(g, seq, (IcyCanvas)TestVisu.this);
            }
        }

        void drawImageAndLayers(Graphics2D g, Layer imageLayer) {
            Sequence seq = TestVisu.this.getSequence();
            Layer defaultImageLayer = TestVisu.this.getImageLayer();
            if (TestVisu.this.isLayersVisible()) {
                List layers = TestVisu.this.getLayers(true);
                for (int i = layers.size() - 1; i >= 0; --i) {
                    Layer layer = (Layer)layers.get(i);
                    if (layer == defaultImageLayer) {
                        this.drawLayer(g, seq, imageLayer);
                        continue;
                    }
                    this.drawLayer(g, seq, layer);
                }
            } else {
                this.drawLayer(g, seq, imageLayer);
            }
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = TestVisu.this.getCanvasSizeX();
            int h = TestVisu.this.getCanvasSizeY();
            int canvasCenterX = w / 2;
            int canvasCenterY = h / 2;
            Graphics2D g2 = (Graphics2D)g.create();
            if (TestVisu.this.isBackgroundColorEnabled()) {
                g2.setBackground(TestVisu.this.getBackgroundColor());
                g2.clearRect(0, 0, w, h);
            }
            AffineTransform transformtocanvas = TestVisu.this.getTransform();
            if (CanvasPreferences.getFiltering() && TestVisu.this.getScaleX() < 4.0 && TestVisu.this.getScaleY() < 4.0) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.transform(transformtocanvas);
            this.drawImageAndLayers(g2, TestVisu.this.getImageLayer());
            g2.dispose();
            Graphics2D gcor = (Graphics2D)g.create();
            if (TestVisu.this.isBackgroundColorEnabled()) {
                gcor.setBackground(TestVisu.this.getBackgroundColor());
                gcor.clearRect(0, 0, w, h);
            }
            if (CanvasPreferences.getFiltering() && TestVisu.this.getScaleX() < 4.0 && TestVisu.this.getScaleY() < 4.0) {
                gcor.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            } else {
                gcor.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            gcor.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AffineTransform myTransform = (AffineTransform)transformtocanvas.clone();
            AffineTransform Ts = new AffineTransform();
            AffineTransform Tx = new AffineTransform();
            Ts.setToScale(TestVisu.this.scales / TestVisu.this.scalet, TestVisu.this.scales / TestVisu.this.scalet);
            AffineTransform Tt = new AffineTransform();
            double ttrx = TestVisu.this.matrix.get(0, 3) * (1.0 / TestVisu.this.scales);
            double ttry = TestVisu.this.matrix.get(1, 3) * (1.0 / TestVisu.this.scales);
            Tx.setTransform(TestVisu.this.matrix.get(0, 0), TestVisu.this.matrix.get(1, 0), TestVisu.this.matrix.get(0, 1), TestVisu.this.matrix.get(1, 1), ttrx, ttry);
            Ts.concatenate(Tx);
            myTransform.concatenate(Ts);
            gcor.transform(myTransform);
            gcor.setComposite(AlphaComposite.getInstance(3, 1.0f - TestVisu.this.getImageLayer().getOpacity()));
            gcor.drawImage((Image)TestVisu.this.correlatedimage, 0, 0, null);
            if (this.areaSelection) {
                Rectangle area = this.getAreaSelection();
                Graphics2D g22 = (Graphics2D)g.create();
                g22.setStroke(new BasicStroke(1.0f));
                g22.setColor(Color.darkGray);
                g22.drawRect(area.x + 1, area.y + 1, area.width, area.height);
                g22.setColor(Color.lightGray);
                g22.drawRect(area.x, area.y, area.width, area.height);
                g22.dispose();
            }
            if (!this.hasMouseFocus) {
                g2 = (Graphics2D)g.create();
                Point mousePos = TestVisu.this.getMousePos();
                int x = mousePos.x - 10;
                int y = mousePos.y - 10;
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g2.drawImage(ICON_TARGET_LIGHT, x + 1, y + 1, null);
                g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g2.drawImage(ICON_TARGET_BLACK, x, y, null);
                g2.dispose();
            }
            if (this.zoomInfoAlphaMover.getValue() > 0.0) {
                g2 = (Graphics2D)g.create();
                g2.setFont(this.font);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.drawTextBottomRight(g2, this.zoomMessage, (float)this.zoomInfoAlphaMover.getValue());
                g2.dispose();
            }
            if (this.rotationInfoAlphaMover.getValue() > 0.0) {
                g2 = (Graphics2D)g.create();
                g2.setFont(this.font);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.drawTextTopRight(g2, this.rotationMessage, (float)this.rotationInfoAlphaMover.getValue());
                g2.dispose();
            }
            if (this.rotating) {
                g2 = (Graphics2D)g.create();
                BasicStroke blackStr = new BasicStroke(5.0f);
                BasicStroke greenStr = new BasicStroke(3.0f);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(blackStr);
                g2.setColor(Color.black);
                g2.drawLine(canvasCenterX - 5, canvasCenterY - 5, canvasCenterX + 5, canvasCenterY + 5);
                g2.drawLine(canvasCenterX - 5, canvasCenterY + 5, canvasCenterX + 5, canvasCenterY - 5);
                g2.setStroke(greenStr);
                g2.setColor(Color.green);
                g2.drawLine(canvasCenterX - 5, canvasCenterY - 5, canvasCenterX + 5, canvasCenterY + 5);
                g2.drawLine(canvasCenterX - 5, canvasCenterY + 5, canvasCenterX + 5, canvasCenterY - 5);
                g2.dispose();
            }
            if (!this.isCacheValid()) {
                this.refresh();
            } else if (this.imageCache.isProcessing()) {
                this.refreshLater(100);
            }
            TestVisu.this.canvasMap.repaint();
        }

        public void drawTextBottomRight(Graphics2D g, String text, float alpha) {
            Rectangle2D rect = GraphicsUtil.getStringBounds((Graphics)g, (String)text);
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            int x = this.getWidth() - (w + 8 + 2);
            int y = this.getHeight() - (h + 8 + 2);
            g.setColor(Color.gray);
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            g.fillRoundRect(x, y, w + 8, h + 8, 8, 8);
            g.setColor(Color.white);
            g.drawString(text, x + 4, y + 2 + h);
        }

        public void drawTextTopRight(Graphics2D g, String text, float alpha) {
            Rectangle2D rect = GraphicsUtil.getStringBounds((Graphics)g, (String)text);
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            int x = this.getWidth() - (w + 8 + 2);
            int y = 2;
            g.setColor(Color.gray);
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            g.fillRoundRect(x, 2, w + 8, h + 8, 8, 8);
            g.setColor(Color.white);
            g.drawString(text, x + 4, 4 + h);
        }

        public void drawTextCenter(Graphics2D g, String text, float alpha) {
            Rectangle2D rect = GraphicsUtil.getStringBounds((Graphics)g, (String)text);
            int w = (int)rect.getWidth();
            int h = (int)rect.getHeight();
            int x = (this.getWidth() - (w + 8 + 2)) / 2;
            int y = (this.getHeight() - (h + 8 + 2)) / 2;
            g.setColor(Color.gray);
            g.setComposite(AlphaComposite.getInstance(3, alpha));
            g.fillRoundRect(x, y, w + 8, h + 8, 8, 8);
            g.setColor(Color.white);
            g.drawString(text, x + 4, y + 2 + h);
        }

        protected void updateCursor() {
            if (this.isDragging()) {
                GuiUtil.setCursor((Component)this, (int)12);
                return;
            }
            if (this.areaSelection) {
                GuiUtil.setCursor((Component)this, (int)1);
                return;
            }
            Sequence seq = TestVisu.this.getSequence();
            if (seq != null) {
                Layer layer;
                ROI overlappedRoi = seq.getFocusedROI();
                if (overlappedRoi != null && (layer = TestVisu.this.getLayer(overlappedRoi)) != null && layer.isVisible()) {
                    GuiUtil.setCursor((Component)this, (int)12);
                    return;
                }
                ArrayList selectedRois = seq.getSelectedROIs();
                for (ROI selectedRoi : selectedRois) {
                    Layer layer2 = TestVisu.this.getLayer(selectedRoi);
                    if (layer2 == null || !layer2.isVisible() || !selectedRoi.hasSelectedPoint()) continue;
                    GuiUtil.setCursor((Component)this, (int)12);
                    return;
                }
            }
            GuiUtil.setCursor((Component)this, (int)0);
        }

        public void refresh() {
            this.imageCache.refresh();
        }

        public void refreshLater(int milli) {
            this.refreshTimer.setInitialDelay(milli);
            this.refreshTimer.start();
        }

        public void setZoomMessage(String value, int delay) {
            this.zoomMessage = value;
            if (StringUtil.isEmpty((String)value)) {
                this.zoomInfoTimer.stop();
                this.zoomInfoAlphaMover.setValue(0.0);
            } else {
                this.zoomInfoAlphaMover.setValue(0.8);
                this.zoomInfoTimer.setInitialDelay(delay);
                this.zoomInfoTimer.restart();
            }
        }

        public void setRotationMessage(String value, int delay) {
            this.rotationMessage = value;
            if (StringUtil.isEmpty((String)value)) {
                this.rotationInfoTimer.stop();
                this.rotationInfoAlphaMover.setValue(0.0);
            } else {
                this.rotationInfoAlphaMover.setValue(0.8);
                this.rotationInfoTimer.setInitialDelay(delay);
                this.rotationInfoTimer.restart();
            }
        }

        public void imageChanged() {
            this.imageCache.invalidCache();
        }

        public void layersChanged() {
        }

        public boolean isDragging() {
            return !this.areaSelection && this.startDragPosition != null;
        }

        public boolean isCacheValid() {
            return this.imageCache.isValid();
        }

        public Rectangle getAreaSelection() {
            int h;
            int y;
            int w;
            int x;
            if (!this.areaSelection) {
                return null;
            }
            Point mp = TestVisu.this.getMousePos();
            if (mp.x > this.startDragPosition.x) {
                x = this.startDragPosition.x;
                w = mp.x - x;
            } else {
                x = mp.x;
                w = this.startDragPosition.x - x;
            }
            if (mp.y > this.startDragPosition.y) {
                y = this.startDragPosition.y;
                h = mp.y - y;
            } else {
                y = mp.y;
                h = this.startDragPosition.y - y;
            }
            return new Rectangle(x, y, w, h);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.refreshTimer) {
                this.refresh();
            } else if (source == this.zoomInfoTimer) {
                this.zoomInfoAlphaMover.moveTo(0.0);
            } else if (source == this.rotationInfoTimer) {
                this.rotationInfoAlphaMover.moveTo(0.0);
            }
        }

        public class ImageCache
        implements Runnable {
            private List<ImageCacheTile> tiles;
            private final SingleProcessor processor = new SingleProcessor(true, "TestVisu renderer");
            private boolean needRebuild;
            private boolean notEnoughMemory;

            public ImageCache() {
                this.processor.setKeepAliveTime(3L, TimeUnit.SECONDS);
                this.tiles = new ArrayList<ImageCacheTile>();
                this.needRebuild = true;
                this.notEnoughMemory = false;
                this.processor.submit((Runnable)this);
            }

            public void invalidCache() {
                this.needRebuild = true;
            }

            public boolean isValid() {
                return !this.needRebuild;
            }

            public boolean isProcessing() {
                return this.processor.isProcessing();
            }

            public void refresh() {
                if (this.needRebuild) {
                    this.processor.submit((Runnable)this);
                }
                TestVisu.this.getViewComponent().repaint();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public List<ImageCacheTile> getImageAsTiles() {
                List<ImageCacheTile> list = this.tiles;
                synchronized (list) {
                    return new ArrayList<ImageCacheTile>(this.tiles);
                }
            }

            public boolean getNotEnoughMemory() {
                return this.notEnoughMemory;
            }

            @Override
            public void run() {
                this.needRebuild = false;
                IcyBufferedImage icyImage = TestVisu.this.getImage(TestVisu.this.getPositionT(), TestVisu.this.getPositionZ(), TestVisu.this.getPositionC());
                if (icyImage == null) {
                    this.tiles.clear();
                } else {
                    try {
                        Rectangle imgRect = icyImage.getBounds();
                        List newTiles = ImageUtil.getTileList((int)icyImage.getSizeX(), (int)icyImage.getSizeY(), (int)2048, (int)2048);
                        int len = newTiles.size();
                        int indNewTiles = 0;
                        for (ImageCacheTile tile : this.tiles) {
                            if (indNewTiles < len) {
                                Rectangle oldRect = tile.rect;
                                Rectangle newRect = ((Rectangle)newTiles.get(indNewTiles)).intersection(imgRect);
                                if (oldRect.width != newRect.width || oldRect.height != newRect.height) {
                                    tile.image = new BufferedImage(newRect.width, newRect.height, 2);
                                }
                                tile.rect = newRect;
                            }
                            ++indNewTiles;
                        }
                        while (this.tiles.size() > len) {
                            this.tiles.remove(this.tiles.size() - 1);
                        }
                        while (indNewTiles < len) {
                            this.tiles.add(new ImageCacheTile((Rectangle)newTiles.get(indNewTiles++)));
                        }
                        LUT l = TestVisu.this.getLut();
                        for (ImageCacheTile tile : this.tiles) {
                            IcyBufferedImage icyTile = IcyBufferedImageUtil.getSubImage((IcyBufferedImage)icyImage, (Rectangle)tile.rect);
                            if (icyTile == null) continue;
                            icyTile.setVolatile(false);
                            tile.image = IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)icyTile, (BufferedImage)tile.image, (LUT)l);
                        }
                        this.notEnoughMemory = false;
                    }
                    catch (OutOfMemoryError e) {
                        this.notEnoughMemory = true;
                    }
                }
                TestVisu.this.getViewComponent().repaint();
            }

            public class ImageCacheTile {
                static final int TILE_SIZE = 2048;
                public Rectangle rect;
                public BufferedImage image;

                public ImageCacheTile(Rectangle r, BufferedImage img) {
                    this.rect = new Rectangle(r);
                    this.image = img;
                }

                public ImageCacheTile(Rectangle r) {
                    this(r, new BufferedImage(r.width, r.height, 2));
                }
            }
        }
    }

    public class CanvasMap
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private static final long serialVersionUID = 1373087901039089953L;
        private Point mouseMapPos = new Point(0, 0);
        private Point mapStartDragPos = null;
        private double mapStartRotationZ = 0.0;
        private boolean mapMoving = false;
        private boolean mapRotating = false;

        public CanvasMap() {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setPreferredSize(new Dimension(160, 160));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        public AffineTransform getImageTransform() {
            double ty;
            double tx;
            double s;
            int w = this.getWidth();
            int h = this.getHeight();
            int imgW = TestVisu.this.getImageSizeX();
            int imgH = TestVisu.this.getImageSizeY();
            if (imgW == 0 || imgH == 0) {
                return null;
            }
            double sx = (double)w / (double)imgW;
            double sy = (double)h / (double)imgH;
            if (sx < sy) {
                s = sx;
                tx = 0.0;
                ty = ((double)h - (double)imgH * s) / 2.0;
            } else if (sx > sy) {
                s = sy;
                ty = 0.0;
                tx = ((double)w - (double)imgW * s) / 2.0;
            } else {
                s = sx;
                tx = 0.0;
                ty = 0.0;
            }
            AffineTransform result = new AffineTransform();
            result.translate(tx, ty);
            result.scale(s, s);
            return result;
        }

        public Point getCanvasPosition(Point p) {
            return TestVisu.this.imageToCanvas(this.getImagePosition(p));
        }

        public Point getCanvasPosition(Point2D.Double p) {
            return TestVisu.this.imageToCanvas(p);
        }

        public Point2D.Double getImagePosition(Point p) {
            AffineTransform trans = this.getImageTransform();
            try {
                return (Point2D.Double)trans.inverseTransform(p, new Point2D.Double());
            }
            catch (Exception ecx) {
                return new Point2D.Double(0.0, 0.0);
            }
        }

        public boolean isDragging() {
            return this.mapStartDragPos != null;
        }

        protected void updateDrag(InputEvent e) {
            if (!this.mapMoving) {
                return;
            }
            Point2D.Double startDragImagePoint = this.getImagePosition(this.mapStartDragPos);
            Point2D.Double imagePoint = this.getImagePosition(this.mouseMapPos);
            if (EventUtil.isShiftDown((InputEvent)e)) {
                if (Math.abs(this.mouseMapPos.x - this.mapStartDragPos.x) > Math.abs(this.mouseMapPos.y - this.mapStartDragPos.y)) {
                    imagePoint.y = startDragImagePoint.y;
                } else {
                    imagePoint.x = startDragImagePoint.x;
                }
            }
            TestVisu.this.centerOnImage(imagePoint);
        }

        protected void updateRot(InputEvent e) {
            if (!this.mapRotating) {
                return;
            }
            Point2D.Double imagePoint = this.getImagePosition(this.mouseMapPos);
            TestVisu.this.setMousePos(TestVisu.this.imageToCanvas(imagePoint));
            int mapCenterX = this.getWidth() / 2;
            int mapCenterY = this.getHeight() / 2;
            int lastMouseDeltaPosX = this.mapStartDragPos.x - mapCenterX;
            int lastMouseDeltaPosY = this.mapStartDragPos.y - mapCenterY;
            int newMouseDeltaPosX = this.mouseMapPos.x - mapCenterX;
            int newMouseDeltaPosY = this.mouseMapPos.y - mapCenterY;
            double newAngle = Math.atan2(newMouseDeltaPosY, newMouseDeltaPosX);
            double lastAngle = Math.atan2(lastMouseDeltaPosY, lastMouseDeltaPosX);
            double angle = lastAngle - newAngle;
            if (EventUtil.isControlDown((InputEvent)e)) {
                angle *= 3.0;
            }
            double destAngle = EventUtil.isShiftDown((InputEvent)e) ? Math.rint((this.mapStartRotationZ + angle) * 1.2732395447351628) * 0.7853981633974483 : this.mapStartRotationZ + angle;
            TestVisu.this.setRotation(destAngle, true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TestVisu.this.canvasView.handlingMouseMoveEvent = true;
            try {
                this.mouseMapPos = new Point(e.getPoint());
                if (this.isDragging()) {
                    if (EventUtil.isLeftMouseButton((MouseEvent)e)) {
                        this.mapMoving = true;
                        if (this.mapRotating) {
                            this.mapRotating = false;
                            TestVisu.this.canvasView.repaint();
                        }
                        this.updateDrag(e);
                    } else if (EventUtil.isRightMouseButton((MouseEvent)e)) {
                        this.mapMoving = false;
                        if (!this.mapRotating) {
                            this.mapRotating = true;
                            TestVisu.this.canvasView.repaint();
                        }
                        this.updateRot(e);
                    }
                    e.consume();
                }
            }
            finally {
                TestVisu.this.canvasView.handlingMouseMoveEvent = false;
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.mouseMapPos = new Point(e.getPoint());
            TestVisu.this.canvasView.onMousePositionChanged(this.getCanvasPosition(e.getPoint()));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            AffineTransform trans;
            this.mapStartDragPos = (Point)e.getPoint().clone();
            this.mapStartRotationZ = TestVisu.this.getRotationZ();
            if (EventUtil.isLeftMouseButton((MouseEvent)e) && (trans = this.getImageTransform()) != null) {
                try {
                    Point2D imagePoint = trans.inverseTransform(e.getPoint(), null);
                    TestVisu.this.centerOnImage(imagePoint.getX(), imagePoint.getY());
                    TestVisu.this.setMousePos(TestVisu.this.imageToCanvas(imagePoint.getX(), imagePoint.getY()));
                    e.consume();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mapStartDragPos = null;
            this.mapRotating = false;
            this.mapMoving = false;
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            AffineTransform trans = this.getImageTransform();
            if (trans != null) {
                try {
                    Point2D imagePoint = trans.inverseTransform(e.getPoint(), null);
                    TestVisu.this.centerOnImage(imagePoint.getX(), imagePoint.getY());
                    TestVisu.this.setMousePos(TestVisu.this.imageToCanvas(imagePoint.getX(), imagePoint.getY()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (TestVisu.this.canvasView.onMouseWheelMoved(e.isConsumed(), e.getWheelRotation(), EventUtil.isLeftMouseButton((MouseEvent)e), EventUtil.isRightMouseButton((MouseEvent)e), EventUtil.isControlDown((InputEvent)e), EventUtil.isShiftDown((InputEvent)e))) {
                e.consume();
            }
        }

        public void keyPressed(KeyEvent e) {
            this.updateDrag(e);
            this.updateRot(e);
        }

        public void keyReleased(KeyEvent e) {
            this.updateDrag(e);
            this.updateRot(e);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            AffineTransform trans = this.getImageTransform();
            if (trans != null) {
                Graphics2D g2 = (Graphics2D)g.create();
                List<CanvasView.ImageCache.ImageCacheTile> tiles = TestVisu.this.canvasView.imageCache.getImageAsTiles();
                for (CanvasView.ImageCache.ImageCacheTile tile : tiles) {
                    trans.translate(tile.rect.getX(), tile.rect.getY());
                    g2.drawImage(tile.image, trans, null);
                    trans.translate(-tile.rect.getX(), -tile.rect.getY());
                }
                trans.scale(1.0 / TestVisu.this.getScaleX(), 1.0 / TestVisu.this.getScaleY());
                trans.translate(-TestVisu.this.getOffsetX(), -TestVisu.this.getOffsetY());
                int canvasSizeX = TestVisu.this.getCanvasSizeX();
                int canvasSizeY = TestVisu.this.getCanvasSizeY();
                int canvasCenterX = canvasSizeX / 2;
                int canvasCenterY = canvasSizeY / 2;
                trans.translate(canvasCenterX, canvasCenterY);
                trans.rotate(-TestVisu.this.getRotationZ());
                trans.translate(-canvasCenterX, -canvasCenterY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Shape shape = trans.createTransformedShape(new Rectangle(canvasSizeX, canvasSizeY));
                g2.setStroke(new BasicStroke(3.0f));
                g2.setColor(Color.black);
                g2.draw(shape);
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(Color.white);
                g2.draw(shape);
                if (this.mapRotating) {
                    Point2D center = trans.transform(new Point(canvasCenterX, canvasCenterY), null);
                    int centerX = (int)Math.round(center.getX());
                    int centerY = (int)Math.round(center.getY());
                    BasicStroke blackStr = new BasicStroke(4.0f);
                    BasicStroke greenStr = new BasicStroke(2.0f);
                    g2.setStroke(blackStr);
                    g2.setColor(Color.black);
                    g2.drawLine(centerX - 4, centerY - 4, centerX + 4, centerY + 4);
                    g2.drawLine(centerX - 4, centerY + 4, centerX + 4, centerY - 4);
                    g2.setStroke(greenStr);
                    g2.setColor(Color.green);
                    g2.drawLine(centerX - 4, centerY - 4, centerX + 4, centerY + 4);
                    g2.drawLine(centerX - 4, centerY + 4, centerX + 4, centerY - 4);
                }
                g2.dispose();
            }
        }
    }

    protected class TestVisuImageOverlay
    extends IcyCanvas.IcyCanvasImageOverlay {
        protected TestVisuImageOverlay() {
            super((IcyCanvas)TestVisu.this);
        }

        public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
            if (g == null) {
                return;
            }
            List<CanvasView.ImageCache.ImageCacheTile> tiles = TestVisu.this.canvasView.imageCache.getImageAsTiles();
            for (CanvasView.ImageCache.ImageCacheTile tile : tiles) {
                g.drawImage((Image)tile.image, tile.rect.x, tile.rect.y, null);
            }
            if (tiles.isEmpty()) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.transform(TestVisu.this.getInverseTransform());
                g2.setFont(TestVisu.this.canvasView.font);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                if (TestVisu.this.canvasView.imageCache.isProcessing()) {
                    TestVisu.this.canvasView.drawTextCenter(g2, "Loading...", 0.8f);
                } else if (TestVisu.this.canvasView.imageCache.getNotEnoughMemory()) {
                    TestVisu.this.canvasView.drawTextCenter(g2, "Not enough memory to display image", 0.8f);
                } else {
                    TestVisu.this.canvasView.drawTextCenter(g2, " No image ", 0.8f);
                }
                g2.dispose();
            }
        }
    }
}

