/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.gui.dialog.MessageDialog;
import icy.gui.dialog.OpenDialog;
import icy.gui.frame.IcyFrame;
import icy.math.ArrayMath;
import icy.resource.ResourceUtil;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.poi.ss.formula.FormulaParseException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTable;
import org.math.plot.Plot2DPanel;
import org.math.plot.Plot3DPanel;
import org.math.plot.utils.Array;
import plugins.adufour.blocks.tools.io.WorkbookToFile;
import plugins.adufour.ezplug.EzButton;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzDialog;
import plugins.adufour.ezplug.EzLabel;
import plugins.adufour.ezplug.EzVarEnum;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.PersistentColumnControlButton;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarString;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.vars.util.VarListener;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;

public class WorkbookEditor
extends SwingVarEditor<Workbook> {
    final VarString formula = new VarString("Formula", "");
    final VarBoolean useHeader = new VarBoolean("Header", false);
    final VarBoolean readOnly = new VarBoolean("read-only", false);
    final VarBoolean openButtonVisible = new VarBoolean("show open button", true){

        public void valueChanged(Var<Boolean> source, Boolean oldValue, Boolean newValue) {
            super.valueChanged(source, (Object)oldValue, (Object)newValue);
            if (WorkbookEditor.this.openButton != null) {
                ThreadUtil.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WorkbookEditor.this.openButton.setVisible(false);
                    }
                });
            }
        }
    };
    private JButton openButton;
    private JButton exportButton;
    private JButton plotButton;
    private JTabbedPane tabs;
    private final HashMap<Sheet, JXTable> tables = new HashMap();
    private final HashMap<Sheet, JXTable> headers = new HashMap();
    private Workbook book;
    private final TabChangeListener tabChangeListener = new TabChangeListener();

    public WorkbookEditor(VarWorkbook variable) {
        super((Var)variable);
    }

    protected JComponent createEditorComponent() {
        return new JXPanel((LayoutManager)new BorderLayout());
    }

    protected void activateListeners() {
        this.useHeader.addListener((VarListener)new VarListener<Boolean>(){

            public void valueChanged(Var<Boolean> source, Boolean oldValue, Boolean newValue) {
                WorkbookEditor.this.updateInterfaceValue();
            }

            public void referenceChanged(Var<Boolean> source, Var<? extends Boolean> oldReference, Var<? extends Boolean> newReference) {
            }
        });
    }

    protected void deactivateListeners() {
        this.useHeader.removeListeners();
    }

    public void dispose() {
        super.dispose();
        this.tables.clear();
        this.headers.clear();
        this.book = null;
        if (this.tabs != null) {
            this.tabs.removeChangeListener(this.tabChangeListener);
            this.tabs.removeAll();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 100);
    }

    public double getComponentVerticalResizeFactor() {
        return 1.0;
    }

    public boolean isComponentResizeable() {
        return true;
    }

    public void setFirstRowAsHeader(boolean header) {
        this.useHeader.setValue((Object)header);
    }

    public void setOpenButtonVisible(boolean visible) {
        this.openButtonVisible.setValue((Object)visible);
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly.setValue((Object)readOnly);
    }

    private WorkbookToFile.MergePolicy confirm() {
        final EzDialog confirmDialog = new EzDialog("Confirmation");
        confirmDialog.addEzComponent((EzComponent)new EzLabel("This file already exists."));
        EzVarEnum policy = new EzVarEnum("Action: ", (Enum[])WorkbookToFile.MergePolicy.values());
        confirmDialog.addEzComponent((EzComponent)policy);
        final VarBoolean confirmed = new VarBoolean("confirmed", true);
        confirmDialog.addEzComponent((EzComponent)new EzButton("Ok", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                confirmed.setValue((Object)true);
                confirmDialog.close();
            }
        }));
        confirmDialog.addEzComponent((EzComponent)new EzButton("Cancel", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                confirmed.setValue((Object)false);
                confirmDialog.close();
            }
        }));
        confirmDialog.showDialog(true);
        confirmDialog.hideDialog();
        if (((Boolean)confirmed.getValue()).booleanValue()) {
            return (WorkbookToFile.MergePolicy)((Object)policy.getValue());
        }
        return null;
    }

    protected void updateInterfaceValue() {
        int i;
        boolean buildNewEditor;
        if (this.variable.getReference() != null) {
            this.setReadOnly(true);
            this.setOpenButtonVisible(false);
        }
        this.book = (Workbook)this.variable.getValue();
        if (this.book == null) {
            return;
        }
        JXPanel wbPanel = (JXPanel)this.getEditorComponent();
        String bookID = "" + this.book.hashCode();
        boolean bl = buildNewEditor = wbPanel.getName() == null || !wbPanel.getName().equalsIgnoreCase(bookID);
        if (buildNewEditor) {
            wbPanel.removeAll();
            JPanel optionBar = new JPanel();
            optionBar.setLayout(new BoxLayout(optionBar, 0));
            this.openButton = new JButton(ResourceUtil.getImageIcon((Image)ResourceUtil.ICON_OPEN, (int)18));
            this.openButton.setVisible((Boolean)this.openButtonVisible.getValue());
            this.openButton.setBorderPainted(false);
            this.openButton.setFocusable(false);
            this.openButton.setContentAreaFilled(false);
            this.openButton.setToolTipText("Open/Create workbook...");
            this.openButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String path = OpenDialog.chooseFile((String)"Load/Create workbook...", null, (String)"Workbook", (String)".xls");
                    if (path == null) {
                        return;
                    }
                    try {
                        WorkbookEditor.this.variable.setValue((Object)WorkbookFactory.create((File)new File(path)));
                    }
                    catch (Exception e1) {
                        MessageDialog.showDialog((String)e1.getMessage(), (int)0);
                    }
                }
            });
            optionBar.add(this.openButton);
            this.exportButton = new JButton(ResourceUtil.getImageIcon((Image)ResourceUtil.ICON_SAVE, (int)18));
            this.exportButton.setBorderPainted(false);
            this.exportButton.setFocusable(false);
            this.exportButton.setContentAreaFilled(false);
            this.exportButton.setToolTipText("Export workbook to disk...");
            final JFileChooser fileChooser = new JFileChooser();
            final FileNameExtensionFilter txtFilter = new FileNameExtensionFilter("Text files (.txt)", "txt");
            final FileNameExtensionFilter xlsFilter = new FileNameExtensionFilter("Spreadsheets (.xlsx)", "xlsx");
            final JPopupMenu exportPopupMenu = new JPopupMenu();
            JMenuItem exportXLS = new JMenuItem("Export to an Excel file");
            exportXLS.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fileChooser.setFileFilter(xlsFilter);
                    if (fileChooser.showSaveDialog(exportPopupMenu) != 0) {
                        return;
                    }
                    File outputFile = fileChooser.getSelectedFile();
                    if (outputFile.exists()) {
                        WorkbookToFile.MergePolicy mergingPolicy = WorkbookEditor.this.confirm();
                        if (mergingPolicy != null) {
                            WorkbookToFile.saveAsSpreadSheet(WorkbookEditor.this.book, outputFile.getPath(), mergingPolicy);
                        }
                    } else {
                        WorkbookToFile.saveAsSpreadSheet(WorkbookEditor.this.book, outputFile.getPath(), WorkbookToFile.MergePolicy.Overwrite);
                    }
                }
            });
            JMenuItem exportTXT = new JMenuItem("Export to a text file");
            exportTXT.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fileChooser.setFileFilter(txtFilter);
                    if (fileChooser.showSaveDialog(exportPopupMenu) != 0) {
                        return;
                    }
                    File outputFile = fileChooser.getSelectedFile();
                    if (outputFile.exists()) {
                        WorkbookToFile.MergePolicy mergingPolicy = WorkbookEditor.this.confirm();
                        if (mergingPolicy != null) {
                            WorkbookToFile.saveAsText(WorkbookEditor.this.book, outputFile.getPath(), mergingPolicy);
                        }
                    } else {
                        WorkbookToFile.saveAsText(WorkbookEditor.this.book, outputFile.getPath(), WorkbookToFile.MergePolicy.Overwrite);
                    }
                }
            });
            exportPopupMenu.add(exportTXT);
            exportPopupMenu.add(exportXLS);
            this.exportButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    exportPopupMenu.show(WorkbookEditor.this.exportButton, 0, WorkbookEditor.this.exportButton.getHeight());
                }
            });
            optionBar.add(this.exportButton);
            this.plotButton = new JButton(ResourceUtil.getImageIcon((Image)ResourceUtil.getAlphaIconAsImage((String)"align_left.png"), (int)18));
            this.plotButton.setBorderPainted(false);
            this.plotButton.setFocusable(false);
            this.plotButton.setContentAreaFilled(false);
            this.plotButton.setToolTipText("Plot");
            final JPopupMenu plotPopupMenu = new JPopupMenu();
            final JMenu plotHistogram1D = new JMenu("Histogram (1D)");
            plotHistogram1D.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    int sheetIndex = WorkbookEditor.this.book.getActiveSheetIndex();
                    if (sheetIndex == -1) {
                        return;
                    }
                    Sheet sheet = WorkbookEditor.this.book.getSheetAt(sheetIndex);
                    IcySpreadSheet icySheet = Workbooks.getSheet(WorkbookEditor.this.book, WorkbookEditor.this.book.getSheetName(sheetIndex));
                    for (int i = 0; i < icySheet.getNumberOfColumns(); ++i) {
                        final double[] histData = icySheet.getColumnValues(i);
                        if (histData == null || histData.length < 2) continue;
                        final String columnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(i);
                        JMenuItem plotColHistogram = new JMenuItem(columnName);
                        plotColHistogram.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                double min = ArrayMath.min((double[])histData);
                                double max = ArrayMath.max((double[])histData);
                                int bins = Math.max(10, (int)Math.round(Math.sqrt(histData.length)));
                                Plot2DPanel panel = new Plot2DPanel();
                                panel.addHistogramPlot(columnName, histData, min, max, bins);
                                panel.setFixedBounds(0, min, max);
                                IcyFrame plot = new IcyFrame("Histogram of " + columnName, true);
                                plot.setPreferredSize(new Dimension(520, 420));
                                plot.addToDesktopPane();
                                plot.add((Component)panel);
                                plot.pack();
                                plot.setVisible(true);
                            }
                        });
                        plotHistogram1D.add(plotColHistogram);
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    plotHistogram1D.removeAll();
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            final JMenu plotHistogram2D = new JMenu("Histogram (2D)");
            plotHistogram2D.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    int sheetIndex = WorkbookEditor.this.book.getActiveSheetIndex();
                    if (sheetIndex == -1) {
                        return;
                    }
                    Sheet sheet = WorkbookEditor.this.book.getSheetAt(sheetIndex);
                    IcySpreadSheet icySheet = Workbooks.getSheet(WorkbookEditor.this.book, WorkbookEditor.this.book.getSheetName(sheetIndex));
                    JMenuItem labelFirstColumn = new JMenuItem("Select X axis...");
                    labelFirstColumn.setEnabled(false);
                    plotHistogram2D.add(labelFirstColumn);
                    plotHistogram2D.addSeparator();
                    for (int i = 0; i < icySheet.getNumberOfColumns(); ++i) {
                        final double[] xValues = icySheet.getColumnValues(i);
                        if (xValues == null) continue;
                        final double minX = ArrayMath.min((double[])xValues);
                        final double maxX = ArrayMath.max((double[])xValues);
                        final int binsX = Math.max(10, (int)Math.round(Math.sqrt(xValues.length)));
                        String xColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(i);
                        JMenu plotFirstColumn = new JMenu(xColumnName);
                        plotHistogram2D.add(plotFirstColumn);
                        JMenuItem labelSecondColumn = new JMenuItem("Select Y axis...");
                        labelSecondColumn.setEnabled(false);
                        plotFirstColumn.add(labelSecondColumn);
                        plotFirstColumn.addSeparator();
                        for (int j = 0; j < icySheet.getNumberOfColumns(); ++j) {
                            double[] yValues;
                            if (i == j || (yValues = icySheet.getColumnValues(j)) == null) continue;
                            if (xValues.length != yValues.length) {
                                throw new IcyHandledException("Cannot create scatter plot: datasets have different sizes");
                            }
                            final double minY = ArrayMath.min((double[])yValues);
                            final double maxY = ArrayMath.max((double[])yValues);
                            final int binsY = Math.max(10, (int)Math.round(Math.sqrt(yValues.length)));
                            String yColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(j);
                            final String plotTitle = xColumnName + " vs. " + yColumnName;
                            JMenuItem plotSecondColumn = new JMenuItem(yColumnName);
                            plotSecondColumn.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    Plot3DPanel panel = new Plot3DPanel();
                                    double[][] xy = Array.mergeColumns((double[][])new double[][]{xValues, yValues});
                                    panel.addHistogramPlot(plotTitle, xy, binsX, binsY);
                                    panel.setFixedBounds(new double[]{minX, minY}, new double[]{maxX, maxY});
                                    IcyFrame plot = new IcyFrame(plotTitle, true);
                                    plot.setPreferredSize(new Dimension(520, 420));
                                    plot.addToDesktopPane();
                                    plot.add((Component)panel);
                                    plot.pack();
                                    plot.setVisible(true);
                                }
                            });
                            plotFirstColumn.add(plotSecondColumn);
                        }
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    plotHistogram2D.removeAll();
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            final JMenu plotScatter2D = new JMenu("Scatter plot (2D)");
            plotScatter2D.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    int sheetIndex = WorkbookEditor.this.book.getActiveSheetIndex();
                    if (sheetIndex == -1) {
                        return;
                    }
                    Sheet sheet = WorkbookEditor.this.book.getSheetAt(sheetIndex);
                    IcySpreadSheet icySheet = Workbooks.getSheet(WorkbookEditor.this.book, WorkbookEditor.this.book.getSheetName(sheetIndex));
                    JMenuItem labelFirstColumn = new JMenuItem("Select X axis...");
                    labelFirstColumn.setEnabled(false);
                    plotScatter2D.add(labelFirstColumn);
                    plotScatter2D.addSeparator();
                    for (int i = 0; i < icySheet.getNumberOfColumns(); ++i) {
                        final double[] xValues = icySheet.getColumnValues(i);
                        if (xValues == null) continue;
                        final double minX = ArrayMath.min((double[])xValues);
                        final double maxX = ArrayMath.max((double[])xValues);
                        final String xColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(i);
                        JMenu plotFirstColumn = new JMenu(xColumnName);
                        plotScatter2D.add(plotFirstColumn);
                        JMenuItem labelSecondColumn = new JMenuItem("Select Y axis...");
                        labelSecondColumn.setEnabled(false);
                        plotFirstColumn.add(labelSecondColumn);
                        plotFirstColumn.addSeparator();
                        for (int j = 0; j < icySheet.getNumberOfColumns(); ++j) {
                            double[] yValues;
                            if (i == j || (yValues = icySheet.getColumnValues(j)) == null) continue;
                            if (xValues.length != yValues.length) {
                                throw new IcyHandledException("Cannot create scatter plot: datasets have different sizes");
                            }
                            final double minY = ArrayMath.min((double[])yValues);
                            final double maxY = ArrayMath.max((double[])yValues);
                            final String yColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(j);
                            JMenuItem plotSecondColumn = new JMenuItem(yColumnName);
                            plotSecondColumn.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    Plot2DPanel panel = new Plot2DPanel();
                                    panel.addScatterPlot("Scatter plot", xValues, yValues);
                                    panel.setAxisLabels(new String[]{xColumnName, yColumnName});
                                    panel.setFixedBounds(new double[]{minX, minY}, new double[]{maxX, maxY});
                                    IcyFrame plot = new IcyFrame(xColumnName + " vs. " + yColumnName, true);
                                    plot.setPreferredSize(new Dimension(520, 420));
                                    plot.addToDesktopPane();
                                    plot.add((Component)panel);
                                    plot.pack();
                                    plot.setVisible(true);
                                }
                            });
                            plotFirstColumn.add(plotSecondColumn);
                        }
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    plotScatter2D.removeAll();
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            final JMenu plotScatter3D = new JMenu("Scatter plot (3D)");
            plotScatter3D.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    int sheetIndex = WorkbookEditor.this.book.getActiveSheetIndex();
                    if (sheetIndex == -1) {
                        return;
                    }
                    Sheet sheet = WorkbookEditor.this.book.getSheetAt(sheetIndex);
                    IcySpreadSheet icySheet = Workbooks.getSheet(WorkbookEditor.this.book, WorkbookEditor.this.book.getSheetName(sheetIndex));
                    JMenuItem labelFirstColumn = new JMenuItem("Select X axis...");
                    labelFirstColumn.setEnabled(false);
                    plotScatter3D.add(labelFirstColumn);
                    plotScatter3D.addSeparator();
                    for (int i = 0; i < icySheet.getNumberOfColumns(); ++i) {
                        final double[] xValues = icySheet.getColumnValues(i);
                        if (xValues == null) continue;
                        final double minX = ArrayMath.min((double[])xValues);
                        final double maxX = ArrayMath.max((double[])xValues);
                        final String xColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(i);
                        JMenu plotFirstColumn = new JMenu(xColumnName);
                        plotScatter3D.add(plotFirstColumn);
                        JMenuItem labelSecondColumn = new JMenuItem("Select Y axis...");
                        labelSecondColumn.setEnabled(false);
                        plotFirstColumn.add(labelSecondColumn);
                        plotFirstColumn.addSeparator();
                        for (int j = 0; j < icySheet.getNumberOfColumns(); ++j) {
                            double[] yValues;
                            if (i == j || (yValues = icySheet.getColumnValues(j)) == null) continue;
                            if (xValues.length != yValues.length) {
                                throw new IcyHandledException("Cannot create scatter plot: datasets have different sizes");
                            }
                            final double minY = ArrayMath.min((double[])yValues);
                            final double maxY = ArrayMath.max((double[])yValues);
                            final String yColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(j);
                            JMenu plotSecondColumn = new JMenu(yColumnName);
                            plotFirstColumn.add(plotSecondColumn);
                            JMenuItem labelThirdColumn = new JMenuItem("Select Z axis...");
                            labelThirdColumn.setEnabled(false);
                            plotSecondColumn.add(labelThirdColumn);
                            plotSecondColumn.addSeparator();
                            for (int k = 0; k < icySheet.getNumberOfColumns(); ++k) {
                                double[] zValues;
                                if (i == k || j == k || (zValues = icySheet.getColumnValues(k)) == null) continue;
                                if (xValues.length != zValues.length) {
                                    throw new IcyHandledException("Cannot create scatter plot: datasets have different sizes");
                                }
                                final double minZ = ArrayMath.min((double[])zValues);
                                final double maxZ = ArrayMath.max((double[])zValues);
                                final String zColumnName = ((JXTable)WorkbookEditor.this.tables.get(sheet)).getColumnName(k);
                                JMenuItem plotThirdColumn = new JMenuItem(zColumnName);
                                plotSecondColumn.add(plotThirdColumn);
                                plotThirdColumn.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        Plot3DPanel panel = new Plot3DPanel();
                                        panel.addScatterPlot("Scatter plot", xValues, yValues, zValues);
                                        panel.setAxisLabels(new String[]{xColumnName, yColumnName, zColumnName});
                                        panel.setFixedBounds(new double[]{minX, minY, minZ}, new double[]{maxX, maxY, maxZ});
                                        IcyFrame plot = new IcyFrame(xColumnName + " vs. " + yColumnName + " vs. " + zColumnName, true);
                                        plot.setPreferredSize(new Dimension(520, 420));
                                        plot.addToDesktopPane();
                                        plot.add((Component)panel);
                                        plot.pack();
                                        plot.setVisible(true);
                                    }
                                });
                            }
                        }
                    }
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    plotScatter3D.removeAll();
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            });
            plotPopupMenu.add(plotHistogram1D);
            plotPopupMenu.add(plotHistogram2D);
            plotPopupMenu.add(plotScatter2D);
            plotPopupMenu.add(plotScatter3D);
            this.plotButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    plotPopupMenu.show(WorkbookEditor.this.plotButton, 0, WorkbookEditor.this.plotButton.getHeight());
                }
            });
            optionBar.add(this.plotButton);
            VarEditor formulaEditor = this.formula.createVarViewer();
            formulaEditor.setEnabled(true);
            optionBar.add((Component)formulaEditor.getEditorComponent());
            optionBar.add(Box.createHorizontalGlue());
            JCheckBox useHeaderOption = (JCheckBox)this.useHeader.createVarEditor(true).getEditorComponent();
            useHeaderOption.setText("Use first row as header");
            useHeaderOption.setFocusable(false);
            optionBar.add(useHeaderOption);
            wbPanel.add((Component)optionBar, (Object)"North");
            if (this.tabs != null) {
                this.tabs.removeChangeListener(this.tabChangeListener);
            }
            this.tabs = new JTabbedPane(3);
            this.tabs.addChangeListener(this.tabChangeListener);
            wbPanel.add((Component)this.tabs, (Object)"Center");
            wbPanel.setName("" + this.book.hashCode());
        }
        int nSheets = this.book.getNumberOfSheets();
        block0: for (i = 0; i < this.tabs.getTabCount(); ++i) {
            for (int j = 0; j < nSheets; ++j) {
                if (this.tabs.getTitleAt(i).equalsIgnoreCase(this.book.getSheetName(j))) continue block0;
            }
            this.tabs.remove(i--);
        }
        for (i = 0; i < nSheets; ++i) {
            Sheet sheet = this.book.getSheetAt(i);
            int currentSheetIndex = -1;
            for (int j = 0; j < this.tabs.getTabCount(); ++j) {
                if (!this.tabs.getTitleAt(j).equalsIgnoreCase(sheet.getSheetName())) continue;
                currentSheetIndex = i;
                break;
            }
            if (currentSheetIndex == -1) {
                this.tabs.addTab(sheet.getSheetName(), new JPanel());
                currentSheetIndex = this.tabs.getTabCount() - 1;
            }
            if (this.tables.containsKey(sheet = this.book.getSheetAt(currentSheetIndex))) {
                this.updateTable(sheet);
                continue;
            }
            this.createTable(sheet);
        }
        ArrayList<Sheet> keys = new ArrayList<Sheet>();
        keys.addAll(this.tables.keySet());
        for (Sheet sheet : keys) {
            if (this.book.getSheetIndex(sheet) != -1) continue;
            this.tables.remove(sheet);
        }
        keys.clear();
        keys.addAll(this.headers.keySet());
        for (Sheet sheet : keys) {
            if (this.book.getSheetIndex(sheet) != -1) continue;
            this.headers.remove(sheet);
        }
        if (!((Boolean)this.readOnly.getValue()).booleanValue()) {
            this.tabs.addTab("+", new JPanel());
        }
    }

    private static void createSheet(Workbook book) {
        book.createSheet("Sheet " + (book.getNumberOfSheets() + 1));
    }

    private void updateTable(Sheet sheet) {
        JXTable table = this.tables.get(sheet);
        JXTable header = this.headers.get(sheet);
        SheetModel model = (SheetModel)table.getModel();
        if (new IcySpreadSheet(sheet).getNumberOfColumns() != table.getColumnCount(true)) {
            model.fireTableStructureChanged();
        } else if (model.useFirstDataRowAsHeader != (Boolean)this.useHeader.getValue()) {
            model.useFirstDataRowAsHeader = (Boolean)this.useHeader.getValue();
            model.fireTableDataChanged();
            for (TableColumn column : table.getColumns(true)) {
                column.setHeaderValue(table.getModel().getColumnName(column.getModelIndex()));
            }
            table.getTableHeader().repaint();
        }
        header.tableChanged(new TableModelEvent(header.getModel()));
        table.tableChanged(new TableModelEvent(table.getModel()));
    }

    private void createTable(Sheet sheet) {
        final IcySpreadSheet icySheet = new IcySpreadSheet(sheet);
        final int sheetIndex = icySheet.getIndex();
        final SheetModel tableModel = new SheetModel(icySheet, (Boolean)this.useHeader.getValue());
        final VarString sheetName = new VarString("sheet name", sheet.getSheetName());
        final JXTable table = new JXTable(tableModel){

            public TableCellEditor getCellEditor(int row, int column) {
                DefaultCellEditor editor = new DefaultCellEditor(new JTextField()){

                    @Override
                    public Component getTableCellEditorComponent(JTable theTable, Object value, boolean isSelected, int theRow, int theColumn) {
                        theRow = this.convertRowIndexToModel(theRow);
                        theColumn = this.convertColumnIndexToModel(theColumn);
                        String contents = icySheet.getFormula(theRow, theColumn);
                        contents = (contents.isEmpty() ? "" : "=") + icySheet.getValue(theRow, theColumn);
                        return super.getTableCellEditorComponent(theTable, contents, true, theRow, theColumn);
                    }
                };
                return editor;
            }

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable theTable, Object value, boolean isSelected, boolean hasFocus, int theRow, int theColumn) {
                        theRow = this.convertRowIndexToModel(theRow);
                        theColumn = this.convertColumnIndexToModel(theColumn);
                        if (((Boolean)WorkbookEditor.this.useHeader.getValue()).booleanValue()) {
                            ++theRow;
                        }
                        Component component = super.getTableCellRendererComponent(theTable, value, isSelected, hasFocus, theRow, theColumn);
                        Color fillColor = icySheet.getFillColor(theRow, theColumn);
                        if (fillColor != null) {
                            component.setBackground(fillColor);
                        }
                        return component;
                    }
                };
            }
        };
        Comparator<Object> comparator = new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                if (a == null) {
                    a = "";
                }
                if (b == null) {
                    b = "";
                }
                if (a instanceof Comparable && b instanceof Comparable && (a.getClass().isAssignableFrom(b.getClass()) || b.getClass().isAssignableFrom(a.getClass()))) {
                    return ((Comparable)a).compareTo(b);
                }
                if (a instanceof String) {
                    return -1;
                }
                if (b instanceof String) {
                    return 1;
                }
                return 0;
            }
        };
        int nCol = table.getColumnCount();
        for (int i = 0; i < nCol; ++i) {
            table.getColumnExt(i).setComparator((Comparator)comparator);
            table.setSortOrderCycle(new SortOrder[]{SortOrder.DESCENDING, SortOrder.ASCENDING, SortOrder.UNSORTED});
        }
        table.setHorizontalScrollEnabled(true);
        table.setSelectionMode(1);
        table.setCellSelectionEnabled(true);
        table.setColumnControlVisible(true);
        table.setColumnControl((JComponent)((Object)new PersistentColumnControlButton(table)));
        JScrollPane scrollPane = new JScrollPane((Component)table, 22, 30);
        final AbstractTableModel headerModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return row + 1;
            }

            @Override
            public int getRowCount() {
                return tableModel.getRowCount();
            }
        };
        JXTable headerTable = new JXTable(headerModel){

            public TableCellRenderer getCellRenderer(int row, int column) {
                return new TableCellRenderer(){
                    private final TableCellRenderer headerRenderer;
                    Font headerFont;
                    {
                        this.headerRenderer = table.getTableHeader().getDefaultRenderer();
                        this.headerFont = null;
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable theTable, Object value, boolean isSelected, boolean hasFocus, int theRow, int theColumn) {
                        isSelected = table.getSelectionModel().isSelectedIndex(theRow);
                        Component c = this.headerRenderer.getTableCellRendererComponent(theTable, value, isSelected, hasFocus, -1, theColumn);
                        if (this.headerFont == null) {
                            this.headerFont = c.getFont().deriveFont(isSelected ? 1 : 0);
                        }
                        c.setFont(this.headerFont);
                        return c;
                    }
                };
            }
        };
        headerTable.setShowGrid(true);
        headerTable.setAutoResizeMode(0);
        headerTable.setPreferredScrollableViewportSize(new Dimension(40, 0));
        headerTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        headerTable.setRowHeight(table.getRowHeight());
        table.getRowSorter().addRowSorterListener(new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                headerModel.fireTableDataChanged();
            }
        });
        scrollPane.setRowHeaderView((Component)headerTable);
        this.tables.put(sheet, table);
        this.headers.put(sheet, headerTable);
        this.tabs.setComponentAt(sheetIndex, scrollPane);
        final JLabel sheetNameLabel = new JLabel((String)sheetName.getValue());
        class Listener
        implements ListSelectionListener,
        TableColumnModelListener {
            Listener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (table.getSelectedRow() == -1) {
                    return;
                }
                int row = table.convertRowIndexToModel(table.getSelectedRow());
                int column = table.convertColumnIndexToModel(table.getSelectedColumn());
                WorkbookEditor.this.updateFormulaField(tableModel, row, column);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
                this.valueChanged(e);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }
        }
        Listener l = new Listener();
        table.getSelectionModel().addListSelectionListener(l);
        table.getColumnModel().addColumnModelListener(l);
        if (!((Boolean)this.readOnly.getValue()).booleanValue()) {
            sheetNameLabel.setRequestFocusEnabled(false);
            sheetNameLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1) {
                        WorkbookEditor.this.tabs.setSelectedIndex(sheetIndex);
                    } else {
                        Object answer = JOptionPane.showInputDialog(sheetNameLabel, null, "Rename this sheet to...", 3, null, null, sheetName.getValue());
                        if (answer != null) {
                            sheetName.setValue((Object)answer.toString());
                        }
                    }
                }
            });
            sheetName.addListener((VarListener)new VarListener<String>(){

                public void valueChanged(Var<String> source, String oldValue, String newValue) {
                    ((Workbook)WorkbookEditor.this.variable.getValue()).setSheetName(sheetIndex, newValue);
                    sheetNameLabel.setText(newValue);
                }

                public void referenceChanged(Var<String> source, Var<? extends String> oldReference, Var<? extends String> newReference) {
                }
            });
        }
        this.tabs.setTabComponentAt(sheetIndex, sheetNameLabel);
        this.tabs.setTitleAt(sheetIndex, sheet.getSheetName());
    }

    private void updateFormulaField(SheetModel model, int row, int col) {
        String value;
        if (col == -1) {
            this.formula.setValue((Object)"");
            return;
        }
        if (model.useFirstDataRowAsHeader) {
            ++row;
        }
        if (!(value = model.sheet.getFormula(row, col)).isEmpty()) {
            this.formula.setValue((Object)(" Formula: =" + value));
        } else {
            value = "" + model.sheet.getValue(row, col);
            if (!value.isEmpty()) {
                this.formula.setValue((Object)(" Value: " + value));
            } else {
                this.formula.setValue((Object)"");
            }
        }
    }

    private class SheetModel
    extends AbstractTableModel {
        final int MAX_NB_ROWS = 65536;
        final int MAX_NB_COLS = 256;
        private boolean useFirstDataRowAsHeader = false;
        final IcySpreadSheet sheet;

        public SheetModel(IcySpreadSheet sheet, boolean useFirstRowAsHeader) {
            this.sheet = sheet;
            this.useFirstDataRowAsHeader = useFirstRowAsHeader;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue instanceof String) {
                String text = (String)aValue;
                if (text.isEmpty()) {
                    this.sheet.deleteCell(rowIndex, columnIndex);
                } else if (text.startsWith("=")) {
                    try {
                        this.sheet.setFormula(rowIndex, columnIndex, text);
                    }
                    catch (FormulaParseException e1) {
                        this.sheet.setValue(rowIndex, columnIndex, text);
                    }
                } else {
                    this.sheet.setValue(rowIndex, columnIndex, text);
                }
            } else {
                this.sheet.setValue(rowIndex, columnIndex, aValue);
            }
            WorkbookEditor.this.updateFormulaField(this, rowIndex, columnIndex);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.useFirstDataRowAsHeader) {
                ++rowIndex;
            }
            return this.sheet.getValue(rowIndex, columnIndex);
        }

        @Override
        public int getRowCount() {
            if (!((Boolean)WorkbookEditor.this.readOnly.getValue()).booleanValue()) {
                return 65536;
            }
            int nbRows = this.sheet.getNumberOfRows();
            return this.useFirstDataRowAsHeader ? nbRows - 1 : nbRows;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.useFirstDataRowAsHeader) {
                return "" + this.getValueAt(-1, columnIndex);
            }
            return super.getColumnName(columnIndex);
        }

        @Override
        public int getColumnCount() {
            if (!((Boolean)WorkbookEditor.this.readOnly.getValue()).booleanValue()) {
                return 256;
            }
            return this.sheet.getNumberOfColumns();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return (Boolean)WorkbookEditor.this.readOnly.getValue() == false;
        }
    }

    class TabChangeListener
    implements ChangeListener {
        TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Workbook book = (Workbook)WorkbookEditor.this.variable.getValue();
            int sheetIndex = WorkbookEditor.this.tabs.getSelectedIndex();
            if (sheetIndex == book.getNumberOfSheets()) {
                WorkbookEditor.this.tabs.removeTabAt(book.getNumberOfSheets());
                WorkbookEditor.createSheet(book);
                WorkbookEditor.this.updateInterfaceValue();
                WorkbookEditor.this.tabs.setSelectedIndex(book.getNumberOfSheets() - 1);
                book.setActiveSheet(book.getNumberOfSheets() - 1);
            }
            if (sheetIndex >= 0) {
                Sheet sheet = book.getSheetAt(sheetIndex);
                book.setActiveSheet(sheetIndex);
                if (WorkbookEditor.this.tables.containsKey(sheet)) {
                    JXTable table = (JXTable)WorkbookEditor.this.tables.get(sheet);
                    SheetModel model = (SheetModel)table.getModel();
                    WorkbookEditor.this.updateFormulaField(model, table.getSelectedRow(), table.getSelectedColumn());
                }
            }
        }
    }
}

