/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.gui.frame.GenericFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import plugins.ylemontag.mathoperations.Expression;

public class ExpressionComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private List<ValueListener> _listeners = new LinkedList<ValueListener>();
    private String[] _validVariables;
    private Expression _value;
    private boolean _isTextEmpty;
    private JTextField _textField;
    private JButton _helpButton;

    public ExpressionComponent() {
        this((String[])null);
    }

    public ExpressionComponent(String[] validVariables) {
        super(new BorderLayout(5, 5));
        this._validVariables = validVariables;
        this._value = null;
        this._isTextEmpty = true;
        this._textField = new JTextField();
        this.add((Component)this._textField, "Center");
        this._textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionComponent.this.onComponentValueChanged(ExpressionComponent.this._textField.getText());
            }
        });
        this._textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                ExpressionComponent.this.onComponentValueChanged(ExpressionComponent.this._textField.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (ExpressionComponent.this._isTextEmpty) {
                    ExpressionComponent.this._textField.setText("");
                    ExpressionComponent.this._textField.setForeground(Color.BLACK);
                }
            }
        });
        this.updateComponentText("");
        this._helpButton = new JButton("?");
        Dimension dim = this._helpButton.getPreferredSize();
        dim.setSize(30.0, dim.getHeight());
        this._helpButton.setMinimumSize(dim);
        this._helpButton.setPreferredSize(dim);
        this.add((Component)this._helpButton, "East");
        this._helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExpressionComponent.this.showHelpFrame();
            }
        });
    }

    public void addValueListener(ValueListener l) {
        this._listeners.add(l);
    }

    public void removeValueListener(ValueListener l) {
        this._listeners.remove(l);
    }

    public Expression getValue() {
        return this._value;
    }

    public void setValue(Expression value) {
        Expression oldValue = this._value;
        if (this.isExpressionValid(value)) {
            this._value = value;
            this.updateComponentText(value.getRepresentation(true));
        } else {
            this._value = null;
            this.updateComponentText("");
        }
        if (this.isSameExpression(oldValue)) {
            return;
        }
        this.fireValueListeners();
    }

    private void onComponentValueChanged(String newText) {
        Expression oldValue = this._value;
        this._value = this.getValidatedExpression(newText);
        this.updateComponentText(this._value == null ? newText : this._value.getRepresentation(true));
        if (this.isSameExpression(oldValue)) {
            return;
        }
        this.fireValueListeners();
    }

    private void updateComponentText(String text) {
        if (text.equals("")) {
            this._isTextEmpty = true;
            if (this._textField.hasFocus()) {
                this._textField.setText("");
                this._textField.setForeground(Color.BLACK);
            } else {
                this._textField.setText("Example: x+log(y)");
                this._textField.setForeground(Color.GRAY);
            }
        } else {
            this._isTextEmpty = false;
            this._textField.setText(text);
            this._textField.setForeground(this._value == null ? Color.RED : Color.BLACK);
        }
    }

    private Expression getValidatedExpression(String text) {
        try {
            Expression expr = Expression.parse(text);
            if (this.isExpressionValid(expr)) {
                return expr;
            }
            return null;
        }
        catch (Expression.ParsingException err) {
            return null;
        }
    }

    private boolean isExpressionValid(Expression expression) {
        if (expression == null) {
            return false;
        }
        return expression.isValidFunctor(this._validVariables);
    }

    private boolean isSameExpression(Expression newValue) {
        if (this._value == null) {
            return newValue == null;
        }
        return this._value.equals(newValue);
    }

    private void fireValueListeners() {
        for (ValueListener l : this._listeners) {
            l.valueChanged(this._value);
        }
    }

    private void showHelpFrame() {
        String title = "Syntax for mathematical expressions";
        JTextPane message = new JTextPane();
        message.setEditable(false);
        message.setContentType("text/html");
        message.setText("<h3>Examples</h3><ul><li><tt>5*a + log(3/b) - c^2</tt></li><li><tt>-x + max(y, abs(z))</tt></li><li><tt>rho*cos(theta) + alpha^(-2)</tt></li></ul><h3>Available functions</h3><p>All the following functions expect one argument, unless otherwise specified.</p><ul><li><tt>abs</tt>&nbsp;: absolute value</li><li><tt>sign</tt>&nbsp;: sign extraction</li><li><tt>sqrt</tt>&nbsp;: square root</li><li><tt>exp</tt>&nbsp;: exponential function</li><li><tt>log</tt>&nbsp;: natural logarithm</li><li><tt>log10</tt>&nbsp;: decimal logarithm</li><li><tt>cos</tt>&nbsp;: cosine</li><li><tt>sin</tt>&nbsp;: sine</li><li><tt>tan</tt>&nbsp;: tangent</li><li><tt>acos</tt>&nbsp;: arc cosine</li><li><tt>asin</tt>&nbsp;: arc sine</li><li><tt>atan</tt>&nbsp;: arc tangent</li><li><tt>cosh</tt>&nbsp;: hyperbolic cosine</li><li><tt>sinh</tt>&nbsp;: hyperbolic sine</li><li><tt>tanh</tt>&nbsp;: hyperbolic tangent</li><li><tt>round</tt>&nbsp;: rounding to the closest integer</li><li><tt>floor</tt>&nbsp;: rounding to the largest previous integer</li><li><tt>ceil</tt>&nbsp;: rounding to the smallest following integer</li><li><tt>max</tt>&nbsp;: maximum (expects two arguments)</li><li><tt>min</tt>&nbsp;: minimum (expects two arguments)</li></ul><h3>Available operators</h3><ul><li><tt>+</tt>&nbsp;: addition</li><li><tt>-</tt>&nbsp;: substraction</li><li><tt>*</tt>&nbsp;: multiplication</li><li><tt>/</tt>&nbsp;: division</li><li><tt>^</tt>&nbsp;: power</li></ul><p>All the operators are left-associative, which means that <tt>a/b/c</tt> will be evaluated as <tt>(a/b)/c</tt>. Usual precedence rules between operators apply: operator <tt>^</tt> is evaluated first, then <tt>*</tt> and <tt>/</tt>, and finally <tt>+</tt> and <tt>-</tt>. For instance, <tt>-a^3 + 4/3*b</tt> will be interpreted as <tt>(-(a^3)) + ((4/3)*b)</tt>.</p>");
        Dimension dim = message.getPreferredSize();
        dim.setSize(600.0, dim.getHeight() + 100.0);
        message.setPreferredSize(dim);
        JScrollPane scroll = new JScrollPane(message);
        dim = scroll.getPreferredSize();
        dim.setSize(600, 500);
        scroll.setPreferredSize(dim);
        GenericFrame infoFrame = new GenericFrame(title, (JComponent)scroll);
        infoFrame.addToMainDesktopPane();
        infoFrame.setVisible(true);
        infoFrame.requestFocus();
    }

    public static interface ValueListener {
        public void valueChanged(Expression var1);
    }
}

