/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.convert;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROIUtil;
import java.util.ArrayList;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarInteger;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.util.VarException;
import plugins.stef.roi.bloc.RoiBlocks;

public class ROITo3DStack
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected final VarROIArray input = new VarROIArray("Roi(s)");
    protected final VarInteger sizeZ = new VarInteger("Size Z", 10);
    protected final VarROIArray output = new VarROIArray("3D stack roi(s)");

    public void run() {
        ROI[] rois = (ROI[])this.input.getValue();
        ArrayList<ROI> result = new ArrayList<ROI>();
        if (rois != null) {
            int maxZ = this.sizeZ.getValue() - 1;
            if (maxZ < 0) {
                throw new VarException((Var)this.sizeZ, "Size Z field should be > 0");
            }
            for (ROI roi : rois) {
                if (roi instanceof ROI2D) {
                    result.add(ROIUtil.convertToStack((ROI2D)((ROI2D)roi), (int)0, (int)maxZ));
                    continue;
                }
                result.add(roi);
            }
        }
        this.output.setValue((Object)result.toArray(new ROI[result.size()]));
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input", (Var)this.input);
        inputMap.add("sizeZ", (Var)this.sizeZ);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

