/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.op;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import icy.system.IcyHandledException;
import icy.type.dimension.Dimension3D;
import icy.type.dimension.Dimension5D;
import icy.type.rectangle.Rectangle5D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class SeparateROIWatershed
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarROIArray varInTargetRois;
    protected VarROIArray varInSeedRois;
    protected VarROIArray varOutRois;
    protected VarROIArray varOutSeeds;

    public void declareInput(VarList inputMap) {
        this.varInTargetRois = new VarROIArray("ROI(s)");
        this.varInSeedRois = new VarROIArray("Seed ROI(s)");
        inputMap.add("inputRois", (Var)this.varInTargetRois);
        inputMap.add("inputSeeds", (Var)this.varInSeedRois);
    }

    public void declareOutput(VarList outputMap) {
        this.varOutRois = new VarROIArray("Separated ROI(s)");
        this.varOutSeeds = new VarROIArray("Seed ROI(s)");
        outputMap.add("outputRois", (Var)this.varOutRois);
        outputMap.add("outputSeeds", (Var)this.varOutSeeds);
    }

    public void run() {
        ROI[] rois = (ROI[])this.varInTargetRois.getValue();
        ROI[] seeds = (ROI[])this.varInSeedRois.getValue();
        List result = new ArrayList();
        if (rois != null) {
            List<Object> seedList;
            try {
                if (seeds != null && seeds.length > 0) {
                    seedList = Arrays.asList(seeds);
                    result = ROIUtil.computeWatershedSeparation(Arrays.asList(rois), seedList, (Dimension5D)this.getDimensionSize(rois), (Dimension3D)new Dimension3D.Double(1.0, 1.0, 1.0));
                } else {
                    seedList = new ArrayList();
                    result = ROIUtil.computeWatershedSeparation(Arrays.asList(rois), (Dimension5D)this.getDimensionSize(rois), (Dimension3D)new Dimension3D.Double(1.0, 1.0, 1.0), seedList);
                }
            }
            catch (Exception e) {
                throw new IcyHandledException("Error on watershed separation: " + e.getMessage(), (Throwable)e);
            }
            this.varOutRois.setValue((Object)result.toArray(new ROI[result.size()]));
            this.varOutSeeds.setValue((Object)seedList.toArray(new ROI[seedList.size()]));
        }
    }

    private Dimension5D getDimensionSize(ROI[] rois) {
        Dimension5D.Double dims = new Dimension5D.Double();
        for (ROI roi : rois) {
            Rectangle5D roiBounds = roi.getBounds5D();
            dims.sizeX = Math.max(dims.sizeX, roiBounds.getMaxX() + 10.0);
            dims.sizeY = Math.max(dims.sizeY, roiBounds.getMaxY() + 10.0);
            dims.sizeZ = Math.max(dims.sizeZ, roiBounds.getMaxZ());
            dims.sizeT = Math.max(dims.sizeT, roiBounds.getMaxT());
            dims.sizeC = Math.max(dims.sizeC, roiBounds.getMaxC());
        }
        if (!Double.isFinite(dims.sizeX) || dims.sizeX == 0.0) {
            dims.sizeX = 1.0;
        }
        if (!Double.isFinite(dims.sizeY) || dims.sizeY == 0.0) {
            dims.sizeY = 1.0;
        }
        if (!Double.isFinite(dims.sizeZ) || dims.sizeZ == 0.0) {
            dims.sizeZ = 1.0;
        }
        if (!Double.isFinite(dims.sizeT) || dims.sizeT == 0.0) {
            dims.sizeT = 1.0;
        }
        if (!Double.isFinite(dims.sizeC) || dims.sizeC == 0.0) {
            dims.sizeC = 1.0;
        }
        return dims;
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

