/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.codec;

import java.io.IOException;
import java.util.Random;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCodec
implements Codec {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BaseCodec.class);

    public void test() throws FormatException {
        int i;
        byte[] testdata = new byte[50000];
        Random r = new Random();
        LOGGER.info("Testing {}", (Object)this.getClass().getName());
        LOGGER.info("Generating random data");
        r.nextBytes(testdata);
        LOGGER.info("Compressing data");
        byte[] compressed = this.compress(testdata, null);
        LOGGER.info("Compressed size: {}", (Object)compressed.length);
        LOGGER.info("Decompressing data");
        byte[] decompressed = this.decompress(compressed);
        LOGGER.info("Comparing data...");
        if (testdata.length != decompressed.length) {
            LOGGER.info("Test data differs in length from uncompressed data");
            LOGGER.info("Exiting...");
            System.exit(-1);
        } else {
            boolean equalsFlag = true;
            for (i = 0; i < testdata.length; ++i) {
                if (testdata[i] == decompressed[i]) continue;
                LOGGER.info("Test data and uncompressed data differ at byte {}", (Object)i);
                equalsFlag = false;
            }
            if (!equalsFlag) {
                LOGGER.info("Comparison failed. Exiting...");
                System.exit(-1);
            }
        }
        LOGGER.info("Success.");
        LOGGER.info("Generating 2D byte array test");
        byte[][] twoDtest = new byte[100][500];
        for (i = 0; i < 100; ++i) {
            System.arraycopy(testdata, 500 * i, twoDtest[i], 0, 500);
        }
        byte[] twoDcompressed = this.compress(twoDtest, null);
        LOGGER.info("Comparing compressed data...");
        if (twoDcompressed.length != compressed.length) {
            LOGGER.info("1D and 2D compressed data not same length");
            LOGGER.info("Exiting...");
            System.exit(-1);
        }
        boolean equalsFlag = true;
        for (int i2 = 0; i2 < twoDcompressed.length; ++i2) {
            if (twoDcompressed[i2] != compressed[i2]) {
                LOGGER.info("1D data and 2D compressed data differs at byte {}", (Object)i2);
                equalsFlag = false;
            }
            if (equalsFlag) continue;
            LOGGER.info("Comparison failed. Exiting...");
            System.exit(-1);
        }
        LOGGER.info("Success.");
        LOGGER.info("Test complete.");
    }

    @Override
    public byte[] compress(byte[][] data, CodecOptions options) throws FormatException {
        int len = 0;
        for (int i = 0; i < data.length; ++i) {
            len += data[i].length;
        }
        byte[] toCompress = new byte[len];
        int curPos = 0;
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, toCompress, curPos, data[i].length);
            curPos += data[i].length;
        }
        return this.compress(toCompress, options);
    }

    @Override
    public byte[] decompress(byte[] data) throws FormatException {
        return this.decompress(data, null);
    }

    @Override
    public byte[] decompress(byte[][] data) throws FormatException {
        return this.decompress(data, null);
    }

    @Override
    public byte[] decompress(byte[] data, CodecOptions options) throws FormatException {
        byte[] byArray;
        RandomAccessInputStream r = new RandomAccessInputStream(data);
        try {
            byArray = this.decompress(r, options);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FormatException(e);
            }
        }
        r.close();
        return byArray;
    }

    @Override
    public abstract byte[] decompress(RandomAccessInputStream var1, CodecOptions var2) throws FormatException, IOException;

    @Override
    public byte[] decompress(byte[][] data, CodecOptions options) throws FormatException {
        if (data == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        int len = 0;
        for (int i = 0; i < data.length; ++i) {
            len += data[i].length;
        }
        byte[] toDecompress = new byte[len];
        int curPos = 0;
        for (int i = 0; i < data.length; ++i) {
            System.arraycopy(data[i], 0, toDecompress, curPos, data[i].length);
            curPos += data[i].length;
        }
        return this.decompress(toDecompress, options);
    }
}

