/*
 * Decompiled with CFR 0.152.
 */
package mitiv.base.indexing;

import mitiv.base.indexing.Range;
import mitiv.exception.IllegalRangeException;

public class CompiledRange {
    public final int offset;
    public final int stride;
    public final int number;
    public final boolean nothing;

    public CompiledRange(Range rng, int length) {
        if (rng == null) {
            this.offset = 0;
            this.stride = 1;
            this.number = length;
            this.nothing = true;
        } else {
            int first = rng.getFirst(length);
            int last = rng.getLast(length);
            int step = rng.getStep();
            this.number = CompiledRange.count(first, last, step, length);
            this.offset = first;
            this.stride = step;
            this.nothing = first == 0 && this.number == length && (step == 1 || length == 1);
        }
    }

    public CompiledRange(Range rng, int length, int offset, int stride) {
        if (rng == null) {
            this.offset = offset;
            this.stride = stride;
            this.number = length;
            this.nothing = true;
        } else {
            int first = rng.getFirst(length);
            int last = rng.getLast(length);
            int step = rng.getStep();
            this.number = CompiledRange.count(first, last, step, length);
            this.offset = offset + first * stride;
            this.stride = step * stride;
            this.nothing = first == 0 && this.number == length && (step == 1 || length == 1);
        }
    }

    private static final int count(int first, int last, int step, int length) {
        if (first <= last) {
            if (0 <= first && last < length) {
                if (step > 0) {
                    return (last - first) / step + 1;
                }
                if (step < 0) {
                    CompiledRange.emptyRange();
                } else {
                    CompiledRange.illegalStep();
                }
            }
        } else if (0 <= last && first < length) {
            if (step < 0) {
                return (last - first) / step + 1;
            }
            if (step > 0) {
                CompiledRange.emptyRange();
            } else {
                CompiledRange.illegalStep();
            }
        }
        throw new IndexOutOfBoundsException("Range is outside bounds");
    }

    private static final void emptyRange() {
        throw new IllegalRangeException("Empty range");
    }

    private static final void illegalStep() {
        throw new IllegalRangeException("Illegal 0 step");
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getStride() {
        return this.stride;
    }

    public final int getNumber() {
        return this.number;
    }

    public final boolean doesNothing() {
        return this.nothing;
    }
}

