/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.ribbon.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.Border;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceRibbonBandBorder
implements Border {
    @Override
    public Insets getBorderInsets(Component c) {
        return SubstanceSizeUtils.getDefaultBorderInsets(SubstanceSizeUtils.getComponentFontSize(c));
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        float radius = this.getCornerRadius(c);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(c, ComponentState.ENABLED);
        graphics.setComposite(LafWidgetUtilities.getAlphaComposite(c, alpha, g));
        AbstractRibbonBand band = (AbstractRibbonBand)c;
        int titleHeight = band.getUI().getBandTitleHeight();
        SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(c, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, radius, borderColorScheme);
        if (!(band.getCurrentResizePolicy() instanceof IconRibbonBandResizePolicy)) {
            graphics.clipRect(0, c.getHeight() - titleHeight, c.getWidth(), titleHeight);
            SubstanceColorScheme bottomColorScheme = SubstanceLookAndFeel.getCurrentSkin(c).getColorScheme(DecorationAreaType.HEADER, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
            graphics.setComposite(LafWidgetUtilities.getAlphaComposite(c, 0.75f, g));
            SubstanceImageCreator.paintBorder(c, graphics, x, y, width, height, radius, bottomColorScheme);
        }
        graphics.dispose();
    }

    public float getCornerRadius(Component c) {
        return SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(c));
    }
}

