/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.distancetransforms;

import plugins.adufour.distancetransforms.ChamferDistanceTransform;

public class Chamfer3
extends ChamferDistanceTransform {
    @Override
    public void updateUnsignedChamferDistance2D(float[] map, int width, float planarLateralDistance) {
        float bDist;
        float aDist;
        int i;
        int j;
        double xy2 = planarLateralDistance * planarLateralDistance;
        float planarDiagonalDistance = (float)Math.sqrt(xy2 + xy2);
        int height = map.length / width;
        int offset = 0;
        for (j = 0; j < height; ++j) {
            i = 0;
            while (i < width) {
                float val = map[offset];
                aDist = val + planarLateralDistance;
                if (i < width - 1 && map[offset + 1] > aDist) {
                    map[offset + 1] = aDist;
                }
                if (j < height - 1) {
                    if (map[offset + width] > aDist) {
                        map[offset + width] = aDist;
                    }
                    bDist = val + planarDiagonalDistance;
                    if (i < width - 1 && map[offset + width + 1] > bDist) {
                        map[offset + width + 1] = bDist;
                    }
                    if (i > 0 && map[offset + width - 1] > bDist) {
                        map[offset + width - 1] = bDist;
                    }
                }
                ++i;
                ++offset;
            }
        }
        --offset;
        for (j = height - 1; j >= 0; --j) {
            i = width - 1;
            while (i >= 0) {
                aDist = map[offset] + planarLateralDistance;
                if (i > 0 && map[offset - 1] > aDist) {
                    map[offset - 1] = aDist;
                }
                if (j > 0) {
                    bDist = aDist - planarLateralDistance + planarDiagonalDistance;
                    if (map[offset - width] > aDist) {
                        map[offset - width] = aDist;
                    }
                    if (i > 0 && map[offset - width - 1] > bDist) {
                        map[offset - width - 1] = bDist;
                    }
                    if (i < width - 1 && map[offset - width + 1] > bDist) {
                        map[offset - width + 1] = bDist;
                    }
                }
                --i;
                --offset;
            }
        }
    }

    @Override
    public void updateUnsignedChamferDistance3D(float[][] map, int width, float planoLateralDistance, float axioLateralDistance) {
        int offsetDown;
        int offsetUp;
        float eDist;
        float dDist;
        float cDist;
        float aDist;
        float val;
        int i;
        int j;
        int offset;
        float[] thisSlice;
        int k;
        double xy2 = planoLateralDistance * planoLateralDistance;
        double xz2 = axioLateralDistance * axioLateralDistance;
        float planoDiagonalDistance = (float)Math.sqrt(xy2 + xy2);
        float axioDiagonalDistance = (float)Math.sqrt(xy2 + xz2);
        float planoAxioDiagonalDistance = (float)Math.sqrt(xy2 + xy2 + xz2);
        int height = map[0].length / width;
        int depth = map.length;
        for (k = 0; k < depth; ++k) {
            thisSlice = map[k];
            offset = 0;
            for (j = 0; j < height; ++j) {
                i = 0;
                while (i < width) {
                    val = thisSlice[offset];
                    aDist = val + planoLateralDistance;
                    if (i < width - 1 && thisSlice[offset + 1] > aDist) {
                        thisSlice[offset + 1] = aDist;
                    }
                    if (j < height - 1) {
                        if (thisSlice[offset + width] > aDist) {
                            thisSlice[offset + width] = aDist;
                        }
                        float bDist = val + planoDiagonalDistance;
                        if (i < width - 1 && thisSlice[offset + width + 1] > bDist) {
                            thisSlice[offset + width + 1] = bDist;
                        }
                        if (i > 0 && thisSlice[offset + width - 1] > bDist) {
                            thisSlice[offset + width - 1] = bDist;
                        }
                    }
                    if (k < depth - 1) {
                        float[] nextSlice = map[k + 1];
                        cDist = val + axioLateralDistance;
                        if (nextSlice[offset] > cDist) {
                            nextSlice[offset] = cDist;
                        }
                        dDist = val + axioDiagonalDistance;
                        if (i > 0 && nextSlice[offset - 1] > dDist) {
                            nextSlice[offset - 1] = dDist;
                        }
                        if (i < width - 1 && nextSlice[offset + 1] > dDist) {
                            nextSlice[offset + 1] = dDist;
                        }
                        eDist = val + planoAxioDiagonalDistance;
                        if (j > 0) {
                            offsetUp = offset - width;
                            if (nextSlice[offsetUp] > dDist) {
                                nextSlice[offsetUp] = dDist;
                            }
                            if (i > 0 && nextSlice[offsetUp - 1] > eDist) {
                                nextSlice[offsetUp - 1] = eDist;
                            }
                            if (i < width - 1 && nextSlice[offsetUp + 1] > eDist) {
                                nextSlice[offsetUp + 1] = eDist;
                            }
                        }
                        if (j < height - 1) {
                            offsetDown = offset + width;
                            if (nextSlice[offsetDown] > dDist) {
                                nextSlice[offsetDown] = dDist;
                            }
                            if (i > 0 && nextSlice[offsetDown - 1] > eDist) {
                                nextSlice[offsetDown - 1] = eDist;
                            }
                            if (i < width - 1 && nextSlice[offsetDown + 1] > eDist) {
                                nextSlice[offsetDown + 1] = eDist;
                            }
                        }
                    }
                    ++i;
                    ++offset;
                }
            }
        }
        for (k = depth - 1; k >= 0; --k) {
            thisSlice = map[k];
            offset = thisSlice.length - 1;
            for (j = height - 1; j >= 0; --j) {
                i = width - 1;
                while (i >= 0) {
                    val = thisSlice[offset];
                    aDist = val + planoLateralDistance;
                    if (i > 0 && thisSlice[offset - 1] > aDist) {
                        thisSlice[offset - 1] = aDist;
                    }
                    if (j > 0) {
                        int offsetUp2 = offset - width;
                        if (thisSlice[offsetUp2] > aDist) {
                            thisSlice[offsetUp2] = aDist;
                        }
                        float bDist = val + planoDiagonalDistance;
                        if (i > 0 && thisSlice[offsetUp2 - 1] > bDist) {
                            thisSlice[offsetUp2 - 1] = bDist;
                        }
                        if (i < width - 1 && thisSlice[offsetUp2 + 1] > bDist) {
                            thisSlice[offsetUp2 + 1] = bDist;
                        }
                    }
                    if (k > 0) {
                        float[] prevSlice = map[k - 1];
                        cDist = val + axioLateralDistance;
                        if (prevSlice[offset] > cDist) {
                            prevSlice[offset] = cDist;
                        }
                        dDist = val + axioDiagonalDistance;
                        if (i > 0 && prevSlice[offset - 1] > dDist) {
                            prevSlice[offset - 1] = dDist;
                        }
                        if (i < width - 1 && prevSlice[offset + 1] > dDist) {
                            prevSlice[offset + 1] = dDist;
                        }
                        eDist = val + planoAxioDiagonalDistance;
                        if (j > 0) {
                            offsetUp = offset - width;
                            if (prevSlice[offsetUp] > dDist) {
                                prevSlice[offsetUp] = dDist;
                            }
                            if (i > 0 && prevSlice[offsetUp - 1] > eDist) {
                                prevSlice[offsetUp - 1] = eDist;
                            }
                            if (i < width - 1 && prevSlice[offsetUp + 1] > eDist) {
                                prevSlice[offsetUp + 1] = eDist;
                            }
                        }
                        if (j < height - 1) {
                            offsetDown = offset + width;
                            if (prevSlice[offsetDown] > dDist) {
                                prevSlice[offsetDown] = dDist;
                            }
                            if (i > 0 && prevSlice[offsetDown - 1] > eDist) {
                                prevSlice[offsetDown - 1] = eDist;
                            }
                            if (i < width - 1 && prevSlice[offsetDown + 1] > eDist) {
                                prevSlice[offsetDown + 1] = eDist;
                            }
                        }
                    }
                    --i;
                    --offset;
                }
            }
        }
    }
}

