/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import icy.canvas.Canvas2D;
import icy.canvas.IcyCanvas;
import icy.file.FileUtil;
import icy.file.Saver;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.gui.util.GuiUtil;
import icy.gui.viewer.Viewer;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.system.thread.ThreadUtil;
import icy.util.XLSUtil;
import icy.util.XMLUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import loci.formats.FormatException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GeneralSpotDetectionPanel;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.Point3D;
import plugins.fab.spotDetector.SpotDetector;
import plugins.fab.spotDetector.detector.DetectionToROI;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;
import plugins.nchenouard.spot.DetectionResult;
import plugins.nchenouard.spot.Spot;

public class OutPutPanel
extends GeneralSpotDetectionPanel {
    private static final long serialVersionUID = -2273173314961844726L;
    JCheckBox exportXLSCheckBox;
    JCheckBox exportXMLCheckBox;
    JCheckBox exportOriginalImageWithROIAndDetection;
    JCheckBox exportBinaryImage;
    JCheckBox exportSwimmingPoolCheckBox;
    JCheckBox exportToROIcheckBox;
    JCheckBox removePreviousSpotROIcheckBox;
    XLSPanel XLSPanel;
    XMLPanel XMLPanel;

    public OutPutPanel(SpotDetector spotDetector) {
        super(spotDetector);
        this.setTitle("Output");
        this.setLayout(new BoxLayout(this, 3));
        this.exportToROIcheckBox = new JCheckBox("Export to ROI", false);
        this.exportSwimmingPoolCheckBox = new JCheckBox("Export to SwimmingPool", false);
        this.exportOriginalImageWithROIAndDetection = new JCheckBox("Export original image with ROIs and detection", false);
        this.exportBinaryImage = new JCheckBox("Export binary image", false);
        this.removePreviousSpotROIcheckBox = new JCheckBox("Remove previous spots rendered as ROI", true);
        this.XLSPanel = new XLSPanel();
        this.XMLPanel = new XMLPanel();
        this.add(this.XLSPanel);
        this.add(this.XMLPanel);
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.exportToROIcheckBox, Box.createHorizontalGlue()}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.removePreviousSpotROIcheckBox, Box.createHorizontalGlue()}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.exportOriginalImageWithROIAndDetection, Box.createHorizontalGlue()}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.exportBinaryImage, Box.createHorizontalGlue()}));
        this.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.exportSwimmingPoolCheckBox, Box.createHorizontalGlue()}));
        this.add(Box.createVerticalGlue());
    }

    ArrayList<String> getTagList(Sequence sequence, ROI roi) {
        ArrayList<String> tagList = new ArrayList<String>();
        Node tagNode = sequence.getNode("tags");
        if (tagNode != null) {
            ArrayList roiElementList = XMLUtil.getSubElements((Node)tagNode);
            for (Element roiElement1 : roiElementList) {
                int roiId = XMLUtil.getAttributeIntValue((Element)roiElement1, (String)"ROI_ID", (int)-1);
                if (roiId != roi.getId()) continue;
                ArrayList roiTagList = XMLUtil.getSubElements((Node)roiElement1);
                for (Element tag : roiTagList) {
                    String name = XMLUtil.getAttributeValue((Element)tag, (String)"name", (String)"no name");
                    tagList.add(name);
                }
            }
        }
        return tagList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(final GlobalDetectionToken gdt) {
        ArrayList<Object> roiList;
        File xlsAppendFile;
        if (this.XMLPanel.isExportToXMLSelected()) {
            File XMLFile = this.XMLPanel.getSelectedFile();
            if (XMLFile == null) {
                new FailedAnnounceFrame("XML output is enabled, but no output file was specified !");
                return;
            }
            Document document = XMLUtil.loadDocument((File)XMLFile);
            if (document == null) {
                document = XMLUtil.createDocument((boolean)true);
            }
            HashMap<ROI, ArrayList<DetectionSpot>> ROI2Detection = gdt.roi2detection;
            for (ROI roi : ROI2Detection.keySet()) {
                ArrayList<DetectionSpot> detection = gdt.roi2detection.get(roi);
                Element roiElement = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"ROI");
                XMLUtil.setAttributeValue((Element)roiElement, (String)"name", (String)roi.getName());
                XMLUtil.setAttributeIntValue((Element)roiElement, (String)"nb", (int)detection.size());
                XMLUtil.setAttributeIntValue((Element)roiElement, (String)"surface", (int)OutPutPanel.computeROISurface(roi));
                XMLUtil.setAttributeValue((Element)roiElement, (String)"file_and_folder", (String)gdt.inputSequence.getFilename());
                XMLUtil.setAttributeValue((Element)roiElement, (String)"folder", (String)FileUtil.getDirectory((String)gdt.inputSequence.getFilename()));
                XMLUtil.setAttributeValue((Element)roiElement, (String)"file", (String)FileUtil.getFileName((String)gdt.inputSequence.getFilename(), (boolean)true));
                XMLUtil.setAttributeValue((Element)roiElement, (String)"process_date", (String)new Date().toString());
                ArrayList<String> tagList = this.getTagList(gdt.inputSequence, roi);
                for (String tagName : tagList) {
                    XMLUtil.setAttributeValue((Element)roiElement, (String)("tag" + (tagList.indexOf(tagName) + 1)), (String)tagName);
                }
            }
            XMLUtil.saveDocument((Document)document, (File)XMLFile);
        }
        gdt.inputSequence.getFilename();
        File XLSFile = null;
        String fileName = gdt.inputSequence.getFilename();
        if (fileName == null) {
            fileName = System.getProperty("user.home");
            fileName = fileName + "/icy";
            FileUtil.createDir((File)new File(fileName));
            fileName = fileName + "/noname.tif";
        }
        File inputSequenceFile = new File(fileName);
        String file = inputSequenceFile.getAbsolutePath();
        String folder = file = file.substring(0, file.length() - inputSequenceFile.getName().length());
        final File dirResult = new File(folder, "/save");
        final File withnessImageFile = new File(folder + "/" + "save" + "/" + inputSequenceFile.getName() + ".roi.detection.tif");
        ThreadUtil.invokeNow((Runnable)new Runnable(){

            @Override
            public void run() {
                if (OutPutPanel.this.exportOriginalImageWithROIAndDetection.isSelected()) {
                    Viewer viewer = new Viewer(gdt.inputSequence, false);
                    viewer.setCanvas((IcyCanvas)new Canvas2D(viewer));
                    Canvas2D canvas = (Canvas2D)viewer.getCanvas();
                    viewer.setSize(200, 200);
                    BufferedImage renderedImage = canvas.getRenderedImage(0, 0, -1, false);
                    try {
                        if (!dirResult.exists()) {
                            dirResult.mkdir();
                        }
                        Saver.saveImage((IcyBufferedImage)IcyBufferedImage.createFrom((BufferedImage)renderedImage), (File)withnessImageFile, (boolean)true);
                    }
                    catch (FormatException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    viewer.close();
                }
            }
        });
        if (this.exportBinaryImage.isSelected()) {
            final File binaryImageFile = new File(folder + "/" + "save" + "/" + inputSequenceFile.getName() + ".roi.binary.tif");
            ThreadUtil.invokeNow((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Sequence sequenceBinaryDetection = gdt.inputSequence.extractChannel(0).convertToType(0, false, false);
                        sequenceBinaryDetection.beginUpdate();
                        for (IcyBufferedImage image : sequenceBinaryDetection.getAllImage()) {
                            byte[] b = image.getDataXYAsByte(0);
                            Arrays.fill(b, (byte)0);
                        }
                        for (DetectionSpot detection : gdt.detectionResult) {
                            int t = detection.t;
                            for (Point3D p : detection.points) {
                                sequenceBinaryDetection.getDataXYAsByte((int)t, (int)((int)p.z), (int)0)[sequenceBinaryDetection.getWidth() * (int)p.y + (int)p.x] = -1;
                            }
                        }
                        sequenceBinaryDetection.endUpdate();
                        if (!dirResult.exists()) {
                            dirResult.mkdir();
                        }
                        Saver.save((Sequence)sequenceBinaryDetection, (File)binaryImageFile, (boolean)false, (boolean)true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            throw e;
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            });
        }
        XLSFile = new File(folder + "/" + "save" + "/" + inputSequenceFile.getName() + ".xls");
        if (this.XLSPanel.isAutomaticExportToXLSSelected()) {
            if (!dirResult.exists()) {
                dirResult.mkdir();
            }
            this.saveToXLS(XLSFile, gdt, this.XLSPanel.isAutomaticExportToXLSAppendSelected());
        }
        if (this.XLSPanel.isSpecificExportFileToXLSSelected() && (xlsAppendFile = this.XLSPanel.getSelectedSpecificFile()) != null) {
            if (!dirResult.exists()) {
                dirResult.mkdir();
            }
            this.saveToXLS(xlsAppendFile, gdt, true);
        }
        if (this.exportSwimmingPoolCheckBox.isSelected()) {
            try {
                DetectionResult detectionResultConverted = this.convertDetectionToDetectionResult(gdt.detectionResult, gdt.inputSequence);
                SwimmingObject swimmingObject = new SwimmingObject((Object)detectionResultConverted, "detections of " + gdt.inputSequence.getName());
                Icy.getMainInterface().getSwimmingPool().add(swimmingObject);
            }
            catch (Exception e) {
                System.out.println("Error while creating detection object for swimming pool: is the plugin nchenouard.tracker installed ?");
            }
        }
        if (this.removePreviousSpotROIcheckBox.isSelected()) {
            roiList = new ArrayList(gdt.inputSequence.getROIs());
            for (ROI rOI : roiList) {
                if (!rOI.getName().startsWith("spot #")) continue;
                gdt.inputSequence.removeROI(rOI);
            }
        }
        if (this.exportToROIcheckBox.isSelected()) {
            roiList = DetectionToROI.convertDetectionToROI(gdt.detectionResult);
            gdt.inputSequence.beginUpdate();
            try {
                for (ROI rOI : roiList) {
                    gdt.inputSequence.addROI(rOI);
                }
            }
            finally {
                gdt.inputSequence.endUpdate();
            }
        }
    }

    static int computeROISurface(ROI roi) {
        return (int)ROIInteriorDescriptor.computeInterior((ROI)roi);
    }

    private DetectionResult convertDetectionToDetectionResult(ArrayList<DetectionSpot> detections, Sequence sequence) {
        DetectionResult detectionResult = new DetectionResult();
        for (DetectionSpot detectionSpot : detections) {
            Spot spot = new Spot(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().y, detectionSpot.getMassCenter().z, detectionSpot.minIntensity, detectionSpot.maxIntensity, detectionSpot.meanIntensity, this.convertToChenouardPoint3D(detectionSpot.points));
            detectionResult.addDetection(detectionSpot.getT(), spot);
        }
        detectionResult.setSequence(sequence);
        return detectionResult;
    }

    private ArrayList<plugins.nchenouard.spot.Point3D> convertToChenouardPoint3D(ArrayList<Point3D> inputList) {
        ArrayList<plugins.nchenouard.spot.Point3D> returnList = new ArrayList<plugins.nchenouard.spot.Point3D>();
        for (Point3D inputPoint : inputList) {
            returnList.add(new plugins.nchenouard.spot.Point3D(inputPoint.x, inputPoint.y, inputPoint.z));
        }
        return returnList;
    }

    private WritableWorkbook loadWorkbook(File file) throws IOException, BiffException {
        if (!file.exists()) {
            return XLSUtil.createWorkbook((File)file);
        }
        WritableWorkbook result = Workbook.createWorkbook((File)file, (Workbook)Workbook.getWorkbook((File)file));
        return result;
    }

    void saveToXLS(File xlsFile, GlobalDetectionToken gdt, boolean appendToExistingFile) {
        WritableWorkbook workbook = null;
        try {
            workbook = appendToExistingFile ? this.loadWorkbook(xlsFile) : XLSUtil.createWorkbook((File)xlsFile);
        }
        catch (IOException e) {
            new FailedAnnounceFrame("Cannot write the XLS file ! Is it already open in another application ?");
            e.printStackTrace();
            return;
        }
        catch (BiffException e) {
            e.printStackTrace();
        }
        int row = 0;
        int indexPage = workbook.getSheetNames().length;
        WritableSheet page = XLSUtil.createNewPage((WritableWorkbook)workbook, (String)(indexPage + "-" + gdt.inputSequence.getName()));
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)0, (String)"Date of XLS page:");
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)1, (String)new Date().toString());
        row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Input");
        this.spotDetector.inputPanel.inputDetection.saveXLS(page, gdt);
        this.addXLSSeparator(page);
        row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Pre processor");
        this.spotDetector.preProcessPanel.preProcessorDetection.saveXLS(page, gdt);
        this.addXLSSeparator(page);
        row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Detector");
        this.spotDetector.detectorPanel.detectorDetection.saveXLS(page, gdt);
        this.addXLSSeparator(page);
        row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"Region of interest");
        this.spotDetector.roiPanel.roiDetection.saveXLS(page, gdt);
        this.addXLSSeparator(page);
        try {
            XLSUtil.saveAndClose((WritableWorkbook)workbook);
        }
        catch (WriteException e) {
            new FailedAnnounceFrame("Cannot write the XLS file ! Is it already open in another application ?");
            e.printStackTrace();
        }
        catch (IOException e) {
            new FailedAnnounceFrame("Cannot write the XLS file ! Is it already open in another application ?");
            e.printStackTrace();
        }
    }

    private void addXLSSeparator(WritableSheet page) {
        int row = page.getRows();
        XLSUtil.setCellString((WritableSheet)page, (int)0, (int)row, (String)"------------");
    }

    class XLSPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1237537075380067160L;
        JPanel detailPanel = new JPanel();
        JTextArea automaticLabel = new JTextArea("The XLS file will be saved in the 'save' folder of the original image. The file name will be 'originalfilename.xls'. If an XLS file already exists, it will be replaced.");
        JButton specifyFile = new JButton("no file selected");
        JTextArea appendLabel = new JTextArea("The XLS data will be appended to this file. If the file does not exist, it will be created. Each image will consist in one page in the XLS file. If it becomes slow consider using XML. Watch how to use it on the online documentation.");
        File XLSAppendfile = null;
        JCheckBox automaticAppendCheckBox = new JCheckBox("Append data to existing files.", false);
        JCheckBox enableAutomaticCheckBox = new JCheckBox("Enable Automatic", false);
        JCheckBox enableSpecificFileCheckBox = new JCheckBox("Enable Specific file", false);
        JCheckBox exportImageInExcelFileFor2D = new JCheckBox("Export Image (ROI and detections) in the XLS file (only for 2D images)", false);

        public XLSPanel() {
            this.setBorder(new TitledBorder("Excel output settings:"));
            this.setLayout(new BoxLayout(this, 3));
            new GuiUtil();
            JPanel automaticPanel = new JPanel();
            automaticPanel.setBorder(new TitledBorder("Automatic XLS file naming"));
            automaticPanel.setLayout(new BoxLayout(automaticPanel, 3));
            automaticPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.enableAutomaticCheckBox, Box.createHorizontalGlue()}));
            this.enableAutomaticCheckBox.addActionListener(this);
            this.automaticLabel.setLineWrap(true);
            this.automaticLabel.setWrapStyleWord(true);
            automaticPanel.add(this.automaticLabel);
            automaticPanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.automaticAppendCheckBox, Box.createHorizontalGlue()}));
            this.add(automaticPanel);
            JPanel specificFilePanel = new JPanel();
            specificFilePanel.setBorder(new TitledBorder("Append all data to a single file"));
            specificFilePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.enableSpecificFileCheckBox, Box.createHorizontalGlue()}));
            specificFilePanel.setLayout(new BoxLayout(specificFilePanel, 3));
            this.enableSpecificFileCheckBox.addActionListener(this);
            this.appendLabel.setLineWrap(true);
            this.appendLabel.setWrapStyleWord(true);
            specificFilePanel.add(this.appendLabel);
            specificFilePanel.add((Component)GuiUtil.createLineBoxPanel((Component[])new Component[]{this.specifyFile}), (Object)Box.createHorizontalGlue());
            this.specifyFile.addActionListener(this);
            this.add(specificFilePanel);
            this.refreshEnableStatePanel();
        }

        public boolean exportImageInXLSFor2D() {
            return this.exportImageInExcelFileFor2D.isSelected();
        }

        public boolean isSpecificExportFileToXLSSelected() {
            return this.enableSpecificFileCheckBox.isSelected();
        }

        public File getSelectedSpecificFile() {
            return this.XLSAppendfile;
        }

        public boolean isAutomaticExportToXLSSelected() {
            return this.enableAutomaticCheckBox.isSelected();
        }

        public boolean isAutomaticExportToXLSAppendSelected() {
            return this.automaticAppendCheckBox.isSelected();
        }

        void refreshEnableStatePanel() {
            this.automaticLabel.setEnabled(this.enableAutomaticCheckBox.isSelected());
            this.automaticAppendCheckBox.setEnabled(this.enableAutomaticCheckBox.isSelected());
            this.appendLabel.setEnabled(this.enableSpecificFileCheckBox.isSelected());
            this.specifyFile.setEnabled(this.enableSpecificFileCheckBox.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.refreshEnableStatePanel();
            if (e.getSource() == this.specifyFile) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogType(1);
                int returnValue = fileChooser.showDialog(null, "XLS Export");
                if (returnValue == 0) {
                    this.XLSAppendfile = fileChooser.getSelectedFile();
                    this.specifyFile.setText(this.XLSAppendfile.getAbsolutePath());
                }
            }
        }
    }

    class XMLPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = 1237537075380067160L;
        JPanel detailPanel = new JPanel();
        JButton specifyFile = new JButton("no file selected");
        JTextArea appendLabel = new JTextArea("The XML data will be appended to this file. If the file does not exist, it will be created.");
        File XMLAppendfile = null;
        JCheckBox enableXMLCheckBox = new JCheckBox("Enable XML export", false);

        public XMLPanel() {
            this.setBorder(new TitledBorder("XML output settings:"));
            this.setLayout(new BoxLayout(this, 3));
            JPanel specificFilePanel = new JPanel();
            specificFilePanel.add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.enableXMLCheckBox, Box.createHorizontalGlue()}));
            specificFilePanel.setLayout(new BoxLayout(specificFilePanel, 3));
            this.enableXMLCheckBox.addActionListener(this);
            this.appendLabel.setLineWrap(true);
            this.appendLabel.setWrapStyleWord(true);
            specificFilePanel.add(this.appendLabel);
            specificFilePanel.add((Component)GuiUtil.createLineBoxPanel((Component[])new Component[]{this.specifyFile}), (Object)Box.createHorizontalGlue());
            this.specifyFile.addActionListener(this);
            this.add(specificFilePanel);
            this.refreshEnableStatePanel();
        }

        public boolean isSpecificExportFileToXLSSelected() {
            return this.enableXMLCheckBox.isSelected();
        }

        public File getSelectedFile() {
            return this.XMLAppendfile;
        }

        public boolean isExportToXMLSelected() {
            return this.enableXMLCheckBox.isSelected();
        }

        void refreshEnableStatePanel() {
            this.appendLabel.setEnabled(this.enableXMLCheckBox.isSelected());
            this.specifyFile.setEnabled(this.enableXMLCheckBox.isSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.refreshEnableStatePanel();
            if (e.getSource() == this.specifyFile) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogType(1);
                int returnValue = fileChooser.showDialog(null, "XML Export");
                if (returnValue == 0) {
                    this.XMLAppendfile = fileChooser.getSelectedFile();
                    this.specifyFile.setText(this.XMLAppendfile.getAbsolutePath());
                    this.XMLAppendfile = new File(FileUtil.setExtension((String)this.XMLAppendfile.getAbsolutePath(), (String)".xml"));
                }
            }
        }
    }
}

