/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import mitiv.array.ArrayFactory;
import mitiv.array.Byte1D;
import mitiv.array.ByteArray;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.IntArray;
import mitiv.array.LongArray;
import mitiv.array.ShapedArray;
import mitiv.array.ShortArray;
import mitiv.utils.HistoMap;

public abstract class WeightFactory {
    public static ShapedArray defaultWeights(ShapedArray dat) {
        switch (dat.getType()) {
            case 4: {
                float[] wgt = new float[dat.getNumber()];
                WeightFactory.defaultWeights(wgt, ((FloatArray)dat).flatten(false));
                return ArrayFactory.wrap(wgt, dat.getShape());
            }
            case 5: {
                double[] wgt = new double[dat.getNumber()];
                WeightFactory.defaultWeights(wgt, ((DoubleArray)dat).flatten(false));
                return ArrayFactory.wrap(wgt, dat.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static void defaultWeights(float[] wgt, float[] dat) {
        WeightFactory.computeWeightsFromData(wgt, dat, 0.0f, 1.0f);
    }

    public static void defaultWeights(double[] wgt, double[] dat) {
        WeightFactory.computeWeightsFromData(wgt, dat, 0.0, 1.0);
    }

    public static ShapedArray computeWeightsFromVariance(ShapedArray var) {
        switch (var.getType()) {
            case 4: {
                float[] wgt = new float[var.getNumber()];
                WeightFactory.computeWeightsFromVariance(wgt, ((FloatArray)var).flatten(false));
                return ArrayFactory.wrap(wgt, var.getShape());
            }
            case 5: {
                double[] wgt = new double[var.getNumber()];
                WeightFactory.computeWeightsFromVariance(wgt, ((DoubleArray)var).flatten(false));
                return ArrayFactory.wrap(wgt, var.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static void computeWeightsFromVariance(float[] wgt, float[] var) {
        if (wgt.length != var.length) {
            throw new IllegalArgumentException("Weighting and variance arrays must have the same length");
        }
        float zero = 0.0f;
        float one = 1.0f;
        for (int i = 0; i < wgt.length; ++i) {
            if (WeightFactory.isnan(var[i]) || var[i] <= 0.0f) {
                throw new IllegalArgumentException("Invalid variance value(s)");
            }
            wgt[i] = WeightFactory.isinf(var[i]) ? 0.0f : 1.0f / var[i];
        }
    }

    public static void computeWeightsFromVariance(double[] wgt, double[] var) {
        if (wgt.length != var.length) {
            throw new IllegalArgumentException("Weighting and variance arrays must have the same length");
        }
        double zero = 0.0;
        double one = 1.0;
        for (int i = 0; i < wgt.length; ++i) {
            if (WeightFactory.isnan(var[i]) || var[i] <= 0.0) {
                throw new IllegalArgumentException("Invalid variance value(s)");
            }
            wgt[i] = WeightFactory.isinf(var[i]) ? 0.0 : 1.0 / var[i];
        }
    }

    public static ShapedArray computeWeightsFromData(ShapedArray dat, double alpha, double beta, double bad) {
        switch (dat.getType()) {
            case 4: {
                float[] wgt = new float[dat.getNumber()];
                WeightFactory.computeWeightsFromData(wgt, ((FloatArray)dat).flatten(false), (float)alpha, (float)beta, (float)bad);
                return ArrayFactory.wrap(wgt, dat.getShape());
            }
            case 5: {
                double[] wgt = new double[dat.getNumber()];
                WeightFactory.computeWeightsFromData(wgt, ((DoubleArray)dat).flatten(false), alpha, beta, bad);
                return ArrayFactory.wrap(wgt, dat.getShape());
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    public static ShapedArray computeWeightsFromData(ShapedArray dat, double alpha, double beta) {
        return WeightFactory.computeWeightsFromData(dat, alpha, beta, Double.NaN);
    }

    public static int computeWeightsFromData(float[] wgt, float[] dat, float alpha, float beta, float bad) {
        float zero = 0.0f;
        float one = 1.0f;
        int count = 0;
        if (WeightFactory.isnan(alpha) || WeightFactory.isinf(alpha) || alpha < 0.0f) {
            throw new IllegalArgumentException("Parameter ALPHA must be finite and nonnegative");
        }
        if (WeightFactory.isnan(beta) || WeightFactory.isinf(beta) || beta <= 0.0f) {
            throw new IllegalArgumentException("Parameter BETA must be finite and strictly positive");
        }
        if (wgt.length != dat.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        float wmax = 1.0f / beta;
        int len = dat.length;
        if (WeightFactory.isnan(bad) || WeightFactory.isinf(bad)) {
            if (alpha > 0.0f) {
                for (int i = 0; i < len; ++i) {
                    if (WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                        wgt[i] = 0.0f;
                        continue;
                    }
                    if (dat[i] > 0.0f) {
                        wgt[i] = 1.0f / (alpha * dat[i] + beta);
                        ++count;
                        continue;
                    }
                    wgt[i] = wmax;
                    ++count;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    if (WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                        wgt[i] = 0.0f;
                        continue;
                    }
                    wgt[i] = wmax;
                    ++count;
                }
            }
        } else if (alpha > 0.0f) {
            for (int i = 0; i < len; ++i) {
                if (dat[i] == bad || WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                    wgt[i] = 0.0f;
                    continue;
                }
                if (dat[i] > 0.0f) {
                    wgt[i] = 1.0f / (alpha * dat[i] + beta);
                    ++count;
                    continue;
                }
                wgt[i] = wmax;
                ++count;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (dat[i] == bad || WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                    wgt[i] = 0.0f;
                    continue;
                }
                if (!(wgt[i] > 0.0f)) continue;
                wgt[i] = wmax;
                ++count;
            }
        }
        return count;
    }

    public static int computeWeightsFromData(float[] wgt, float[] dat, float alpha, float beta) {
        return WeightFactory.computeWeightsFromData(wgt, dat, alpha, beta, Float.NaN);
    }

    public static int computeWeightsFromData(double[] wgt, double[] dat, double alpha, double beta, double bad) {
        double zero = 0.0;
        double one = 1.0;
        int count = 0;
        if (WeightFactory.isnan(alpha) || WeightFactory.isinf(alpha) || alpha < 0.0) {
            throw new IllegalArgumentException("Parameter ALPHA must be finite and nonnegative");
        }
        if (WeightFactory.isnan(beta) || WeightFactory.isinf(beta) || beta <= 0.0) {
            throw new IllegalArgumentException("Parameter BETA must be finite and strictly positive");
        }
        if (wgt.length != dat.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        double wmax = 1.0 / beta;
        int len = dat.length;
        if (WeightFactory.isnan(bad) || WeightFactory.isinf(bad)) {
            if (alpha > 0.0) {
                for (int i = 0; i < len; ++i) {
                    if (WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                        wgt[i] = 0.0;
                        continue;
                    }
                    if (dat[i] > 0.0) {
                        wgt[i] = 1.0 / (alpha * dat[i] + beta);
                        ++count;
                        continue;
                    }
                    wgt[i] = wmax;
                    ++count;
                }
            } else {
                for (int i = 0; i < len; ++i) {
                    if (WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                        wgt[i] = 0.0;
                        continue;
                    }
                    wgt[i] = wmax;
                    ++count;
                }
            }
        } else if (alpha > 0.0) {
            for (int i = 0; i < len; ++i) {
                if (dat[i] == bad || WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                    wgt[i] = 0.0;
                    continue;
                }
                if (dat[i] > 0.0) {
                    wgt[i] = 1.0 / (alpha * dat[i] + beta);
                    ++count;
                    continue;
                }
                wgt[i] = wmax;
                ++count;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (dat[i] == bad || WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                    wgt[i] = 0.0;
                    continue;
                }
                if (!(wgt[i] > 0.0)) continue;
                wgt[i] = wmax;
                ++count;
            }
        }
        return count;
    }

    public static int computeWeightsFromData(double[] wgt, double[] dat, double alpha, double beta) {
        return WeightFactory.computeWeightsFromData(wgt, dat, alpha, beta, Double.NaN);
    }

    public static boolean flagBads(ShapedArray dat, ByteArray badArray, double sat) {
        switch (dat.getType()) {
            case 4: {
                return WeightFactory.flagBads(((FloatArray)dat).flatten(false), badArray, sat);
            }
            case 5: {
                return WeightFactory.flagBads(((DoubleArray)dat).flatten(false), badArray, sat);
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    private static boolean flagBads(float[] dat, ByteArray badArray, double sat) {
        if (dat.length != badArray.getNumber()) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same length");
        }
        boolean isbad = false;
        boolean one = true;
        int len = dat.length;
        for (int i = 0; i < len; ++i) {
            float val;
            if (((Byte1D)badArray.as1D()).get(i) != 0 || !WeightFactory.isnan(val = dat[i]) && !WeightFactory.isinf(val) && !((double)val >= sat)) continue;
            ((Byte1D)badArray.as1D()).set(i, (byte)1);
            isbad = true;
        }
        return isbad;
    }

    private static boolean flagBads(double[] dat, ByteArray badArray, double sat) {
        if (dat.length != badArray.getNumber()) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same length");
        }
        boolean isbad = false;
        boolean one = true;
        int len = dat.length;
        for (int i = 0; i < len; ++i) {
            double val;
            if (((Byte1D)badArray.as1D()).get(i) != 0 || !WeightFactory.isnan(val = dat[i]) && !WeightFactory.isinf(val) && !(val >= sat)) continue;
            ((Byte1D)badArray.as1D()).set(i, (byte)1);
            isbad = true;
        }
        return isbad;
    }

    public static void removeBads(ShapedArray wgt, ShapedArray bad) {
        boolean[] b;
        if (!wgt.getShape().equals(bad.getShape())) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same shape");
        }
        if (!wgt.isFlat()) {
            throw new IllegalArgumentException("Weights must be a flat array");
        }
        switch (bad.getType()) {
            case 0: {
                b = WeightFactory.toBoolean(((ByteArray)bad).flatten(false));
                break;
            }
            case 1: {
                b = WeightFactory.toBoolean(((ShortArray)bad).flatten(false));
                break;
            }
            case 2: {
                b = WeightFactory.toBoolean(((IntArray)bad).flatten(false));
                break;
            }
            case 3: {
                b = WeightFactory.toBoolean(((LongArray)bad).flatten(false));
                break;
            }
            case 4: {
                b = WeightFactory.toBoolean(((FloatArray)bad).flatten(false));
                break;
            }
            case 5: {
                b = WeightFactory.toBoolean(((DoubleArray)bad).flatten(false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
        switch (wgt.getType()) {
            case 4: {
                WeightFactory.removeBads(((FloatArray)wgt).flatten(false), b);
                break;
            }
            case 5: {
                WeightFactory.removeBads(((DoubleArray)wgt).flatten(false), b);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static final void removeBads(float[] wgt, boolean[] bad) {
        if (wgt.length != bad.length) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same length");
        }
        float zero = 0.0f;
        int len = wgt.length;
        for (int i = 0; i < len; ++i) {
            if (!bad[i]) continue;
            wgt[i] = 0.0f;
        }
    }

    public static final void removeBads(double[] wgt, boolean[] bad) {
        if (wgt.length != bad.length) {
            throw new IllegalArgumentException("Array of weights and bad data must have the same length");
        }
        double zero = 0.0;
        int len = wgt.length;
        for (int i = 0; i < len; ++i) {
            if (!bad[i]) continue;
            wgt[i] = 0.0;
        }
    }

    public static void checkWeights(ShapedArray wgt) {
        switch (wgt.getType()) {
            case 4: {
                WeightFactory.checkWeights(((FloatArray)wgt).flatten(false));
                break;
            }
            case 5: {
                WeightFactory.checkWeights(((DoubleArray)wgt).flatten(false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static void checkWeights(float[] wgt) {
        float zero = 0.0f;
        int len = wgt.length;
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            if (WeightFactory.isinf(wgt[i]) || WeightFactory.isnan(wgt[i]) || wgt[i] < 0.0f) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (!(wgt[i] > 0.0f)) continue;
            ++cnt;
        }
        if (cnt < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    public static void checkWeights(double[] wgt) {
        double zero = 0.0;
        int len = wgt.length;
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            if (WeightFactory.isinf(wgt[i]) || WeightFactory.isnan(wgt[i]) || wgt[i] < 0.0) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (!(wgt[i] > 0.0)) continue;
            ++cnt;
        }
        if (cnt < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    public static void fixWeightsAndData(ShapedArray wgt, ShapedArray dat) {
        if (!wgt.getShape().equals(dat.getShape())) {
            throw new IllegalArgumentException("Array of weights and data must have the same shape");
        }
        if (!wgt.isFlat()) {
            throw new IllegalArgumentException("Weights must be a flat array");
        }
        if (!dat.isFlat()) {
            throw new IllegalArgumentException("Data must be a flat array");
        }
        if (wgt.getType() != dat.getType()) {
            throw new IllegalArgumentException("Data and weights have the same element type");
        }
        switch (dat.getType()) {
            case 4: {
                WeightFactory.fixWeightsAndData(((FloatArray)wgt).flatten(false), ((FloatArray)dat).flatten(false));
                break;
            }
            case 5: {
                WeightFactory.fixWeightsAndData(((DoubleArray)wgt).flatten(false), ((DoubleArray)dat).flatten(false));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static void fixWeightsAndData(float[] wgt, float[] dat) {
        if (wgt.length != dat.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        float zero = 0.0f;
        int len = wgt.length;
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            if (wgt[i] == 0.0f) {
                dat[i] = 0.0f;
                continue;
            }
            if (WeightFactory.isinf(wgt[i]) || WeightFactory.isnan(wgt[i]) || wgt[i] < 0.0f) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                wgt[i] = 0.0f;
                dat[i] = 0.0f;
                continue;
            }
            ++cnt;
        }
        if (cnt < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    public static void fixWeightsAndData(double[] wgt, double[] dat) {
        if (wgt.length != dat.length) {
            throw new IllegalArgumentException("Weighting and data arrays must have the same length");
        }
        double zero = 0.0;
        int len = wgt.length;
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            if (wgt[i] == 0.0) {
                dat[i] = 0.0;
                continue;
            }
            if (WeightFactory.isinf(wgt[i]) || WeightFactory.isnan(wgt[i]) || wgt[i] < 0.0) {
                throw new IllegalArgumentException("Invalid weight value");
            }
            if (WeightFactory.isinf(dat[i]) || WeightFactory.isnan(dat[i])) {
                wgt[i] = 0.0;
                dat[i] = 0.0;
                continue;
            }
            ++cnt;
        }
        if (cnt < 1) {
            throw new IllegalArgumentException("No valid data!");
        }
    }

    private static final boolean isinf(float val) {
        return Float.isInfinite(val);
    }

    private static final boolean isnan(float val) {
        return Float.isNaN(val);
    }

    private static final boolean isinf(double val) {
        return Double.isInfinite(val);
    }

    private static final boolean isnan(double val) {
        return Double.isNaN(val);
    }

    private static final boolean[] toBoolean(byte[] arr) {
        boolean zero = false;
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i] != 0;
        }
        return res;
    }

    private static final boolean[] toBoolean(short[] arr) {
        boolean zero = false;
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i] != 0;
        }
        return res;
    }

    private static final boolean[] toBoolean(int[] arr) {
        boolean zero = false;
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i] != 0;
        }
        return res;
    }

    private static final boolean[] toBoolean(long[] arr) {
        long zero = 0L;
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i] != 0L;
        }
        return res;
    }

    private static final boolean[] toBoolean(float[] arr) {
        float zero = 0.0f;
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i] != 0.0f;
        }
        return res;
    }

    private static final boolean[] toBoolean(double[] arr) {
        double zero = 0.0;
        boolean[] res = new boolean[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            res[i] = arr[i] != 0.0;
        }
        return res;
    }

    public static void normalize(ShapedArray wgtArray) {
        switch (wgtArray.getType()) {
            case 4: {
                ((FloatArray)wgtArray).scale((float)wgtArray.getNumber() / wgtArray.toFloat().sum());
                break;
            }
            case 5: {
                ((DoubleArray)wgtArray).scale((double)wgtArray.getNumber() / wgtArray.toDouble().sum());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type");
            }
        }
    }

    public static ShapedArray computeWeightsFromModel(ShapedArray dataArray, ShapedArray modelArray, ByteArray badpixArray) {
        HistoMap hm = new HistoMap(modelArray, dataArray, badpixArray);
        return hm.computeWeightMap(modelArray);
    }
}

