/*
 * Decompiled with CFR 0.152.
 */
package mitiv.linalg;

import mitiv.base.mapping.DifferentiableMapping;
import mitiv.exception.IllegalLinearOperationException;
import mitiv.exception.IncorrectSpaceException;
import mitiv.exception.NotImplementedException;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;

public abstract class LinearOperator
extends DifferentiableMapping {
    public static int DIRECT = 0;
    public static int ADJOINT = 1;
    public static int INVERSE = 2;
    public static int INVERSE_ADJOINT = ADJOINT | INVERSE;
    public static int ADJOINT_INVERSE = ADJOINT | INVERSE;

    public LinearOperator(VectorSpace vsp) {
        super(vsp);
    }

    protected LinearOperator(VectorSpace inp, VectorSpace out) {
        super(inp, out);
    }

    public void apply(Vector dst, Vector src, int job) throws IncorrectSpaceException, IllegalLinearOperationException, NotImplementedException {
        if (job == DIRECT || job == (INVERSE | ADJOINT)) {
            if (!this.outputSpace.owns(dst)) {
                throw new IncorrectSpaceException("Destination does not belong to the output space");
            }
            if (!this.inputSpace.owns(src)) {
                throw new IncorrectSpaceException("Source does not belong to the input space");
            }
        } else if (job == ADJOINT || job == INVERSE) {
            if (!this.inputSpace.owns(dst)) {
                throw new IncorrectSpaceException("Destination does not belong to the input space");
            }
            if (!this.outputSpace.owns(src)) {
                throw new IncorrectSpaceException("Source does not belong to the output space");
            }
        } else {
            throw new IllegalLinearOperationException();
        }
        this._apply(dst, src, job);
    }

    protected abstract void _apply(Vector var1, Vector var2, int var3) throws NotImplementedException;

    @Override
    protected void _apply(Vector dst, Vector src) {
        this._apply(dst, src, DIRECT);
    }

    @Override
    protected void _applyJacobian(Vector y, Vector x, Vector v) {
        this._apply(y, v, ADJOINT);
    }

    public static void checkLinearProblem(LinearOperator A, Vector b, Vector x, boolean endomorphism) throws IncorrectSpaceException {
        if (!x.belongsTo(A.getInputSpace()) || !b.belongsTo(A.getOutputSpace())) {
            throw new IncorrectSpaceException();
        }
        if (endomorphism && A.getInputSpace() != A.getOutputSpace()) {
            throw new IllegalArgumentException("LHS linear operator is not an endomorphism");
        }
    }

    public double checkAdjoint(Vector x, Vector y) {
        Vector Ax = this.outputSpace.create();
        this.apply(Ax, x);
        Vector Aty = this.inputSpace.create();
        this.apply(Aty, y, ADJOINT);
        double a = y.dot(Ax);
        double b = x.dot(Aty);
        if (a == b) {
            return 0.0;
        }
        return Math.abs(a - b) / Math.max(Math.abs(a), Math.abs(b));
    }
}

