/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.io.Serializable;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.Utilities;

public abstract class LargeArray
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7921589398878016801L;
    protected LargeArrayType type;
    protected long length;
    protected long sizeof;
    protected long ptr = 0L;
    protected static int LARGEST_32BIT_INDEX = 0x40000000;

    public long length() {
        return this.length;
    }

    public LargeArrayType getType() {
        return this.type;
    }

    public abstract Object get(long var1);

    public Object get_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.get(l);
    }

    public abstract Object getFromNative(long var1);

    public abstract boolean getBoolean(long var1);

    public boolean getBoolean_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getBoolean(l);
    }

    public abstract byte getByte(long var1);

    public byte getByte_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getByte(l);
    }

    public abstract short getShort(long var1);

    public short getShort_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getShort(l);
    }

    public abstract int getInt(long var1);

    public int getInt_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getInt(l);
    }

    public abstract long getLong(long var1);

    public long getLong_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getLong(l);
    }

    public abstract float getFloat(long var1);

    public float getFloat_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getFloat(l);
    }

    public abstract double getDouble(long var1);

    public double getDouble_safe(long l) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        return this.getDouble(l);
    }

    public abstract Object getData();

    public abstract boolean[] getBooleanData();

    public abstract boolean[] getBooleanData(boolean[] var1, long var2, long var4, long var6);

    public abstract byte[] getByteData();

    public abstract byte[] getByteData(byte[] var1, long var2, long var4, long var6);

    public abstract short[] getShortData();

    public abstract short[] getShortData(short[] var1, long var2, long var4, long var6);

    public abstract int[] getIntData();

    public abstract int[] getIntData(int[] var1, long var2, long var4, long var6);

    public abstract long[] getLongData();

    public abstract long[] getLongData(long[] var1, long var2, long var4, long var6);

    public abstract float[] getFloatData();

    public abstract float[] getFloatData(float[] var1, long var2, long var4, long var6);

    public abstract double[] getDoubleData();

    public abstract double[] getDoubleData(double[] var1, long var2, long var4, long var6);

    public void set(long l, Object object) {
        if (object instanceof Boolean) {
            this.setBoolean(l, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(l, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort(l, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(l, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(l, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat(l, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble(l, (Double)object);
        } else if (object instanceof Double) {
            throw new IllegalArgumentException("Unsupported type.");
        }
    }

    public abstract void setToNative(long var1, Object var3);

    public void set_safe(long l, Object object) {
        if (object instanceof Boolean) {
            this.setBoolean_safe(l, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte_safe(l, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort_safe(l, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt_safe(l, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong_safe(l, (Long)object);
        } else if (object instanceof Float) {
            this.setFloat_safe(l, ((Float)object).floatValue());
        } else if (object instanceof Double) {
            this.setDouble_safe(l, (Double)object);
        } else if (object instanceof Double) {
            throw new IllegalArgumentException("Unsupported type.");
        }
    }

    public abstract void setBoolean(long var1, boolean var3);

    public void setBoolean_safe(long l, boolean bl) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setBoolean(l, bl);
    }

    public abstract void setByte(long var1, byte var3);

    public void setByte_safe(long l, byte by) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setByte(l, by);
    }

    public abstract void setShort(long var1, short var3);

    public void setShort_safe(long l, short s) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setShort(l, s);
    }

    public abstract void setInt(long var1, int var3);

    public void setInt_safe(long l, int n) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setInt(l, n);
    }

    public abstract void setLong(long var1, long var3);

    public void setLong_safe(long l, long l2) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setLong(l, l2);
    }

    public abstract void setFloat(long var1, float var3);

    public void setFloat_safe(long l, float f) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setFloat(l, f);
    }

    public abstract void setDouble(long var1, double var3);

    public void setDouble_safe(long l, double d) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException(Long.toString(l));
        }
        this.setDouble(l, d);
    }

    public boolean isLarge() {
        return this.ptr != 0L;
    }

    public static void setMaxSizeOf32bitArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index cannot be negative");
        }
        LARGEST_32BIT_INDEX = n;
    }

    public static int getMaxSizeOf32bitArray() {
        return LARGEST_32BIT_INDEX;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    protected void zeroNativeMemory(long l) {
        if (this.ptr != 0L) {
            int n = Runtime.getRuntime().availableProcessors();
            if (n <= 2 || l < 100000L) {
                Utilities.UNSAFE.setMemory(this.ptr, l * this.sizeof, (byte)0);
            } else {
                int n2;
                long l2 = l / (long)n;
                Thread[] threadArray = new Thread[n];
                final long l3 = this.ptr;
                for (n2 = 0; n2 < n; ++n2) {
                    final long l4 = (long)n2 * l2;
                    final long l5 = n2 == n - 1 ? l : l4 + l2;
                    threadArray[n2] = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = l4; i < l5; ++i) {
                                Utilities.UNSAFE.putByte(l3 + LargeArray.this.sizeof * i, (byte)0);
                            }
                        }
                    });
                    threadArray[n2].start();
                }
                try {
                    for (n2 = 0; n2 < n; ++n2) {
                        threadArray[n2].join();
                        threadArray[n2] = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Utilities.UNSAFE.setMemory(this.ptr, l * this.sizeof, (byte)0);
                }
            }
        }
    }

    protected static class Deallocator
    implements Runnable {
        private long ptr;
        private final long length;
        private final long sizeof;

        public Deallocator(long l, long l2, long l3) {
            this.ptr = l;
            this.length = l2;
            this.sizeof = l3;
        }

        @Override
        public void run() {
            if (this.ptr != 0L) {
                Utilities.UNSAFE.freeMemory(this.ptr);
                this.ptr = 0L;
                MemoryCounter.decreaseCounter(this.length * this.sizeof);
            }
        }
    }
}

