/*
 * Decompiled with CFR 0.152.
 */
package mitiv.conv;

import mitiv.array.ArrayUtils;
import mitiv.array.FloatArray;
import mitiv.array.ShapedArray;
import mitiv.base.Shape;
import mitiv.conv.Convolution;
import mitiv.exception.IncorrectSpaceException;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.FloatShapedVectorSpace;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.linalg.shaped.ShapedVectorSpace;

abstract class ConvolutionFloat
extends Convolution {
    private float[] wrk = null;
    private float[] mtf = null;

    protected ConvolutionFloat(Shape wrk, ShapedVectorSpace inp, int[] inpOff, ShapedVectorSpace out, int[] outOff) {
        super(wrk, inp, inpOff, out, outOff);
        if (this.getType() != 4) {
            throw new IllegalArgumentException("Input and output vector spaces must be for float data type");
        }
    }

    public float[] getWorkArray() {
        if (this.wrk == null) {
            this.wrk = new float[2 * this.getNumberOfFrequencies()];
        }
        return this.wrk;
    }

    @Override
    public void push(ShapedVector src, boolean adjoint) {
        if (adjoint) {
            if (!src.belongsTo(this.outputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to output space");
            }
        } else if (!src.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to input space");
        }
        this.push(this.getWorkArray(), ((FloatShapedVector)src).getData(), adjoint);
    }

    @Override
    public void pull(ShapedVector dst, boolean adjoint) {
        if (adjoint) {
            if (!dst.belongsTo(this.inputSpace)) {
                throw new IncorrectSpaceException("Vector does not belong to input space");
            }
        } else if (!dst.belongsTo(this.outputSpace)) {
            throw new IncorrectSpaceException("Vector does not belong to output space");
        }
        this.pull(((FloatShapedVector)dst).getData(), this.getWorkArray(), adjoint);
    }

    public abstract void push(float[] var1, float[] var2, boolean var3);

    public abstract void pull(float[] var1, float[] var2, boolean var3);

    public abstract void forwardFFT(float[] var1);

    @Override
    public void forwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    public abstract void backwardFFT(float[] var1);

    @Override
    public void backwardFFT() {
        this.forwardFFT(this.getWorkArray());
    }

    @Override
    public void convolve(boolean conj) {
        if (this.mtf == null) {
            throw new IllegalArgumentException("You must set the PSF or the MTF first");
        }
        float[] h = this.mtf;
        float[] z = this.getWorkArray();
        int n = this.getNumberOfFrequencies();
        this.forwardFFT();
        if (conj) {
            for (int k = 0; k < n; ++k) {
                int real = k + k;
                int imag = real + 1;
                float h_re = h[real];
                float h_im = h[imag];
                float z_re = z[real];
                float z_im = z[imag];
                z[real] = h_re * z_re + h_im * z_im;
                z[imag] = h_re * z_im - h_im * z_re;
            }
        } else {
            for (int k = 0; k < n; ++k) {
                int real = k + k;
                int imag = real + 1;
                float h_re = h[real];
                float h_im = h[imag];
                float z_re = z[real];
                float z_im = z[imag];
                z[real] = h_re * z_re - h_im * z_im;
                z[imag] = h_re * z_im + h_im * z_re;
            }
        }
        this.backwardFFT(z);
    }

    @Override
    public void setPSF(ShapedVector psf) {
        if (!psf.belongsTo(this.inputSpace)) {
            throw new IncorrectSpaceException("PSF does not belong to the correct space");
        }
        this.computeMTF(((FloatShapedVector)psf).getData());
    }

    @Override
    public void setPSF(ShapedArray psf, int[] off, boolean normalize) {
        float sum;
        boolean writable = false;
        if (psf.getType() != 4) {
            psf = psf.toFloat();
            writable = true;
        }
        if (normalize && (sum = (float)ArrayUtils.sum(psf)) != 1.0f) {
            if (!writable) {
                psf = psf.copy();
            }
            ((FloatArray)psf).scale(1.0f / sum);
        }
        psf = this.adjustPSF(psf, off);
        this.computeMTF(((FloatArray)psf).flatten());
    }

    private final void computeMTF(float[] psf) {
        float zero = 0.0f;
        int n = this.getNumberOfFrequencies();
        float scale = 1.0f / (float)n;
        if (this.mtf == null) {
            this.mtf = new float[2 * n];
        }
        for (int k = 0; k < n; ++k) {
            int real = k + k;
            int imag = real + 1;
            this.mtf[real] = psf[k] * scale;
            this.mtf[imag] = 0.0f;
        }
        this.forwardFFT(this.mtf);
    }

    @Override
    public FloatShapedVectorSpace getInputSpace() {
        return (FloatShapedVectorSpace)this.inputSpace;
    }

    @Override
    public FloatShapedVectorSpace getOutputSpace() {
        return (FloatShapedVectorSpace)this.outputSpace;
    }
}

