/*
 * Decompiled with CFR 0.152.
 */
package icy.canvas;

import icy.canvas.IcyCanvas;
import icy.gui.viewer.Viewer;
import icy.sequence.DimensionId;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;
import java.awt.Point;

public abstract class IcyCanvas3D
extends IcyCanvas {
    private static final long serialVersionUID = 6001100311244609559L;
    protected Point3D.Double mouseImagePos;

    public IcyCanvas3D(Viewer viewer) {
        super(viewer);
        this.posX = -1;
        this.posY = -1;
        this.posZ = -1;
        this.posT = 0;
        this.mouseImagePos = new Point3D.Double();
    }

    @Override
    public void setPositionT(int t) {
        if (t != -1) {
            super.setPositionT(t);
        }
    }

    @Override
    public double getMouseImagePosX() {
        if (this.mouseImagePos == null) {
            return 0.0;
        }
        return this.mouseImagePos.x;
    }

    @Override
    public double getMouseImagePosY() {
        if (this.mouseImagePos == null) {
            return 0.0;
        }
        return this.mouseImagePos.y;
    }

    @Override
    public double getMouseImagePosZ() {
        if (this.mouseImagePos == null) {
            return 0.0;
        }
        return this.mouseImagePos.z;
    }

    public Point3D.Double getMouseImagePos() {
        return (Point3D.Double)this.mouseImagePos.clone();
    }

    public void setMouseImagePos(double x, double y, double z) {
        if (this.mouseImagePos.x != x || this.mouseImagePos.y != y || this.mouseImagePos.z != z) {
            this.mouseImagePos.x = x;
            this.mouseImagePos.y = y;
            this.mouseImagePos.z = z;
            this.mousePos = this.imageToCanvas(this.mouseImagePos);
            this.mouseImagePositionChanged(DimensionId.NULL);
        }
    }

    public void setMouseImagePos(Point3D.Double point) {
        this.setMouseImagePos(point.x, point.y, point.z);
    }

    @Override
    public boolean setMousePos(int x, int y) {
        boolean result = super.setMousePos(x, y);
        if (result) {
            if (this.mouseImagePos == null) {
                this.mouseImagePos = new Point3D.Double();
            }
            Point3D.Double newPos = this.canvasToImage(this.mousePos);
            double newX = ((Point3D)newPos).getX();
            double newY = ((Point3D)newPos).getY();
            double newZ = ((Point3D)newPos).getZ();
            boolean changed = false;
            if (!Double.isNaN(newX) && newX != this.mouseImagePos.x) {
                this.mouseImagePos.x = newX;
                changed = true;
            }
            if (!Double.isNaN(newY) && newY != this.mouseImagePos.y) {
                this.mouseImagePos.y = newY;
                changed = true;
            }
            if (!Double.isNaN(newZ) && newZ != this.mouseImagePos.z) {
                this.mouseImagePos.z = newZ;
                changed = true;
            }
            if (changed) {
                this.mouseImagePositionChanged(DimensionId.NULL);
            }
        }
        return result;
    }

    public Point imageToCanvas(double x, double y, double z) {
        return new Point(0, 0);
    }

    public Point imageToCanvas(Point3D.Double point) {
        return this.imageToCanvas(point.x, point.y, point.z);
    }

    public Point3D.Double canvasToImage(int x, int y) {
        return new Point3D.Double(0.0, 0.0, 0.0);
    }

    public Point3D.Double canvasToImage(Point point) {
        return this.canvasToImage(point.x, point.y);
    }

    public void centerOn(Rectangle3D.Integer region) {
    }
}

