/*
 * Decompiled with CFR 0.152.
 */
package mitiv.random;

import mitiv.random.PressTeukolskyGenerator;

public abstract class RandomEngine {
    protected RandomEngine() {
    }

    public static RandomEngine NewDefaultEngine() {
        return new PressTeukolskyGenerator();
    }

    public static RandomEngine NewDefaultEngine(int seed) {
        return new PressTeukolskyGenerator(seed);
    }

    public abstract void reset(int var1);

    public abstract int next();

    public float nextFloat() {
        return (float)this.nextDouble();
    }

    public abstract double nextDouble();

    public abstract int min();

    public abstract int max();

    protected static final double standardBias(double minValue, double maxValue) {
        return (minValue - 0.5) / (maxValue - minValue + 1.0);
    }

    protected static final double standardScale(double minValue, double maxValue) {
        return 1.0 / (maxValue - minValue + 1.0);
    }
}

