/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.plugin;

import icy.gui.component.button.IcyCommandButton;
import icy.gui.component.button.IcyCommandToggleButton;
import icy.gui.plugin.PluginRichToolTip;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class PluginCommandButton {
    public static void setButton(final AbstractCommandButton button, final PluginDescriptor plugin, boolean doAction, boolean alpha) {
        ActionListener[] listeners;
        String name = plugin.getName();
        String className = plugin.getClassName();
        button.setText(name);
        button.setIcon((ResizableIcon)new IcyIcon(plugin.getIconAsImage(), alpha));
        button.setName(className);
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                button.setActionRichTooltip((RichTooltip)new PluginRichToolTip(plugin));
            }
        });
        for (ActionListener listener : listeners = (ActionListener[])button.getListeners(ActionListener.class)) {
            button.removeActionListener(listener);
        }
        if (doAction) {
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractCommandButton button = (AbstractCommandButton)e.getSource();
                    PluginDescriptor plugin = PluginLoader.getPlugin(button.getName());
                    if (plugin != null) {
                        PluginLauncher.start(plugin);
                    }
                }
            });
        }
    }

    public static void setButton(AbstractCommandButton button, PluginDescriptor plugin) {
        PluginCommandButton.setButton(button, plugin, true, false);
    }

    public static AbstractCommandButton createButton(PluginDescriptor plugin, boolean toggle, boolean doAction, boolean alpha) {
        Object result = toggle ? new IcyCommandToggleButton() : new IcyCommandButton();
        PluginCommandButton.setButton((AbstractCommandButton)result, plugin, doAction, alpha);
        return result;
    }

    public static IcyCommandButton createButton(PluginDescriptor plugin) {
        return (IcyCommandButton)PluginCommandButton.createButton(plugin, false, true, false);
    }

    public static IcyCommandToggleButton createToggleButton(PluginDescriptor plugin, boolean doAction, boolean alpha) {
        return (IcyCommandToggleButton)PluginCommandButton.createButton(plugin, true, doAction, alpha);
    }
}

