/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.util.VarException;
import plugins.adufour.vars.util.VarListener;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.ylemontag.mathoperations.Expression;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.MathOperationAbstractBlock;
import plugins.ylemontag.mathoperations.MathOperationPlugin;
import plugins.ylemontag.mathoperations.VarExpression;
import plugins.ylemontag.mathoperations.Variant;

public class MathOperationExpressionBlock
extends MathOperationAbstractBlock {
    private VarExpression _expression = new VarExpression("", null);
    private String[] _names;

    public MathOperationExpressionBlock() {
        super("result");
        this._expression.setReferencingPolicy(VarReferencingPolicy.NONE);
    }

    public void declareInput(final VarList inputMap) {
        this._expression.addListener((VarListener)new VarListener<Expression>(){

            public void valueChanged(Var<Expression> source, Expression oldValue, Expression newValue) {
                MathOperationExpressionBlock.access$002(MathOperationExpressionBlock.this, newValue == null ? null : newValue.getVariablesAsArray());
                MathOperationExpressionBlock.this.defineRuntimeInputVariants(inputMap, MathOperationExpressionBlock.this._names);
            }

            public void referenceChanged(Var<Expression> source, Var<? extends Expression> oldReference, Var<? extends Expression> newReference) {
            }
        });
        inputMap.add("Operation", (Var)this._expression);
    }

    public String getMainPluginClassName() {
        return MathOperationPlugin.class.getName();
    }

    public String getName() {
        return "Math expression";
    }

    public void run() {
        Functor fun = this.extractFunctor();
        Variant[] in = new Variant[this._names.length];
        String[] inDesc = new String[this._names.length];
        for (int k = 0; k < this._names.length; ++k) {
            in[k] = this.retrieveInputValue(this._names[k]);
            inDesc[k] = in[k].toString();
        }
        String description = fun.describeOperation(inDesc);
        try {
            Variant out = fun.apply(in);
            this.defineOutputValue(out);
        }
        catch (Functor.InconsistentArguments err) {
            MathOperationExpressionBlock.reportError(err, description);
        }
    }

    private Functor extractFunctor() {
        Expression expression = (Expression)this._expression.getValue();
        if (expression == null) {
            throw new VarException("The 'op' field is either empty or inconsistent.");
        }
        try {
            return expression.getFunctor(this._names);
        }
        catch (Expression.BadFunctor err) {
            throw new VarException("Cannot interpret the 'op' field. Here is the error message: " + err.getMessage());
        }
    }

    static /* synthetic */ String[] access$002(MathOperationExpressionBlock x0, String[] x1) {
        x0._names = x1;
        return x1;
    }
}

