/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jxl.Cell;
import jxl.Sheet;
import jxl.write.WritableSheet;

public class ExcelGrid
extends JScrollPane {
    private static final long serialVersionUID = 2320166861791007410L;
    private JTable table = new JTable();

    public ExcelGrid(WritableSheet page) {
        this.updateSheet(page);
        this.setViewportView(this.table);
        this.setAutoscrolls(true);
    }

    public synchronized void updateSheet(WritableSheet page) {
        this.table = new JTable();
        this.setViewportView(this.table);
        if (page != null) {
            this.table.setModel(new SheetTableModel((Sheet)page));
        }
    }

    private class SheetTableModel
    implements TableModel {
        private Sheet sheet = null;

        public SheetTableModel(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public int getRowCount() {
            return this.sheet.getRows();
        }

        @Override
        public int getColumnCount() {
            return this.sheet.getColumns();
        }

        @Override
        public String getColumnName(int column) {
            String result = "";
            while (column >= 0) {
                result = (char)((char)(column % 26) + 65) + result;
                column = column / 26 - 1;
            }
            return result;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                Cell cell = this.sheet.getCell(columnIndex, rowIndex);
                return cell.getContents();
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

