/*
 * Decompiled with CFR 0.152.
 */
package mitiv.invpb;

import mitiv.cost.CompositeDifferentiableCostFunction;
import mitiv.cost.DifferentiableCostFunction;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.linalg.shaped.ShapedVectorSpace;
import mitiv.optim.BLMVM;
import mitiv.optim.BoundProjector;
import mitiv.optim.IterativeDifferentiableSolver;
import mitiv.optim.LBFGS;
import mitiv.optim.LineSearch;
import mitiv.optim.MoreThuenteLineSearch;
import mitiv.optim.NonLinearConjugateGradient;
import mitiv.optim.OptimTask;
import mitiv.optim.SimpleBounds;
import mitiv.optim.SimpleLowerBound;
import mitiv.optim.SimpleUpperBound;

public class SmoothInverseProblem
extends IterativeDifferentiableSolver {
    protected boolean debug = false;
    private boolean restart = true;
    private DifferentiableCostFunction fdata = null;
    private double mu = 1.0;
    private DifferentiableCostFunction fprior = null;
    private int limitedMemorySize = 5;
    private double lowerBound = Double.NEGATIVE_INFINITY;
    private double upperBound = Double.POSITIVE_INFINITY;
    private BoundProjector projector = null;
    private LineSearch lineSearch = null;
    private double gatol = 0.0;
    private double grtol = 0.001;

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public void setAbsoluteTolerance(double value) {
        if (this.nonfinite(value) || value < 0.0) {
            SmoothInverseProblem.error("Absolute tolerance for convergence must be nonnegative");
        }
        this.gatol = value;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public void setRelativeTolerance(double value) {
        if (this.nonfinite(value) || value < 0.0) {
            SmoothInverseProblem.error("Relative tolerance for convergence must be nonnegative");
        }
        this.grtol = value;
    }

    public int getLimitedMemorySize() {
        return this.limitedMemorySize;
    }

    public void setLimitedMemorySize(int value) {
        if (value < 0) {
            SmoothInverseProblem.error("Limited memory size be nonnegative");
        }
        if (this.limitedMemorySize != value) {
            this.limitedMemorySize = value;
            this.restart = true;
        }
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double value) {
        if (Double.isNaN(value) || value == Double.POSITIVE_INFINITY) {
            SmoothInverseProblem.error("Invalid value for the lower bound");
        }
        if (this.lowerBound != value) {
            this.lowerBound = value;
            this.restart = true;
        }
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double value) {
        if (Double.isNaN(value) || value == Double.NEGATIVE_INFINITY) {
            SmoothInverseProblem.error("Invalid value for the upper bound");
        }
        if (this.upperBound != value) {
            this.upperBound = value;
            this.restart = true;
        }
    }

    public DifferentiableCostFunction getLikelihood() {
        return this.fdata;
    }

    public void setLikelihood(DifferentiableCostFunction f) {
        if (this.fdata != f) {
            this.fdata = f;
            this.restart = true;
        }
    }

    public double getRegularizationLevel() {
        return this.mu;
    }

    public void setRegularizationLevel(double value) {
        if (this.nonfinite(value) || value < 0.0) {
            SmoothInverseProblem.error("Regularization level must be nonnegative");
        }
        if (this.mu != value) {
            this.mu = value;
            this.restart = true;
        }
    }

    public DifferentiableCostFunction getRegularization() {
        return this.fprior;
    }

    public void setRegularization(DifferentiableCostFunction f) {
        if (this.fprior != f) {
            this.fprior = f;
            this.restart = true;
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    @Override
    public OptimTask start(Vector x) {
        return this.start(x, false);
    }

    @Override
    public OptimTask start(Vector x, boolean reset) {
        if (this.restart) {
            this.setup(x);
        }
        return super.start(x, reset);
    }

    @Override
    public OptimTask iterate(Vector x) {
        if (this.restart) {
            return this.start(x);
        }
        return super.iterate(x);
    }

    public void releaseResources() {
        this.setOptimizer(null);
        this.restart = true;
    }

    private void setup(Vector x) {
        if (this.fdata == null) {
            SmoothInverseProblem.error("No data cost specified");
        }
        if (this.mu == 0.0) {
            this.setCostFunction(this.fdata);
        } else {
            if (this.fprior == null) {
                SmoothInverseProblem.error("No regularization specified");
            }
            this.setCostFunction(new CompositeDifferentiableCostFunction(1.0, this.fdata, this.mu, this.fprior));
        }
        if (this.lowerBound > this.upperBound) {
            SmoothInverseProblem.error("Incompatible bounds");
        }
        int bounded = 0;
        if (this.lowerBound != Double.NEGATIVE_INFINITY) {
            bounded |= 1;
        }
        if (this.upperBound != Double.POSITIVE_INFINITY) {
            bounded |= 2;
        }
        this.lineSearch = null;
        this.projector = null;
        VectorSpace space = this.getSpace();
        if (bounded == 0) {
            this.lineSearch = new MoreThuenteLineSearch(1.0E-4, 0.9, LBFGS.SXTOL);
            if (this.limitedMemorySize > 0) {
                LBFGS lbfgs = new LBFGS(space, this.limitedMemorySize, this.lineSearch);
                lbfgs.setAbsoluteTolerance(this.gatol);
                lbfgs.setRelativeTolerance(this.grtol);
                this.setOptimizer(lbfgs);
                if (this.debug) {
                    System.out.format("Using L-BFGS with %d memorized steps.\n", this.limitedMemorySize);
                }
            } else {
                this.lineSearch = new MoreThuenteLineSearch(0.05, 0.1, NonLinearConjugateGradient.SXTOL);
                int method = 771;
                NonLinearConjugateGradient nlcg = new NonLinearConjugateGradient(space, method, this.lineSearch);
                nlcg.setAbsoluteTolerance(this.gatol);
                nlcg.setRelativeTolerance(this.grtol);
                this.setOptimizer(nlcg);
                if (this.debug) {
                    System.out.format("Using non-linear conjugate gradients.\n", new Object[0]);
                }
            }
        } else {
            if (!(space instanceof ShapedVectorSpace)) {
                SmoothInverseProblem.error("Bounds are only implented for shaped vectors");
            }
            this.projector = bounded == 1 ? new SimpleLowerBound((ShapedVectorSpace)space, this.lowerBound) : (bounded == 2 ? new SimpleUpperBound((ShapedVectorSpace)space, this.upperBound) : new SimpleBounds((ShapedVectorSpace)space, this.lowerBound, this.upperBound));
            int m = this.limitedMemorySize > 1 ? this.limitedMemorySize : 5;
            BLMVM blmvm = new BLMVM(space, this.projector, m);
            blmvm.setAbsoluteTolerance(this.gatol);
            blmvm.setRelativeTolerance(this.grtol);
            this.setOptimizer(blmvm);
            this.projector.projectVariables(x, x);
            if (this.debug) {
                System.out.format("Using BLMVM with %d memorized steps.\n", this.limitedMemorySize);
            }
        }
        this.restart = false;
    }

    private static void error(String reason) {
        throw new IllegalArgumentException(reason);
    }

    private boolean nonfinite(double value) {
        return Double.isInfinite(value) || Double.isNaN(value);
    }
}

