/*
 * Decompiled with CFR 0.152.
 */
package icy.roi;

import icy.roi.BooleanMask2D;
import icy.roi.BooleanMask3D;
import icy.roi.BooleanMask4D;
import icy.type.collection.array.DynamicArray;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle4D;
import icy.type.rectangle.Rectangle5D;
import java.awt.Rectangle;
import java.util.Map;
import java.util.TreeMap;

public class BooleanMask5D {
    public Rectangle5D.Integer bounds;
    public final TreeMap<Integer, BooleanMask4D> mask;

    private static BooleanMask4D doUnion4D(BooleanMask4D m1, BooleanMask4D m2) {
        if (m1 == null) {
            if (m2 != null) {
                return (BooleanMask4D)m2.clone();
            }
            return null;
        }
        if (m2 == null) {
            return (BooleanMask4D)m1.clone();
        }
        return BooleanMask4D.getUnion(m1, m2);
    }

    private static BooleanMask4D doIntersection4D(BooleanMask4D m1, BooleanMask4D m2) {
        if (m1 == null || m2 == null) {
            return null;
        }
        return BooleanMask4D.getIntersection(m1, m2);
    }

    private static BooleanMask4D doExclusiveUnion4D(BooleanMask4D m1, BooleanMask4D m2) {
        if (m1 == null) {
            if (m2 != null) {
                return (BooleanMask4D)m2.clone();
            }
            return null;
        }
        if (m2 == null) {
            return (BooleanMask4D)m1.clone();
        }
        return BooleanMask4D.getExclusiveUnion(m1, m2);
    }

    private static BooleanMask4D doSubtraction4D(BooleanMask4D m1, BooleanMask4D m2) {
        if (m1 == null) {
            return null;
        }
        if (m2 == null) {
            return (BooleanMask4D)m1.clone();
        }
        return BooleanMask4D.getSubtraction(m1, m2);
    }

    public static BooleanMask5D getUnion(BooleanMask5D mask1, BooleanMask5D mask2) {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask5D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask5D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask5D)mask1.clone();
        }
        Rectangle5D.Integer bounds = (Rectangle5D.Integer)mask1.bounds.createUnion(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask4D[] mask;
            if (bounds.sizeC == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeC != Integer.MAX_VALUE || mask2.bounds.sizeC != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite C dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask4D[1];
                BooleanMask4D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask4D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask5D.doUnion4D(m2d1, m2d2);
            } else {
                mask = new BooleanMask4D[bounds.sizeT];
                for (int c = 0; c < bounds.sizeC; ++c) {
                    BooleanMask4D m2d1 = mask1.getMask4D(c + bounds.c);
                    BooleanMask4D m2d2 = mask2.getMask4D(c + bounds.c);
                    mask[c] = BooleanMask5D.doUnion4D(m2d1, m2d2);
                }
            }
            return new BooleanMask5D(bounds, mask);
        }
        return new BooleanMask5D();
    }

    public static BooleanMask5D getIntersection(BooleanMask5D mask1, BooleanMask5D mask2) {
        if (mask1 == null || mask2 == null) {
            return new BooleanMask5D();
        }
        Rectangle5D.Integer bounds = (Rectangle5D.Integer)mask1.bounds.createIntersection(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask4D[] mask;
            if (bounds.sizeC == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeC != Integer.MAX_VALUE || mask2.bounds.sizeC != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite C dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask4D[1];
                BooleanMask4D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask4D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask5D.doIntersection4D(m2d1, m2d2);
            } else {
                mask = new BooleanMask4D[bounds.sizeT];
                for (int c = 0; c < bounds.sizeC; ++c) {
                    BooleanMask4D m2d1 = mask1.getMask4D(c + bounds.c);
                    BooleanMask4D m2d2 = mask2.getMask4D(c + bounds.c);
                    mask[c] = BooleanMask5D.doIntersection4D(m2d1, m2d2);
                }
            }
            return new BooleanMask5D(bounds, mask);
        }
        return new BooleanMask5D();
    }

    public static BooleanMask5D getExclusiveUnion(BooleanMask5D mask1, BooleanMask5D mask2) {
        if (mask1 == null && mask2 == null) {
            return new BooleanMask5D();
        }
        if (mask1 == null || mask1.isEmpty()) {
            return (BooleanMask5D)mask2.clone();
        }
        if (mask2 == null || mask2.isEmpty()) {
            return (BooleanMask5D)mask1.clone();
        }
        Rectangle5D.Integer bounds = (Rectangle5D.Integer)mask1.bounds.createUnion(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask4D[] mask;
            if (bounds.sizeC == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeC != Integer.MAX_VALUE || mask2.bounds.sizeC != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite C dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask4D[1];
                BooleanMask4D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask4D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask5D.doExclusiveUnion4D(m2d1, m2d2);
            } else {
                mask = new BooleanMask4D[bounds.sizeT];
                for (int c = 0; c < bounds.sizeC; ++c) {
                    BooleanMask4D m2d1 = mask1.getMask4D(c + bounds.c);
                    BooleanMask4D m2d2 = mask2.getMask4D(c + bounds.c);
                    mask[c] = BooleanMask5D.doExclusiveUnion4D(m2d1, m2d2);
                }
            }
            return new BooleanMask5D(bounds, mask);
        }
        return new BooleanMask5D();
    }

    public static BooleanMask5D getSubtraction(BooleanMask5D mask1, BooleanMask5D mask2) {
        if (mask1 == null) {
            return new BooleanMask5D();
        }
        if (mask2 == null) {
            return (BooleanMask5D)mask1.clone();
        }
        Rectangle5D.Integer bounds = (Rectangle5D.Integer)mask1.bounds.createIntersection(mask2.bounds);
        if (!bounds.isEmpty()) {
            BooleanMask4D[] mask;
            if (bounds.sizeC == Integer.MAX_VALUE) {
                if (mask1.bounds.sizeC != Integer.MAX_VALUE || mask2.bounds.sizeC != Integer.MAX_VALUE) {
                    throw new UnsupportedOperationException("Cannot merge an infinite C dimension ROI with  a finite Z dimension ROI");
                }
                mask = new BooleanMask4D[1];
                BooleanMask4D m2d1 = mask1.mask.firstEntry().getValue();
                BooleanMask4D m2d2 = mask2.mask.firstEntry().getValue();
                mask[0] = BooleanMask5D.doSubtraction4D(m2d1, m2d2);
            } else {
                mask = new BooleanMask4D[bounds.sizeC];
                for (int c = 0; c < bounds.sizeC; ++c) {
                    BooleanMask4D m2d1 = mask1.getMask4D(c + bounds.c);
                    BooleanMask4D m2d2 = mask2.getMask4D(c + bounds.c);
                    mask[c] = BooleanMask5D.doSubtraction4D(m2d1, m2d2);
                }
            }
            return new BooleanMask5D(bounds, mask);
        }
        return (BooleanMask5D)mask1.clone();
    }

    public BooleanMask5D(Rectangle5D.Integer bounds, BooleanMask4D[] mask) {
        this.bounds = bounds;
        this.mask = new TreeMap();
        if (bounds.sizeC == Integer.MAX_VALUE) {
            this.mask.put(Integer.MIN_VALUE, mask[0]);
        } else {
            for (int c = 0; c < bounds.sizeC; ++c) {
                if (mask[c] == null) continue;
                this.mask.put(bounds.c + c, mask[c]);
            }
        }
    }

    public BooleanMask5D(Point5D.Integer[] points) {
        this.mask = new TreeMap();
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle5D.Integer();
        } else {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int minT = Integer.MAX_VALUE;
            int minC = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxT = Integer.MIN_VALUE;
            int maxC = Integer.MIN_VALUE;
            for (Point5D.Integer pt : points) {
                int x = pt.x;
                int y = pt.y;
                int z = pt.z;
                int t = pt.t;
                int c = pt.c;
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (z > maxZ) {
                    maxZ = z;
                }
                if (t < minT) {
                    minT = t;
                }
                if (t > maxT) {
                    maxT = t;
                }
                if (c < minC) {
                    minC = c;
                }
                if (c <= maxC) continue;
                maxC = c;
            }
            this.bounds = new Rectangle5D.Integer(minX, minY, minZ, minT, minC, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1, maxT - minT + 1, maxC - minC + 1);
            for (Point5D.Integer pt : points) {
                BooleanMask2D m2d;
                BooleanMask3D m3d;
                BooleanMask4D m4d = this.mask.get(pt.c);
                if (m4d == null) {
                    m4d = new BooleanMask4D(new Rectangle4D.Integer(minX, minY, minZ, minT, this.bounds.sizeX, this.bounds.sizeY, this.bounds.sizeZ, this.bounds.sizeT), new BooleanMask3D[this.bounds.sizeT]);
                    this.mask.put(pt.c, m4d);
                }
                if ((m3d = m4d.getMask3D(pt.t)) == null) {
                    m3d = new BooleanMask3D(new Rectangle3D.Integer(minX, minY, minZ, this.bounds.sizeX, this.bounds.sizeY, this.bounds.sizeZ), new BooleanMask2D[this.bounds.sizeZ]);
                    m4d.mask.put(pt.t, m3d);
                }
                if ((m2d = m3d.getMask2D(pt.z)) == null) {
                    m2d = new BooleanMask2D(new Rectangle(minX, minY, this.bounds.sizeX, this.bounds.sizeY), new boolean[this.bounds.sizeX * this.bounds.sizeY]);
                    m3d.mask.put(pt.z, m2d);
                }
                m2d.mask[(pt.y - minY) * this.bounds.sizeX + (pt.x - minX)] = true;
            }
            for (BooleanMask4D m : this.mask.values()) {
                m.optimizeBounds();
            }
        }
    }

    public BooleanMask5D(Point5D[] points) {
        this.mask = new TreeMap();
        if (points == null || points.length == 0) {
            this.bounds = new Rectangle5D.Integer();
        } else {
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            int minZ = Integer.MAX_VALUE;
            int minT = Integer.MAX_VALUE;
            int minC = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int maxZ = Integer.MIN_VALUE;
            int maxT = Integer.MIN_VALUE;
            int maxC = Integer.MIN_VALUE;
            for (Point5D pt : points) {
                int x = (int)pt.getX();
                int y = (int)pt.getY();
                int z = (int)pt.getZ();
                int t = (int)pt.getT();
                int c = (int)pt.getC();
                if (x < minX) {
                    minX = x;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (y > maxY) {
                    maxY = y;
                }
                if (z < minZ) {
                    minZ = z;
                }
                if (z > maxZ) {
                    maxZ = z;
                }
                if (t < minT) {
                    minT = t;
                }
                if (t > maxT) {
                    maxT = t;
                }
                if (c < minC) {
                    minC = c;
                }
                if (c <= maxC) continue;
                maxC = c;
            }
            this.bounds = new Rectangle5D.Integer(minX, minY, minZ, minT, minC, maxX - minX + 1, maxY - minY + 1, maxZ - minZ + 1, maxT - minT + 1, maxC - minC + 1);
            for (Point5D pt : points) {
                BooleanMask2D m2d;
                BooleanMask3D m3d;
                BooleanMask4D m4d = this.mask.get((int)pt.getC());
                if (m4d == null) {
                    m4d = new BooleanMask4D(new Rectangle4D.Integer(minX, minY, minZ, minT, this.bounds.sizeX, this.bounds.sizeY, this.bounds.sizeZ, this.bounds.sizeT), new BooleanMask3D[this.bounds.sizeT]);
                    this.mask.put((int)pt.getC(), m4d);
                }
                if ((m3d = m4d.getMask3D((int)pt.getT())) == null) {
                    m3d = new BooleanMask3D(new Rectangle3D.Integer(minX, minY, minZ, this.bounds.sizeX, this.bounds.sizeY, this.bounds.sizeZ), new BooleanMask2D[this.bounds.sizeZ]);
                    m4d.mask.put((int)pt.getT(), m3d);
                }
                if ((m2d = m3d.getMask2D((int)pt.getZ())) == null) {
                    m2d = new BooleanMask2D(new Rectangle(minX, minY, this.bounds.sizeX, this.bounds.sizeY), new boolean[this.bounds.sizeX * this.bounds.sizeY]);
                    m3d.mask.put((int)pt.getZ(), m2d);
                }
                m2d.mask[((int)pt.getY() - minY) * this.bounds.sizeX + ((int)pt.getX() - minX)] = true;
            }
            for (BooleanMask4D m : this.mask.values()) {
                m.optimizeBounds();
            }
        }
    }

    public BooleanMask5D() {
        this(new Rectangle5D.Integer(), new BooleanMask4D[0]);
    }

    public BooleanMask4D getMask4D(int c) {
        if (this.bounds.sizeC == Integer.MAX_VALUE) {
            return this.mask.firstEntry().getValue();
        }
        return this.mask.get(c);
    }

    public BooleanMask3D getMask3D(int t, int c) {
        BooleanMask4D m = this.getMask4D(c);
        if (m != null) {
            return m.getMask3D(t);
        }
        return null;
    }

    public BooleanMask2D getMask2D(int z, int t, int c) {
        BooleanMask3D m = this.getMask3D(t, c);
        if (m != null) {
            return m.getMask2D(z);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.bounds.isEmpty();
    }

    public boolean contains(int x, int y, int z, int t, int c) {
        BooleanMask4D m4d;
        if (this.bounds.contains(x, y, z, t, c) && (m4d = this.getMask4D(c)) != null) {
            return m4d.contains(x, y, z, t);
        }
        return false;
    }

    public boolean contains(BooleanMask2D booleanMask, int z, int t, int c) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask2D mask2d = this.getMask2D(z, t, c);
        if (mask2d != null) {
            return mask2d.contains(booleanMask);
        }
        return false;
    }

    public boolean contains(BooleanMask3D booleanMask, int t, int c) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask3D mask3d = this.getMask3D(t, c);
        if (mask3d != null) {
            return mask3d.contains(booleanMask);
        }
        return false;
    }

    public boolean contains(BooleanMask4D booleanMask, int c) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask4D mask4d = this.getMask4D(c);
        if (mask4d != null) {
            return mask4d.contains(booleanMask);
        }
        return false;
    }

    public boolean contains(BooleanMask5D booleanMask) {
        int offC;
        if (this.isEmpty()) {
            return false;
        }
        int sizeC = booleanMask.bounds.sizeC;
        if (sizeC == Integer.MAX_VALUE) {
            if (this.bounds.sizeC != Integer.MAX_VALUE) {
                return false;
            }
            return booleanMask.mask.firstEntry().getValue().contains(this.mask.firstEntry().getValue());
        }
        for (int c = offC = booleanMask.bounds.c; c < offC + sizeC; ++c) {
            if (this.contains(booleanMask.getMask4D(c), c)) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(BooleanMask2D booleanMask, int z, int t, int c) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask2D mask2d = this.getMask2D(z, t, c);
        if (mask2d != null) {
            return mask2d.intersects(booleanMask);
        }
        return false;
    }

    public boolean intersects(BooleanMask3D booleanMask, int t, int c) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask3D mask3d = this.getMask3D(t, c);
        if (mask3d != null) {
            return mask3d.intersects(booleanMask);
        }
        return false;
    }

    public boolean intersects(BooleanMask4D booleanMask, int c) {
        if (this.isEmpty()) {
            return false;
        }
        BooleanMask4D mask4d = this.getMask4D(c);
        if (mask4d != null) {
            return mask4d.intersects(booleanMask);
        }
        return false;
    }

    public boolean intersects(BooleanMask5D booleanMask) {
        int offC;
        if (this.isEmpty()) {
            return false;
        }
        int sizeC = booleanMask.bounds.sizeC;
        if (sizeC == Integer.MAX_VALUE) {
            BooleanMask4D mask4d = booleanMask.mask.firstEntry().getValue();
            for (BooleanMask4D m : this.mask.values()) {
                if (!m.intersects(mask4d)) continue;
                return true;
            }
            return false;
        }
        if (this.bounds.sizeC == Integer.MAX_VALUE) {
            BooleanMask4D mask4d = this.mask.firstEntry().getValue();
            for (BooleanMask4D m : booleanMask.mask.values()) {
                if (!m.intersects(mask4d)) continue;
                return true;
            }
            return false;
        }
        for (int c = offC = booleanMask.bounds.c; c < offC + sizeC; ++c) {
            if (!this.intersects(booleanMask.getMask4D(c), c)) continue;
            return true;
        }
        return false;
    }

    public Rectangle5D.Integer getOptimizedBounds(boolean compute4DBounds) {
        Rectangle5D.Integer result = new Rectangle5D.Integer();
        if (this.mask.isEmpty()) {
            return result;
        }
        Rectangle4D bounds4D = null;
        for (BooleanMask4D m4d : this.mask.values()) {
            Rectangle4D.Integer optB4d = compute4DBounds ? m4d.getOptimizedBounds() : new Rectangle4D.Integer(m4d.bounds);
            if (optB4d.isEmpty()) continue;
            if (bounds4D == null) {
                bounds4D = optB4d;
                continue;
            }
            bounds4D.add(optB4d);
        }
        if (bounds4D == null || bounds4D.isEmpty()) {
            return result;
        }
        int minC = this.mask.firstKey();
        int maxC = this.mask.lastKey();
        result.setX(((Rectangle4D.Integer)bounds4D).x);
        result.setY(((Rectangle4D.Integer)bounds4D).y);
        result.setZ(((Rectangle4D.Integer)bounds4D).z);
        result.setT(((Rectangle4D.Integer)bounds4D).t);
        result.setSizeX(((Rectangle4D.Integer)bounds4D).sizeX);
        result.setSizeY(((Rectangle4D.Integer)bounds4D).sizeY);
        result.setSizeZ(((Rectangle4D.Integer)bounds4D).sizeZ);
        result.setSizeT(((Rectangle4D.Integer)bounds4D).sizeT);
        if (minC == maxC && this.bounds.sizeC == Integer.MAX_VALUE) {
            result.setC(-2.147483648E9);
            result.setSizeC(2.147483647E9);
        } else {
            result.setC(minC);
            result.setSizeC(maxC - minC + 1);
        }
        return result;
    }

    public Rectangle5D.Integer getOptimizedBounds() {
        return this.getOptimizedBounds(true);
    }

    public void optimizeBounds() {
        for (BooleanMask4D m : this.mask.values()) {
            m.optimizeBounds();
        }
        this.moveBounds(this.getOptimizedBounds(false));
    }

    public void moveBounds(Rectangle5D.Integer value) {
        if (!this.bounds.equals(value)) {
            if (value.isEmpty()) {
                this.bounds = new Rectangle5D.Integer();
                this.mask.clear();
                return;
            }
            Rectangle4D.Integer bounds4D = new Rectangle4D.Integer(value.x, value.y, value.z, value.t, value.sizeX, value.sizeY, value.sizeZ, value.sizeT);
            if (this.bounds.sizeC == Integer.MAX_VALUE) {
                BooleanMask4D m4d = this.mask.firstEntry().getValue();
                m4d.moveBounds(bounds4D);
                if (value.sizeC != Integer.MAX_VALUE) {
                    this.mask.clear();
                    for (int c = 0; c <= value.sizeC; ++c) {
                        this.mask.put(c + value.c, (BooleanMask4D)m4d.clone());
                    }
                }
            } else if (value.sizeT == Integer.MAX_VALUE) {
                BooleanMask4D mask4D = this.getMask4D(value.c);
                if (mask4D == null && !this.mask.isEmpty()) {
                    mask4D = this.mask.firstEntry().getValue();
                }
                this.mask.clear();
                if (mask4D != null) {
                    this.mask.put(Integer.MIN_VALUE, mask4D);
                }
            } else {
                int c;
                BooleanMask4D[] newMask = new BooleanMask4D[value.sizeC];
                for (c = 0; c < value.sizeC; ++c) {
                    BooleanMask4D mask4D = this.getMask4D(value.c + c);
                    if (mask4D != null) {
                        mask4D.moveBounds(bounds4D);
                    }
                    newMask[c] = mask4D;
                }
                this.mask.clear();
                for (c = 0; c < value.sizeC; ++c) {
                    this.mask.put(value.c + c, newMask[c]);
                }
            }
            this.bounds = value;
        }
    }

    public static int[] toInt5D(int[] source4D, int c) {
        int[] result = new int[source4D.length * 5 / 4];
        int pt = 0;
        for (int i = 0; i < source4D.length; i += 4) {
            result[pt++] = source4D[i + 0];
            result[pt++] = source4D[i + 1];
            result[pt++] = source4D[i + 2];
            result[pt++] = source4D[i + 3];
            result[pt++] = c;
        }
        return result;
    }

    public Point5D.Integer[] getContourPoints() {
        return Point5D.Integer.toPoint5D(this.getContourPointsAsIntArray());
    }

    public int[] getContourPointsAsIntArray() {
        DynamicArray.Int result = new DynamicArray.Int(8);
        if (this.mask.size() <= 2) {
            for (Map.Entry<Integer, BooleanMask4D> entry : this.mask.entrySet()) {
                result.add(BooleanMask5D.toInt5D(entry.getValue().getPointsAsIntArray(), entry.getKey()));
            }
        } else {
            Map.Entry<Integer, BooleanMask4D> firstEntry = this.mask.firstEntry();
            Map.Entry<Integer, BooleanMask4D> lastEntry = this.mask.lastEntry();
            Integer firstKey = firstEntry.getKey();
            Integer lastKey = lastEntry.getKey();
            result.add(BooleanMask5D.toInt5D(firstEntry.getValue().getPointsAsIntArray(), firstKey));
            for (Map.Entry entry : this.mask.subMap(firstKey, false, lastKey, false).entrySet()) {
                result.add(BooleanMask5D.toInt5D(((BooleanMask4D)entry.getValue()).getContourPointsAsIntArray(), (Integer)entry.getKey()));
            }
            result.add(BooleanMask5D.toInt5D(lastEntry.getValue().getPointsAsIntArray(), lastKey));
        }
        return result.asArray();
    }

    public int getNumberOfPoints() {
        int result = 0;
        for (BooleanMask4D mask4d : this.mask.values()) {
            result += mask4d.getNumberOfPoints();
        }
        return result;
    }

    public Point5D.Integer[] getPoints() {
        return Point5D.Integer.toPoint5D(this.getPointsAsIntArray());
    }

    public int[] getPointsAsIntArray() {
        DynamicArray.Int result = new DynamicArray.Int(8);
        for (Map.Entry<Integer, BooleanMask4D> entry : this.mask.entrySet()) {
            result.add(BooleanMask5D.toInt5D(entry.getValue().getPointsAsIntArray(), entry.getKey()));
        }
        return result.asArray();
    }

    public Object clone() {
        BooleanMask5D result = new BooleanMask5D();
        result.bounds = new Rectangle5D.Integer(this.bounds);
        for (Map.Entry<Integer, BooleanMask4D> entry : this.mask.entrySet()) {
            result.mask.put(entry.getKey(), (BooleanMask4D)entry.getValue().clone());
        }
        return result;
    }
}

