/*
 * Decompiled with CFR 0.152.
 */
package icy.type.value;

import icy.type.value.AbstractValue;
import icy.util.StringUtil;

public class FloatValue
extends AbstractValue<Float> {
    public FloatValue(Float value) {
        super(value);
    }

    public FloatValue(float value) {
        this(Float.valueOf(value));
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public int compareTo(Float f) {
        return ((Float)this.value).compareTo(f);
    }

    @Override
    public boolean loadFromString(String s) {
        if (StringUtil.isEmpty(s)) {
            this.value = this.getDefaultValue();
            return true;
        }
        try {
            this.value = Float.valueOf(Float.parseFloat(s));
            return true;
        }
        catch (NumberFormatException E) {
            return false;
        }
    }
}

