/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import ome.units.UNITS;
import ome.units.quantity.Time;

public class PCORAWReader
extends FormatReader {
    private TiffReader reader = new TiffReader();
    private String imageFile;
    private String paramFile;

    public PCORAWReader() {
        super("PCO-RAW", new String[]{"pcoraw", "rec"});
        this.domains = new String[]{"Unknown"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.datasetDescription = "A single .pcoraw file with a similarly-named .rec file";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        if (PCORAWReader.checkSuffix(name, "rec") && open) {
            String base = new Location(name).getAbsoluteFile().getAbsolutePath();
            base = base.substring(0, base.lastIndexOf("."));
            String id = base + ".pcoraw";
            return new Location(id).exists();
        }
        if (PCORAWReader.checkSuffix(name, "pcoraw") && open) {
            return this.reader.isThisType(name, open);
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.reader.isThisType(stream);
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        String[] stringArray;
        if (noPixels) {
            String[] stringArray2;
            if (this.paramFile == null) {
                stringArray2 = null;
            } else {
                String[] stringArray3 = new String[1];
                stringArray2 = stringArray3;
                stringArray3[0] = this.paramFile;
            }
            return stringArray2;
        }
        if (this.paramFile == null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = this.imageFile;
        } else {
            String[] stringArray5 = new String[2];
            stringArray5[0] = this.imageFile;
            stringArray = stringArray5;
            stringArray5[1] = this.paramFile;
        }
        return stringArray;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        return this.reader.openBytes(no, buf, x, y, w, h2);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        this.reader.close(fileOnly);
        if (!fileOnly) {
            this.imageFile = null;
            this.paramFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initFile(String id) throws FormatException, IOException {
        if (PCORAWReader.checkSuffix(id, "rec")) {
            this.paramFile = new Location(id).getAbsolutePath();
            String base = new Location(id).getAbsoluteFile().getAbsolutePath();
            id = (base = base.substring(0, base.lastIndexOf("."))) + ".pcoraw";
            if (!new Location(id).exists()) {
                throw new FormatException("Could not find image file.");
            }
        }
        super.initFile(id);
        this.imageFile = new Location(id).getAbsolutePath();
        this.reader.close();
        this.reader.setMetadataStore(this.getMetadataStore());
        this.reader.setId(id);
        this.core = this.reader.getCoreMetadataList();
        this.metadata = this.reader.getGlobalMetadata();
        this.in = new RandomAccessInputStream(id);
        try {
            if ((double)this.in.length() >= Math.pow(2.0, 32.0)) {
                long add = 0L;
                long prevOffset = 0L;
                for (IFD ifd : this.reader.ifds) {
                    long[] offsets = ifd.getStripOffsets();
                    for (int i = 0; i < offsets.length; ++i) {
                        int n = i;
                        offsets[n] = offsets[n] + add;
                        if (offsets[i] < prevOffset) {
                            add += 0x100000000L;
                            int n2 = i;
                            offsets[n2] = offsets[n2] + 0x100000000L;
                        }
                        prevOffset = offsets[i];
                    }
                    ifd.put(273, offsets);
                }
            }
        }
        finally {
            this.in.close();
        }
        if (this.paramFile == null) {
            String base = this.imageFile.substring(0, this.imageFile.lastIndexOf("."));
            if (new Location(base = base + ".rec").exists()) {
                this.paramFile = base;
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, true);
        if (this.paramFile != null) {
            store.setInstrumentID(MetadataTools.createLSID("Instrument", 0), 0);
            String detector = MetadataTools.createLSID("Detector", 0, 0);
            store.setDetectorID(detector, 0, 0);
            String[] lines = DataTools.readFile(this.paramFile).split("\n");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                int sep = line.indexOf(58);
                if (sep < 0) continue;
                String key = line.substring(0, sep).trim();
                String value = line.substring(sep + 1).trim();
                this.addGlobalMeta(key, value);
                if (key.equals("Exposure / Delay")) {
                    String exp = value.substring(0, value.indexOf(32));
                    Double parsedExp = new Double(exp);
                    Time exposure = null;
                    if (parsedExp != null) {
                        exposure = new Time(parsedExp / 1000.0, UNITS.SECOND);
                    }
                    for (int plane = 0; plane < this.getImageCount(); ++plane) {
                        store.setPlaneExposureTime(exposure, 0, plane);
                    }
                    continue;
                }
                if (key.equals("Camera serial number")) {
                    store.setDetectorSerialNumber(value, 0, 0);
                    continue;
                }
                if (key.equals("Binning horz./vert.")) {
                    store.setDetectorSettingsID(detector, 0, 0);
                    value = value.charAt(1) + value;
                    value = value.substring(0, 3);
                    store.setDetectorSettingsBinning(MetadataTools.getBinning(value), 0, 0);
                    continue;
                }
                if (!key.equals("Comment")) continue;
                StringBuilder description = new StringBuilder();
                for (int j = i + 1; j < lines.length; ++j) {
                    lines[j] = lines[j].trim();
                    if (lines[j].length() <= 0) continue;
                    description.append(lines[j]);
                    description.append(" ");
                }
                store.setImageDescription(description.toString().trim(), 0);
                break;
            }
        }
    }
}

