/*
 * Decompiled with CFR 0.152.
 */
package mitiv.optim;

import mitiv.base.Traits;
import mitiv.linalg.Vector;
import mitiv.linalg.VectorSpace;
import mitiv.optim.LineSearch;
import mitiv.optim.ReverseCommunicationOptimizerWithLineSearch;

abstract class QuasiNewton
extends ReverseCommunicationOptimizerWithLineSearch {
    public static final double SFTOL = 1.0E-4;
    public static final double SGTOL = 0.9;
    public static final double SXTOL = Traits.DBL_EPSILON;
    protected double epsilon = 0.0;
    protected double delta = 0.001;
    protected double grtol;
    protected double gatol;
    protected double ginit;
    protected double stpmin = 1.0E-20;
    protected double stpmax = 1.0E20;

    public QuasiNewton(VectorSpace space, LineSearch lnsrch) {
        super(space, lnsrch);
    }

    public double getSufficientDescentThreshold() {
        return this.epsilon;
    }

    public void setSufficientDescentThreshold(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value) || value < 0.0 || value >= 1.0) {
            throw new IllegalArgumentException("Bad value for the sufficient descent threshold");
        }
        this.epsilon = value;
    }

    boolean checkSufficientDescent(double dtg, double gnorm, Vector d) {
        double r;
        if (this.epsilon > 0.0 && (r = this.epsilon * gnorm * d.norm2()) > 0.0) {
            return dtg <= -r;
        }
        return dtg < 0.0;
    }

    boolean checkSufficientDescent(double dtg, double gnorm, double dnorm) {
        double r;
        if (this.epsilon > 0.0 && (r = this.epsilon * gnorm * dnorm) > 0.0) {
            return dtg <= -r;
        }
        return dtg < 0.0;
    }

    public double getRelativeSmallStep() {
        return this.delta;
    }

    public void setRelativeSmallStep(double value) {
        if (Double.isNaN(value) || Double.isInfinite(value) || value <= 0.0 || value >= 1.0) {
            throw new IllegalArgumentException("Bad value for relative small step size");
        }
        this.delta = value;
    }

    public void setAbsoluteTolerance(double gatol) {
        this.gatol = gatol;
    }

    public void setRelativeTolerance(double grtol) {
        this.grtol = grtol;
    }

    public double getAbsoluteTolerance() {
        return this.gatol;
    }

    public double getRelativeTolerance() {
        return this.grtol;
    }

    public double getGradientThreshold(double g0nrm) {
        return QuasiNewton.max(0.0, this.gatol, this.grtol * g0nrm);
    }

    private static final double max(double a1, double a2, double a3) {
        if (a3 >= a2) {
            return a3 >= a1 ? a3 : a1;
        }
        return a2 >= a1 ? a2 : a1;
    }
}

