/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.roi;

import icy.gui.main.MainAdapter;
import icy.gui.main.MainEvent;
import icy.gui.main.MainListener;
import icy.gui.util.GuiUtil;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.border.TitledBorder;
import jxl.write.WritableSheet;
import plugins.fab.spotDetector.DetectionSpot;
import plugins.fab.spotDetector.GlobalDetectionToken;
import plugins.fab.spotDetector.roi.ROIDetectionAbstract;
import plugins.fab.spotDetector.roi.ROI_XLS_Common_Saver;
import plugins.kernel.roi.roi2d.ROI2DRectangle;

public class ROIFromSequence
extends ROIDetectionAbstract {
    JLabel currentSequenceNameLabel = new JLabel();
    Color labelDefaultColor = null;

    public ROIFromSequence() {
        this.getPanel().setLayout(new BoxLayout(this.getPanel(), 3));
        this.getPanel().setBorder(new TitledBorder("use ROI in current sequence"));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Current sequence input:")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(10)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{this.currentSequenceNameLabel}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalStrut(30)}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{new JLabel("Tip: Remove detection areas with black rois")}));
        this.getPanel().add(GuiUtil.createLineBoxPanel((Component[])new Component[]{Box.createVerticalGlue()}));
        this.refreshCurrentSequenceLabel();
        Icy.getMainInterface().addListener((MainListener)new MainAdapter(){

            public void sequenceFocused(MainEvent event) {
                ROIFromSequence.this.refreshCurrentSequenceLabel();
            }
        });
    }

    private void refreshCurrentSequenceLabel() {
        Sequence sequence = this.getFocusedSequence();
        if (sequence == null) {
            this.currentSequenceNameLabel.setForeground(Color.red);
            this.currentSequenceNameLabel.setText("No sequence loaded");
        } else {
            this.currentSequenceNameLabel.setForeground(this.labelDefaultColor);
            this.currentSequenceNameLabel.setText(sequence.getName());
        }
    }

    @Override
    public void process(GlobalDetectionToken gdt) {
        ArrayList roiArrayList = gdt.inputSequence.getROIs();
        ArrayList roiArrayListCopy = new ArrayList(roiArrayList);
        for (Object roi : roiArrayListCopy) {
            if (!roi.getName().startsWith("spot")) continue;
            roiArrayList.remove(roi);
        }
        ArrayList<DetectionSpot> cloneDetectionList = new ArrayList<DetectionSpot>(gdt.detectionResult);
        for (ROI roi : roiArrayList) {
            if (roi.getColor().getRed() != 0 || roi.getColor().getGreen() != 0 || roi.getColor().getBlue() != 0) continue;
            for (DetectionSpot detectionSpot : cloneDetectionList) {
                if (!roi.contains(detectionSpot.getMassCenter().x, detectionSpot.getMassCenter().y, detectionSpot.getMassCenter().z, (double)detectionSpot.getT(), -1.0)) continue;
                gdt.detectionResult.remove(detectionSpot);
            }
        }
        HashMap ROI2Detection = new HashMap();
        if (roiArrayList.size() == 0) {
            ROI2Detection.put(new ROI2DRectangle((Rectangle2D)gdt.inputSequence.getBounds2D()), (ArrayList)gdt.detectionResult.clone());
        } else {
            for (ROI roi : roiArrayList) {
                ROI2Detection.put(roi, new ArrayList());
            }
            for (ROI roi : roiArrayList) {
                for (DetectionSpot spot : gdt.detectionResult) {
                    if (!roi.contains(spot.getMassCenter().x, spot.getMassCenter().y, spot.getMassCenter().z, (double)spot.getT(), -1.0)) continue;
                    ((ArrayList)ROI2Detection.get(roi)).add(spot);
                }
            }
        }
        gdt.detectionResult.clear();
        for (ROI roi : ROI2Detection.keySet()) {
            for (DetectionSpot ds : (ArrayList)ROI2Detection.get(roi)) {
                gdt.detectionResult.add(ds);
            }
        }
        gdt.roi2detection = ROI2Detection;
    }

    @Override
    public void saveXLS(WritableSheet page, GlobalDetectionToken gdt) {
        ROI_XLS_Common_Saver.saveXLS(page, gdt, "ROI From Sequence module");
    }
}

