/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.inspector;

import icy.gui.component.PopupPanel;
import icy.gui.main.ActiveSequenceListener;
import icy.gui.main.ActiveViewerListener;
import icy.gui.sequence.SequenceInfosPanel;
import icy.gui.viewer.Viewer;
import icy.gui.viewer.ViewerEvent;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;

public class SequencePanel
extends JPanel
implements ActiveSequenceListener,
ActiveViewerListener {
    private static final long serialVersionUID = -5727785928741370159L;
    private PopupPanel canvasPopupPanel;
    private PopupPanel lutPopupPanel;
    private PopupPanel infosPopupPanel;
    private JPanel canvasPanel;
    private JPanel lutPanel;
    private JPanel infosPanel;
    private SequenceInfosPanel sequenceInfosPanel;

    public SequencePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.sequenceInfosPanel = new SequenceInfosPanel();
        this.infosPopupPanel = new PopupPanel("Sequence Properties");
        this.infosPanel = this.infosPopupPanel.getMainPanel();
        this.infosPanel.setLayout(new BorderLayout());
        this.infosPopupPanel.expand();
        this.canvasPopupPanel = new PopupPanel("Canvas");
        this.canvasPanel = this.canvasPopupPanel.getMainPanel();
        this.canvasPanel.setLayout(new BorderLayout());
        this.canvasPopupPanel.expand();
        GridBagConstraints gbc_canvasPopupPanel = new GridBagConstraints();
        gbc_canvasPopupPanel.fill = 2;
        gbc_canvasPopupPanel.insets = new Insets(0, 0, 0, 0);
        gbc_canvasPopupPanel.gridx = 0;
        gbc_canvasPopupPanel.gridy = 0;
        this.add((Component)this.canvasPopupPanel, gbc_canvasPopupPanel);
        this.lutPopupPanel = new PopupPanel("Histogram and colormap");
        this.lutPanel = this.lutPopupPanel.getMainPanel();
        this.lutPanel.setLayout(new BorderLayout());
        this.lutPopupPanel.expand();
        GridBagConstraints gbc_lutPopupPanel = new GridBagConstraints();
        gbc_lutPopupPanel.fill = 2;
        gbc_lutPopupPanel.insets = new Insets(0, 0, 0, 0);
        gbc_lutPopupPanel.gridx = 0;
        gbc_lutPopupPanel.gridy = 1;
        this.add((Component)this.lutPopupPanel, gbc_lutPopupPanel);
        this.infosPanel.add((Component)this.sequenceInfosPanel, "Center");
        GridBagConstraints gbc_infosPopupPanel = new GridBagConstraints();
        gbc_infosPopupPanel.insets = new Insets(0, 0, 0, 0);
        gbc_infosPopupPanel.fill = 2;
        gbc_infosPopupPanel.gridx = 0;
        gbc_infosPopupPanel.gridy = 2;
        this.add((Component)this.infosPopupPanel, gbc_infosPopupPanel);
    }

    public void setCanvasPanel(JPanel panel) {
        this.canvasPanel.removeAll();
        if (panel != null) {
            this.canvasPanel.add((Component)panel, "Center");
        }
        this.canvasPanel.revalidate();
        this.canvasPanel.repaint();
    }

    public void setLutPanel(JPanel panel) {
        this.lutPanel.removeAll();
        if (panel != null) {
            this.lutPanel.add((Component)panel, "Center");
        }
        this.lutPanel.revalidate();
        this.lutPanel.repaint();
    }

    @Override
    public void viewerActivated(Viewer viewer) {
        if (viewer != null) {
            this.setLutPanel(viewer.getLutViewer());
            this.setCanvasPanel(viewer.getCanvasPanel());
        } else {
            this.setLutPanel(null);
            this.setCanvasPanel(null);
        }
    }

    @Override
    public void viewerDeactivated(Viewer viewer) {
    }

    @Override
    public void activeViewerChanged(ViewerEvent event) {
        switch (event.getType()) {
            case CANVAS_CHANGED: {
                this.setCanvasPanel(event.getSource().getCanvasPanel());
                break;
            }
            case LUT_CHANGED: {
                this.setLutPanel(event.getSource().getLutViewer());
                break;
            }
        }
    }

    @Override
    public void sequenceActivated(Sequence sequence) {
        this.sequenceInfosPanel.sequenceActivated(sequence);
    }

    @Override
    public void sequenceDeactivated(Sequence sequence) {
    }

    @Override
    public void activeSequenceChanged(SequenceEvent event) {
        this.sequenceInfosPanel.activeSequenceChanged(event);
    }
}

