/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.VarEnum;
import plugins.adufour.vars.util.VarException;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.MathOperationAbstractBlock;
import plugins.ylemontag.mathoperations.MathOperationPlugin;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.operations.Operation1;

public class MathOperationUnaryBlock
extends MathOperationAbstractBlock {
    private VarEnum<Operation1> _operation = new VarEnum("op", (Enum)Operation1.ABS);
    private String _name0 = "a";

    public MathOperationUnaryBlock() {
        super("result");
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("Operation", this._operation);
        this.addInputVariant(inputMap, this._name0, "In");
    }

    public String getMainPluginClassName() {
        return MathOperationPlugin.class.getName();
    }

    public String getName() {
        return "Math operation (1)";
    }

    public void run() {
        Operation1 op = (Operation1)this._operation.getValue();
        if (op == null) {
            throw new VarException("No operation selected");
        }
        Variant in0 = this.retrieveInputValue(this._name0);
        String description = op.getFunctor().describeOperation(in0.getRepresentation(true));
        try {
            Variant out = op.getFunctor().apply(in0);
            this.defineOutputValue(out);
        }
        catch (Functor.InconsistentArguments err) {
            MathOperationUnaryBlock.reportError(err, description);
        }
    }
}

