/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.PlugIn;
import ij.plugin.frame.Recorder;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class PlugInFrame
extends Frame
implements PlugIn,
WindowListener,
FocusListener {
    String title;

    public PlugInFrame(String title) {
        super(title);
        Image img;
        this.enableEvents(64L);
        this.title = title;
        ImageJ ij = IJ.getInstance();
        this.addWindowListener(this);
        this.addFocusListener(this);
        if (IJ.isLinux()) {
            this.setBackground(ImageJ.backgroundColor);
        }
        if (ij != null && !IJ.isMacOSX() && (img = ij.getIconImage()) != null) {
            try {
                this.setIconImage(img);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run(String arg) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (e.getSource() == this) {
            this.close();
            if (Recorder.record) {
                Recorder.record("run", "Close");
            }
        }
    }

    public void close() {
        this.dispose();
        WindowManager.removeWindow(this);
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (Prefs.setIJMenuBar) {
            this.setMenuBar(Menus.getMenuBar());
            ++Menus.setMenuBarCount;
        }
        WindowManager.setWindow(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        WindowManager.setWindow(this);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

