/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.IOException;
import java.util.HashMap;
import loci.common.ByteArrayHandle;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.BitBuffer;
import ome.codecs.BitWriter;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.HuffmanCodecOptions;
import ome.codecs.UnsupportedCompressionException;

public class HuffmanCodec
extends BaseCodec {
    private static final int LEAVES_OFFSET = 16;
    private int leafCounter;
    private HashMap<short[], Decoder> cachedDecoders = new HashMap();

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        throw new UnsupportedCompressionException("Huffman encoding not currently supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null || !(options instanceof HuffmanCodecOptions)) {
            throw new CodecException("Options must be an instance of ome.codecs.HuffmanCodecOptions.");
        }
        HuffmanCodecOptions huffman = (HuffmanCodecOptions)options;
        int nSamples = huffman.maxBytes * 8 / huffman.bitsPerSample;
        int bytesPerSample = huffman.bitsPerSample / 8;
        if (huffman.bitsPerSample % 8 != 0) {
            ++bytesPerSample;
        }
        BitWriter out = new BitWriter();
        for (int i = 0; i < nSamples; ++i) {
            int sample = this.getSample(in, options);
            out.write(sample, bytesPerSample * 8);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getSample(BitBuffer bb, CodecOptions options) throws CodecException {
        int n;
        RandomAccessInputStream s2 = null;
        try {
            s2 = new RandomAccessInputStream(new ByteArrayHandle(bb.getByteBuffer()));
            n = this.getSample(s2, options);
        }
        catch (Throwable throwable) {
            try {
                s2.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CodecException(e);
            }
        }
        s2.close();
        return n;
    }

    public int getSample(RandomAccessInputStream bb, CodecOptions options) throws CodecException {
        if (bb == null) {
            throw new IllegalArgumentException("No data to handle.");
        }
        if (options == null || !(options instanceof HuffmanCodecOptions)) {
            throw new CodecException("Options must be an instance of ome.codecs.HuffmanCodecOptions.");
        }
        HuffmanCodecOptions huffman = (HuffmanCodecOptions)options;
        Decoder decoder = this.cachedDecoders.get(huffman.table);
        if (decoder == null) {
            decoder = new Decoder(huffman.table);
            this.cachedDecoders.put(huffman.table, decoder);
        }
        try {
            int v;
            int bitCount = decoder.decode(bb);
            if (bitCount == 16) {
                return 32768;
            }
            if (bitCount < 0) {
                bitCount = 0;
            }
            if (((v = bb.readBits(bitCount) & (int)Math.pow(2.0, bitCount) - 1) & 1 << bitCount - 1) == 0) {
                v -= (1 << bitCount) - 1;
            }
            return v;
        }
        catch (IOException e) {
            throw new CodecException(e);
        }
    }

    class Decoder {
        public Decoder[] branch = new Decoder[2];
        private int leafValue = -1;

        public Decoder() {
        }

        public Decoder(short[] source) {
            HuffmanCodec.this.leafCounter = 0;
            this.createDecoder(this, source, 0, 0);
        }

        private Decoder createDecoder(short[] source, int start, int level) {
            Decoder dest = new Decoder();
            this.createDecoder(dest, source, start, level);
            return dest;
        }

        private void createDecoder(Decoder dest, short[] source, int start, int level) {
            int i;
            int next = 0;
            for (i = 0; i <= HuffmanCodec.this.leafCounter && next < 16; i += source[start + next++] & 0xFF) {
            }
            if (level < next && next <= 16) {
                dest.branch[0] = this.createDecoder(source, start, level + 1);
                dest.branch[1] = this.createDecoder(source, start, level + 1);
            } else {
                i = start + 16 + HuffmanCodec.this.leafCounter++;
                if (i < source.length) {
                    dest.leafValue = source[i] & 0xFF;
                }
            }
        }

        public int decode(RandomAccessInputStream bb) throws IOException {
            int v;
            Decoder d = this;
            while (d.branch[0] != null && (v = bb.readBits(1)) >= 0) {
                d = d.branch[v];
            }
            return d.leafValue;
        }
    }
}

