/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.vars.gui.swing;

import icy.gui.main.GlobalSequenceListener;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.lang.Var;

public class SequenceList
extends SwingVarEditor<Sequence[]> {
    private ListSelectionListener listener;
    private GlobalSequenceListener mainListener;

    public SequenceList(Var<Sequence[]> variable) {
        super(variable);
    }

    @Override
    protected JComponent createEditorComponent() {
        final JList<Sequence> list = new JList<Sequence>();
        list.setModel(new SequenceListModel());
        this.listener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                List selection = list.getSelectedValuesList();
                Sequence[] sequences = new Sequence[selection.size()];
                for (int i = 0; i < sequences.length; ++i) {
                    sequences[i] = (Sequence)selection.get(i);
                }
                SequenceList.this.variable.setValue(sequences);
            }
        };
        this.mainListener = new GlobalSequenceListener(){

            public void sequenceClosed(Sequence sequence) {
                list.updateUI();
                list.repaint();
            }

            public void sequenceOpened(Sequence sequence) {
                list.updateUI();
                list.repaint();
            }
        };
        return list;
    }

    @Override
    public JList<Sequence> getEditorComponent() {
        return (JList)super.getEditorComponent();
    }

    @Override
    public double getComponentVerticalResizeFactor() {
        return 0.5;
    }

    @Override
    public boolean isComponentOpaque() {
        return true;
    }

    @Override
    protected void activateListeners() {
        Icy.getMainInterface().addGlobalSequenceListener(this.mainListener);
        ((JList)this.getEditorComponent()).addListSelectionListener(this.listener);
    }

    @Override
    protected void deactivateListeners() {
        Icy.getMainInterface().removeGlobalSequenceListener(this.mainListener);
        ((JList)this.getEditorComponent()).removeListSelectionListener(this.listener);
    }

    @Override
    protected void updateInterfaceValue() {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Sequence[] seqs = (Sequence[])SequenceList.this.variable.getValue();
                int[] indices = new int[seqs.length];
                for (int i = 0; i < seqs.length; ++i) {
                    indices[i] = Icy.getMainInterface().getSequences().indexOf(seqs[i]);
                }
                ((JList)SequenceList.this.getEditorComponent()).setSelectedIndices(indices);
            }
        });
    }

    private final class SequenceListModel
    extends DefaultListModel<Sequence> {
        private static final long serialVersionUID = 1L;

        private SequenceListModel() {
        }

        @Override
        public int getSize() {
            return Icy.getMainInterface().getSequences().size();
        }

        @Override
        public Sequence getElementAt(int index) {
            return (Sequence)Icy.getMainInterface().getSequences().get(index);
        }
    }
}

