/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.ShortScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort1D;
import mitiv.array.impl.StriddenShort1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.ShortGenerator;

public class FlatShort1D
extends Short1D {
    static final int order = 1;
    final short[] data;

    public FlatShort1D(int dim1) {
        super(dim1);
        this.data = new short[this.number];
    }

    public FlatShort1D(int[] dims) {
        super(dims);
        this.data = new short[this.number];
    }

    public FlatShort1D(Shape shape) {
        super(shape);
        this.data = new short[this.number];
    }

    public FlatShort1D(short[] arr, int dim1) {
        super(dim1);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatShort1D(short[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatShort1D(short[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(short[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1) {
        return i1;
    }

    @Override
    public final short get(int i1) {
        return this.data[i1];
    }

    @Override
    public final void set(int i1, short value) {
        this.data[i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(short value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextShort();
        }
    }

    @Override
    public void increment(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] - value);
        }
    }

    @Override
    public void scale(short value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = (short)(this.data[n] * value);
        }
    }

    @Override
    public void map(ShortFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        if (forceCopy) {
            short[] result = new short[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public short[] getData() {
        return this.data;
    }

    @Override
    public ShortScalar slice(int idx) {
        idx = Helper.fixIndex(idx, this.dim1);
        return new ShortScalar(this.data, idx);
    }

    @Override
    public ShortScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new ShortScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Short1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenShort1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Short1D view(int[] sel1) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        return new SelectedShort1D(this.data, idx1);
    }

    @Override
    public Short1D as1D() {
        return this;
    }
}

