/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.gui.dialog.ConfirmDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mmcorej.CMMCore;
import org.micromanager.MMOptions;
import org.micromanager.logging.LogFileManager;
import org.micromanager.utils.NumberUtils;
import org.micromanager.utils.ReportingUtils;
import org.micromanager.utils.UIMonitor;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;

public class OptionsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -6444295509604671195L;
    JTextField bufSizeField_;
    JTextField logDeleteDaysField_;
    JCheckBox storeAcquisition;
    JCheckBox hideMDAdisplay;
    JCheckBox metadataFileWithMultipageTiffCheckBox;
    JCheckBox separateFilesForPositionsMPTiffCheckBox;
    JCheckBox syncExposureMainAndMDA;
    JCheckBox debugLogEnabledCheckBox;
    JCheckBox deleteLogCheckBox;
    MMMainFrame mainFrame_;
    MMOptions opts_;
    CMMCore core_;

    public OptionsPanel(MMMainFrame mainFrame, MMOptions opts, CMMCore core) {
        this.mainFrame_ = mainFrame;
        this.opts_ = opts;
        this.core_ = core;
        this.initialize();
        this.refresh();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{16, 0, 0, 40, 0, 16, 0};
        gridBagLayout.rowHeights = new int[]{20, 23, 0, 0, 23, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_lblSequenceBufferSize = new GridBagConstraints();
        gbc_lblSequenceBufferSize.fill = 3;
        gbc_lblSequenceBufferSize.anchor = 13;
        gbc_lblSequenceBufferSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblSequenceBufferSize.gridx = 1;
        gbc_lblSequenceBufferSize.gridy = 0;
        JLabel lblSequenceBufferSize = new JLabel("Sequence buffer size");
        this.add((Component)lblSequenceBufferSize, gbc_lblSequenceBufferSize);
        this.bufSizeField_ = new JTextField(Integer.toString(this.opts_.circularBufferSizeMB_), 5);
        GridBagConstraints gbc_bufSizeField_ = new GridBagConstraints();
        gbc_bufSizeField_.fill = 1;
        gbc_bufSizeField_.insets = new Insets(0, 0, 5, 5);
        gbc_bufSizeField_.gridx = 2;
        gbc_bufSizeField_.gridy = 0;
        this.add((Component)this.bufSizeField_, gbc_bufSizeField_);
        GridBagConstraints gbc_4 = new GridBagConstraints();
        gbc_4.fill = 3;
        gbc_4.anchor = 17;
        gbc_4.insets = new Insets(0, 0, 5, 5);
        gbc_4.gridx = 3;
        gbc_4.gridy = 0;
        JLabel label_4 = new JLabel("MB");
        this.add((Component)label_4, gbc_4);
        this.separateFilesForPositionsMPTiffCheckBox = new JCheckBox();
        this.separateFilesForPositionsMPTiffCheckBox.setText("Save XY positions in separate Image stack files");
        this.separateFilesForPositionsMPTiffCheckBox.setSelected(this.opts_.mpTiffSeparateFilesForPositions_);
        this.metadataFileWithMultipageTiffCheckBox = new JCheckBox();
        this.metadataFileWithMultipageTiffCheckBox.setText("Create metadata.txt file with Image stack files");
        this.metadataFileWithMultipageTiffCheckBox.setSelected(this.opts_.mpTiffMetadataFile_);
        GridBagConstraints gbc_metadataFileWithMultipageTiffCheckBox = new GridBagConstraints();
        gbc_metadataFileWithMultipageTiffCheckBox.fill = 3;
        gbc_metadataFileWithMultipageTiffCheckBox.anchor = 17;
        gbc_metadataFileWithMultipageTiffCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_metadataFileWithMultipageTiffCheckBox.gridwidth = 4;
        gbc_metadataFileWithMultipageTiffCheckBox.gridx = 1;
        gbc_metadataFileWithMultipageTiffCheckBox.gridy = 1;
        this.add((Component)this.metadataFileWithMultipageTiffCheckBox, gbc_metadataFileWithMultipageTiffCheckBox);
        GridBagConstraints gbc_separateFilesForPositionsMPTiffCheckBox = new GridBagConstraints();
        gbc_separateFilesForPositionsMPTiffCheckBox.fill = 3;
        gbc_separateFilesForPositionsMPTiffCheckBox.anchor = 17;
        gbc_separateFilesForPositionsMPTiffCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_separateFilesForPositionsMPTiffCheckBox.gridwidth = 4;
        gbc_separateFilesForPositionsMPTiffCheckBox.gridx = 1;
        gbc_separateFilesForPositionsMPTiffCheckBox.gridy = 2;
        this.add((Component)this.separateFilesForPositionsMPTiffCheckBox, gbc_separateFilesForPositionsMPTiffCheckBox);
        this.syncExposureMainAndMDA = new JCheckBox();
        this.syncExposureMainAndMDA.setText("Sync exposure between Main and MDA windows");
        this.syncExposureMainAndMDA.setSelected(this.opts_.syncExposureMainAndMDA_);
        this.hideMDAdisplay = new JCheckBox();
        this.hideMDAdisplay.setToolTipText("Checking this option will disable image display when doing MDA");
        this.hideMDAdisplay.setText("Hide MDA (Multi Dimension Acquisition) display");
        this.hideMDAdisplay.setSelected(!this.mainFrame_.getDisplayAcquisitionSequence());
        this.hideMDAdisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsPanel.this.refresh();
            }
        });
        GridBagConstraints gbc_hideMDAdisplay = new GridBagConstraints();
        gbc_hideMDAdisplay.fill = 3;
        gbc_hideMDAdisplay.anchor = 17;
        gbc_hideMDAdisplay.insets = new Insets(0, 0, 5, 5);
        gbc_hideMDAdisplay.gridwidth = 4;
        gbc_hideMDAdisplay.gridx = 1;
        gbc_hideMDAdisplay.gridy = 3;
        this.add((Component)this.hideMDAdisplay, gbc_hideMDAdisplay);
        this.storeAcquisition = new JCheckBox("Keep last acquisition in memory");
        this.storeAcquisition.setToolTipText("Keep last acquisition in memory so it can be retrieved later (disable it for large acquisition you want to stream in file)");
        GridBagConstraints gbc_storeAcquisition = new GridBagConstraints();
        gbc_storeAcquisition.anchor = 17;
        gbc_storeAcquisition.gridwidth = 4;
        gbc_storeAcquisition.insets = new Insets(0, 0, 5, 5);
        gbc_storeAcquisition.gridx = 1;
        gbc_storeAcquisition.gridy = 4;
        this.add((Component)this.storeAcquisition, gbc_storeAcquisition);
        GridBagConstraints gbc_syncExposureMainAndMDA = new GridBagConstraints();
        gbc_syncExposureMainAndMDA.fill = 3;
        gbc_syncExposureMainAndMDA.anchor = 17;
        gbc_syncExposureMainAndMDA.insets = new Insets(0, 0, 5, 5);
        gbc_syncExposureMainAndMDA.gridwidth = 4;
        gbc_syncExposureMainAndMDA.gridx = 1;
        gbc_syncExposureMainAndMDA.gridy = 5;
        this.add((Component)this.syncExposureMainAndMDA, gbc_syncExposureMainAndMDA);
        this.deleteLogCheckBox = new JCheckBox();
        this.deleteLogCheckBox.setText("Delete log files after");
        this.deleteLogCheckBox.setSelected(this.opts_.deleteOldCoreLogs_);
        this.debugLogEnabledCheckBox = new JCheckBox();
        this.debugLogEnabledCheckBox.setText("Enable debug logging");
        this.debugLogEnabledCheckBox.setToolTipText("Enable verbose logging for troubleshooting and debugging");
        this.debugLogEnabledCheckBox.setSelected(this.opts_.debugLogEnabled_);
        GridBagConstraints gbc_debugLogEnabledCheckBox = new GridBagConstraints();
        gbc_debugLogEnabledCheckBox.fill = 3;
        gbc_debugLogEnabledCheckBox.gridwidth = 4;
        gbc_debugLogEnabledCheckBox.anchor = 17;
        gbc_debugLogEnabledCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_debugLogEnabledCheckBox.gridx = 1;
        gbc_debugLogEnabledCheckBox.gridy = 6;
        this.add((Component)this.debugLogEnabledCheckBox, gbc_debugLogEnabledCheckBox);
        GridBagConstraints gbc_deleteLogCheckBox = new GridBagConstraints();
        gbc_deleteLogCheckBox.fill = 3;
        gbc_deleteLogCheckBox.anchor = 17;
        gbc_deleteLogCheckBox.insets = new Insets(0, 0, 0, 5);
        gbc_deleteLogCheckBox.gridx = 1;
        gbc_deleteLogCheckBox.gridy = 7;
        this.add((Component)this.deleteLogCheckBox, gbc_deleteLogCheckBox);
        this.logDeleteDaysField_ = new JTextField(Integer.toString(this.opts_.deleteCoreLogAfterDays_), 3);
        GridBagConstraints gbc_logDeleteDaysField_ = new GridBagConstraints();
        gbc_logDeleteDaysField_.fill = 1;
        gbc_logDeleteDaysField_.insets = new Insets(0, 0, 0, 5);
        gbc_logDeleteDaysField_.gridx = 2;
        gbc_logDeleteDaysField_.gridy = 7;
        this.add((Component)this.logDeleteDaysField_, gbc_logDeleteDaysField_);
        GridBagConstraints gbc_7 = new GridBagConstraints();
        gbc_7.fill = 3;
        gbc_7.anchor = 17;
        gbc_7.insets = new Insets(0, 0, 0, 5);
        gbc_7.gridx = 3;
        gbc_7.gridy = 7;
        JLabel label = new JLabel("days");
        this.add((Component)label, gbc_7);
        JButton deleteLogFilesButton = new JButton();
        deleteLogFilesButton.setText("Delete Log Files Now");
        deleteLogFilesButton.setToolTipText("Delete all CoreLog files except for the current one");
        deleteLogFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String dir2;
                String dir1 = LogFileManager.getLogFileDirectory().getAbsolutePath();
                String dirs = dir1.equals(dir2 = LogFileManager.getLegacyLogFileDirectory().getAbsolutePath()) ? dir1 : dir1 + " and " + dir2;
                boolean confirm = ConfirmDialog.confirm((String)"Delete Log Files", (String)("<html><body><p style='width: 400px;'>Delete all CoreLog files in " + dirs + "?</p></body></html>"), (int)0);
                if (confirm) {
                    LogFileManager.deleteLogFilesDaysOld((int)0, (String)OptionsPanel.this.core_.getPrimaryLogFile());
                }
            }
        });
        GridBagConstraints gbc_deleteLogFilesButton = new GridBagConstraints();
        gbc_deleteLogFilesButton.insets = new Insets(0, 0, 0, 5);
        gbc_deleteLogFilesButton.fill = 3;
        gbc_deleteLogFilesButton.gridx = 4;
        gbc_deleteLogFilesButton.gridy = 7;
        this.add((Component)deleteLogFilesButton, gbc_deleteLogFilesButton);
    }

    protected void refresh() {
        if (this.hideMDAdisplay.isSelected()) {
            this.storeAcquisition.setSelected(this.mainFrame_.getStoreLastAcquisition());
            this.storeAcquisition.setEnabled(true);
        } else {
            this.storeAcquisition.setSelected(true);
            this.storeAcquisition.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int deleteLogDays;
        int seqBufSize;
        int oldBufsize = this.opts_.circularBufferSizeMB_;
        try {
            seqBufSize = NumberUtils.displayStringToInt((Object)this.bufSizeField_.getText());
            deleteLogDays = NumberUtils.displayStringToInt((Object)this.logDeleteDaysField_.getText());
        }
        catch (ParseException ex) {
            ReportingUtils.showError((Throwable)ex);
            return;
        }
        this.opts_.circularBufferSizeMB_ = seqBufSize;
        this.opts_.deleteCoreLogAfterDays_ = deleteLogDays;
        this.opts_.mpTiffSeparateFilesForPositions_ = this.separateFilesForPositionsMPTiffCheckBox.isSelected();
        this.opts_.mpTiffMetadataFile_ = this.metadataFileWithMultipageTiffCheckBox.isSelected();
        this.opts_.syncExposureMainAndMDA_ = this.syncExposureMainAndMDA.isSelected();
        this.opts_.deleteOldCoreLogs_ = this.deleteLogCheckBox.isSelected();
        this.opts_.debugLogEnabled_ = this.debugLogEnabledCheckBox.isSelected();
        this.core_.enableDebugLog(this.opts_.debugLogEnabled_);
        UIMonitor.enable((boolean)this.opts_.debugLogEnabled_);
        this.opts_.saveSettings();
        if (oldBufsize != this.opts_.circularBufferSizeMB_) {
            try {
                this.core_.setCircularBufferMemoryFootprint((long)this.opts_.circularBufferSizeMB_);
            }
            catch (Exception exc) {
                ReportingUtils.showError((Throwable)exc);
            }
        }
        this.mainFrame_.setDisplayAcquisitionSequence(!this.hideMDAdisplay.isSelected());
        if (this.storeAcquisition.isEnabled()) {
            this.mainFrame_.setStoreLastAcquisition(this.storeAcquisition.isSelected());
        } else {
            this.mainFrame_.setStoreLastAcquisition(true);
        }
    }
}

