/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.common.listener.ProgressListener;
import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.painter.Overlay;
import icy.roi.BooleanMask2D;
import icy.roi.ROI;
import icy.sequence.DimensionId;
import icy.sequence.MetaDataUtil;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;
import icy.type.rectangle.Rectangle5D;
import icy.util.OMEUtil;
import icy.util.StringUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ome.xml.meta.MetadataRetrieve;
import ome.xml.meta.OMEXMLMetadata;

public class SequenceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addT(Sequence sequence, int t, int num, int copyLast) {
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        sequence.beginUpdate();
        try {
            SequenceUtil.moveT(sequence, t, sizeT - 1, num);
            for (int i = 0; i < num; ++i) {
                for (int z = 0; z < sizeZ; ++z) {
                    sequence.setImage(t + i, z, (BufferedImage)IcyBufferedImageUtil.getCopy(AddTHelper.getExtendedImage(sequence, t + i, z, t, num, copyLast)));
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static void addT(Sequence sequence, int t, int num) {
        SequenceUtil.addT(sequence, t, num, 0);
    }

    public static void addT(Sequence sequence, int num) {
        SequenceUtil.addT(sequence, sequence.getSizeT(), num, 0);
    }

    public static void addT(Sequence sequence, int num, boolean copyLast) {
        SequenceUtil.addT(sequence, sequence.getSizeT(), num, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapT(Sequence sequence, int t1, int t2) {
        int sizeT = sequence.getSizeT();
        if (t1 < 0 || t2 < 0 || t1 >= sizeT || t2 >= sizeT) {
            return;
        }
        VolumetricImage vi1 = sequence.getVolumetricImage(t1);
        VolumetricImage vi2 = sequence.getVolumetricImage(t2);
        sequence.beginUpdate();
        try {
            TreeMap<Integer, IcyBufferedImage> images;
            sequence.removeAllImages(t1);
            sequence.removeAllImages(t2);
            if (vi1 != null) {
                images = vi1.getImages();
                for (Map.Entry entry : images.entrySet()) {
                    sequence.setImage(t2, (int)((Integer)entry.getKey()), (BufferedImage)entry.getValue());
                }
            }
            if (vi2 != null) {
                images = vi2.getImages();
                for (Map.Entry entry : images.entrySet()) {
                    sequence.setImage(t1, (int)((Integer)entry.getKey()), (BufferedImage)entry.getValue());
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveT(Sequence sequence, int t, int newT) {
        int sizeT = sequence.getSizeT();
        if (t < 0 || t >= sizeT || newT < 0 || t == newT) {
            return;
        }
        VolumetricImage vi = sequence.getVolumetricImage(t);
        sequence.beginUpdate();
        try {
            sequence.removeAllImages(newT);
            if (vi != null) {
                TreeMap<Integer, IcyBufferedImage> images = vi.getImages();
                for (Map.Entry<Integer, IcyBufferedImage> entry : images.entrySet()) {
                    sequence.setImage(newT, (int)entry.getKey(), (BufferedImage)entry.getValue());
                }
                sequence.removeAllImages(t);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveT(Sequence sequence, int from, int to, int offset) {
        sequence.beginUpdate();
        try {
            if (offset > 0) {
                for (int t = to; t >= from; --t) {
                    SequenceUtil.moveT(sequence, t, t + offset);
                }
            } else {
                for (int t = from; t <= to; ++t) {
                    SequenceUtil.moveT(sequence, t, t + offset);
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static void removeT(Sequence sequence, int t) {
        int sizeT = sequence.getSizeT();
        if (t < 0 || t >= sizeT) {
            return;
        }
        sequence.removeAllImages(t);
    }

    public static void removeTAndShift(Sequence sequence, int t) {
        int sizeT = sequence.getSizeT();
        if (t < 0 || t >= sizeT) {
            return;
        }
        sequence.beginUpdate();
        try {
            SequenceUtil.removeT(sequence, t);
            SequenceUtil.moveT(sequence, t + 1, sizeT - 1, -1);
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverseT(Sequence sequence) {
        int z;
        int t;
        int sizeT = sequence.getSizeT();
        int sizeZ = sequence.getSizeZ();
        Sequence save = new Sequence();
        save.beginUpdate();
        try {
            for (t = 0; t < sizeT; ++t) {
                for (z = 0; z < sizeZ; ++z) {
                    save.setImage(t, z, (BufferedImage)sequence.getImage(t, z));
                }
            }
        }
        finally {
            save.endUpdate();
        }
        sequence.beginUpdate();
        try {
            sequence.removeAllImages();
            for (t = 0; t < sizeT; ++t) {
                for (z = 0; z < sizeZ; ++z) {
                    sequence.setImage(sizeT - (t + 1), z, (BufferedImage)save.getImage(t, z));
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
        save.removeAllImages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addZ(Sequence sequence, int z, int num, int copyLast) {
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        sequence.beginUpdate();
        try {
            SequenceUtil.moveZ(sequence, z, sizeZ - 1, num);
            for (int i = 0; i < num; ++i) {
                for (int t = 0; t < sizeT; ++t) {
                    sequence.setImage(t, z + i, (BufferedImage)IcyBufferedImageUtil.getCopy(AddZHelper.getExtendedImage(sequence, t, z + i, z, num, copyLast)));
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static void addZ(Sequence sequence, int z, int num) {
        SequenceUtil.addZ(sequence, z, num, 0);
    }

    public static void addZ(Sequence sequence, int num) {
        SequenceUtil.addZ(sequence, sequence.getSizeZ(), num, 0);
    }

    public static void addZ(Sequence sequence, int num, boolean copyLast) {
        SequenceUtil.addZ(sequence, sequence.getSizeZ(), num, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void swapZ(Sequence sequence, int z1, int z2) {
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        if (z1 < 0 || z2 < 0 || z1 >= sizeZ || z2 >= sizeZ) {
            return;
        }
        sequence.beginUpdate();
        try {
            for (int t = 0; t < sizeT; ++t) {
                IcyBufferedImage image1 = sequence.getImage(t, z1);
                IcyBufferedImage image2 = sequence.getImage(t, z2);
                if (image1 != null) {
                    sequence.setImage(t, z2, (BufferedImage)image1);
                } else {
                    sequence.removeImage(t, z2);
                }
                if (image2 != null) {
                    sequence.setImage(t, z1, (BufferedImage)image2);
                    continue;
                }
                sequence.removeImage(t, z1);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveZ(Sequence sequence, int z, int newZ) {
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        if (z < 0 || z >= sizeZ || newZ < 0 || z == newZ) {
            return;
        }
        sequence.beginUpdate();
        try {
            for (int t = 0; t < sizeT; ++t) {
                IcyBufferedImage image = sequence.getImage(t, z);
                if (image != null) {
                    sequence.setImage(t, newZ, (BufferedImage)image);
                    sequence.removeImage(t, z);
                    continue;
                }
                sequence.removeImage(t, newZ);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveZ(Sequence sequence, int from, int to, int offset) {
        sequence.beginUpdate();
        try {
            if (offset > 0) {
                for (int z = to; z >= from; --z) {
                    SequenceUtil.moveZ(sequence, z, z + offset);
                }
            } else {
                for (int z = from; z <= to; ++z) {
                    SequenceUtil.moveZ(sequence, z, z + offset);
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeZ(Sequence sequence, int z) {
        int sizeZ = sequence.getSizeZ();
        if (z < 0 || z >= sizeZ) {
            return;
        }
        sequence.beginUpdate();
        try {
            int maxT = sequence.getSizeT();
            for (int t = 0; t < maxT; ++t) {
                sequence.removeImage(t, z);
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static void removeZAndShift(Sequence sequence, int z) {
        int sizeZ = sequence.getSizeZ();
        if (z < 0 || z >= sizeZ) {
            return;
        }
        sequence.beginUpdate();
        try {
            SequenceUtil.removeZ(sequence, z);
            SequenceUtil.moveZ(sequence, z + 1, sizeZ - 1, -1);
        }
        finally {
            sequence.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reverseZ(Sequence sequence) {
        int z;
        int t;
        int sizeT = sequence.getSizeT();
        int sizeZ = sequence.getSizeZ();
        Sequence save = new Sequence();
        save.beginUpdate();
        try {
            for (t = 0; t < sizeT; ++t) {
                for (z = 0; z < sizeZ; ++z) {
                    save.setImage(t, z, (BufferedImage)sequence.getImage(t, z));
                }
            }
        }
        finally {
            save.endUpdate();
        }
        sequence.beginUpdate();
        try {
            sequence.removeAllImages();
            for (t = 0; t < sizeT; ++t) {
                for (z = 0; z < sizeZ; ++z) {
                    sequence.setImage(t, sizeZ - (z + 1), (BufferedImage)save.getImage(t, z));
                }
            }
        }
        finally {
            sequence.endUpdate();
        }
        save.removeAllImages();
    }

    public static void convertToTime(Sequence sequence) {
        sequence.beginUpdate();
        try {
            ArrayList<IcyBufferedImage> images = sequence.getAllImage();
            sequence.removeAllImages();
            for (int i = 0; i < images.size(); ++i) {
                sequence.setImage(i, 0, (BufferedImage)images.get(i));
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static void convertToStack(Sequence sequence) {
        sequence.beginUpdate();
        try {
            ArrayList<IcyBufferedImage> images = sequence.getAllImage();
            sequence.removeAllImages();
            for (int i = 0; i < images.size(); ++i) {
                sequence.setImage(0, i, (BufferedImage)images.get(i));
            }
        }
        finally {
            sequence.endUpdate();
        }
    }

    @Deprecated
    public static void convertToVolume(Sequence sequence) {
        SequenceUtil.convertToStack(sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChannel(Sequence source, int channel) {
        int sizeC = source.getSizeC();
        if (channel >= sizeC) {
            return;
        }
        int[] keep = new int[sizeC - 1];
        int i = 0;
        for (int c = 0; c < sizeC; ++c) {
            if (c == channel) continue;
            keep[i++] = c;
        }
        Sequence tmp = SequenceUtil.extractChannels(source, keep);
        source.beginUpdate();
        try {
            source.removeAllImages();
            for (int t = 0; t < tmp.getSizeT(); ++t) {
                for (int z = 0; z < tmp.getSizeZ(); ++z) {
                    source.setImage(t, z, (BufferedImage)tmp.getImage(t, z));
                }
            }
            source.setMetaData(tmp.getOMEXMLMetadata());
            for (int c = 0; c < tmp.getSizeC(); ++c) {
                source.setDefaultColormap(c, tmp.getDefaultColorMap(c), false);
            }
            tmp.removeAllImages();
        }
        finally {
            source.endUpdate();
        }
    }

    public static int getMaxDim(Sequence[] sequences, DimensionId dim) {
        int result = 0;
        block7: for (Sequence seq : sequences) {
            switch (dim) {
                case X: {
                    result = Math.max(result, seq.getSizeX());
                    continue block7;
                }
                case Y: {
                    result = Math.max(result, seq.getSizeY());
                    continue block7;
                }
                case C: {
                    result = Math.max(result, seq.getSizeC());
                    continue block7;
                }
                case Z: {
                    result = Math.max(result, seq.getSizeZ());
                    continue block7;
                }
                case T: {
                    result = Math.max(result, seq.getSizeT());
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported dimension: " + (Object)((Object)dim));
                }
            }
        }
        return result;
    }

    public static Sequence concatC(Sequence[] sequences, int[] channels, boolean fillEmpty, boolean rescale, ProgressListener pl) throws IllegalArgumentException {
        int sizeX = SequenceUtil.getMaxDim(sequences, DimensionId.X);
        int sizeY = SequenceUtil.getMaxDim(sequences, DimensionId.Y);
        int sizeZ = SequenceUtil.getMaxDim(sequences, DimensionId.Z);
        int sizeT = SequenceUtil.getMaxDim(sequences, DimensionId.T);
        Sequence result = new Sequence();
        if (sequences.length > 0) {
            result.setMetaData(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequences[0].getOMEXMLMetadata(), true));
        }
        result.setName("C Merge");
        int ind = 0;
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                if (pl != null) {
                    pl.notifyProgress(ind, sizeT * sizeZ);
                }
                result.setImage(t, z, (BufferedImage)MergeCHelper.getImage(sequences, channels, sizeX, sizeY, t, z, fillEmpty, rescale));
                ++ind;
            }
        }
        for (int i = 0; i < sequences.length; ++i) {
            int c = channels[i];
            Sequence seq = sequences[i];
            if (c >= seq.getSizeC()) continue;
            String channelName = seq.getChannelName(c);
            IcyColorMap channelColor = seq.getColorMap(c);
            if (!StringUtil.equals(seq.getDefaultChannelName(c), channelName)) {
                result.setChannelName(i, channelName);
            }
            if (channelColor.equals(LinearColorMap.white_)) continue;
            result.setColormap(i, channelColor, true);
        }
        return result;
    }

    public static Sequence concatC(Sequence[] sequences, boolean fillEmpty, boolean rescale, ProgressListener pl) {
        int len = 0;
        for (Sequence s : sequences) {
            len += s.getSizeC();
        }
        Sequence[] newSequences = new Sequence[len];
        int[] channels = new int[len];
        int ind = 0;
        for (Sequence s : sequences) {
            int c = 0;
            while (c < s.getSizeC()) {
                newSequences[ind] = s;
                channels[ind] = c++;
                ++ind;
            }
        }
        return SequenceUtil.concatC(newSequences, channels, fillEmpty, rescale, pl);
    }

    public static Sequence concatC(Sequence[] sequences, boolean fillEmpty, boolean rescale) {
        return SequenceUtil.concatC(sequences, fillEmpty, rescale, null);
    }

    public static Sequence concatC(Sequence[] sequences) {
        return SequenceUtil.concatC(sequences, true, false, null);
    }

    public static Sequence concatZ(Sequence[] sequences, boolean interlaced, boolean fillEmpty, boolean rescale, ProgressListener pl) {
        int sizeX = SequenceUtil.getMaxDim(sequences, DimensionId.X);
        int sizeY = SequenceUtil.getMaxDim(sequences, DimensionId.Y);
        int sizeC = SequenceUtil.getMaxDim(sequences, DimensionId.C);
        int sizeT = SequenceUtil.getMaxDim(sequences, DimensionId.T);
        int sizeZ = 0;
        for (Sequence seq : sequences) {
            sizeZ += seq.getSizeZ();
        }
        Sequence result = new Sequence();
        if (sequences.length > 0) {
            result.setMetaData(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequences[0].getOMEXMLMetadata(), true));
        }
        result.setName("Z Merge");
        int ind = 0;
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                if (pl != null) {
                    pl.notifyProgress(ind, sizeT * sizeZ);
                }
                result.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.getCopy(MergeZHelper.getImage(sequences, sizeX, sizeY, sizeC, t, z, interlaced, fillEmpty, rescale)));
                ++ind;
            }
        }
        return result;
    }

    public static Sequence concatZ(Sequence[] sequences, boolean interlaced, boolean fillEmpty, boolean rescale) {
        return SequenceUtil.concatZ(sequences, interlaced, fillEmpty, rescale, null);
    }

    public static Sequence concatZ(Sequence[] sequences) {
        return SequenceUtil.concatZ(sequences, false, true, false, null);
    }

    public static Sequence concatT(Sequence[] sequences, boolean interlaced, boolean fillEmpty, boolean rescale, ProgressListener pl) {
        int sizeX = SequenceUtil.getMaxDim(sequences, DimensionId.X);
        int sizeY = SequenceUtil.getMaxDim(sequences, DimensionId.Y);
        int sizeC = SequenceUtil.getMaxDim(sequences, DimensionId.C);
        int sizeZ = SequenceUtil.getMaxDim(sequences, DimensionId.Z);
        int sizeT = 0;
        for (Sequence seq : sequences) {
            sizeT += seq.getSizeT();
        }
        Sequence result = new Sequence();
        if (sequences.length > 0) {
            result.setMetaData(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)sequences[0].getOMEXMLMetadata(), true));
        }
        result.setName("T Merge");
        int ind = 0;
        for (int t = 0; t < sizeT; ++t) {
            for (int z = 0; z < sizeZ; ++z) {
                if (pl != null) {
                    pl.notifyProgress(ind, sizeT * sizeZ);
                }
                result.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.getCopy(MergeTHelper.getImage(sequences, sizeX, sizeY, sizeC, t, z, interlaced, fillEmpty, rescale)));
                ++ind;
            }
        }
        return result;
    }

    public static Sequence concatT(Sequence[] sequences, boolean interlaced, boolean fillEmpty, boolean rescale) {
        return SequenceUtil.concatT(sequences, interlaced, fillEmpty, rescale, null);
    }

    public static Sequence concatT(Sequence[] sequences) {
        return SequenceUtil.concatT(sequences, false, true, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustZT(Sequence sequence, int newSizeZ, int newSizeT, boolean reverseOrder) {
        int sizeZ = sequence.getSizeZ();
        int sizeT = sequence.getSizeT();
        Sequence tmp = new Sequence();
        tmp.beginUpdate();
        sequence.beginUpdate();
        try {
            int z;
            int t;
            try {
                for (t = 0; t < sizeT; ++t) {
                    for (z = 0; z < sizeZ; ++z) {
                        tmp.setImage(t, z, (BufferedImage)sequence.getImage(t, z));
                        sequence.removeImage(t, z);
                    }
                }
            }
            finally {
                tmp.endUpdate();
            }
            for (t = 0; t < newSizeT; ++t) {
                for (z = 0; z < newSizeZ; ++z) {
                    sequence.setImage(t, z, (BufferedImage)AdjustZTHelper.getImage(tmp, t, z, newSizeZ, newSizeT, reverseOrder));
                }
            }
            tmp.removeAllImages();
        }
        finally {
            sequence.endUpdate();
        }
    }

    public static Sequence extractChannel(Sequence source, int channel) {
        return SequenceUtil.extractChannels(source, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Sequence extractChannels(Sequence source, List<Integer> channels) {
        Sequence outSequence = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        outSequence.beginUpdate();
        try {
            for (int t = 0; t < source.getSizeT(); ++t) {
                for (int z = 0; z < source.getSizeZ(); ++z) {
                    outSequence.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.extractChannels(source.getImage(t, z), channels));
                }
            }
        }
        finally {
            outSequence.endUpdate();
        }
        if (channels.size() > 1) {
            String s = "";
            for (int i = 0; i < channels.size(); ++i) {
                s = s + " " + channels.get(i).toString();
            }
            outSequence.setName(source.getName() + " (channels" + s + ")");
        } else if (channels.size() == 1) {
            outSequence.setName(source.getName() + " (" + source.getChannelName(channels.get(0)) + ")");
        }
        int c = 0;
        for (Integer i : channels) {
            outSequence.setChannelName(c, source.getChannelName(i));
            ++c;
        }
        return outSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence extractChannels(Sequence source, int ... channels) {
        Sequence outSequence = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        int sizeT = source.getSizeT();
        int sizeZ = source.getSizeZ();
        int sizeC = source.getSizeC();
        outSequence.beginUpdate();
        try {
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    outSequence.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.extractChannels(source.getImage(t, z), channels));
                }
            }
        }
        finally {
            outSequence.endUpdate();
        }
        OMEXMLMetadata metadata = outSequence.getOMEXMLMetadata();
        for (int ch = MetaDataUtil.getNumChannel(metadata, 0) - 1; ch >= 0; --ch) {
            boolean remove = true;
            int[] nArray = channels;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2 = nArray[i];
                if (i2 != ch) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            MetaDataUtil.removeChannel(metadata, 0, ch);
        }
        if (channels.length > 1) {
            String s = "";
            for (int i = 0; i < channels.length; ++i) {
                s = s + " " + channels[i];
            }
            outSequence.setName(source.getName() + " (channels" + s + ")");
        } else if (channels.length == 1) {
            outSequence.setName(source.getName() + " (" + source.getChannelName(channels[0]) + ")");
        }
        int c = 0;
        for (int channel : channels) {
            if (channel < sizeC) {
                outSequence.setChannelName(c, source.getChannelName(channel));
                outSequence.setDefaultColormap(c, source.getDefaultColorMap(channel), false);
            }
            ++c;
        }
        return outSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence extractSlice(Sequence source, int z) {
        OMEXMLMetadata metadata = OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true);
        Sequence outSequence = new Sequence(metadata);
        MetaDataUtil.keepPlanes(metadata, 0, -1, z, -1);
        outSequence.beginUpdate();
        try {
            for (int t = 0; t < source.getSizeT(); ++t) {
                outSequence.setImage(t, 0, (BufferedImage)IcyBufferedImageUtil.getCopy(source.getImage(t, z)));
            }
        }
        finally {
            outSequence.endUpdate();
        }
        outSequence.setName(source.getName() + " (slice " + z + ")");
        return outSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence extractFrame(Sequence source, int t) {
        OMEXMLMetadata metadata = OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true);
        Sequence outSequence = new Sequence(metadata);
        MetaDataUtil.keepPlanes(metadata, 0, t, -1, -1);
        outSequence.beginUpdate();
        try {
            for (int z = 0; z < source.getSizeZ(); ++z) {
                outSequence.setImage(0, z, (BufferedImage)IcyBufferedImageUtil.getCopy(source.getImage(t, z)));
            }
        }
        finally {
            outSequence.endUpdate();
        }
        outSequence.setName(source.getName() + " (frame " + t + ")");
        return outSequence;
    }

    public static Sequence convertToType(Sequence source, DataType dataType, boolean rescale, boolean useDataBounds) {
        if (source == null) {
            return null;
        }
        if (!rescale) {
            return SequenceUtil.convertType(source, dataType, null);
        }
        double[] boundsDst = dataType.getDefaultBounds();
        int sizeC = source.getSizeC();
        Scaler[] scalers = new Scaler[sizeC];
        for (int c = 0; c < sizeC; ++c) {
            double[] boundsSrc;
            if (useDataBounds) {
                source.loadAllData();
                boundsSrc = source.getChannelBounds(c);
            } else {
                boundsSrc = source.getChannelTypeBounds(c);
            }
            scalers[c] = new Scaler(boundsSrc[0], boundsSrc[1], boundsDst[0], boundsDst[1], false);
        }
        return SequenceUtil.convertType(source, dataType, scalers);
    }

    public static Sequence convertToType(Sequence source, DataType dataType, boolean rescale) {
        return SequenceUtil.convertToType(source, dataType, rescale, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static Sequence convertToType(Sequence source, DataType dataType, Scaler scaler) {
        Sequence output = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        output.beginUpdate();
        try {
            for (int t = 0; t < source.getSizeT(); ++t) {
                for (int z = 0; z < source.getSizeZ(); ++z) {
                    IcyBufferedImage converted = IcyBufferedImageUtil.convertToType(source.getImage(t, z), dataType, scaler);
                    output.setImage(t, z, (BufferedImage)converted);
                }
            }
            output.setName(source.getName() + " (" + (Object)((Object)output.getDataType_()) + ")");
        }
        finally {
            output.endUpdate();
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence convertType(Sequence source, DataType dataType, Scaler[] scalers) {
        Sequence output = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        output.beginUpdate();
        try {
            for (int t = 0; t < source.getSizeT(); ++t) {
                for (int z = 0; z < source.getSizeZ(); ++z) {
                    IcyBufferedImage converted = IcyBufferedImageUtil.convertType(source.getImage(t, z), dataType, scalers);
                    output.setImage(t, z, (BufferedImage)converted);
                }
            }
        }
        finally {
            output.endUpdate();
        }
        for (int c = 0; c < source.getSizeC(); ++c) {
            output.setChannelName(c, source.getChannelName(c));
            output.setDefaultColormap(c, source.getDefaultColorMap(c), true);
            output.setColormap(c, source.getColorMap(c));
        }
        output.setName(source.getName() + " (" + (Object)((Object)output.getDataType_()) + ")");
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence rotate(Sequence source, double xOrigin, double yOrigin, double angle, IcyBufferedImageUtil.FilterType filterType) {
        int sizeT = source.getSizeT();
        int sizeZ = source.getSizeZ();
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        result.beginUpdate();
        try {
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    result.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.rotate(source.getImage(t, z), xOrigin, yOrigin, angle, filterType));
                }
            }
        }
        finally {
            result.endUpdate();
        }
        for (int c = 0; c < source.getSizeC(); ++c) {
            result.setChannelName(c, source.getChannelName(c));
            result.setDefaultColormap(c, source.getDefaultColorMap(c), true);
            result.setColormap(c, source.getColorMap(c));
        }
        result.setName(source.getName() + " (rotated)");
        return result;
    }

    public static Sequence rotate(Sequence source, double angle, IcyBufferedImageUtil.FilterType filterType) {
        if (source == null) {
            return null;
        }
        return SequenceUtil.rotate(source, (double)source.getSizeX() / 2.0, (double)source.getSizeY() / 2.0, angle, filterType);
    }

    public static Sequence rotate(Sequence source, double angle) {
        if (source == null) {
            return null;
        }
        return SequenceUtil.rotate(source, (double)source.getSizeX() / 2.0, (double)source.getSizeY() / 2.0, angle, IcyBufferedImageUtil.FilterType.BILINEAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence scale(Sequence source, int width, int height, boolean resizeContent, int xAlign, int yAlign, IcyBufferedImageUtil.FilterType filterType) {
        int sizeT = source.getSizeT();
        int sizeZ = source.getSizeZ();
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        result.beginUpdate();
        try {
            for (int t = 0; t < sizeT; ++t) {
                for (int z = 0; z < sizeZ; ++z) {
                    result.setImage(t, z, (BufferedImage)IcyBufferedImageUtil.scale(source.getImage(t, z), width, height, resizeContent, xAlign, yAlign, filterType));
                }
            }
        }
        finally {
            result.endUpdate();
        }
        for (int c = 0; c < source.getSizeC(); ++c) {
            result.setChannelName(c, source.getChannelName(c));
            result.setDefaultColormap(c, source.getDefaultColorMap(c), true);
            result.setColormap(c, source.getColorMap(c));
        }
        result.setName(source.getName() + " (resized)");
        if (resizeContent) {
            double sx = (double)source.getSizeX() / (double)result.getSizeX();
            double sy = (double)source.getSizeY() / (double)result.getSizeY();
            if (sx != 0.0 && !Double.isInfinite(sx)) {
                result.setPixelSizeX(result.getPixelSizeX() * sx);
            }
            if (sy != 0.0 && !Double.isInfinite(sy)) {
                result.setPixelSizeY(result.getPixelSizeY() * sy);
            }
        } else {
            int yt;
            int xt;
            int dx = width - source.getWidth();
            switch (xAlign) {
                default: {
                    xt = 0;
                    break;
                }
                case 0: {
                    xt = dx / 2;
                    break;
                }
                case 4: {
                    xt = dx;
                }
            }
            int dy = height - source.getHeight();
            switch (yAlign) {
                default: {
                    yt = 0;
                    break;
                }
                case 0: {
                    yt = dy / 2;
                    break;
                }
                case 3: {
                    yt = dy;
                }
            }
            result.setPositionX(source.getPositionX() - (double)xt * source.getPixelSizeX());
            result.setPositionY(source.getPositionY() - (double)yt * source.getPixelSizeY());
        }
        return result;
    }

    public static Sequence scale(Sequence source, int width, int height, boolean resizeContent, int xAlign, int yAlign) {
        return SequenceUtil.scale(source, width, height, resizeContent, xAlign, yAlign, IcyBufferedImageUtil.FilterType.BILINEAR);
    }

    public static Sequence scale(Sequence source, int width, int height, IcyBufferedImageUtil.FilterType filterType) {
        return SequenceUtil.scale(source, width, height, true, 0, 0, filterType);
    }

    public static Sequence scale(Sequence source, int width, int height) {
        return SequenceUtil.scale(source, width, height, IcyBufferedImageUtil.FilterType.BILINEAR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence getSubSequence(Sequence source, Rectangle5D.Integer region) {
        int endC;
        int startC;
        int endT;
        int startT;
        int endZ;
        int startZ;
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        Rectangle region2d = region.toRectangle2D().getBounds();
        if (region.isInfiniteZ()) {
            startZ = 0;
            endZ = source.getSizeZ();
        } else {
            startZ = Math.max(0, region.z);
            endZ = Math.min(source.getSizeZ(), region.z + region.sizeZ);
        }
        if (region.isInfiniteT()) {
            startT = 0;
            endT = source.getSizeT();
        } else {
            startT = Math.max(0, region.t);
            endT = Math.min(source.getSizeT(), region.t + region.sizeT);
        }
        if (region.isInfiniteC()) {
            startC = 0;
            endC = source.getSizeC();
        } else {
            startC = Math.max(0, region.c);
            endC = Math.min(source.getSizeC(), region.c + region.sizeC);
        }
        result.beginUpdate();
        try {
            for (int t = startT; t < endT; ++t) {
                for (int z = startZ; z < endZ; ++z) {
                    IcyBufferedImage img = source.getImage(t, z);
                    if (img != null) {
                        img = IcyBufferedImageUtil.getSubImage(img, region2d, startC, endC - startC);
                    }
                    result.setImage(t - startT, z - startZ, (BufferedImage)img);
                }
            }
        }
        finally {
            result.endUpdate();
        }
        for (int c = startC; c < endC; ++c) {
            result.setChannelName(c - startC, source.getChannelName(c));
            result.setDefaultColormap(c - startC, source.getDefaultColorMap(c), true);
            result.setColormap(c - startC, source.getColorMap(c));
        }
        result.setName(source.getName() + " (crop)");
        result.setPositionX(source.getPositionX() + (double)region2d.x * source.getPixelSizeX());
        result.setPositionY(source.getPositionY() + (double)region2d.y * source.getPixelSizeY());
        result.setPositionZ(source.getPositionZ() + (double)startZ * source.getPixelSizeZ());
        double startTOffset = source.getPositionTOffset(0, 0, 0);
        double curTOffset = source.getPositionTOffset(startT, startZ, startC);
        result.setTimeStamp(source.getTimeStamp() + (long)((curTOffset - startTOffset) * 1000.0));
        return result;
    }

    @Deprecated
    public static Sequence getSubSequence(Sequence source, int startX, int startY, int startC, int startZ, int startT, int sizeX, int sizeY, int sizeC, int sizeZ, int sizeT) {
        return SequenceUtil.getSubSequence(source, new Rectangle5D.Integer(startX, startY, startZ, startT, startC, sizeX, sizeY, sizeZ, sizeT, sizeC));
    }

    @Deprecated
    public static Sequence getSubSequence(Sequence source, int startX, int startY, int startZ, int startT, int sizeX, int sizeY, int sizeZ, int sizeT) {
        return SequenceUtil.getSubSequence(source, startX, startY, 0, startZ, startT, sizeX, sizeY, source.getSizeC(), sizeZ, sizeT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence getSubSequence(Sequence source, ROI roi, double nullValue) {
        Rectangle5D.Integer bounds = roi.getBounds5D().toInteger();
        Sequence result = SequenceUtil.getSubSequence(source, bounds);
        if (!Double.isNaN(nullValue)) {
            int offX = bounds.x == Integer.MIN_VALUE ? 0 : bounds.x;
            int offY = bounds.y == Integer.MIN_VALUE ? 0 : bounds.y;
            int offZ = bounds.z == Integer.MIN_VALUE ? 0 : bounds.z;
            int offT = bounds.t == Integer.MIN_VALUE ? 0 : bounds.t;
            int offC = bounds.c == Integer.MIN_VALUE ? 0 : bounds.c;
            int sizeX = result.getSizeX();
            int sizeY = result.getSizeY();
            int sizeZ = result.getSizeZ();
            int sizeT = result.getSizeT();
            int sizeC = result.getSizeC();
            DataType dataType = result.getDataType_();
            result.beginUpdate();
            try {
                for (int t = 0; t < sizeT; ++t) {
                    for (int z = 0; z < sizeZ; ++z) {
                        for (int c = 0; c < sizeC; ++c) {
                            BooleanMask2D mask = roi.getBooleanMask2D(z + offZ, t + offT, c + offC, false);
                            IcyBufferedImage img = result.getImage(t, z);
                            img.lockRaster();
                            try {
                                Object data = img.getDataXY(c);
                                int offset = 0;
                                for (int y = 0; y < sizeY; ++y) {
                                    int x = 0;
                                    while (x < sizeX) {
                                        if (!mask.contains(x + offX, y + offY)) {
                                            Array1DUtil.setValue(data, offset, dataType, nullValue);
                                        }
                                        ++x;
                                        ++offset;
                                    }
                                }
                            }
                            finally {
                                img.releaseRaster(true);
                            }
                            img.dataChanged();
                        }
                    }
                }
            }
            finally {
                result.endUpdate();
            }
        }
        return result;
    }

    public static Sequence getSubSequence(Sequence source, ROI roi) {
        return SequenceUtil.getSubSequence(source, roi, Double.NaN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sequence getCopy(Sequence source, boolean copyROI, boolean copyOverlay, boolean nameSuffix) {
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        result.beginUpdate();
        try {
            result.copyDataFrom(source);
            if (copyROI) {
                for (ROI roi : source.getROIs()) {
                    result.addROI(roi);
                }
            }
            if (copyOverlay) {
                for (Overlay overlay : source.getOverlays()) {
                    result.addOverlay(overlay);
                }
            }
        }
        finally {
            result.endUpdate();
        }
        for (int c = 0; c < source.getSizeC(); ++c) {
            result.setChannelName(c, source.getChannelName(c));
            result.setDefaultColormap(c, source.getDefaultColorMap(c), true);
            result.setColormap(c, source.getColorMap(c));
        }
        if (nameSuffix) {
            result.setName(source.getName() + " (copy)");
        }
        return result;
    }

    public static Sequence getCopy(Sequence source) {
        return SequenceUtil.getCopy(source, false, false, true);
    }

    public static Sequence toGray(Sequence source) {
        return SequenceUtil.convertColor(source, 10, null);
    }

    public static Sequence toRGB(Sequence source) {
        return SequenceUtil.convertColor(source, 1, null);
    }

    public static Sequence toARGB(Sequence source) {
        return SequenceUtil.convertColor(source, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Sequence convertColor(Sequence source, int imageType, LUT lut) {
        Sequence result = new Sequence(OMEUtil.createOMEXMLMetadata((MetadataRetrieve)source.getOMEXMLMetadata(), true));
        BufferedImage imgOut = new BufferedImage(source.getSizeX(), source.getSizeY(), imageType);
        result.beginUpdate();
        try {
            for (int t = 0; t < source.getSizeT(); ++t) {
                for (int z = 0; z < source.getSizeZ(); ++z) {
                    result.setImage(t, z, IcyBufferedImageUtil.toBufferedImage(source.getImage(t, z), imgOut, lut));
                }
            }
            switch (imageType) {
                default: {
                    result.setChannelName(0, "red");
                    result.setChannelName(1, "green");
                    result.setChannelName(2, "blue");
                    result.setChannelName(3, "alpha");
                    result.setName(source.getName() + " (ARGB rendering)");
                    return result;
                }
                case 1: {
                    result.setChannelName(0, "red");
                    result.setChannelName(1, "green");
                    result.setChannelName(2, "blue");
                    result.setName(source.getName() + " (RGB rendering)");
                    return result;
                }
                case 10: {
                    result.setChannelName(0, "gray");
                    result.setName(source.getName() + " (gray rendering)");
                    return result;
                }
            }
        }
        finally {
            result.endUpdate();
        }
    }

    public static Point2D convertPoint(Point2D pt, int inputResolution, int outputResolution) {
        if (pt == null) {
            return null;
        }
        double factor = Math.pow(2.0, inputResolution - outputResolution);
        return new Point2D.Double(pt.getX() * factor, pt.getY() * factor);
    }

    public static Rectangle2D convertRectangle(Rectangle2D rect, int inputResolution, int outputResolution) {
        if (rect == null) {
            return null;
        }
        double factor = Math.pow(2.0, inputResolution - outputResolution);
        return new Rectangle2D.Double(rect.getX() * factor, rect.getY() * factor, rect.getWidth() * factor, rect.getHeight() * factor);
    }

    public static Point3D convertPoint(Point3D pt, Sequence source, Sequence destination) {
        if (pt == null) {
            return new Point3D.Double();
        }
        if (source == null || destination == null) {
            return new Point3D.Double(pt.getX(), pt.getY(), pt.getZ());
        }
        double posXum = pt.getX() * source.getPixelSizeX() + source.getPositionX();
        double posYum = pt.getY() * source.getPixelSizeY() + source.getPositionY();
        double posZum = pt.getZ() * source.getPixelSizeZ() + source.getPositionZ();
        return new Point3D.Double((posXum - destination.getPositionX()) / destination.getPixelSizeX(), (posYum - destination.getPositionY()) / destination.getPixelSizeY(), (posZum - destination.getPositionZ()) / destination.getPixelSizeZ());
    }

    public static Point2D convertPoint(Point2D pt, Sequence source, Sequence destination) {
        if (pt == null) {
            return new Point2D.Double();
        }
        return SequenceUtil.convertPoint(new Point3D.Double(pt.getX(), pt.getY(), 0.0), source, destination).toPoint2D();
    }

    public static Rectangle3D convertRectangle(Rectangle3D rect, Sequence source, Sequence destination) {
        if (rect == null) {
            return new Rectangle3D.Double();
        }
        if (source == null || destination == null) {
            return new Rectangle3D.Double(rect);
        }
        double psxs = source.getPixelSizeX();
        double psys = source.getPixelSizeY();
        double pszs = source.getPixelSizeZ();
        double posXum = rect.getX() * psxs + source.getPositionX();
        double posYum = rect.getY() * psys + source.getPositionY();
        double posZum = rect.getZ() * pszs + source.getPositionZ();
        double sizeXum = rect.getX() * psxs;
        double sizeYum = rect.getY() * psys;
        double sizeZum = rect.getZ() * pszs;
        double psxd = destination.getPixelSizeX();
        double psyd = destination.getPixelSizeY();
        double pszd = destination.getPixelSizeZ();
        return new Rectangle3D.Double((posXum - destination.getPositionX()) / psxd, (posYum - destination.getPositionY()) / psyd, (posZum - destination.getPositionZ()) / pszd, sizeXum / psxd, sizeYum / psyd, sizeZum / pszd);
    }

    public static Rectangle2D convertRectangle(Rectangle2D rect, Sequence source, Sequence destination) {
        if (rect == null) {
            return new Rectangle2D.Double();
        }
        return SequenceUtil.convertRectangle(new Rectangle3D.Double(rect.getX(), rect.getY(), 0.0, rect.getWidth(), rect.getHeight(), 0.0), source, destination).toRectangle2D();
    }

    public static Point getOriginPoint(Point pt, Sequence source) {
        if (pt == null) {
            return null;
        }
        Point2D adjPt = SequenceUtil.convertPoint((Point2D)pt, source.getOriginResolution(), 0);
        Point result = new Point((int)adjPt.getX(), (int)adjPt.getY());
        Rectangle region = source.getOriginXYRegion();
        if (region != null) {
            result.setLocation(result.x + region.x, result.y + region.y);
        }
        return result;
    }

    public static Rectangle getOriginRectangle(Rectangle rect, Sequence source) {
        if (rect == null) {
            return null;
        }
        Rectangle2D adjRect = SequenceUtil.convertRectangle((Rectangle2D)rect, source.getOriginResolution(), 0);
        Rectangle result = new Rectangle((int)adjRect.getX(), (int)adjRect.getY(), (int)adjRect.getWidth(), (int)adjRect.getHeight());
        Rectangle region = source.getOriginXYRegion();
        if (region != null) {
            result.setLocation(result.x + region.x, result.y + region.y);
        }
        return result;
    }

    public static class AdjustZTHelper {
        public static IcyBufferedImage getImage(Sequence sequence, int t, int z, int newSizeZ, int newSizeT, boolean reverseOrder) {
            int sizeZ = sequence.getSizeZ();
            int sizeT = sequence.getSizeT();
            if (t >= newSizeT || z >= newSizeZ) {
                return null;
            }
            int index = reverseOrder ? z * newSizeT + t : t * newSizeZ + z;
            int tOrigin = index / sizeZ;
            int zOrigin = index % sizeZ;
            if (tOrigin >= sizeT) {
                return new IcyBufferedImage(sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeC(), sequence.getDataType_());
            }
            return sequence.getImage(tOrigin, zOrigin);
        }
    }

    public static class MergeTHelper {
        private static IcyBufferedImage getImageFromSequenceInternal(Sequence seq, int t, int z, boolean fillEmpty) {
            IcyBufferedImage img = seq.getImage(t, z);
            if (img == null && fillEmpty) {
                int curT = t;
                if (t >= seq.getSizeT()) {
                    while (img == null && curT > 0) {
                        img = seq.getImage(--curT, z);
                    }
                }
                if (img == null) {
                    int curZ = z;
                    while (img == null && curZ > 0) {
                        img = seq.getImage(t, --curZ);
                    }
                }
                return img;
            }
            return img;
        }

        private static IcyBufferedImage getImageInternal(Sequence[] sequences, int t, int z, boolean interlaced, boolean fillEmpty) {
            int tRemaining = t;
            if (interlaced) {
                int tInd = 0;
                while (tRemaining >= 0) {
                    for (Sequence seq : sequences) {
                        if (tInd >= seq.getSizeT() || tRemaining-- != 0) continue;
                        return MergeTHelper.getImageFromSequenceInternal(seq, tInd, z, fillEmpty);
                    }
                    ++tInd;
                }
            } else {
                for (Sequence seq : sequences) {
                    int sizeT = seq.getSizeT();
                    if (tRemaining < sizeT) {
                        return MergeTHelper.getImageFromSequenceInternal(seq, tRemaining, z, fillEmpty);
                    }
                    tRemaining -= sizeT;
                }
            }
            return null;
        }

        public static IcyBufferedImage getImage(Sequence[] sequences, int sizeX, int sizeY, int sizeC, int t, int z, boolean interlaced, boolean fillEmpty, boolean rescale) {
            IcyBufferedImage result = MergeTHelper.getImageInternal(sequences, t, z, interlaced, fillEmpty);
            if (result != null) {
                int imgSizeC;
                if (result.getSizeX() != sizeX || result.getSizeY() != sizeY) {
                    result = IcyBufferedImageUtil.scale(result, sizeX, sizeY, rescale, 0, 0, IcyBufferedImageUtil.FilterType.BILINEAR);
                }
                if ((imgSizeC = result.getSizeC()) < sizeC) {
                    return IcyBufferedImageUtil.addChannels(result, imgSizeC, sizeC - imgSizeC);
                }
            }
            return result;
        }
    }

    public static class MergeZHelper {
        private static IcyBufferedImage getImageFromSequenceInternal(Sequence seq, int t, int z, boolean fillEmpty) {
            IcyBufferedImage img = seq.getImage(t, z);
            if (img == null && fillEmpty) {
                int curZ = z;
                if (z >= seq.getSizeZ()) {
                    while (img == null && curZ > 0) {
                        img = seq.getImage(t, --curZ);
                    }
                }
                if (img == null) {
                    int curT = t;
                    while (img == null && curT > 0) {
                        img = seq.getImage(--curT, z);
                    }
                }
                return img;
            }
            return img;
        }

        private static IcyBufferedImage getImageInternal(Sequence[] sequences, int t, int z, boolean interlaced, boolean fillEmpty) {
            int zRemaining = z;
            if (interlaced) {
                int zInd = 0;
                while (zRemaining >= 0) {
                    for (Sequence seq : sequences) {
                        if (zInd >= seq.getSizeZ() || zRemaining-- != 0) continue;
                        return MergeZHelper.getImageFromSequenceInternal(seq, t, zInd, fillEmpty);
                    }
                    ++zInd;
                }
            } else {
                for (Sequence seq : sequences) {
                    int sizeZ = seq.getSizeZ();
                    if (zRemaining < sizeZ) {
                        return MergeZHelper.getImageFromSequenceInternal(seq, t, zRemaining, fillEmpty);
                    }
                    zRemaining -= sizeZ;
                }
            }
            return null;
        }

        public static IcyBufferedImage getImage(Sequence[] sequences, int sizeX, int sizeY, int sizeC, int t, int z, boolean interlaced, boolean fillEmpty, boolean rescale) {
            IcyBufferedImage result = MergeZHelper.getImageInternal(sequences, t, z, interlaced, fillEmpty);
            if (result != null) {
                int imgSizeC;
                if (result.getSizeX() != sizeX || result.getSizeY() != sizeY) {
                    result = IcyBufferedImageUtil.scale(result, sizeX, sizeY, rescale, 0, 0, IcyBufferedImageUtil.FilterType.BILINEAR);
                }
                if ((imgSizeC = result.getSizeC()) < sizeC) {
                    return IcyBufferedImageUtil.addChannels(result, imgSizeC, sizeC - imgSizeC);
                }
            }
            return result;
        }
    }

    public static class MergeCHelper {
        private static IcyBufferedImage getImageFromSequenceInternal(Sequence seq, int t, int z, int c, boolean fillEmpty) {
            IcyBufferedImage img = seq.getImage(t, z, c);
            if (img == null && fillEmpty) {
                int curZ = z;
                if (z >= seq.getSizeZ()) {
                    while (img == null && curZ > 0) {
                        img = seq.getImage(t, --curZ, c);
                    }
                }
                if (img == null) {
                    int curT = t;
                    while (img == null && curT > 0) {
                        img = seq.getImage(--curT, z, c);
                    }
                }
                return img;
            }
            return img;
        }

        public static IcyBufferedImage getImage(Sequence[] sequences, int[] channels, int sizeX, int sizeY, int t, int z, boolean fillEmpty, boolean rescale) throws IllegalArgumentException {
            if (sequences.length == 0) {
                return null;
            }
            ArrayList<IcyBufferedImage> images = new ArrayList<IcyBufferedImage>();
            ArrayList<IcyColorMap> colormaps = new ArrayList<IcyColorMap>();
            for (int i = 0; i < sequences.length; ++i) {
                Sequence seq = sequences[i];
                int c = channels[i];
                colormaps.add(seq.getColorMap(c));
                IcyBufferedImage img = MergeCHelper.getImageFromSequenceInternal(seq, t, z, c, fillEmpty);
                if (img == null) {
                    img = new IcyBufferedImage(sizeX, sizeY, 1, seq.getDataType_());
                } else if (img.getSizeX() != sizeX || img.getSizeY() != sizeY) {
                    img = IcyBufferedImageUtil.scale(img, sizeX, sizeY, rescale, 0, 0, IcyBufferedImageUtil.FilterType.BILINEAR);
                }
                images.add(img);
            }
            IcyBufferedImage result = IcyBufferedImage.createFrom(images);
            for (int c = 0; c < result.getSizeC(); ++c) {
                IcyColorMap map = (IcyColorMap)colormaps.get(c);
                if (map == null) continue;
                result.setColorMap(c, (IcyColorMap)colormaps.get(c), false);
            }
            return result;
        }
    }

    public static class AddTHelper {
        public static IcyBufferedImage getExtendedImage(Sequence sequence, int t, int z, int insertPosition, int numInsert, int copyLast) {
            if (t < insertPosition) {
                return sequence.getImage(t, z);
            }
            int pos = t - insertPosition;
            if (pos < numInsert) {
                if (insertPosition > 0 && copyLast > 0) {
                    int duplicate = Math.min(insertPosition, copyLast);
                    int baseReplicate = insertPosition - duplicate;
                    return sequence.getImage(baseReplicate + pos % duplicate, z);
                }
                return new IcyBufferedImage(sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeC(), sequence.getDataType_());
            }
            return sequence.getImage(t - numInsert, z);
        }
    }

    public static class AddZHelper {
        public static IcyBufferedImage getExtendedImage(Sequence sequence, int t, int z, int insertPosition, int numInsert, int copyLast) {
            if (z < insertPosition) {
                return sequence.getImage(t, z);
            }
            int pos = z - insertPosition;
            if (pos < numInsert) {
                if (insertPosition > 0 && copyLast > 0) {
                    int duplicate = Math.min(insertPosition, copyLast);
                    int baseReplicate = insertPosition - duplicate;
                    return sequence.getImage(t, baseReplicate + pos % duplicate);
                }
                return new IcyBufferedImage(sequence.getSizeX(), sequence.getSizeY(), sequence.getSizeC(), sequence.getDataType_());
            }
            return sequence.getImage(t, z - numInsert);
        }
    }
}

