/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetScan;

public class DatasetSorter {
    private static Logger logger = LoggerFactory.getLogger(DatasetSorter.class);
    private String targetLevel;
    private boolean increasingOrder = true;
    private String type = "lexigraphic";
    private String attributeName;
    private Comparator invDatasetComparator;

    public DatasetSorter(boolean increasingOrder) {
        this.increasingOrder = increasingOrder;
        this.invDatasetComparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                InvDataset ds1 = (InvDataset)obj1;
                InvDataset ds2 = (InvDataset)obj2;
                int compareVal = ds1.getName().compareTo(ds2.getName());
                return DatasetSorter.this.increasingOrder ? compareVal : -compareVal;
            }
        };
    }

    public DatasetSorter(Comparator invDatasetComparator) {
        this.invDatasetComparator = invDatasetComparator;
    }

    public void sortDatasets(InvDataset collectionDs) {
        this.sortDatasets(collectionDs.getDatasets());
    }

    public void sortDatasets(List datasets) {
        Collections.sort(datasets, this.invDatasetComparator);
    }

    public void sortNestedDatasets(InvDataset collectionDs) {
        InvDataset curDs2 = null;
        for (InvDataset curDs2 : collectionDs.getDatasets()) {
            if (curDs2.getClass().equals(InvCatalogRef.class) || curDs2.getClass().equals(InvDatasetScan.class)) continue;
            this.sortDatasets(curDs2);
        }
        logger.debug("sortDatasets(): sort the datasets contained by dataset ({})", (Object)collectionDs.getName());
        this.sortDatasets(collectionDs.getDatasets());
    }
}

