/*
 * Decompiled with CFR 0.152.
 */
package icy.painter;

import icy.painter.Anchor3D;
import icy.type.point.Point3D;
import icy.util.EventUtil;
import java.awt.Color;
import java.awt.event.InputEvent;

public abstract class RectAnchor3D
extends Anchor3D {
    protected boolean fixedZ = false;

    public RectAnchor3D(Point3D position, Color color, Color selectedColor) {
        super(position.getX(), position.getY(), position.getZ(), color, selectedColor);
    }

    public boolean isFixedZ() {
        return this.fixedZ;
    }

    public void setFixedZ(boolean value) {
        this.fixedZ = value;
    }

    protected boolean updateDrag(InputEvent e, double x, double y, double z) {
        if (this.startDragMousePosition == null) {
            return false;
        }
        Anchor3D anchor = this.getOppositePoint();
        if (EventUtil.isShiftDown((InputEvent)e) && anchor != null) {
            Point3D pos = anchor.getPosition();
            double dx = x - pos.getX();
            double dy = y - pos.getY();
            double absDx = Math.abs(dx);
            double absDy = Math.abs(dy);
            if (this.isFixedZ()) {
                if (absDx > absDy) {
                    dx = dx >= 0.0 ? absDy : -absDy;
                } else {
                    dy = dy >= 0.0 ? absDx : -absDx;
                }
                this.setPosition(pos.getX() + dx, pos.getY() + dy, this.getZ());
            } else {
                double dz = z - pos.getZ();
                double absDz = Math.abs(dz);
                if (absDx > absDz && absDy > absDz) {
                    dx = dx >= 0.0 ? absDy : -absDy;
                } else if (absDx > absDy && absDz > absDy) {
                    dx = dx >= 0.0 ? absDy : -absDy;
                } else {
                    dy = dy >= 0.0 ? absDx : -absDx;
                }
                this.setPosition(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz);
            }
        } else {
            double dx = x - this.startDragMousePosition.getX();
            double dy = y - this.startDragMousePosition.getY();
            double dz = z - this.startDragMousePosition.getZ();
            this.setPosition(this.startDragPainterPosition.getX() + dx, this.startDragPainterPosition.getY() + dy, this.startDragPainterPosition.getZ() + dz);
        }
        return true;
    }

    protected abstract Anchor3D getOppositePoint();
}

