/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.util.ArrayList;
import mcib3d.geom.Object3D;
import mcib3d.geom.Object3DVoxels;
import mcib3d.geom.ObjectCreator3D;
import mcib3d.geom.Voxel3D;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.utils.ArrayUtil;
import mcib3d.utils.KDTreeC;

public class Object3DLabel
extends Object3D {
    private ArrayList<Voxel3D> voxels = null;

    public Object3DLabel(ImageInt ima, int val) {
        this.value = val;
        this.labelImage = ima;
        this.init();
        this.resXY = ima.getScaleXY();
        this.resZ = ima.getScaleZ();
        this.units = ima.getUnit();
    }

    @Deprecated
    public Object3DLabel(ImagePlus plus, int val) {
        this.value = val;
        ImageInt ima = null;
        if (plus.getBitDepth() <= 16) {
            ima = (ImageInt)ImageHandler.wrap(plus);
        }
        this.labelImage = ima;
        this.init();
        Calibration cal = plus.getCalibration();
        if (cal != null) {
            if (cal.scaled()) {
                this.resXY = cal.getX(1.0);
                this.resZ = cal.getZ(1.0);
                this.units = cal.getUnits();
            } else {
                this.resXY = 1.0;
                this.resZ = 1.0;
                this.units = "pix";
            }
        }
    }

    private boolean insideImage(double x, double y, double z) {
        return x >= 0.0 && x < (double)this.labelImage.sizeX && y >= 0.0 && y < (double)this.labelImage.sizeY && z >= 0.0 && z < (double)this.labelImage.sizeZ;
    }

    @Override
    public ArrayList<Voxel3D> listVoxels(ImageHandler ima, double threshold) {
        return this.listVoxels(ima, threshold, Double.POSITIVE_INFINITY);
    }

    @Override
    public ArrayList<Voxel3D> listVoxels(ImageHandler ima, double threshold1, double threshold2) {
        ArrayList<Voxel3D> list = new ArrayList<Voxel3D>();
        int xmin0 = this.getXmin();
        int ymin0 = this.getYmin();
        int zmin0 = this.getZmin();
        int xmax0 = this.getXmax();
        int ymax0 = this.getYmax();
        int zmax0 = this.getZmax();
        for (int k = zmin0; k <= zmax0; ++k) {
            for (int j = ymin0; j <= ymax0; ++j) {
                for (int i = xmin0; i <= xmax0; ++i) {
                    float val;
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value || !((double)(val = ima != null ? ima.getPixel(i, j, k) : (float)this.value) > threshold1) || !((double)val < threshold2)) continue;
                    Voxel3D pixel = new Voxel3D(i, j, k, val);
                    list.add(pixel);
                }
            }
        }
        return list;
    }

    @Override
    protected void computeBounding() {
        this.xmin = this.labelImage.sizeX;
        this.xmax = 0;
        this.ymin = this.labelImage.sizeY;
        this.ymax = 0;
        this.zmin = this.labelImage.sizeZ;
        this.zmax = 0;
        for (int k = 0; k < this.labelImage.sizeZ; ++k) {
            for (int j = 0; j < this.labelImage.sizeY; ++j) {
                for (int i = 0; i < this.labelImage.sizeX; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    if (i < this.xmin) {
                        this.xmin = i;
                    }
                    if (i > this.xmax) {
                        this.xmax = i;
                    }
                    if (j < this.ymin) {
                        this.ymin = j;
                    }
                    if (j > this.ymax) {
                        this.ymax = j;
                    }
                    if (k < this.zmin) {
                        this.zmin = k;
                    }
                    if (k <= this.zmax) continue;
                    this.zmax = k;
                }
            }
        }
    }

    @Override
    public void computeContours() {
        this.contours = new ArrayList();
        this.kdtreeContours = new KDTreeC(3);
        this.kdtreeContours.setScale3(this.resXY, this.resXY, this.resZ);
        int sx = this.labelImage.sizeX;
        int sy = this.labelImage.sizeY;
        int sz = this.labelImage.sizeZ;
        double XYZ = this.resXY * this.resZ;
        double XX = this.resXY * this.resXY;
        this.areaNbVoxels = 0.0;
        this.areaContactUnit = 0.0;
        this.areaContactVoxels = 0.0;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    boolean cont = false;
                    int pix6 = 0;
                    int pix5 = 0;
                    int pix4 = 0;
                    int pix3 = 0;
                    int pix2 = 0;
                    int pix1 = 0;
                    int pix0 = this.labelImage.getPixelInt(i, j, k);
                    if (pix0 != this.value) continue;
                    if (i + 1 < sx) {
                        pix1 = this.labelImage.getPixelInt(i + 1, j, k);
                    }
                    if (i > 0) {
                        pix2 = this.labelImage.getPixelInt(i - 1, j, k);
                    }
                    if (j + 1 < sy) {
                        pix3 = this.labelImage.getPixelInt(i, j + 1, k);
                    }
                    if (j > 0) {
                        pix4 = this.labelImage.getPixelInt(i, j - 1, k);
                    }
                    if (k + 1 < sz) {
                        pix5 = this.labelImage.getPixelInt(i, j, k + 1);
                    }
                    if (k > 0) {
                        pix6 = this.labelImage.getPixelInt(i, j, k - 1);
                    }
                    if (pix1 != this.value) {
                        cont = true;
                        this.areaContactUnit += XYZ;
                        this.areaContactVoxels += 1.0;
                    }
                    if (pix2 != this.value) {
                        cont = true;
                        this.areaContactUnit += XYZ;
                        this.areaContactVoxels += 1.0;
                    }
                    if (pix3 != this.value) {
                        cont = true;
                        this.areaContactUnit += XYZ;
                        this.areaContactVoxels += 1.0;
                    }
                    if (pix4 != this.value) {
                        cont = true;
                        this.areaContactUnit += XYZ;
                        this.areaContactVoxels += 1.0;
                    }
                    if (pix5 != this.value) {
                        cont = true;
                        this.areaContactUnit += XX;
                        this.areaContactVoxels += 1.0;
                    }
                    if (pix6 != this.value) {
                        cont = true;
                        this.areaContactUnit += XX;
                        this.areaContactVoxels += 1.0;
                    }
                    if (!cont) continue;
                    this.areaNbVoxels += 1.0;
                    Voxel3D vox = new Voxel3D(i, j, k, this.value);
                    this.contours.add(vox);
                    this.kdtreeContours.add(vox.getArray(), vox);
                }
            }
        }
    }

    @Override
    public Voxel3D getPixelMax(ImageHandler ima) {
        Voxel3D res = null;
        float max = -3.4028235E38f;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    float pix;
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value || !((pix = ima.getPixel(i, j, k)) > max)) continue;
                    max = pix;
                    res = new Voxel3D(i, j, k, pix);
                }
            }
        }
        return res;
    }

    private boolean isContour(int x, int y, int z) {
        if (this.labelImage.getPixel(x, y, z) != (float)this.value) {
            return false;
        }
        ArrayUtil vois = this.labelImage.getNeighborhood3x3x3(x, y, z);
        return !vois.hasOnlyValue(this.value);
    }

    @Override
    protected void computeCenter() {
        this.bx = 0.0;
        this.by = 0.0;
        this.bz = 0.0;
        int sum = 0;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    this.bx += (double)i;
                    this.by += (double)j;
                    this.bz += (double)k;
                    ++sum;
                }
            }
        }
        this.bx /= (double)sum;
        this.by /= (double)sum;
        this.bz /= (double)sum;
        this.volume = sum;
    }

    @Override
    protected void computeMassCenter(ImageHandler ima) {
        if (ima != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double sum = 0.0;
            double sum2 = 0.0;
            double pmin = Double.MAX_VALUE;
            double pmax = -1.7976931348623157E308;
            int nb = 0;
            for (int k = this.zmin; k <= this.zmax; ++k) {
                for (int j = this.ymin; j <= this.ymax; ++j) {
                    for (int i = this.xmin; i <= this.xmax; ++i) {
                        double pix;
                        if (this.labelImage.getPixel(i, j, k) != (float)this.value || Double.isNaN(pix = (double)ima.getPixel(i, j, k))) continue;
                        ++nb;
                        this.cx += (double)i * pix;
                        this.cy += (double)j * pix;
                        this.cz += (double)k * pix;
                        sum += pix;
                        sum2 += pix * pix;
                        if (pix > pmax) {
                            pmax = pix;
                        }
                        if (!(pix < pmin)) continue;
                        pmin = pix;
                    }
                }
            }
            this.cx /= sum;
            this.cy /= sum;
            this.cz /= sum;
            this.integratedDensity = sum;
            this.meanDensity = this.integratedDensity / (double)nb;
            this.pixmin = pmin;
            this.pixmax = pmax;
            int vol = this.getVolumePixels();
            this.sigma = Math.sqrt((sum2 - sum * sum / (double)vol) / (double)(vol - 1));
        }
    }

    @Override
    protected void computeMassCenter(ImageHandler ima, ImageHandler mask) {
        if (ima != null) {
            this.cx = 0.0;
            this.cy = 0.0;
            this.cz = 0.0;
            double sum = 0.0;
            double sum2 = 0.0;
            double pmin = Double.MAX_VALUE;
            double pmax = -1.7976931348623157E308;
            for (int k = this.zmin; k <= this.zmax; ++k) {
                for (int j = this.ymin; j <= this.ymax; ++j) {
                    for (int i = this.xmin; i <= this.xmax; ++i) {
                        if (this.labelImage.getPixel(i, j, k) != (float)this.value || !mask.contains(i, j, k) || !(mask.getPixel(i, j, k) > 0.0f)) continue;
                        double pix = ima.getPixel(i, j, k);
                        this.cx += (double)i * pix;
                        this.cy += (double)j * pix;
                        this.cz += (double)k * pix;
                        sum += pix;
                        sum2 += pix * pix;
                        if (pix > pmax) {
                            pmax = pix;
                        }
                        if (!(pix < pmin)) continue;
                        pmin = pix;
                    }
                }
            }
            this.cx /= sum;
            this.cy /= sum;
            this.cz /= sum;
            this.integratedDensity = sum;
            this.pixmin = pmin;
            this.pixmax = pmax;
            int vol = this.getVolumePixels();
            this.sigma = Math.sqrt((sum2 - sum * sum / (double)vol) / (double)(vol - 1));
        }
    }

    @Override
    public void computeMoments2(boolean normalize) {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    this.s200 += ((double)i - this.bx) * ((double)i - this.bx);
                    this.s020 += ((double)j - this.by) * ((double)j - this.by);
                    this.s002 += ((double)k - this.bz) * ((double)k - this.bz);
                    this.s110 += ((double)i - this.bx) * ((double)j - this.by);
                    this.s101 += ((double)i - this.bx) * ((double)k - this.bz);
                    this.s011 += ((double)j - this.by) * ((double)k - this.bz);
                }
            }
        }
        this.s200 *= this.resXY * this.resXY;
        this.s020 *= this.resXY * this.resXY;
        this.s002 *= this.resZ * this.resZ;
        this.s110 *= this.resXY * this.resXY;
        this.s101 *= this.resXY * this.resZ;
        this.s011 *= this.resXY * this.resZ;
        if (normalize) {
            this.s200 /= (double)this.volume;
            this.s020 /= (double)this.volume;
            this.s002 /= (double)this.volume;
            this.s110 /= (double)this.volume;
            this.s101 /= (double)this.volume;
            this.s011 /= (double)this.volume;
        }
        this.eigen = null;
    }

    @Override
    public void computeMoments3() {
        this.s003 = 0.0;
        this.s030 = 0.0;
        this.s300 = 0.0;
        this.s111 = 0.0;
        this.s012 = 0.0;
        this.s102 = 0.0;
        this.s021 = 0.0;
        this.s120 = 0.0;
        this.s201 = 0.0;
        this.s210 = 0.0;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    double xx = (double)i - this.bx;
                    double yy = (double)j - this.by;
                    double zz = (double)k - this.bz;
                    this.s300 += xx * xx * xx;
                    this.s030 += yy * yy * yy;
                    this.s003 += zz * zz * zz;
                    this.s210 += xx * xx * yy;
                    this.s201 += xx * xx * zz;
                    this.s120 += yy * yy * xx;
                    this.s021 += yy * yy * zz;
                    this.s102 += zz * zz * xx;
                    this.s012 += zz * zz * yy;
                    this.s111 += xx * yy * zz;
                }
            }
        }
        this.s300 *= this.resXY * this.resXY * this.resXY;
        this.s030 *= this.resXY * this.resXY * this.resXY;
        this.s003 *= this.resZ * this.resZ * this.resZ;
        this.s210 *= this.resXY * this.resXY * this.resXY;
        this.s201 *= this.resXY * this.resXY * this.resZ;
        this.s120 *= this.resXY * this.resXY * this.resXY;
        this.s021 *= this.resXY * this.resXY * this.resZ;
        this.s102 *= this.resZ * this.resZ * this.resXY;
        this.s012 *= this.resZ * this.resZ * this.resXY;
        this.s111 *= this.resXY * this.resXY * this.resZ;
        this.s300 /= (double)this.volume;
        this.s030 /= (double)this.volume;
        this.s003 /= (double)this.volume;
        this.s210 /= (double)this.volume;
        this.s201 /= (double)this.volume;
        this.s120 /= (double)this.volume;
        this.s021 /= (double)this.volume;
        this.s102 /= (double)this.volume;
        this.s012 /= (double)this.volume;
        this.s111 /= (double)this.volume;
    }

    @Override
    public void computeMoments4() {
        this.s211 = 0.0;
        this.s112 = 0.0;
        this.s121 = 0.0;
        this.s022 = 0.0;
        this.s202 = 0.0;
        this.s220 = 0.0;
        this.s040 = 0.0;
        this.s040 = 0.0;
        this.s400 = 0.0;
        this.s031 = 0.0;
        this.s013 = 0.0;
        this.s310 = 0.0;
        this.s130 = 0.0;
        this.s301 = 0.0;
        this.s103 = 0.0;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    double xx = (double)i - this.bx;
                    double yy = (double)j - this.by;
                    double zz = (double)k - this.bz;
                    this.s400 += xx * xx * xx * xx;
                    this.s040 += yy * yy * yy * yy;
                    this.s004 += zz * zz * zz * zz;
                    this.s220 += xx * xx * yy * yy;
                    this.s202 += xx * xx * zz * zz;
                    this.s022 += yy * yy * zz * zz;
                    this.s121 += xx * yy * yy * zz;
                    this.s112 += xx * yy * zz * zz;
                    this.s211 += xx * xx * yy * zz;
                    this.s103 += xx * zz * zz * zz;
                    this.s301 += xx * xx * xx * zz;
                    this.s130 += xx * yy * yy * yy;
                    this.s310 += xx * xx * xx * yy;
                    this.s013 += yy * zz * zz * zz;
                    this.s031 += yy * yy * yy * zz;
                }
            }
        }
        this.s400 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s040 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s004 *= this.resZ * this.resZ * this.resZ * this.resZ;
        this.s220 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s202 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s022 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s121 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s112 *= this.resXY * this.resXY * this.resZ * this.resZ;
        this.s211 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s103 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s301 *= this.resXY * this.resXY * this.resXY * this.resZ;
        this.s130 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s310 *= this.resXY * this.resXY * this.resXY * this.resXY;
        this.s013 *= this.resXY * this.resZ * this.resZ * this.resZ;
        this.s031 *= this.resXY * this.resXY * this.resXY * this.resZ;
    }

    public void computeMomentsInertia() {
        this.s200 = 0.0;
        this.s110 = 0.0;
        this.s101 = 0.0;
        this.s020 = 0.0;
        this.s011 = 0.0;
        this.s002 = 0.0;
        for (int k = this.zmin; k <= this.zmax; ++k) {
            for (int j = this.ymin; j <= this.ymax; ++j) {
                for (int i = this.xmin; i <= this.xmax; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    this.s200 += this.resXY * this.resXY * ((double)j - this.by) * ((double)j - this.by) + this.resZ * this.resZ * ((double)k - this.bz) * ((double)k - this.bz);
                    this.s020 += this.resXY * this.resXY * ((double)i - this.bx) * ((double)i - this.bx) + this.resZ * this.resZ * ((double)k - this.bz) * ((double)k - this.bz);
                    this.s002 += this.resXY * this.resXY * ((double)i - this.bx) * ((double)i - this.bx) + this.resXY * this.resXY * ((double)j - this.by) * ((double)j - this.by);
                    this.s110 += this.resXY * this.resXY * ((double)i - this.bx) * ((double)j - this.by);
                    this.s101 += this.resXY * this.resZ * ((double)i - this.bx) * ((double)k - this.bz);
                    this.s011 += this.resXY * this.resZ * ((double)j - this.by) * ((double)k - this.bz);
                }
            }
        }
    }

    @Override
    public void draw(ObjectCreator3D obj, int col) {
        for (int z = this.zmin; z <= this.zmax; ++z) {
            for (int y = this.ymin; y <= this.ymax; ++y) {
                for (int x = this.xmin; x <= this.xmax; ++x) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value) continue;
                    obj.createPixel(x, y, z, col);
                }
            }
        }
    }

    @Override
    @Deprecated
    public boolean draw(ByteProcessor mask, int z, int col) {
        boolean ok = false;
        for (int x = this.xmin; x <= this.xmax; ++x) {
            for (int y = this.ymin; y <= this.ymax; ++y) {
                if (this.labelImage.getPixel(x, y, z) != (float)this.value) continue;
                mask.putPixel(x, y, col);
                ok = true;
            }
        }
        return ok;
    }

    @Override
    public void draw(ImageHandler mask, int col) {
        for (int z = this.zmin; z <= this.zmax; ++z) {
            for (int x = this.xmin; x <= this.xmax; ++x) {
                for (int y = this.ymin; y <= this.ymax; ++y) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value) continue;
                    mask.setPixel(x, y, z, col);
                }
            }
        }
    }

    @Override
    @Deprecated
    public void draw(ImageStack mask, int red, int green, int blue) {
        Color col = new Color(red, green, blue);
        for (int z = this.zmin; z <= this.zmax; ++z) {
            ImageProcessor tmp = mask.getProcessor(z + 1);
            tmp.setColor(col);
            for (int x = this.xmin; x <= this.xmax; ++x) {
                for (int y = this.ymin; y <= this.ymax; ++y) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value) continue;
                    tmp.drawPixel(x, y);
                }
            }
        }
    }

    @Override
    @Deprecated
    public void draw(ImageStack mask, int col) {
        for (int z = this.zmin; z <= this.zmax; ++z) {
            ImageProcessor tmp = mask.getProcessor(z + 1);
            for (int x = this.xmin; x <= this.xmax; ++x) {
                for (int y = this.ymin; y <= this.ymax; ++y) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value) continue;
                    tmp.putPixel(x, y, col);
                }
            }
        }
    }

    @Deprecated
    public void drawIntersection(ImageStack mask, Object3DLabel other, int red, int green, int blue) {
        ImageInt otherSeg = other.getLabelImage();
        int otherValue = other.getValue();
        Color col = new Color(red, green, blue);
        for (int z = this.zmin; z <= this.zmax; ++z) {
            ImageProcessor tmp = mask.getProcessor(z + 1);
            tmp.setColor(col);
            for (int x = this.xmin; x <= this.xmax; ++x) {
                for (int y = this.ymin; y <= this.ymax; ++y) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value || otherSeg.getPixel(x, y, z) != (float)otherValue) continue;
                    tmp.drawPixel(x, y);
                }
            }
        }
    }

    @Deprecated
    public void drawIntersection(ImageStack mask, Object3DLabel other, int col) {
        ImageInt otherSeg = other.getLabelImage();
        int otherValue = other.getValue();
        for (int z = this.zmin; z <= this.zmax; ++z) {
            ImageProcessor tmp = mask.getProcessor(z + 1);
            for (int x = this.xmin; x <= this.xmax; ++x) {
                for (int y = this.ymin; y <= this.ymax; ++y) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value || otherSeg.getPixel(x, y, z) != (float)otherValue) continue;
                    tmp.putPixel(x, y, col);
                }
            }
        }
    }

    @Override
    @Deprecated
    public Roi createRoi(int z) {
        int sx = this.labelImage.sizeX;
        int sy = this.labelImage.sizeY;
        ByteProcessor mask = new ByteProcessor(sx, sy);
        this.draw(mask, z, 255);
        ImagePlus maskPlus = new ImagePlus("mask " + z, (ImageProcessor)mask);
        ThresholdToSelection tts = new ThresholdToSelection();
        tts.setup("", maskPlus);
        tts.run((ImageProcessor)mask);
        maskPlus.updateAndDraw();
        return maskPlus.getRoi();
    }

    @Override
    public ArrayList<Voxel3D> getVoxels() {
        if (this.voxels == null) {
            this.voxels = this.listVoxels(null);
        }
        return this.voxels;
    }

    protected Object3DVoxels buildObject3DVoxels() {
        Object3DVoxels obj = new Object3DVoxels(this.getVoxels());
        obj.setResXY(this.getResXY());
        obj.setResZ(this.getResZ());
        return obj;
    }

    @Override
    public void saveObject(String path) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void translate(double x, double y, double z) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getColoc(Object3D other) {
        if (this.disjointBox(other)) {
            return 0;
        }
        int count = 0;
        int val = other.getValue();
        ImageInt otherseg = other.getMaxLabelImage(val);
        int xmin0 = this.getXmin();
        int ymin0 = this.getYmin();
        int zmin0 = this.getZmin();
        int xmax0 = this.getXmax();
        int ymax0 = this.getYmax();
        int zmax0 = this.getZmax();
        if (other != null) {
            xmin0 = Math.max(xmin0, other.getXmin());
            ymin0 = Math.max(ymin0, other.getYmin());
            zmin0 = Math.max(zmin0, other.getZmin());
            xmax0 = Math.min(xmax0, other.getXmax());
            ymax0 = Math.min(ymax0, other.getYmax());
            zmax0 = Math.min(zmax0, other.getZmax());
        }
        for (int k = zmin0; k <= zmax0; ++k) {
            for (int j = ymin0; j <= ymax0; ++j) {
                for (int i = xmin0; i <= xmax0; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value || otherseg.getPixel(i, j, k) != (float)val) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    @Override
    public boolean hasOneVoxelColoc(Object3D obj) {
        if (this.disjointBox(obj)) {
            return false;
        }
        if (this.labelImage == null || obj.getMaxLabelImage(obj.getValue()) == null) {
            return false;
        }
        int val = obj.getValue();
        ImageInt otherseg = obj.getLabelImage();
        int xmin0 = this.getXmin();
        int ymin0 = this.getYmin();
        int zmin0 = this.getZmin();
        int xmax0 = this.getXmax();
        int ymax0 = this.getYmax();
        int zmax0 = this.getZmax();
        xmin0 = Math.max(xmin0, obj.getXmin());
        ymin0 = Math.max(ymin0, obj.getYmin());
        zmin0 = Math.max(zmin0, obj.getZmin());
        xmax0 = Math.min(xmax0, obj.getXmax());
        ymax0 = Math.min(ymax0, obj.getYmax());
        zmax0 = Math.min(zmax0, obj.getZmax());
        int offX1 = otherseg.offsetX;
        int offY1 = otherseg.offsetY;
        int offZ1 = otherseg.offsetZ;
        for (int k = zmin0; k <= zmax0; ++k) {
            for (int j = ymin0; j <= ymax0; ++j) {
                for (int i = xmin0; i <= xmax0; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value || otherseg.getPixel(i - offX1, j - offY1, k - offZ1) != (float)val) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public ArrayUtil listValues(ImageHandler ima) {
        ArrayUtil list = new ArrayUtil(this.getVolumePixels());
        int xmin0 = this.getXmin();
        int ymin0 = this.getYmin();
        int zmin0 = this.getZmin();
        int xmax0 = this.getXmax();
        int ymax0 = this.getYmax();
        int zmax0 = this.getZmax();
        int idx = 0;
        for (int k = zmin0; k <= zmax0; ++k) {
            for (int j = ymin0; j <= ymax0; ++j) {
                for (int i = xmin0; i <= xmax0; ++i) {
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value) continue;
                    list.putValue(idx, ima.getPixel(i, j, k));
                    ++idx;
                }
            }
        }
        return list;
    }

    @Override
    public ArrayUtil listValues(ImageHandler ima, float thresh) {
        ArrayUtil list = new ArrayUtil(this.getVolumePixels());
        int xmin0 = this.getXmin();
        int ymin0 = this.getYmin();
        int zmin0 = this.getZmin();
        int xmax0 = this.getXmax();
        int ymax0 = this.getYmax();
        int zmax0 = this.getZmax();
        int idx = 0;
        for (int k = zmin0; k <= zmax0; ++k) {
            for (int j = ymin0; j <= ymax0; ++j) {
                for (int i = xmin0; i <= xmax0; ++i) {
                    float pixel;
                    if (this.labelImage.getPixel(i, j, k) != (float)this.value || !((pixel = ima.getPixel(i, j, k)) > thresh)) continue;
                    list.putValue(idx, pixel);
                    ++idx;
                }
            }
        }
        return list;
    }

    @Override
    public void draw(ImageHandler mask, int col, int tx, int ty, int tz) {
        for (int z = this.zmin; z <= this.zmax; ++z) {
            for (int x = this.xmin; x <= this.xmax; ++x) {
                for (int y = this.ymin; y <= this.ymax; ++y) {
                    if (this.labelImage.getPixel(x, y, z) != (float)this.value || !mask.contains(x + tx, y + ty, z + tz)) continue;
                    mask.setPixel(x + tx, y + ty, z + tz, col);
                }
            }
        }
    }
}

