/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.LongScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedLong1D;
import mitiv.array.impl.StriddenLong1D;
import mitiv.base.Shape;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.exception.NonConformableArrayException;
import mitiv.random.LongGenerator;

public class FlatLong1D
extends Long1D {
    static final int order = 1;
    final long[] data;

    public FlatLong1D(int dim1) {
        super(dim1);
        this.data = new long[this.number];
    }

    public FlatLong1D(int[] dims) {
        super(dims);
        this.data = new long[this.number];
    }

    public FlatLong1D(Shape shape) {
        super(shape);
        this.data = new long[this.number];
    }

    public FlatLong1D(long[] arr, int dim1) {
        super(dim1);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatLong1D(long[] arr, int[] dims) {
        super(dims);
        this.checkSize(arr);
        this.data = arr;
    }

    public FlatLong1D(long[] arr, Shape shape) {
        super(shape);
        this.checkSize(arr);
        this.data = arr;
    }

    @Override
    public void checkSanity() {
        if (this.data == null) {
            throw new NonConformableArrayException("Wrapped array is null");
        }
        if (this.data.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    private void checkSize(long[] arr) {
        if (arr == null || arr.length < this.number) {
            throw new NonConformableArrayException("Wrapped array is too small");
        }
    }

    final int index(int i1) {
        return i1;
    }

    @Override
    public final long get(int i1) {
        return this.data[i1];
    }

    @Override
    public final void set(int i1, long value) {
        this.data[i1] = value;
    }

    @Override
    public final int getOrder() {
        return 1;
    }

    @Override
    public void fill(long value) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = value;
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = generator.nextLong();
        }
    }

    @Override
    public void increment(long value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(long value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(long value) {
        int j = 0;
        while (j < this.number) {
            int n = j++;
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(LongFunction function) {
        for (int j = 0; j < this.number; ++j) {
            this.data[j] = function.apply(this.data[j]);
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        scanner.initialize(this.data[0]);
        for (int j = 1; j < this.number; ++j) {
            scanner.update(this.data[j]);
        }
    }

    @Override
    public final boolean isFlat() {
        return true;
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        if (forceCopy) {
            long[] result = new long[this.number];
            System.arraycopy(this.data, 0, result, 0, this.number);
            return result;
        }
        return this.data;
    }

    @Override
    public long[] getData() {
        return this.data;
    }

    @Override
    public LongScalar slice(int idx) {
        idx = Helper.fixIndex(idx, this.dim1);
        return new LongScalar(this.data, idx);
    }

    @Override
    public LongScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new LongScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Long1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, 0, 1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenLong1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Long1D view(int[] sel1) {
        int[] idx1 = Helper.select(0, 1, this.dim1, sel1);
        return new SelectedLong1D(this.data, idx1);
    }

    @Override
    public Long1D as1D() {
        return this;
    }
}

