/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.math.MathUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static String getValue(String value, String defaultValue) {
        if (StringUtil.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public static CharSequence getNextNumber(CharSequence text, int index) {
        int len = text.length();
        int st = StringUtil.getNextDigitCharIndex(text, index);
        if (st >= 0) {
            int end = StringUtil.getNextNonDigitCharIndex(text, st);
            if (end < 0) {
                end = len;
            }
            return text.subSequence(st, end);
        }
        return "";
    }

    public static int getPreviousDigitCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from >= len) {
            return -1;
        }
        for (int index = from; index >= 0; --index) {
            if (!Character.isDigit(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getPreviousLetterCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from >= len) {
            return -1;
        }
        for (int index = from; index >= 0; --index) {
            if (!Character.isLetter(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getPreviousNonDigitCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from >= len) {
            return -1;
        }
        for (int index = from; index >= 0; --index) {
            if (Character.isDigit(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getPreviousNonLetterCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from >= len) {
            return -1;
        }
        for (int index = from; index >= 0; --index) {
            if (Character.isLetter(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getNextDigitCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from < 0) {
            return -1;
        }
        for (int index = from; index < len; ++index) {
            if (!Character.isDigit(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getNextLetterCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from < 0) {
            return -1;
        }
        for (int index = from; index < len; ++index) {
            if (!Character.isDigit(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getNextNonDigitCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from < 0) {
            return -1;
        }
        for (int index = from; index < len; ++index) {
            if (Character.isDigit(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getNextNonLetterCharIndex(CharSequence value, int from) {
        int len = value.length();
        if (from < 0) {
            return -1;
        }
        for (int index = from; index < len; ++index) {
            if (Character.isLetter(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static int getNextCtrlCharIndex(CharSequence value, int startIndex) {
        int len = value.length();
        if (startIndex < 0) {
            return -1;
        }
        for (int index = startIndex; index < len; ++index) {
            if (!Character.isISOControl(value.charAt(index))) continue;
            return index;
        }
        return -1;
    }

    public static String limit(String value, int maxlen, boolean tailLimit) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len > maxlen) {
            if (tailLimit || maxlen <= 8) {
                return value.substring(0, maxlen - 2).trim() + "...";
            }
            int cut = (maxlen - 3) / 2;
            return value.substring(0, cut).trim() + "..." + value.substring(len - cut).trim();
        }
        return value;
    }

    public static String limit(String value, int maxlen) {
        return StringUtil.limit(value, maxlen, false);
    }

    public static String trunc(String fullText, String keyword, int maxSize) {
        int idx = fullText.toLowerCase().indexOf(keyword.toLowerCase());
        if (idx == -1) {
            return "";
        }
        String toReturn = fullText;
        int fullTextSize = fullText.length();
        if (fullTextSize > maxSize) {
            int firstSpaceAfter = fullText.indexOf(32, idx);
            firstSpaceAfter = firstSpaceAfter == -1 ? fullTextSize : firstSpaceAfter;
            String textBeforeWord = fullText.substring(0, idx);
            int lastSpaceBefore = textBeforeWord.lastIndexOf(32);
            int n = lastSpaceBefore = lastSpaceBefore == -1 ? 0 : lastSpaceBefore;
            if (idx <= maxSize / 2) {
                toReturn = fullText.substring(0, maxSize);
                toReturn = toReturn.trim() + "...";
            } else if (fullTextSize - idx <= maxSize / 2) {
                toReturn = fullText.substring(fullTextSize - maxSize, fullTextSize);
                toReturn = "..." + toReturn.trim();
            } else {
                int beginIndex = idx - maxSize / 2;
                int endIndex = idx + maxSize / 2;
                if (endIndex > fullTextSize) {
                    System.out.println(endIndex);
                }
                toReturn = "..." + fullText.substring(beginIndex, endIndex).trim() + "...";
            }
        }
        return toReturn;
    }

    public static boolean equals(String s1, String s2, boolean trim) {
        if (StringUtil.isEmpty(s1, trim)) {
            return StringUtil.isEmpty(s2, trim);
        }
        if (StringUtil.isEmpty(s2, trim)) {
            return false;
        }
        if (trim) {
            return s1.trim().equals(s2.trim());
        }
        return s1.equals(s2);
    }

    public static boolean equals(String s1, String s2) {
        return StringUtil.equals(s1, s2, false);
    }

    public static boolean isEmpty(String value, boolean trim) {
        if (value != null) {
            if (trim) {
                return value.trim().length() == 0;
            }
            return value.length() == 0;
        }
        return true;
    }

    public static boolean isEmpty(String value) {
        return StringUtil.isEmpty(value, true);
    }

    public static boolean parseBoolean(String s, boolean def) {
        if (s == null) {
            return def;
        }
        String value = s.toLowerCase();
        if (value.equals(Boolean.toString(true))) {
            return true;
        }
        if (value.equals(Boolean.toString(false))) {
            return false;
        }
        return def;
    }

    public static int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException E) {
            return def;
        }
    }

    public static long parseLong(String s, long def) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException E) {
            return def;
        }
    }

    public static float parseFloat(String s, float def) {
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException E) {
            return def;
        }
    }

    public static double parseDouble(String s, double def) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException E) {
            return def;
        }
    }

    public static byte[] parseBytes(String s, byte[] def) {
        if (s == null) {
            return def;
        }
        return s.getBytes();
    }

    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    public static String toString(int value) {
        return Integer.toString(value);
    }

    public static String toString(int value, int minSize) {
        String result = Integer.toString(value);
        while (result.length() < minSize) {
            result = "0" + result;
        }
        return result;
    }

    public static String toString(long value) {
        return Long.toString(value);
    }

    public static String toString(float value) {
        return Float.toString(value);
    }

    public static String toString(double value) {
        int i = (int)value;
        if ((double)i == value) {
            return StringUtil.toString(i);
        }
        return Double.toString(value);
    }

    public static String toString(double value, int numDecimal) {
        return Double.toString(MathUtil.round(value, numDecimal));
    }

    public static String toStringEx(double value, int size) {
        int i = (int)value;
        if ((double)i == value) {
            return StringUtil.toString(i);
        }
        return Double.toString(MathUtil.roundSignificant(value, size, true));
    }

    public static String toString(byte[] value) {
        return new String(value);
    }

    public static String toHexaString(int value) {
        return Integer.toHexString(value);
    }

    public static String toHexaString(int value, int size) {
        String result = Integer.toHexString(value);
        if (result.length() > size) {
            return result.substring(result.length() - size);
        }
        while (result.length() < size) {
            result = "0" + result;
        }
        return result;
    }

    public static String removeLast(String value, int count) {
        if (value == null) {
            return null;
        }
        int l = value.length();
        if (l < 2) {
            return "";
        }
        return value.substring(0, l - count);
    }

    public static String getFlattened(String string) {
        String[] words = string.split("(?=[A-Z])");
        String output = words[0];
        if (words.length > 1) {
            output = words[1];
            for (int i = 2; i < words.length; ++i) {
                String word = words[i];
                if (word.length() == 1) {
                    if (words[i - 1].length() == 1) {
                        output = output + word;
                        continue;
                    }
                    output = output + " " + word;
                    continue;
                }
                output = output + " " + word.toLowerCase();
            }
        }
        return output;
    }

    public static String replaceCR(String text, String str) {
        return text.replaceAll("(\r\n|\n\r|\r|\n)", str);
    }

    public static String removeCR(String text) {
        return StringUtil.replaceCR(text, "");
    }

    public static String toHtmlCR(String text) {
        return StringUtil.replaceCR(text, "<br>").replaceAll("(<BR>|<br/>|<BR/>)", "<br>");
    }

    public static boolean containHtmlCR(String text) {
        return text.indexOf("<br>") != -1 || text.indexOf("<BR>") != -1 || text.indexOf("<br/>") != -1 || text.indexOf("<BR/>") != -1;
    }

    public static String htmlBoldSubstring(String text, String keyword, boolean ignoreCase) {
        if (!(StringUtil.isEmpty(text) || StringUtil.isEmpty(keyword) || keyword.toLowerCase().equals("b"))) {
            int keywordLen = keyword.length();
            String key = ignoreCase ? keyword.toLowerCase() : keyword;
            String result = text;
            int index = ignoreCase ? result.toLowerCase().indexOf(key) : result.indexOf(key);
            while (index != -1) {
                result = result.substring(0, index) + "<b>" + result.substring(index, index + keywordLen) + "</b>" + result.substring(index + keywordLen);
                if (ignoreCase) {
                    index = result.toLowerCase().indexOf(key, index + keywordLen + 6);
                    continue;
                }
                index = result.indexOf(key, index + keywordLen + 6);
            }
            return result;
        }
        return text;
    }

    public static List<String> split(String text) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(text);
        while (m.find()) {
            result.add(m.group(1).replace("\"", ""));
        }
        return result;
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static class AlphanumComparator
    implements Comparator<String> {
        private static final String getChunk(String s, int slength, int index) {
            int marker = index;
            StringBuilder chunk = new StringBuilder();
            char c = s.charAt(marker);
            chunk.append(c);
            ++marker;
            if (Character.isDigit(c)) {
                while (marker < slength && Character.isDigit(c = s.charAt(marker))) {
                    chunk.append(c);
                    ++marker;
                }
            } else {
                while (marker < slength && !Character.isDigit(c = s.charAt(marker))) {
                    chunk.append(c);
                    ++marker;
                }
            }
            return chunk.toString();
        }

        @Override
        public int compare(String s1, String s2) {
            int thisMarker = 0;
            int thatMarker = 0;
            int s1Length = s1.length();
            int s2Length = s2.length();
            while (thisMarker < s1Length && thatMarker < s2Length) {
                String thisChunk = AlphanumComparator.getChunk(s1, s1Length, thisMarker);
                thisMarker += thisChunk.length();
                String thatChunk = AlphanumComparator.getChunk(s2, s2Length, thatMarker);
                thatMarker += thatChunk.length();
                int result = 0;
                if (Character.isDigit(thisChunk.charAt(0)) && Character.isDigit(thatChunk.charAt(0))) {
                    int thisChunkLength = thisChunk.length();
                    result = thisChunkLength - thatChunk.length();
                    if (result == 0) {
                        for (int i = 0; i < thisChunkLength; ++i) {
                            result = thisChunk.charAt(i) - thatChunk.charAt(i);
                            if (result == 0) continue;
                            return result;
                        }
                    }
                } else {
                    result = thisChunk.compareTo(thatChunk);
                }
                if (result == 0) continue;
                return result;
            }
            return s1Length - s2Length;
        }
    }
}

