/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import java.util.Arrays;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageInt;
import mcib3d.image3d.ImageShort;

public class Segment3DImage {
    float lowThreshold;
    float highThreshold;
    ImageHandler imgCopy;
    int[] objID;
    int[] IDcount;
    int[] surfList;
    boolean[] IDisAtEdge;
    boolean[] isSurf;
    int width = 1;
    int height = 1;
    int nbSlices = 1;
    int nbVoxels = 1;
    int depth = 8;
    int minSize;
    int maxSize;
    int nbObj = 0;
    int nbSurfPix = 0;
    boolean sizeFilter = true;
    boolean exclude = false;

    public Segment3DImage(ImageHandler img, float lowthr, float highthr) {
        this.init(img, lowthr, highthr);
    }

    private void init(ImageHandler img, float lowthr, float highthr) {
        this.imgCopy = img.duplicate();
        this.width = img.sizeX;
        this.height = img.sizeY;
        this.nbSlices = img.sizeZ;
        this.nbVoxels = this.width * this.height * this.nbSlices;
        this.minSize = 1;
        this.maxSize = this.nbVoxels;
        this.sizeFilter = true;
        this.exclude = false;
        if (lowthr <= highthr) {
            this.lowThreshold = lowthr;
            this.highThreshold = highthr;
        } else {
            this.lowThreshold = highthr;
            this.highThreshold = lowthr;
        }
        if (this.depth != 8 && this.depth != 16) {
            throw new IllegalArgumentException("Counter3D class expects 8- or 16-bits images only");
        }
        this.nbObj = this.nbVoxels;
        this.imgArrayModifier();
    }

    public Segment3DImage(ImagePlus plus, float lo, float hi) {
        ImageHandler img = ImageHandler.wrap(plus);
        this.init(img, lo, hi);
    }

    public int getMaxSizeObject() {
        return this.maxSize;
    }

    public void setMaxSizeObject(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getMinSizeObject() {
        return this.minSize;
    }

    public void setMinSizeObject(int minSize) {
        this.minSize = minSize;
    }

    public int getNbObj() {
        return this.nbObj;
    }

    public void segment() {
        int x;
        int y;
        int z;
        int currID = 0;
        int currPos = 0;
        int minID = 0;
        long start = System.currentTimeMillis();
        this.objID = new int[this.nbVoxels];
        for (z = 1; z <= this.nbSlices; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (minID == currID) {
                        ++currID;
                    }
                    if (this.imgCopy.getPixel(currPos) != 0.0f) {
                        minID = currID;
                        this.objID[currPos] = minID = this.minAntTag(minID, x, y, z);
                    }
                    ++currPos;
                }
            }
        }
        this.IDcount = new int[currID];
        for (int i = 0; i < this.nbVoxels; ++i) {
            int n = this.objID[i];
            this.IDcount[n] = this.IDcount[n] + 1;
        }
        this.IDisAtEdge = new boolean[currID];
        Arrays.fill(this.IDisAtEdge, false);
        this.isSurf = new boolean[this.nbVoxels];
        currPos = 0;
        for (z = 1; z <= this.nbSlices; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (this.imgCopy.getPixel(currPos) != 0.0f) {
                        int pos;
                        int neigbX;
                        int neigbY;
                        int neigbZ;
                        minID = this.objID[currPos];
                        int surfPix = 0;
                        int neigbNb = 0;
                        for (neigbZ = z - 1; neigbZ <= z + 1; ++neigbZ) {
                            for (neigbY = y - 1; neigbY <= y + 1; ++neigbY) {
                                for (neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
                                    if (neigbX < 0 || neigbX >= this.width || neigbY < 0 || neigbY >= this.height || neigbZ < 1 || neigbZ > this.nbSlices) continue;
                                    pos = this.offset(neigbX, neigbY, neigbZ);
                                    if (this.imgCopy.getPixel(pos) != 0.0f) {
                                        if (this.nbSlices > 1 && (neigbX == x && neigbY == y && neigbZ == z - 1 || neigbX == x && neigbY == y && neigbZ == z + 1) || neigbX == x && neigbY == y - 1 && neigbZ == z || neigbX == x && neigbY == y + 1 && neigbZ == z || neigbX == x - 1 && neigbY == y && neigbZ == z || neigbX == x + 1 && neigbY == y && neigbZ == z) {
                                            ++surfPix;
                                        }
                                        minID = Math.min(minID, this.objID[pos]);
                                    }
                                    ++neigbNb;
                                }
                            }
                        }
                        if (surfPix != 6 && this.nbSlices > 1 || surfPix != 4 && this.nbSlices == 1) {
                            this.isSurf[currPos] = true;
                            ++this.nbSurfPix;
                        } else {
                            this.isSurf[currPos] = false;
                        }
                        for (neigbZ = z - 1; neigbZ <= z + 1; ++neigbZ) {
                            for (neigbY = y - 1; neigbY <= y + 1; ++neigbY) {
                                for (neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
                                    int currPixID;
                                    if (neigbX < 0 || neigbX >= this.width || neigbY < 0 || neigbY >= this.height || neigbZ < 1 || neigbZ > this.nbSlices || this.imgCopy.getPixel(pos = this.offset(neigbX, neigbY, neigbZ)) == 0.0f || (currPixID = this.objID[pos]) <= minID) continue;
                                    this.replaceID(currPixID, minID);
                                }
                            }
                        }
                        if (x == 0 || y == 0 || x == this.width - 1 || y == this.height - 1 || this.nbSlices != 1 && (z == 1 || z == this.nbSlices)) {
                            this.IDisAtEdge[minID] = true;
                        }
                    }
                    ++currPos;
                }
            }
        }
        int newCurrID = 0;
        for (int i = 1; i < this.IDcount.length; ++i) {
            if (!(this.IDcount[i] == 0 || this.IDcount[i] < this.minSize || this.IDcount[i] > this.maxSize || this.exclude && this.exclude && this.IDisAtEdge[i])) {
                int nbPix = this.IDcount[i];
                this.replaceID(i, ++newCurrID);
                this.IDcount[newCurrID] = nbPix;
                continue;
            }
            this.replaceID(i, 0);
        }
        this.nbObj = newCurrID;
    }

    public ImageInt getLabelledObjectsImage3D() {
        return this.buildImg(this.objID);
    }

    public ImageStack getLabelledObjectsStack() {
        return this.getLabelledObjectsImage3D().getImageStack();
    }

    public ImageInt getSurfaceObjectsImage3D() {
        this.surfList = new int[this.nbVoxels];
        for (int i = 0; i < this.nbVoxels; ++i) {
            this.surfList[i] = this.isSurf[i] ? this.objID[i] : 0;
        }
        return this.buildImg(this.surfList);
    }

    public ImageStack getSurfaceObjectsStack() {
        return this.getSurfaceObjectsImage3D().getImageStack();
    }

    private int minAntTag(int initialValue, int x, int y, int z) {
        int currPos;
        int min = initialValue;
        for (int neigbY = y - 1; neigbY <= y + 1; ++neigbY) {
            for (int neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
                if (neigbX < 0 || neigbX >= this.width || neigbY < 0 || neigbY >= this.height || z - 1 < 1 || z - 1 > this.nbSlices || this.imgCopy.getPixel(currPos = this.offset(neigbX, neigbY, z - 1)) == 0.0f) continue;
                min = Math.min(min, this.objID[currPos]);
            }
        }
        for (int neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
            if (neigbX < 0 || neigbX >= this.width || y - 1 < 0 || y - 1 >= this.height || z < 1 || z > this.nbSlices || this.imgCopy.getPixel(currPos = this.offset(neigbX, y - 1, z)) == 0.0f) continue;
            min = Math.min(min, this.objID[currPos]);
        }
        if (x - 1 >= 0 && x - 1 < this.width && y >= 0 && y < this.height && z >= 1 && z <= this.nbSlices && this.imgCopy.getPixel(currPos = this.offset(x - 1, y, z)) != 0.0f && x >= 1 && y >= 0 && z >= 1) {
            min = Math.min(min, this.objID[currPos]);
        }
        return min;
    }

    private int offset(int m, int n, int o) {
        if (m + n * this.width + (o - 1) * this.width * this.height >= this.width * this.height * this.nbSlices) {
            return this.width * this.height * this.nbSlices - 1;
        }
        if (m + n * this.width + (o - 1) * this.width * this.height < 0) {
            return 0;
        }
        return m + n * this.width + (o - 1) * this.width * this.height;
    }

    private void replaceID(int oldVal, int newVal) {
        if (oldVal != newVal) {
            int nbFoundPix = 0;
            for (int i = 0; i < this.objID.length; ++i) {
                if (this.objID[i] == oldVal) {
                    this.objID[i] = newVal;
                    ++nbFoundPix;
                }
                if (nbFoundPix != this.IDcount[oldVal]) continue;
                i = this.objID.length;
            }
            this.IDcount[oldVal] = 0;
            int n = newVal;
            this.IDcount[n] = this.IDcount[n] + nbFoundPix;
        }
    }

    private void imgArrayModifier() {
        int index = 0;
        for (int z = 0; z < this.nbSlices; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    float val = this.imgCopy.getPixel(x, y, z);
                    if (val < this.lowThreshold || val > this.highThreshold) {
                        this.imgCopy.setPixel(index, 0.0f);
                        --this.nbObj;
                    } else {
                        this.imgCopy.setPixel(index, val);
                    }
                    ++index;
                }
            }
        }
        if (this.nbObj <= 0) {
            IJ.log((String)"No object found");
        }
    }

    private ImageInt buildImg(int[] IDobj) {
        int index = 0;
        ImageShort ima = new ImageShort("Objects", this.width, this.height, this.nbSlices);
        for (int z = 0; z < this.nbSlices; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int currVal = IDobj[index];
                    if (currVal != 0) {
                        ((ImageInt)ima).setPixel(x, y, z, currVal);
                    }
                    ++index;
                }
            }
        }
        return ima;
    }
}

