/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.sequence.Sequence;
import plugins.ylemontag.mathoperations.SubSequence;
import plugins.ylemontag.mathoperations.variants.VariantArray;
import plugins.ylemontag.mathoperations.variants.VariantScalar;
import plugins.ylemontag.mathoperations.variants.VariantSequence;
import plugins.ylemontag.mathoperations.variants.VariantSubSequence;

public abstract class Variant {
    private Type _type;
    private boolean _updating;

    protected Variant(Type type) {
        this._type = type;
        this._updating = false;
    }

    public Type getType() {
        return this._type;
    }

    public double getAsScalar() {
        throw new IllegalStateException("This variant object is not a scalar.");
    }

    public double[] getAsArray() {
        throw new IllegalStateException("This variant object is not an array.");
    }

    public Sequence getAsSequence() {
        throw new IllegalStateException("This variant object is not a sequence.");
    }

    public SubSequence getAsSubSequence() {
        throw new IllegalStateException("This variant object is not a sub-sequence.");
    }

    public abstract String getRepresentation(boolean var1);

    public String toString() {
        return this.getRepresentation(false);
    }

    public static boolean isFragileString(String s) {
        int lg = s.length();
        for (int k = 0; k < lg; ++k) {
            switch (s.charAt(k)) {
                case ' ': 
                case '^': 
                case '\u00d7': 
                case '\u00f7': {
                    return true;
                }
            }
        }
        return false;
    }

    public abstract Dimension getDimension();

    public abstract boolean isReadable();

    public abstract boolean isWritable();

    public ReadIterator getReadIterator() {
        if (!this.isReadable()) {
            throw new IllegalStateException("The current object is not readable.");
        }
        return this.implGetReadIterator();
    }

    protected abstract ReadIterator implGetReadIterator();

    public WriteIterator getWriteIterator() {
        if (!this._updating) {
            throw new IllegalStateException("Must call beginUpdate() before creating a iterator in write mode.");
        }
        return this.implGetWriteIterator();
    }

    protected abstract WriteIterator implGetWriteIterator();

    public void beginUpdate() {
        if (!this.isWritable()) {
            throw new IllegalStateException("The current object is not writable.");
        }
        this.implBeginUpdate();
        this._updating = true;
    }

    protected abstract void implBeginUpdate();

    public void endUpdate() {
        this._updating = false;
        this.implEndUpdate();
    }

    protected abstract void implEndUpdate();

    public static Variant wrap(double value) {
        return new VariantScalar(value);
    }

    public static Variant wrap(double[] value) {
        return new VariantArray(value);
    }

    public static Variant wrap(Sequence value) {
        return new VariantSequence(value);
    }

    public static Variant wrap(SubSequence value) {
        return new VariantSubSequence(value);
    }

    public static interface WriteIterator
    extends Iterator {
        public void set(double var1);
    }

    public static interface ReadIterator
    extends Iterator {
        public double get();
    }

    public static interface Iterator {
        public boolean valid();

        public void next();

        public void startAt(long var1);
    }

    public static abstract class Dimension {
        private DimensionType _type;

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Dimension)) {
                return false;
            }
            return this.equals((Dimension)object);
        }

        public String toString() {
            return this.getRepresentation();
        }

        protected Dimension(DimensionType type) {
            this._type = type;
        }

        public DimensionType getType() {
            return this._type;
        }

        public abstract boolean equals(Dimension var1);

        public abstract String getRepresentation();

        public abstract long getFlatSize();

        public abstract int getGranularity();

        public abstract Variant allocateNewVariant();
    }

    public static enum Type {
        SCALAR("Scalar", DimensionType.SCALAR),
        ARRAY("Array", DimensionType.ARRAY),
        SEQUENCE("Sequence", DimensionType.SEQUENCE),
        SUBSEQUENCE("Sub-sequence", DimensionType.SEQUENCE);

        private String _name;
        private DimensionType _dimensionType;

        private Type(String name, DimensionType dimensionType) {
            this._name = name;
            this._dimensionType = dimensionType;
        }

        public DimensionType getDimensionType() {
            return this._dimensionType;
        }

        public String toString() {
            return this._name;
        }
    }

    public static enum DimensionType {
        SCALAR("Scalar"),
        ARRAY("Array"),
        SEQUENCE("Sequence");

        private String _name;

        private DimensionType(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

