/*
 * Decompiled with CFR 0.152.
 */
package icy.plugin.classloader;

import icy.plugin.classloader.AbstractClassLoader;
import icy.plugin.classloader.ClasspathResources;
import icy.plugin.classloader.Configuration;
import icy.plugin.classloader.ProxyClassLoader;
import icy.plugin.classloader.exception.JclException;
import icy.plugin.classloader.exception.ResourceNotFoundException;
import icy.system.IcyExceptionHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JarClassLoader
extends AbstractClassLoader {
    protected final Map<String, Class> loadedClasses;
    protected final ClasspathResources classpathResources;
    private char classNameReplacementChar;
    private final ProxyClassLoader localLoader = new LocalLoader();
    private static Logger logger = Logger.getLogger(JarClassLoader.class.getName());

    public JarClassLoader(ClassLoader parent) {
        super(parent);
        this.classpathResources = new ClasspathResources();
        this.loadedClasses = Collections.synchronizedMap(new HashMap());
        this.addLoader(this.localLoader);
    }

    public JarClassLoader() {
        this(JarClassLoader.getSystemClassLoader());
    }

    public JarClassLoader(Object[] sources) {
        this();
        this.addAll(sources);
    }

    public JarClassLoader(List sources) {
        this();
        this.addAll(sources);
    }

    public void addAll(Object[] sources) {
        for (Object source : sources) {
            this.add(source);
        }
    }

    public void addAll(List sources) {
        for (Object source : sources) {
            this.add(source);
        }
    }

    public void add(Object source) {
        if (source instanceof InputStream) {
            throw new JclException("Unsupported resource type");
        }
        if (source instanceof URL) {
            this.add((URL)source);
        } else if (source instanceof String) {
            this.add((String)source);
        } else {
            throw new JclException("Unknown Resource type");
        }
    }

    public void add(String resourceName) {
        this.classpathResources.loadResource(resourceName);
    }

    @Deprecated
    public void add(InputStream jarStream) {
    }

    public void add(URL url) {
        this.classpathResources.loadResource(url);
    }

    public void unloadAll() {
        this.classpathResources.entryContents.clear();
        this.loadedClasses.clear();
    }

    protected byte[] getClassBytes(String className) throws IOException {
        return this.classpathResources.getResourceContent(this.formatClassName(className));
    }

    public void unloadClass(String className) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Unloading class " + className);
        }
        if (this.loadedClasses.containsKey(className)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Removing loaded class " + className);
            }
            this.loadedClasses.remove(className);
            try {
                this.classpathResources.unload(this.formatClassName(className));
            }
            catch (ResourceNotFoundException e) {
                throw new JclException("Something is very wrong!!!The locally loaded classes must be in synch with ClasspathResources", e);
            }
        }
        try {
            this.classpathResources.unload(this.formatClassName(className));
        }
        catch (ResourceNotFoundException e) {
            throw new JclException("Class could not be unloaded [Possible reason: Class belongs to the system]", e);
        }
    }

    protected String formatClassName(String className) {
        String cname = className.replace('/', '~');
        cname = this.classNameReplacementChar == '\u0000' ? cname.replace('.', '/') + ".class" : cname.replace('.', this.classNameReplacementChar) + ".class";
        return cname.replace('~', '/');
    }

    public char getClassNameReplacementChar() {
        return this.classNameReplacementChar;
    }

    public void setClassNameReplacementChar(char classNameReplacementChar) {
        this.classNameReplacementChar = classNameReplacementChar;
    }

    public Set<String> getResourcesName() {
        return this.classpathResources.getResourcesName();
    }

    public Map<String, URL> getResources() {
        return this.classpathResources.getResources();
    }

    public Map<String, byte[]> getLoadedResources() {
        return this.classpathResources.getLoadedResources();
    }

    public ProxyClassLoader getLocalLoader() {
        return this.localLoader;
    }

    public Map<String, Class> getLoadedClasses() {
        return Collections.unmodifiableMap(this.loadedClasses);
    }

    class LocalLoader
    extends ProxyClassLoader {
        private final Logger logger;

        public LocalLoader() {
            super(50);
            this.logger = Logger.getLogger(LocalLoader.class.getName());
            this.enabled = Configuration.isLocalLoaderEnabled();
        }

        @Override
        public ClassLoader getLoader() {
            return JarClassLoader.this;
        }

        @Override
        public Class loadClass(String className, boolean resolveIt) throws ClassNotFoundException, ClassFormatError {
            Class result = null;
            result = JarClassLoader.this.loadedClasses.get(className);
            if (result != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning local loaded class [" + className + "] from cache");
                }
                return result;
            }
            result = JarClassLoader.this.findLoadedClass(className);
            if (result == null) {
                byte[] classBytes;
                try {
                    classBytes = JarClassLoader.this.getClassBytes(className);
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(className, e);
                }
                if (classBytes == null) {
                    return null;
                }
                result = JarClassLoader.this.defineClass(className, classBytes, 0, classBytes.length);
                if (result == null) {
                    return null;
                }
            }
            if (result.getPackage() == null) {
                int lastDotIndex = className.lastIndexOf(46);
                String packageName = lastDotIndex >= 0 ? className.substring(0, lastDotIndex) : "";
                JarClassLoader.this.definePackage(packageName, null, null, null, null, null, null, null);
            }
            if (resolveIt) {
                JarClassLoader.this.resolveClass(result);
            }
            JarClassLoader.this.loadedClasses.put(className, result);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("Return new local loaded class " + className);
            }
            return result;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            try {
                byte[] arr = JarClassLoader.this.classpathResources.getResourceContent(name);
                if (arr != null) {
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest("Returning newly loaded resource " + name);
                    }
                    return new ByteArrayInputStream(arr);
                }
            }
            catch (IOException e) {
                IcyExceptionHandler.showErrorMessage(e, false, true);
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            URL url = JarClassLoader.this.classpathResources.getResource(name);
            if (url != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("Returning newly loaded resource " + name);
                }
                return url;
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            final URL url = this.getResource(name);
            return new Enumeration<URL>(){
                boolean hasMore;
                {
                    this.hasMore = url != null;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.hasMore;
                }

                @Override
                public URL nextElement() {
                    if (this.hasMore) {
                        this.hasMore = false;
                        return url;
                    }
                    return null;
                }
            };
        }
    }
}

